/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.DefaultConnectionSource;
import org.beetl.sql.core.ExecuteContext;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringConnectionSource
extends DefaultConnectionSource {
    private static final String DS_CONTEXT_PARAM = "_datasource";

    public SpringConnectionSource() {
    }

    public SpringConnectionSource(DataSource master, DataSource[] slaves) {
        super(master, slaves);
    }

    public Connection getConn(ExecuteContext ctx, boolean isUpdate) {
        boolean isReadOnly;
        if (this.getForceDataSource() != null) {
            try {
                return this.getForceDataSource().getConnection();
            }
            catch (SQLException e) {
                throw new BeetlSQLException(0, (Throwable)e);
            }
        }
        Object ds = null;
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(ctx);
        }
        if (isUpdate) {
            return this.getWriteConn(ctx);
        }
        boolean inTrans = TransactionSynchronizationManager.isActualTransactionActive();
        if (inTrans && !(isReadOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly())) {
            return this.getWriteConn(ctx);
        }
        return this.getReadConn(ctx);
    }

    public boolean isTransaction() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    protected Connection doGetConnection(ExecuteContext ctx, DataSource ds) {
        try {
            Connection connection = DataSourceUtils.getConnection((DataSource)ds);
            if (ctx != null) {
                ctx.setContextPara(DS_CONTEXT_PARAM, (Object)ds);
            }
            return connection;
        }
        catch (CannotGetJdbcConnectionException ex) {
            throw new BeetlSQLException(0, (Throwable)ex);
        }
    }

    public DataSource getMasterSource() {
        return this.master;
    }

    public void setMasterSource(DataSource master) {
        this.master = master;
    }

    public DataSource[] getSlaveSource() {
        return this.slaves;
    }

    public void setSlaveSource(DataSource[] slaves) {
        this.slaves = slaves;
    }

    public void applyStatementSetting(ExecuteContext ctx, Connection conn, Statement statement) throws SQLException {
        DataSource dataSource = this.getDatasourceFromContext(ctx);
        if (dataSource == null) {
            return;
        }
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)dataSource);
        if (holder == null) {
            return;
        }
        if (holder.hasTimeout()) {
            statement.setQueryTimeout(holder.getTimeToLiveInSeconds());
        }
    }

    public void applyConnectionSetting(ExecuteContext ctx, Connection conn) {
    }

    public void closeConnection(Connection conn, ExecuteContext ctx, boolean isUpdate) {
        DataSource dataSource = this.getDatasourceFromContext(ctx);
        DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
    }

    protected DataSource getDatasourceFromContext(ExecuteContext ctx) {
        if (ctx == null) {
            return this.getMasterSource();
        }
        DataSource dataSource = (DataSource)ctx.getContextPara(DS_CONTEXT_PARAM);
        return dataSource;
    }
}

