/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.Cache;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.DefaultCache;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.clazz.kit.NumberKit;
import org.beetl.sql.clazz.kit.PropertyDescriptorWrap;
import org.beetl.sql.clazz.kit.PropertyDescriptorWrapFactory;

public class BeanKit {
    public static boolean queryLambdasSupport = JavaType.isJdk8();
    public static boolean JAVABEAN_STRICT = true;
    static Map<Class, Map<String, Field>> classFields = new ConcurrentHashMap<Class, Map<String, Field>>();
    static Map<Class, Map<String, PropertyDescriptorWrap>> classProperty = new ConcurrentHashMap<Class, Map<String, PropertyDescriptorWrap>>();
    public static Cache classInsCache = new DefaultCache();
    public static PropertyDescriptorWrapFactory propertyDescriptorWrapFactory = (c, prop, i) -> new PropertyDescriptorWrap(c, prop, i);

    public static PropertyDescriptor[] propertyDescriptors(Class<?> c) throws IntrospectionException {
        BeanInfo beanInfo = null;
        beanInfo = Introspector.getBeanInfo(c);
        return beanInfo.getPropertyDescriptors();
    }

    public static Map<String, Field> getClassFields(Class c) {
        Map<String, Field> map = classFields.get(c);
        if (map != null) {
            return map;
        }
        HashMap<String, Field> fieldMap = JAVABEAN_STRICT ? new HashMap<String, Field>() : new CaseInsensitiveHashMap();
        for (Field field : c.getDeclaredFields()) {
            String name = field.getName();
            fieldMap.put(name, field);
        }
        classFields.put(c, fieldMap);
        return fieldMap;
    }

    public static Map<String, PropertyDescriptorWrap> getClassProperty(Class c) {
        Map<String, PropertyDescriptorWrap> map = classProperty.get(c);
        if (map != null) {
            return map;
        }
        Class clazz = c;
        synchronized (clazz) {
            map = classProperty.get(c);
            if (map != null) {
                return map;
            }
            try {
                HashMap<String, PropertyDescriptorWrap> propertyMap = new HashMap<String, PropertyDescriptorWrap>();
                PropertyDescriptor[] propertyDescriptors = BeanKit.propertyDescriptors(c);
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                    String name = propertyDescriptor.getName();
                    propertyMap.put(name, propertyDescriptorWrapFactory.make(c, propertyDescriptor, i));
                }
                for (PropertyDescriptorWrap wrap : propertyMap.values()) {
                    wrap.init(c);
                }
                classProperty.put(c, propertyMap);
                return propertyMap;
            }
            catch (IntrospectionException ex) {
                throw new IllegalStateException(c.getName());
            }
        }
    }

    public static void clearCache() {
        classFields.clear();
        classProperty.clear();
        classInsCache.clearAll();
    }

    public static PropertyDescriptorWrap getPropertyDescriptorWrapWithNull(Class c, String attr) {
        Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(c);
        PropertyDescriptorWrap propertyDescriptor = map.get(attr);
        return propertyDescriptor;
    }

    public static PropertyDescriptorWrap getPropertyDescriptorWrap(Class c, String attr) {
        Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(c);
        PropertyDescriptorWrap propertyDescriptor = map.get(attr);
        if (propertyDescriptor == null) {
            throw new BeetlSQLException(3, "\u627e\u4e0d\u5230\u5c5e\u6027 " + attr + " @" + c);
        }
        return propertyDescriptor;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class c, String attr) {
        Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(c);
        PropertyDescriptorWrap propertyDescriptor = map.get(attr);
        if (propertyDescriptor == null) {
            throw new BeetlSQLException(3, "\u627e\u4e0d\u5230\u5c5e\u6027 " + attr + " @" + c);
        }
        return propertyDescriptor.getProp();
    }

    public static PropertyDescriptor getPropertyDescriptorWithNull(Class c, String attr) {
        Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(c);
        PropertyDescriptorWrap propertyDescriptor = map.get(attr);
        return propertyDescriptor.getProp();
    }

    public static Map getMapIns(Class cls) {
        if (cls == Map.class) {
            return new CaseInsensitiveHashMap();
        }
        try {
            return (Map)cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List getListIns(Class list) {
        if (list == List.class) {
            return new ArrayList();
        }
        try {
            return (List)list.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getBeanProperty(Object o, String attrName) {
        try {
            Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(o.getClass());
            PropertyDescriptorWrap propertyDescriptor = map.get(attrName);
            if (propertyDescriptor == null) {
                throw new BeetlSQLException(3, "\u5c5e\u6027\u4e0d\u5b58\u5728 " + attrName + " @" + o.getClass());
            }
            return propertyDescriptor.getValue(o);
        }
        catch (Exception ex) {
            throw new BeetlSQLException(3, "\u5c5e\u6027\u53d6\u503c\u9519\u8bef " + attrName + " @" + o.getClass() + ",Error=" + ex.getMessage());
        }
    }

    public static void setBeanProperty(Object o, Object value, String attrName) {
        PropertyDescriptorWrap propertyDescriptor = BeanKit.getClassProperty(o.getClass()).get(attrName);
        if (propertyDescriptor == null) {
            throw new BeetlSQLException(3, "\u5c5e\u6027\u4e0d\u5b58\u5728 " + attrName + " @" + o.getClass());
        }
        try {
            propertyDescriptor.setValue(o, value);
        }
        catch (Exception ex) {
            throw new BeetlSQLException(3, "\u5c5e\u6027\u8d4b\u503c\u9519\u8bef " + attrName + " @" + o.getClass() + ",Error=" + ex.getMessage());
        }
    }

    public static void setBeanPropertyWithCast(Object o, Object value, String attrName) {
        if (value == null) {
            return;
        }
        Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(o.getClass());
        PropertyDescriptorWrap propertyDescriptor = map.get(attrName);
        Class<?> type = propertyDescriptor.getProp().getPropertyType();
        Object requiredValue = BeanKit.convertValueToRequiredType(value, type);
        propertyDescriptor.setValue(o, requiredValue);
    }

    public static Object convertValueToRequiredType(Object result, Class<?> requiredType) {
        if (result == null) {
            return null;
        }
        Class<?> type = result.getClass();
        if (type == result) {
            return result;
        }
        if (String.class == requiredType) {
            return result.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (result instanceof Number) {
                return NumberKit.convertNumberToTargetClass((Number)result, requiredType);
            }
            return NumberKit.parseNumber(result.toString(), requiredType);
        }
        if (requiredType.isPrimitive() && result instanceof Number) {
            return NumberKit.convertNumberToTargetClass((Number)result, requiredType);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u5316\u6210\u671f\u671b\u7c7b\u578b:" + requiredType);
    }

    public static <T extends Annotation> T getAnnotation(Class c, Class<T> expect) {
        do {
            T an;
            if ((an = c.getAnnotation(expect)) == null) continue;
            return an;
        } while ((c = c.getSuperclass()) != null && c != Object.class);
        return null;
    }

    public static Annotation getMethodAnnotation(Method m, Class expect) {
        for (Annotation annotation : m.getAnnotations()) {
            Object target = annotation.annotationType().getAnnotation(expect);
            if (target == null) continue;
            return annotation;
        }
        return null;
    }

    public static Annotation getClassAnnotation(Class cls, Class expectAnnotation) {
        for (Annotation annotation : cls.getAnnotations()) {
            Object target = annotation.annotationType().getAnnotation(expectAnnotation);
            if (target == null) continue;
            return annotation;
        }
        return null;
    }

    public static <T> T newInstance(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new BeetlSQLException(9, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BeetlSQLException(9, (Throwable)e);
        }
    }

    public static Collection newCollectionInstance(Class c) {
        if (c.isInterface()) {
            if (c.isAssignableFrom(List.class)) {
                return new ArrayList();
            }
            if (c.isAssignableFrom(Set.class)) {
                return new HashSet();
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b " + c);
        }
        return (Collection)BeanKit.newInstance(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T newSingleInstance(Class<T> c) {
        Class<T> clazz = c;
        synchronized (clazz) {
            Object ins = classInsCache.get(c);
            if (ins != null) {
                return (T)ins;
            }
            ins = BeanKit.newInstance(c);
            classInsCache.put(c, ins);
            return (T)ins;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class c, String property, Method getter, Class<T> annotationClass) {
        if (getter == null) {
            throw new NullPointerException("\u671f\u671bPOJO\u7c7b\u7b26\u5408javabean\u89c4\u8303\uff0c" + c + " \u6ca1\u6709getter\u65b9\u6cd5");
        }
        T t = getter.getAnnotation(annotationClass);
        if (t != null) {
            return t;
        }
        try {
            while (c != null && c != Object.class) {
                Map<String, Field> fieldMap = BeanKit.getClassFields(c);
                Field field = fieldMap.get(property);
                if (field != null) {
                    t = field.getAnnotation(annotationClass);
                    return t;
                }
                c = c.getSuperclass();
            }
            return t;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class c, String property, Class<T> annotationClass) {
        Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(c);
        PropertyDescriptorWrap propertyDescriptor = map.get(property);
        if (propertyDescriptor == null) {
            return null;
        }
        return BeanKit.getAnnotation(c, property, propertyDescriptor.getProp().getReadMethod(), annotationClass);
    }

    public static List<Annotation> getAllAnnotation(Class c, String property) {
        Map<String, PropertyDescriptorWrap> map = BeanKit.getClassProperty(c);
        PropertyDescriptorWrap propertyDescriptor = map.get(property);
        if (propertyDescriptor == null) {
            return null;
        }
        Method getter = propertyDescriptor.getProp().getReadMethod();
        Annotation[] array1 = getter.getAnnotations();
        Annotation[] array2 = null;
        Field f = BeanKit.getField(c, property);
        if (f != null) {
            array2 = f.getAnnotations();
        }
        return BeanKit.addAnnotation(array1, array2);
    }

    public static Field getField(Class c, String property) {
        while (c != null && c != Object.class) {
            Map<String, Field> fieldMap = BeanKit.getClassFields(c);
            Field field = fieldMap.get(property);
            if (field != null) {
                return field;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static boolean isJavaClass(Class entityClass) {
        Package pck = entityClass.getPackage();
        if (pck == null) {
            return false;
        }
        String pkgName = entityClass.getPackage().getName();
        return pkgName.startsWith("java") || pkgName.startsWith("javax") || Objects.isNull(entityClass.getClassLoader());
    }

    public static boolean isBaseDataType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getName().startsWith("java")) {
            return clazz == String.class || clazz == Integer.class || clazz == Byte.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Boolean.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class || clazz == LocalDateTime.class || clazz == LocalDate.class;
        }
        return false;
    }

    private static List<Annotation> addAnnotation(Annotation[] array1, Annotation[] array2) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        if (array1 != null) {
            list.addAll(Arrays.asList(array1));
        }
        if (array2 != null) {
            list.addAll(Arrays.asList(array2));
        }
        return list;
    }

    public static boolean containViewType(Class[] cls, Class viewType) {
        if (cls.length == 1) {
            return cls[0] == viewType;
        }
        if (cls.length == 2) {
            return cls[0] == viewType || cls[1] == viewType;
        }
        for (Class z : cls) {
            if (z != viewType) continue;
            return true;
        }
        return false;
    }

    public static Class getCollectionType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Class paraType = BeanKit.getParameterTypeClass(type);
        return paraType;
    }

    public static Class[] getMapType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Class[] paraType = BeanKit.getMapParameterTypeClass(type);
        return paraType;
    }

    public static Class getParameterTypeClass(Type t) {
        if (t instanceof WildcardType || t instanceof TypeVariable) {
            return null;
        }
        if (t instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)t).getActualTypeArguments();
            if (types.length == 0) {
                return null;
            }
            Type type = types[0];
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                return (Class)types[0];
            }
            if (type instanceof TypeVariable) {
                return null;
            }
            throw new UnsupportedOperationException(type.toString());
        }
        throw new UnsupportedOperationException(t.toString());
    }

    public static Class[] getMapParameterTypeClass(Type t) {
        if (t instanceof WildcardType || t instanceof TypeVariable) {
            return null;
        }
        if (t instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)t).getActualTypeArguments();
            if (types.length == 0) {
                return null;
            }
            Class[] classTypes = new Class[2];
            Type type = types[0];
            if (type instanceof ParameterizedType) {
                classTypes[0] = (Class)((ParameterizedType)type).getRawType();
            } else if (type instanceof Class) {
                classTypes[0] = (Class)types[0];
            } else {
                throw new UnsupportedOperationException(type.toString());
            }
            Type type1 = types[1];
            if (type1 instanceof ParameterizedType) {
                classTypes[1] = (Class)((ParameterizedType)type1).getRawType();
            } else if (type1 instanceof Class) {
                classTypes[1] = (Class)types[1];
            } else {
                throw new UnsupportedOperationException(type.toString());
            }
            return classTypes;
        }
        throw new UnsupportedOperationException(t.toString());
    }

    public static Class getMapperEntity(Class mapperInterface) {
        ParameterizedType pt;
        Type[] faces;
        if (mapperInterface.isInterface() && (faces = mapperInterface.getGenericInterfaces()).length > 0 && faces[0] instanceof ParameterizedType && (pt = (ParameterizedType)faces[0]).getActualTypeArguments().length > 0) {
            Class entityClass = (Class)pt.getActualTypeArguments()[0];
            return entityClass;
        }
        return null;
    }
}

