/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderKit {
    List<ClassLoader> otherLoaders = new ArrayList<ClassLoader>();

    public ClassLoaderKit(ClassLoader first) {
        this.otherLoaders.add(first);
    }

    public ClassLoaderKit() {
        ClassLoader first = this.getDefaultLoader();
        this.otherLoaders.add(first);
    }

    public ClassLoader getPreferredLoader() {
        return this.otherLoaders.get(0);
    }

    public Class loadClass(String className) {
        for (int i = 0; i < this.otherLoaders.size(); ++i) {
            ClassLoader loader = this.otherLoaders.get(i);
            try {
                Class<?> clazz = loader.loadClass(className);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public InputStream loadResource(String resource) {
        for (int i = 0; i < this.otherLoaders.size(); ++i) {
            ClassLoader loader = this.otherLoaders.get(i);
            InputStream inputStream = loader.getResourceAsStream(resource);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public URL loadResourceAsURL(String resource) {
        for (int i = 0; i < this.otherLoaders.size(); ++i) {
            ClassLoader loader = this.otherLoaders.get(i);
            URL url = loader.getResource(resource);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    protected ClassLoader getDefaultLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader;
        }
        return ClassLoaderKit.class.getClassLoader();
    }
}

