/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JavaType {
    public static Map<Integer, Class<?>> jdbcJavaTypes;
    public static Map<Class<?>, Integer> javaTypeJdbcs;
    public static Map<Integer, String> mapping;
    public static Map<String, Integer> jdbcTypeNames;
    public static Map<Integer, String> jdbcTypeId2Names;
    public static final int JAVA_MAJOR_VERSION;
    public static Method invokeDefaultMethod;
    public static final String UNKNOW = "UNKNOW";
    public static final String SPECIAL = "SPECIAL";

    public static boolean isJdk8() {
        return JAVA_MAJOR_VERSION >= 8;
    }

    public static boolean isDateType(Integer sqlType) {
        return sqlType == 91 || sqlType == 92 || sqlType == 2013 || sqlType == 93 || sqlType == 2014;
    }

    public static boolean isDateTimeType(Integer sqlType) {
        return sqlType == 93 || sqlType == 2014;
    }

    public static boolean isInteger(Integer sqlType) {
        return sqlType == 16 || sqlType == -7 || sqlType == 4 || sqlType == -6 || sqlType == 5;
    }

    public static String getType(Integer sqlType, Integer size, Integer digit) {
        String type = mapping.get(sqlType);
        if (SPECIAL.equals(type)) {
            if (digit != null && digit != 0) {
                return "Double";
            }
            if (size >= 9) {
                return "Long";
            }
            return "Integer";
        }
        return type;
    }

    public static boolean isJavaNumberType(int jdbcType) {
        Class<?> type = jdbcJavaTypes.get(jdbcType);
        return type == null ? false : Number.class.isAssignableFrom(type);
    }

    public static boolean isBigType(int sqlType) {
        return sqlType == 2004 || sqlType == 2005 || sqlType == 2011;
    }

    static {
        int majorVersion;
        jdbcJavaTypes = new HashMap();
        javaTypeJdbcs = new HashMap();
        mapping = new HashMap<Integer, String>();
        jdbcTypeNames = new HashMap<String, Integer>();
        jdbcTypeId2Names = new HashMap<Integer, String>();
        invokeDefaultMethod = null;
        try {
            String version = System.getProperty("java.specification.version");
            if (version.startsWith("1.")) {
                version = version.substring(2);
            }
            majorVersion = Integer.parseInt(version);
        }
        catch (Throwable ignored) {
            majorVersion = 8;
        }
        JAVA_MAJOR_VERSION = majorVersion;
        if (JAVA_MAJOR_VERSION >= 16) {
            Method[] ms;
            for (Method call : ms = InvocationHandler.class.getMethods()) {
                if (!"invokeDefault".equals(call.getName())) continue;
                invokeDefaultMethod = call;
                break;
            }
            if (invokeDefaultMethod == null) {
                throw new UnsupportedOperationException("\u5f53\u524dJava\u7248\u672c " + JAVA_MAJOR_VERSION + " \u672a\u627e\u5230invokeDefault");
            }
        }
        jdbcJavaTypes.put(-16, String.class);
        jdbcJavaTypes.put(-15, String.class);
        jdbcJavaTypes.put(-9, String.class);
        jdbcJavaTypes.put(-8, String.class);
        jdbcJavaTypes.put(-7, Boolean.class);
        jdbcJavaTypes.put(-6, Integer.class);
        jdbcJavaTypes.put(-5, Long.class);
        jdbcJavaTypes.put(-4, byte[].class);
        jdbcJavaTypes.put(-3, byte[].class);
        jdbcJavaTypes.put(-2, byte[].class);
        jdbcJavaTypes.put(-1, String.class);
        jdbcJavaTypes.put(1, String.class);
        jdbcJavaTypes.put(2, BigDecimal.class);
        jdbcJavaTypes.put(3, BigDecimal.class);
        jdbcJavaTypes.put(4, Integer.class);
        jdbcJavaTypes.put(5, Integer.class);
        jdbcJavaTypes.put(6, BigDecimal.class);
        jdbcJavaTypes.put(7, BigDecimal.class);
        jdbcJavaTypes.put(8, BigDecimal.class);
        jdbcJavaTypes.put(12, String.class);
        jdbcJavaTypes.put(16, Boolean.class);
        jdbcJavaTypes.put(91, Date.class);
        jdbcJavaTypes.put(92, Time.class);
        jdbcJavaTypes.put(93, Timestamp.class);
        jdbcJavaTypes.put(1111, Object.class);
        jdbcJavaTypes.put(2004, byte[].class);
        jdbcJavaTypes.put(2005, String.class);
        jdbcJavaTypes.put(2009, SQLXML.class);
        jdbcJavaTypes.put(2011, String.class);
        for (Map.Entry<Integer, Class<?>> entry : jdbcJavaTypes.entrySet()) {
            javaTypeJdbcs.put(entry.getValue(), entry.getKey());
        }
        mapping.put(-5, "Long");
        mapping.put(-2, "byte[]");
        mapping.put(-7, "Integer");
        mapping.put(2004, "byte[]");
        mapping.put(16, "Integer");
        mapping.put(1, "String");
        mapping.put(2005, "String");
        mapping.put(70, UNKNOW);
        mapping.put(91, "Date");
        mapping.put(3, SPECIAL);
        mapping.put(2001, UNKNOW);
        mapping.put(8, "Double");
        mapping.put(6, "Float");
        mapping.put(4, "Integer");
        mapping.put(2000, UNKNOW);
        mapping.put(-16, "String");
        mapping.put(-4, "byte[]");
        mapping.put(-1, "String");
        mapping.put(-15, "String");
        mapping.put(-9, "String");
        mapping.put(2011, "String");
        mapping.put(0, UNKNOW);
        mapping.put(2, SPECIAL);
        mapping.put(1111, "Object");
        mapping.put(7, "Double");
        mapping.put(2006, UNKNOW);
        mapping.put(5, "Integer");
        mapping.put(2009, "SQLXML");
        mapping.put(2002, UNKNOW);
        mapping.put(92, "Date");
        mapping.put(93, "Timestamp");
        mapping.put(-6, "Integer");
        mapping.put(-3, "byte[]");
        mapping.put(12, "String");
        if (JavaType.isJdk8()) {
            mapping.put(2012, UNKNOW);
            mapping.put(2014, "Timestamp");
            mapping.put(2013, "Timestamp");
        }
        Field[] fields = Types.class.getFields();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                String name = fields[i].getName().toLowerCase();
                Integer value = (Integer)fields[i].get(Types.class);
                jdbcTypeNames.put(name, value);
                jdbcTypeId2Names.put(value, name);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

