/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesKit {
    static final PropertiesKit propertiesKit = new PropertiesKit();
    Properties ps = new Properties();

    public PropertiesKit() {
        Properties defaultConfig = PropertiesKit.loadDefaultConfig();
        Properties extConfig = PropertiesKit.loadExtConfig();
        this.ps.putAll((Map<?, ?>)defaultConfig);
        this.ps.putAll((Map<?, ?>)extConfig);
    }

    public static PropertiesKit getInstance() {
        return propertiesKit;
    }

    public Properties getPs() {
        return this.ps;
    }

    public String getValue(String name) {
        return this.ps.getProperty(name);
    }

    public Integer getIntValue(String name) {
        return Integer.parseInt(this.ps.getProperty(name).trim());
    }

    public Integer getIntValue(String name, String defaultValue) {
        return Integer.parseInt(this.ps.getProperty(name, defaultValue).trim());
    }

    public static Properties loadDefaultConfig() {
        Properties ps = new Properties();
        InputStream ins = PropertiesKit.loadIns("/btsql.properties");
        if (ins == null) {
            throw new IllegalStateException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:\u627e\u4e0d\u5230 btsql.properties");
        }
        try {
            ps.load(ins);
        }
        catch (IOException e) {
            throw new IllegalStateException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:btsql.properties");
        }
        return ps;
    }

    private static Properties loadExtConfig() {
        Properties ps = new Properties();
        InputStream ins = PropertiesKit.loadIns("btsql-ext.properties");
        if (ins == null) {
            return ps;
        }
        try {
            ps.load(ins);
            ins.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:/btsql-ext.properties");
        }
        return ps;
    }

    protected static InputStream loadIns(String resource) {
        InputStream ins;
        if (Thread.currentThread().getContextClassLoader() != null && (ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource)) != null) {
            return ins;
        }
        ins = PropertiesKit.class.getResourceAsStream(resource);
        return ins;
    }
}

