/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aem.aemtenantspecificvanityurls.core.model.report;

import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.ibm.aem.aemtenantspecificvanityurls.core.exceptions.AtsvuException;
import com.ibm.aem.aemtenantspecificvanityurls.core.model.report.ReportEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ReportService.class})
public class ReportService {
    public static final String ORDER_ASC = "asc";
    public static final String ORDER_DESC = "desc";
    public static final String ORDER_BY_PATH = "path";
    public static final String ORDER_BY_VANITY_PATH = "vanityUrl";
    @Reference
    private QueryBuilder queryBuilder;

    public List<ReportEntry> getVanityEntries(int offset, int limit, ORDER_ATTR orderAttr, ORDER order, ResourceResolver resolver) throws AtsvuException {
        HashMap<String, String> predicates = new HashMap<String, String>();
        predicates.put(ORDER_BY_PATH, "/content");
        predicates.put("property", "sling:vanityPath");
        predicates.put("property.operation", "exists");
        if (orderAttr == ORDER_ATTR.PATH) {
            predicates.put("orderby", "@jcr:path");
        } else {
            predicates.put("orderby", "@sling:vanityPath");
        }
        if (ORDER.DESC == order) {
            predicates.put("orderby.sort", ORDER_DESC);
        }
        PredicateGroup predicateGroup = PredicateGroup.create(predicates);
        Query query = this.queryBuilder.createQuery(predicateGroup, (Session)resolver.adaptTo(Session.class));
        if (limit != 0) {
            query.setHitsPerPage((long)limit);
        }
        if (offset != 0) {
            query.setStart((long)offset);
        }
        ArrayList<ReportEntry> entries = new ArrayList<ReportEntry>();
        try {
            SearchResult result = query.getResult();
            List hits = result.getHits();
            for (Hit hit : hits) {
                Resource resource = hit.getResource();
                Resource pageResource = resource.getParent();
                ReportEntry entry = new ReportEntry();
                entry.setVanityUrl((String)resource.getValueMap().get("sling:vanityPath", String.class));
                entry.setPagePath(pageResource.getPath());
                entries.add(entry);
            }
        }
        catch (RepositoryException e) {
            throw new AtsvuException("Vanity search failed", e);
        }
        return entries;
    }

    public static enum ORDER_ATTR {
        PATH,
        VANITY_PATH;


        public static ORDER_ATTR parse(String value) {
            if (ReportService.ORDER_BY_PATH.equals(value)) {
                return PATH;
            }
            if (ReportService.ORDER_BY_VANITY_PATH.equals(value)) {
                return VANITY_PATH;
            }
            return null;
        }
    }

    public static enum ORDER {
        ASC,
        DESC;


        public static ORDER parse(String value) {
            if (ReportService.ORDER_ASC.equals(value)) {
                return ASC;
            }
            if (ReportService.ORDER_DESC.equals(value)) {
                return DESC;
            }
            return null;
        }
    }
}

