/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.bundle;

import com.ibm.cics.bundle.Manifest;
import com.ibm.cics.bundle.ManifestImpl;
import com.ibm.cics.bundle.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class Bundle {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2008, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "@(#) ,GM02-202005171823 %I% %E% %U%";
    private ManifestImpl manifest;
    private JarOutputStream jarOut;
    public static final int MANIFEST_IMPORT = 1;
    public static final int MANIFEST_EXPORT = 2;
    public static final int MANIFEST_DEFINE = 3;
    static final String packageName = "com.ibm.cics.bundle";
    private ObjectFactory factory = new ObjectFactory();

    public Bundle(JarOutputStream jarOutputStream) {
        this.manifest = new ManifestImpl();
        this.jarOut = jarOutputStream;
    }

    public void setId(String id) {
        this.manifest.setId(id);
    }

    public void setBundleMajorVer(int major) {
        this.manifest.setBundleMajorVer(major);
    }

    public void setBundleMinorVer(int minor) {
        this.manifest.setBundleMinorVer(minor);
    }

    public void setBundleMicroVer(int micro) {
        this.manifest.setBundleMicroVer(micro);
    }

    public void addImport(String name, String type, boolean optional, boolean warn) {
        Manifest.Import newImport = this.checkManifestImport(name, type);
        if (newImport == null) {
            newImport = this.factory.createManifestImport();
            this.manifest.getImport().add(newImport);
        }
        newImport.setName(name);
        newImport.setType(type);
        newImport.setOptional(optional);
        newImport.setWarn(null);
        if (optional) {
            newImport.setWarn(warn);
        }
    }

    public void addImport(String name, String type) {
        Manifest.Import newImport = this.checkManifestImport(name, type);
        if (newImport == null) {
            newImport = this.factory.createManifestImport();
            this.manifest.getImport().add(newImport);
        }
        newImport.setName(name);
        newImport.setType(type);
        newImport.setOptional(null);
        newImport.setWarn(null);
    }

    public void addImport(Manifest.Import impElement) {
        this.addImport(impElement.getName(), impElement.getType(), impElement.isOptional(), impElement.isWarn());
    }

    public void deleteImport(String name, String type) {
        this.manifest.getImport().remove(this.checkManifestImport(name, type));
    }

    public void addExport(String name, String type) {
        Manifest.Export newExport = this.checkManifestExport(name, type);
        if (newExport == null) {
            newExport = this.factory.createManifestExport();
            this.manifest.getExport().add(newExport);
        }
        newExport.setName(name);
        newExport.setType(type);
    }

    public void addExport(Manifest.Export expElement) {
        this.addExport(expElement.getName(), expElement.getType());
    }

    public void deleteExport(String name, String type) {
        this.manifest.getExport().remove(this.checkManifestExport(name, type));
    }

    public void addDefine(Manifest.Define defElement, InputStream inputStream) throws IOException {
        this.deleteDefine(defElement.getName(), defElement.getType());
        this.manifest.getDefine().add(defElement);
        this.addArchiveFile(defElement.getPath(), inputStream);
    }

    public void addDefine(String name, String type, String path, InputStream inputStream) throws IOException {
        Manifest.Define newDefine = this.checkManifestDefine(name, type);
        if (newDefine == null) {
            newDefine = this.factory.createManifestDefine();
            this.manifest.getDefine().add(newDefine);
            this.addArchiveFile(path, inputStream);
        }
        newDefine.setName(name);
        newDefine.setType(type);
        newDefine.setPath(path);
    }

    public void deleteDefine(String name, String type) {
        this.manifest.getDefine().remove(this.checkManifestDefine(name, type));
    }

    public void addModifyEntryPoint(String name, String type, String operation) throws IOException {
        Manifest.Modify newModify = this.checkManifestModifyEntry(name, type, operation);
        if (newModify == null) {
            Manifest.Modify.Entrypoint newEntryPoint = this.factory.createManifestModifyEntrypoint();
            newModify = this.factory.createManifestModify();
            newModify.setEntrypoint(newEntryPoint);
            this.manifest.getModify().add(newModify);
        }
        newModify.entrypoint.setName(name);
        newModify.entrypoint.setType(type);
        newModify.entrypoint.setOperation(operation);
    }

    public void deleteModifyEntry(String name, String type, String operation) {
        this.manifest.getModify().remove(this.checkManifestModifyEntry(name, type, operation));
    }

    public void addModifyPolicyScope(String name, String type, String operation) throws IOException {
        Manifest.Modify newModify = this.checkManifestPolicyScope(name, type, operation);
        if (newModify == null) {
            Manifest.Modify.Policyscope newEntryPoint = this.factory.createManifestModifyPolicyscope();
            newModify = this.factory.createManifestModify();
            newModify.setPolicyscope(newEntryPoint);
            this.manifest.getModify().add(newModify);
        }
        newModify.policyscope.setName(name);
        newModify.policyscope.setType(type);
        newModify.policyscope.setOperation(operation);
    }

    public void deletePolicyScope(String name, String type, String operation) {
        this.manifest.getModify().remove(this.checkManifestPolicyScope(name, type, operation));
    }

    public boolean manifestEntryExist(int elementType, String name, String type) {
        switch (elementType) {
            case 1: {
                return this.checkManifestImport(name, type) != null;
            }
            case 2: {
                return this.checkManifestExport(name, type) != null;
            }
            case 3: {
                return this.checkManifestDefine(name, type) != null;
            }
        }
        return false;
    }

    private Manifest.Import checkManifestImport(String name, String type) {
        for (Manifest.Import impElement : this.manifest.getImport()) {
            if (!impElement.getName().equals(name) || !impElement.getType().equals(type)) continue;
            return impElement;
        }
        return null;
    }

    private Manifest.Export checkManifestExport(String name, String type) {
        for (Manifest.Export expElement : this.manifest.getExport()) {
            if (!expElement.getName().equals(name) || !expElement.getType().equals(type)) continue;
            return expElement;
        }
        return null;
    }

    private Manifest.Define checkManifestDefine(String name, String type) {
        for (Manifest.Define defElement : this.manifest.getDefine()) {
            if (!defElement.getName().equals(name) || !defElement.getType().equals(type)) continue;
            return defElement;
        }
        return null;
    }

    private Manifest.Modify checkManifestModifyEntry(String name, String type, String operation) {
        for (Manifest.Modify modElement : this.manifest.getModify()) {
            if (modElement.entrypoint == null || !modElement.entrypoint.getName().equals(name) || !modElement.entrypoint.getType().equals(type) || !modElement.entrypoint.getOperation().equals(operation)) continue;
            return modElement;
        }
        return null;
    }

    private Manifest.Modify checkManifestPolicyScope(String name, String type, String operation) {
        for (Manifest.Modify modElement : this.manifest.getModify()) {
            if (modElement.policyscope == null || !modElement.policyscope.getName().equals(name) || !modElement.policyscope.getType().equals(type) || !modElement.policyscope.getOperation().equals(operation)) continue;
            return modElement;
        }
        return null;
    }

    public void addArchiveFile(String path, InputStream inputStream) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path for Bundle Define cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStrem to add to Bundle Define cannot be null");
        }
        this.jarOut.putNextEntry(new ZipEntry(path));
        Bundle.writeFile(inputStream, this.jarOut);
        this.jarOut.closeEntry();
    }

    private static void writeFile(InputStream in, OutputStream out) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
    }

    public void writeArchive() throws JAXBException, IOException, SAXException {
        ManifestImpl.writeManifest(this.manifest, this.jarOut);
    }

    private void writeManifest(OutputStream manifestOutStream) throws JAXBException, IOException, SAXException {
        ManifestImpl.marshallManifest(this.manifest, manifestOutStream);
    }
}

