/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.bundle;

import com.ibm.cics.bundle.Manifest;
import com.ibm.cics.bundle.ObjectFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ManifestImpl
extends Manifest {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2008, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "@(#) ,GM02-202005171823 %I% %E% %U%";
    static final String packageName = "com.ibm.cics.bundle";
    protected static final String BUILD_LEVEL = ",GM02-202005171823";
    protected static String BUILD_LEVEL_NAME = null;
    protected static final String BUILD_LEVEL_UNKNOWN = "Not Found";
    static final String manifestLocation = "META-INF/cics.xml";
    static final String typeURI = "http://www.ibm.com/xmlns/prod/cics/bundle";
    public static final int ATOMSERVICE_TYPE = 0;
    public static final int DB2ENTRY_TYPE = 1;
    public static final int DB2TRAN_TYPE = 2;
    public static final int DOCTEMPLATE_TYPE = 3;
    public static final int ENQMODEL_TYPE = 4;
    public static final int EVENTBINDING_TYPE = 5;
    public static final int FILE_TYPE = 6;
    public static final int JOURNALMODEL_TYPE = 7;
    public static final int MAPSET_TYPE = 8;
    public static final int PARTITIONSET_TYPE = 9;
    public static final int PIPELINE_TYPE = 10;
    public static final int PROCESSTYPE_TYPE = 11;
    public static final int PROGRAM_TYPE = 12;
    public static final int SCACOMPOSITE_TYPE = 13;
    public static final int TRANSACTION_TYPE = 14;
    public static final int TSQMODEL_TYPE = 15;
    public static final int URIMAP_TYPE = 16;
    public static final int WEBSERVICE_TYPE = 17;
    public static final int XMLTRANSFORM_TYPE = 18;
    public static final int DB2CONN_TYPE = 19;
    public static final int JVMSERVER_TYPE = 20;
    public static final int LIBRARY_TYPE = 21;
    public static final int MQCONN_TYPE = 22;
    public static final int TCPIPSERVICE_TYPE = 23;
    public static final int TDQUEUE_TYPE = 24;
    public static final String[] types;
    ObjectFactory factory = new ObjectFactory();

    public ManifestImpl() {
        this.createManifest();
    }

    public ManifestImpl(InputStream manifestInStream) throws JAXBException, SAXException {
        this.cloneManifest(ManifestImpl.unmarshallManifest(manifestInStream));
    }

    private void readInManifest(InputStream manifestInStream) throws JAXBException, SAXException {
        this.cloneManifest(ManifestImpl.unmarshallManifest(manifestInStream));
    }

    private void cloneManifest(Manifest man) {
        this.bundleVersion = man.bundleVersion;
        this.bundleRelease = man.bundleRelease;
        this.build = man.build;
        this.id = man.id;
        this.bundleMajorVer = man.bundleMajorVer;
        this.bundleMinorVer = man.bundleMinorVer;
        this.bundleMicroVer = man.bundleMicroVer;
        this.metaDirectives = man.metaDirectives;
        this.define = man.define;
        this.export = man.export;
        this._import = man._import;
        this.modify = man.modify;
    }

    public void setManifest(ManifestImpl man) {
        this.bundleVersion = man.bundleVersion;
        this.bundleRelease = man.bundleRelease;
        this.build = man.build;
        this.id = man.id;
        this.bundleMajorVer = man.bundleMajorVer;
        this.bundleMinorVer = man.bundleMinorVer;
        this.bundleMicroVer = man.bundleMicroVer;
        this.metaDirectives = man.metaDirectives;
        this.define = man.define;
        this.export = man.export;
        this._import = man._import;
        this.modify = man.modify;
    }

    public ManifestImpl getManifest() {
        return this;
    }

    private ManifestImpl createManifest() {
        int bundleversion = 1;
        Integer bundlerelease = 0;
        String build = BUILD_LEVEL_NAME;
        this.factory = new ObjectFactory();
        this.setBundleVersion(bundleversion);
        this.setBundleRelease(bundlerelease);
        this.setBuild(ManifestImpl.validateBuild(build));
        this.addMetaDirectivesElement();
        return this;
    }

    private static String validateBundleVersion(String bundleversion) {
        if (bundleversion.length() > 3) {
            return bundleversion.substring(0, 3);
        }
        return bundleversion;
    }

    private static String validateBundleRelease(String bundlerelease) {
        if (bundlerelease.length() > 10) {
            return bundlerelease.substring(0, 10);
        }
        return bundlerelease;
    }

    private static String validateBuild(String build) {
        if (build.length() > 20) {
            return build.substring(0, 20);
        }
        return build;
    }

    private static String timestampFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S").format(new Date());
    }

    protected static void marshallManifest(ManifestImpl manifest, OutputStream out) throws JAXBException, SAXException {
        JAXBContext jaxbcontext = JAXBContext.newInstance((String)packageName);
        Marshaller marshaller = jaxbcontext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ManifestImpl.class.getClassLoader().getResource("schemaForBundleManifest.xsd")));
        marshaller.marshal((Object)manifest, out);
    }

    protected static ManifestImpl unmarshallManifest(File file) throws JAXBException, SAXException {
        JAXBContext jaxbcontext = JAXBContext.newInstance((String)packageName);
        Unmarshaller unmarshaller = jaxbcontext.createUnmarshaller();
        unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ManifestImpl.class.getClassLoader().getResource("schemaForBundleManifest.xsd")));
        return (ManifestImpl)unmarshaller.unmarshal(file);
    }

    private static Manifest unmarshallManifest(InputStream ins) throws JAXBException, SAXException {
        JAXBContext jaxbcontext = JAXBContext.newInstance((String)packageName);
        Unmarshaller unmarshaller = jaxbcontext.createUnmarshaller();
        unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ManifestImpl.class.getClassLoader().getResource("schemaForBundleManifest.xsd")));
        return (Manifest)unmarshaller.unmarshal(ins);
    }

    public String getType(int type) {
        try {
            return "http://www.ibm.com/xmlns/prod/cics/bundle/" + types[type];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid index: " + type);
            iae.initCause(aioobe);
            throw iae;
        }
    }

    private void addMetaDirectivesElement() {
        Manifest.MetaDirectives metaDirective = this.factory.createManifestMetaDirectives();
        this.setMetaDirectives(metaDirective);
        try {
            metaDirective.setTimestamp(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        }
        catch (DatatypeConfigurationException dce) {
            RuntimeException createTimestamp = new RuntimeException();
            createTimestamp.initCause(dce);
            throw createTimestamp;
        }
    }

    public void addMetaDirectiveSimple(String elementName, String content) {
        Document doc;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Parser Configuration Error", e);
        }
        Element mde = doc.createElementNS(typeURI, elementName);
        Text node = doc.createTextNode(content);
        mde.appendChild(node);
        Manifest.MetaDirectives md = this.getMetaDirectives();
        if (md == null) {
            this.addMetaDirectivesElement();
        }
        this.getMetaDirectives().getAny().add(mde);
    }

    public void deleteMetaDirective(String elementName) {
        Iterator<Object> iter = this.getMetaDirectives().getAny().iterator();
        Element anyElement = null;
        Element removeElement = null;
        while (iter.hasNext() & removeElement == null) {
            anyElement = (Element)iter.next();
            if (!anyElement.getLocalName().equals(elementName)) continue;
            removeElement = anyElement;
        }
        if (removeElement != null) {
            this.getMetaDirectives().getAny().remove(removeElement);
        }
    }

    public String getMetaDirectiveSimpleContent(String elementName) {
        Iterator<Object> iter = this.getMetaDirectives().getAny().iterator();
        Element anyElement = null;
        while (iter.hasNext()) {
            anyElement = (Element)iter.next();
            if (!anyElement.getLocalName().equals(elementName)) continue;
            try {
                return anyElement.getFirstChild().getTextContent();
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return null;
    }

    public void addExport(String name, String type) {
        Manifest.Export newExport = this.checkManifestExport(name, type);
        if (newExport == null) {
            newExport = this.factory.createManifestExport();
            this.getExport().add(newExport);
        }
        newExport.setName(name);
        newExport.setType(type);
    }

    public void addExport(String name, int type) {
        this.addExport(name, this.getType(type));
    }

    public void addExport(Manifest.Export expElement) {
        this.deleteExport(expElement.getName(), expElement.getType());
        this.getExport().add(expElement);
    }

    public void deleteExport(String name, String type) {
        this.getExport().remove(this.checkManifestExport(name, type));
    }

    public void deleteExport(String name, int type) {
        this.deleteExport(name, this.getType(type));
    }

    public void addImport(String name, String type, boolean optional, boolean warn) {
        Manifest.Import newImport = this.checkManifestImport(name, type);
        if (newImport == null) {
            newImport = this.factory.createManifestImport();
            this.getImport().add(newImport);
        }
        newImport.setName(name);
        newImport.setType(type);
        newImport.setOptional(optional);
        newImport.setWarn(null);
        if (optional) {
            newImport.setWarn(warn);
        }
    }

    public void addImport(String name, int type, boolean optional, boolean warn) {
        this.addImport(name, this.getType(type), optional, warn);
    }

    public void addImport(String name, String type) {
        Manifest.Import newImport = this.checkManifestImport(name, type);
        if (newImport == null) {
            newImport = this.factory.createManifestImport();
            this.getImport().add(newImport);
        }
        newImport.setName(name);
        newImport.setType(type);
        newImport.setOptional(null);
        newImport.setWarn(null);
    }

    public void addImport(String name, int type) {
        this.addImport(name, this.getType(type));
    }

    public void addImport(Manifest.Import impElement) {
        this.deleteImport(impElement.getName(), impElement.getType());
        this.getImport().add(impElement);
    }

    public void deleteImport(String name, String type) {
        this.getImport().remove(this.checkManifestImport(name, type));
    }

    public void deleteImport(String name, int type) {
        this.deleteImport(name, this.getType(type));
    }

    public void addDefine(String name, String type, String path) {
        Manifest.Define newDefine = this.checkManifestDefine(name, type, path);
        if (newDefine == null) {
            newDefine = this.factory.createManifestDefine();
            this.getDefine().add(newDefine);
        }
        newDefine.setName(name);
        newDefine.setType(type);
        newDefine.setPath(path);
    }

    public void addDefine(String name, int type, String path) {
        this.addDefine(name, this.getType(type), path);
    }

    public void addDefine(Manifest.Define defElement) {
        this.deleteDefine(defElement.getName(), defElement.getType(), defElement.getPath());
        this.getDefine().add(defElement);
    }

    public void addDefine(String name, String type, String path, int index) {
        Manifest.Define newDefine = this.checkManifestDefine(name, type, path);
        if (newDefine == null) {
            newDefine = this.factory.createManifestDefine();
            this.getDefine().add(index, newDefine);
        }
        newDefine.setName(name);
        newDefine.setType(type);
        newDefine.setPath(path);
    }

    public void deleteDefine(String name, String type, String path) {
        this.getDefine().remove(this.checkManifestDefine(name, type, path));
    }

    public void deleteDefine(String name, int type, String path) {
        this.deleteDefine(name, this.getType(type), path);
    }

    public void deleteDefine(String name, String type) {
        this.getDefine().remove(this.checkManifestDefine(name, type));
    }

    public void deleteDefine(String name, int type) {
        this.deleteDefine(name, this.getType(type));
    }

    private Manifest.Export checkManifestExport(String name, String type) {
        for (Manifest.Export expElement : this.getExport()) {
            if (!expElement.getName().equals(name) || !expElement.getType().equals(type)) continue;
            return expElement;
        }
        return null;
    }

    private Manifest.Import checkManifestImport(String name, String type) {
        for (Manifest.Import impElement : this.getImport()) {
            if (!impElement.getName().equals(name) || !impElement.getType().equals(type)) continue;
            return impElement;
        }
        return null;
    }

    private Manifest.Define checkManifestDefine(String name, String type, String path) {
        for (Manifest.Define defElement : this.getDefine()) {
            if (!defElement.getName().equals(name) || !defElement.getType().equals(type) || !defElement.getPath().equals(path)) continue;
            return defElement;
        }
        return null;
    }

    private Manifest.Define checkManifestDefine(String name, String type) {
        for (Manifest.Define defElement : this.getDefine()) {
            if (!defElement.getName().equals(name) || !defElement.getType().equals(type)) continue;
            return defElement;
        }
        return null;
    }

    public void writeManifest(OutputStream manifestOutStream) throws JAXBException, IOException, SAXException {
        ManifestImpl.marshallManifest(this, manifestOutStream);
    }

    protected static void writeManifest(Manifest manifest, JarOutputStream jarOut) throws JAXBException, IOException, SAXException {
        jarOut.putNextEntry(new ZipEntry(manifestLocation));
        JAXBContext jaxbcontext = JAXBContext.newInstance((String)packageName);
        Marshaller marshaller = jaxbcontext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ManifestImpl.class.getClassLoader().getResource("schemaForBundleManifest.xsd")));
        marshaller.marshal((Object)manifest, (OutputStream)jarOut);
        jarOut.closeEntry();
    }

    static {
        int commaPos = BUILD_LEVEL.lastIndexOf(44);
        if (commaPos == -1) {
            BUILD_LEVEL_NAME = BUILD_LEVEL_UNKNOWN;
        } else {
            BUILD_LEVEL_NAME = BUILD_LEVEL.substring(commaPos + 1).trim();
            int space = BUILD_LEVEL_NAME.indexOf(32);
            if (space != -1) {
                BUILD_LEVEL_NAME = BUILD_LEVEL_NAME.substring(0, space);
            }
        }
        types = new String[]{"ATOMSERVICE", "DB2ENTRY", "DB2TRAN", "DOCTEMPLATE", "ENQMODEL", "EVENTBINDING", "FILE", "JOURNALMODEL", "MAPSET", "PARTITIONSET", "PIPELINE", "PROCESSTYPE", "PROGRAM", "SCACOMPOSITE", "TRANSACTION", "TSQMODEL", "URIMAP", "WEBSERVICE", "XMLTRANSFORM", "DB2CONN", "JVMSERVER", "LIBRARY", "MQCONN", "TCPIPSERVICE", "TDQUEUE"};
    }
}

