/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.gen.api.example;

import com.ibm.cics.gen.api.Factory;
import com.ibm.cics.gen.api.IAssistantParameters;
import com.ibm.cics.gen.api.IAssistantResponse;
import com.ibm.cics.gen.api.ICICSWebServicesAssistant;

public class Sample {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2010 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String XC001_DIR = "test\\bottomup\\";
    private static final String XC003_DIR = "test\\topdown\\";

    public static void main(String[] args) {
        Sample.doBUP();
        Sample.doTD();
    }

    private static void doBUP() {
        IAssistantParameters param = Factory.createAssistantParameters();
        param.setParamLANG("COBOL");
        param.setParamPDSLIB(XC001_DIR);
        param.setParamPGMINT("COMMAREA");
        param.setParamPGMNAME("XC001");
        param.setParamREQMEM("XC001.cbl");
        param.setParamRESPMEM("XC001.cbl");
        param.setParamURI("/xmletest/XC001");
        param.setParamWSBIND("test\\bottomup\\XC001.wsbind");
        param.setParamWSDL("test\\bottomup\\XC001.wsdl");
        param.setParamLOGFILE("test\\bottomup\\XC001.log");
        try {
            ICICSWebServicesAssistant cwsa = Factory.createCICSWebServicesAssistant();
            System.out.println("WSAssistants version number is: " + cwsa.getVersionInformation());
            IAssistantResponse ar = cwsa.DFHLS2WS(param);
            System.out.println("DFHLS2WS:AssistantResponse.getReturnCode():" + ar.getReturnCode());
            System.out.println("----AssistantResponse.getMessages()----");
            String[] msgs = ar.getAllMessages();
            for (int i = 0; i < msgs.length; ++i) {
                System.out.println(msgs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doTD() {
        IAssistantParameters param = Factory.createAssistantParameters();
        param.setParamLANG("COBOL");
        param.setParamPDSLIB(XC003_DIR);
        param.setParamPGMINT("COMMAREA");
        param.setParamBINDING("XC003Binding");
        param.setParamPGMNAME("XC003");
        param.setParamREQMEM("XC003I.cbl");
        param.setParamRESPMEM("XC003O.cbl");
        param.setParamURI("/xmletest/XC003");
        param.setParamWSBIND("test\\topdown\\XC003.wsbind");
        param.setParamWSDL("test\\topdown\\XC003.wsdl");
        param.setParamLOGFILE("test\\topdown\\XC003.log");
        try {
            ICICSWebServicesAssistant cwsa = Factory.createCICSWebServicesAssistant();
            IAssistantResponse ar = cwsa.DFHWS2LS(param);
            System.out.println("DFHWS2LS:AssistantResponse.getReturnCode():" + ar.getReturnCode());
            System.out.println("----AssistantResponse.getMessages()----");
            String[] msgs = ar.getAllMessages();
            for (int i = 0; i < msgs.length; ++i) {
                System.out.println(msgs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

