/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMInputArrayEndDataType;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureEndDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public interface ICM {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SCCSID = "%Z% %W% %I% %E% %U%";
    public static final int FIRST_RECORD_TYPE = 1;
    public static final int DATA_ELEMENT_RECORD_TYPE = 1;
    public static final int FIXED_REPEAT_RECORD_TYPE = 2;
    public static final int VARIABLE_REPEAT_RECORD_TYPE = 3;
    public static final int END_REPEAT_RECORD_TYPE = 4;
    public static final int END_DATA_SECTION_TYPE = 5;
    public static final int EXTENDED_DATA_ELEMENT_RECORD_TYPE = 6;
    public static final int EXTENDED_FIXED_REPEAT_RECORD = 7;
    public static final int EXTENDED_VARIABLE_REPEAT_RECORD = 8;
    public static final int ATTRIBUTE_RECORD_TYPE = 9;
    public static final int RAW_XML_RECORD_TYPE = 10;
    public static final int START_CHOICE_GROUP_ENTRY_TYPE = 11;
    public static final int END_CHOICE_GROUP_ENTRY_TYPE = 12;
    public static final int CHOICE_GROUP_ENTRY_START_TYPE = 13;
    public static final int CHOICE_GROUP_ENTRY_END_TYPE = 14;
    public static final int ABSTRACT_TYPE_START_TYPE = 15;
    public static final int ABSTRACT_TYPE_END_TYPE = 16;
    public static final int ABSTRACT_TYPE_OPTION_TYPE = 17;
    public static final int RAW_JSON_RECORD_TYPE = 18;
    public static final int LAST_RECORD_TYPE = 18;
    public static final String[] RECORD_TYPES = new String[]{"UNUSED", "DATA_ELEMENT", "FIXED_REPEAT", "VARIABLE_REPEAT", "END_REPEAT", "END_DATA_SECTION", "EXTENDED_DATA_ELEMENT", "EXTENDED_FIXED_REPEAT", "EXTENDED_VARIABLE_REPEAT", "ATTRIBUTE", "RAW_XML", "START_CHOICE_GROUP", "END_CHOICE_GROUP", "CHOICE_GROUP_ENTRY_START", "CHOICE_GROUP_ENTRY_END", "ABSTRACT_TYPE_START", "ABSTRACT_TYPE_END", "ABSTRACT_TYPE_OPTION", "RAW_JSON"};
    public static final int FIRST_LANGUAGE = 1;
    public static final int COBOL_LANGUAGE = 1;
    public static final int PLI_LANGUAGE = 2;
    public static final int C_LANGUAGE = 3;
    public static final int C_PLUS_PLUS_LANGUAGE = 4;
    public static final int ASSEMBLER_LANGUAGE = 5;
    public static final int OLD_PLI_LANGUAGE = 6;
    public static final int PLX_LANGUAGE = 7;
    public static final int LAST_LANGUAGE = 7;
    public static final String[] LANGUAGE_TYPES = new String[]{"UNUSED", "COBOL", "ENTERPRISE PL/I", "C", "C++", "ASSEMBLER(UNUSED)", "PRE-ENTERPRISE PL/I", "PL/X (Experimental)"};
    public static final int RPC_STYLE = 0;
    public static final int DOCUMENT_STYLE = 1;
    public static final int WRAPPED_STYLE = 2;
    public static final String[] STYLE_TYPES = new String[]{"RPC", "DOCUMENT", "WRAPPED_DOCUMENT"};
    public static final int FIRST_STYLE = 0;
    public static final int LAST_STYLE = 2;
    public static final int MAPPING_LEVEL_UNSPECIFIED = 0;
    public static final int MAPPING_LEVEL_2 = 1;
    public static final int MAPPING_LEVEL_1_1 = 2;
    public static final int MAPPING_LEVEL_1 = 3;
    public static final int MAPPING_LEVEL_1_2 = 4;
    public static final int MAPPING_LEVEL_2_1 = 5;
    public static final int MAPPING_LEVEL_2_2 = 6;
    public static final int MAPPING_LEVEL_3_0 = 7;
    public static final int MAPPING_LEVEL_4_0 = 8;
    public static final int MAPPING_LEVEL_4_1 = 9;
    public static final int MAPPING_LEVEL_4_2 = 10;
    public static final int MAPPING_LEVEL_4_3 = 11;
    public static final int MAPPING_LEVEL_4_4 = 12;
    public static final int MAPPING_LEVEL_5_0 = 13;
    public static final String[] MAPPING_LEVELS_FOR_DISPLAY = new String[]{"UNSPECIFIED (TS 3.1 GA mappings)", "2.0 (TS 3.2 GA mappings)", "1.1 (TS 3.1 + APAR PK15904 mappings)", "1.0 (TS 3.1 GA mappings)", "1.2 (TS 3.1 + APAR PK23547 mappings)", "2.1 (TS 3.2 + APAR PK59794 mappings)", "2.2 (TS 3.2 + APAR PK69738 mappings)", "3.0 (TS 4.1 GA mappings)", "4.0 (TS 5.2 GA mappings)", "4.1 (TS 5.2 + APAR PI67641 mappings)", "4.2 (TS 5.4 + APAR PI86039 mappings)", "4.3 (TS 5.4 + APAR PI88519 mappings)", "4.4 (Extend JSON Schema draft 05 support)", "5.0 (JSON Schema 2020-12 support)"};
    public static final String[] MAPPING_LEVELS = new String[]{"UNSPECIFIED", "2", "1.1", "1", "1.2", "2.1", "2.2", "3.0", "4.0", "4.1", "4.2", "4.3", "4.4", "5.0"};
    public static final byte[][] MAPPING_LEVELS_AS_ICM_VERSION_NUMS = new byte[][]{{0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 4, 0, 0, 0, 0}, {0, 0, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 3, 0, 0, 0, 0}, {0, 0, 0, 5, 0, 0, 0, 0}, {0, 0, 0, 6, 0, 0, 0, 0}, {0, 0, 0, 7, 0, 0, 0, 0}, {0, 0, 0, 8, 0, 0, 0, 0}, {0, 0, 0, 9, 0, 0, 0, 0}, {0, 0, 0, 10, 0, 0, 0, 0}, {0, 0, 0, 11, 0, 0, 0, 0}, {0, 0, 0, 12, 0, 0, 0, 0}, {0, 0, 0, 13, 0, 0, 0, 0}};
    public static final String[] MAPPING_LEVELS_AS_ICM_VERSION_NUMS_DISPLAY = new String[]{"00010000 (TS 3.1 GA mappings)", "00040000 (TS 3.2 GA mappings)", "00020000 (TS 3.1 + APAR PK15904 mappings)", "00010000 (TS 3.1 GA mappings)", "00030000 (TS 3.1 + APAR PK23547 mappings)", "00050000 (TS 3.2 + APAR PK59794 mappings)", "00060000 (TS 3.2 + APAR PK69738 mappings)", "00070000 (TS 3.0 GA mappings)", "00080000 (TS 5.2 GA mappings)", "00090000 (TS 5.2 + APAR PI67641 mappings)", "000A0000 (TS 5.4 + APAR PI86039 mappings)", "000B0000 (TS 5.4 + APAR PI88519 mappings)", "000C0000 (Extend JSON Schema draft 05 support)", "000D0000 (JSON Schema 2020-12 support)"};
    public static final int FIRST_MAPPING = 0;
    public static final int LAST_MAPPING = 13;
    public static final boolean ALIGNED_DATA = true;
    public static final boolean UNALIGNED_DATA = false;
    public static final int FIRST_DATA_TYPE = 1;
    public static final int CHAR_ARRAY_TYPE = 1;
    public static final int HEX_ARRAY_TYPE = 2;
    public static final int BYTE_TYPE = 3;
    public static final int UNSIGNED_BYTE_TYPE = 4;
    public static final int SHORT_TYPE = 5;
    public static final int UNSIGNED_SHORT_TYPE = 6;
    public static final int INT_TYPE = 7;
    public static final int UNSIGNED_INT_TYPE = 8;
    public static final int LONG_TYPE = 9;
    public static final int UNSIGNED_LONG_TYPE = 10;
    public static final int BOOLEAN_TYPE = 12;
    public static final int BFP_FLOAT = 13;
    public static final int BFP_DOUBLE = 14;
    public static final int DECIMAL_TYPE = 15;
    public static final int UNSIGNED_DECIMAL_TYPE = 16;
    public static final int BASE64_ARRAY = 17;
    public static final int ZONED_TYPE = 18;
    public static final int UNSIGNED_ZONED_TYPE = 19;
    public static final int HFP_SHORT = 20;
    public static final int HFP_LONG = 21;
    public static final int ABSTIME = 22;
    public static final int WIDE_CHAR_ARRAY_TYPE = 23;
    public static final int ENUM_TYPE = 24;
    public static final int BIT_ARRAY_TYPE = 25;
    public static final int UTF16_ARRAY_TYPE = 26;
    public static final int LAST_DATA_TYPE = 26;
    public static final String UNUSED = "UNUSED";
    public static final String[] DATA_TYPES = new String[]{"UNUSED", "CHAR_ARRAY", "HEX_ARRAY", "BYTE", "UNSIGNED_BYTE", "SHORT", "UNSIGNED_SHORT", "INT", "UNSIGNED_INT", "LONG", "UNSIGNED_LONG", "UNUSED", "BOOLEAN", "BFP_FLOAT", "BFP_DOUBLE", "DECIMAL", "UNSIGNED_DECIMAL", "BASE64_ARRAY", "ZONED", "UNSIGNED_ZONED", "HFP_SHORT", "HFP_LONG", "ABSTIME", "WIDE_CHAR_ARRAY", "ENUM", "BIT_ARRAY", "UTF16_CHAR_ARRAY"};
    public static final long MAX_BYTE_VAL = 127L;
    public static final long MAX_UNSIGNED_BYTE_VAL = 255L;
    public static final long MAX_SHORT_VAL = 32767L;
    public static final long MAX_UNSIGNED_SHORT_VAL = 65535L;
    public static final long MAX_INT_VAL = Integer.MAX_VALUE;
    public static final long MAX_UNSIGNED_INT_VAL = 0xFFFFFFFFL;
    public static final long MAX_LONG_VAL = Long.MAX_VALUE;
    public static final long MAX_UNSIGNED_LONG_VAL = Long.MAX_VALUE;
    public static final int FIRST_WHITE_SPACE_VALUE = 0;
    public static final int COLLAPSE_WHITE_SPACE = 0;
    public static final int REPLACE_WHITE_SPACE = 1;
    public static final int PRESERVE_WHITE_SPACE = 2;
    public static final int LAST_WHITE_SPACE_VALUE = 2;
    public static final String[] WHITESPACE_TYPES = new String[]{"COLLAPSE", "REPLACE", "PRESERVE"};
    public static final int REQUEST_MESSAGE = 0;
    public static final int RESPONSE_MESSAGE = 1;
    public static final int NOT_SOAP_MESSAGE__ELEMENT = 2;
    public static final int NOT_SOAP_MESSAGE__TYPE = 3;
    public static final String[] MESSAGE_TYPES = new String[]{"Request Message", "Response Message", "Directionless Message"};
    public static final int FIRST_VARYING_LEN_VALUE = 0;
    public static final int FIXED_LEN_ARRAY = 0;
    public static final int NULL_TERMINATED_CHAR_ARRAY = 1;
    public static final int VARYING_ARRAY = 2;
    public static final int VARYING_CONTAINER = 3;
    public static final int VARYING_NAMED_CONTAINER = 4;
    public static final int LAST_VARYING_LEN_VALUE = 4;
    public static final int WHITESPACE_COLLAPSE = 5;
    public static final int FIXED_LENGTH_BINARY = 6;
    public static final int NO_VARYING_STRATEGY = -1;
    public static final String[] VARYING_LENGTH_OPTIONS = new String[]{"FIXED_LENGTH_ARRAY", "NULL_TERMINATED_CHAR_ARRAY", "VARYING_ARRAY", "VARYING_CONTAINER", "VARYING_NAMED_CONTAINER", "WHITESPACE_COLLAPSE", "FIXED_LENGTH_BINARY"};

    public void addElementDeclaration(String var1, String var2, QName var3, boolean var4) throws ICMException;

    public void addTypeDefinition(String var1, String var2, QName var3) throws ICMException;

    public void addGlobalTypeDefinition(QName var1, boolean var2) throws ICMException;

    public void completedICM() throws ICMException, IOException;

    public String toString();

    public byte[] toByteArray() throws IOException, ICMException;

    public Element toXMLElement() throws ICMException;

    public List<ICMEntry> getContents() throws ICMException;

    public void addContainerEntry(ICMInputContainerDataType var1) throws ICMException;

    public void addDataElementEntry(ICMInputSimpleDataType var1) throws ICMException;

    public void addFixedRepeatEntry(ICMInputArrayStartDataType var1) throws ICMException;

    public void addEndRepeatEntry(ICMInputArrayEndDataType var1) throws ICMException;

    public void sendStructStart(ICMInputStructureStartDataType var1) throws ICMException;

    public void sendStructEnd(ICMInputStructureEndDataType var1) throws ICMException;

    public String[] getMessages();

    public long getCommAreaLength() throws ICMException;

    public long getICMLength();

    public String getTargetNameSpace();

    public String getTopLevelElementLocalName();

    public IPlatform.EndianType getEndianType();

    public IPlatform.ZonedEncodingType getZonedEncodingType();

    public static enum StructureType {
        STRUCTURE_STANDARD,
        STRUCTURE_CONTAINER,
        STRUCTURE_CONTAINER_OPTIONAL;

    }

    public static enum ContainerUsage {
        CONT_USE_REQUIRED,
        CONT_USE_OPTIONAL;

    }

    public static enum ContainerDataType {
        CONT_TYPE_TEXT,
        CONT_TYPE_BIT;

    }

    public static enum EncodingType {
        SBCS,
        DBCS,
        UTF16BE;

    }

    public static enum VaryingLength {
        NO_VARYING_STRATEGY(-1),
        FIXED_LENGTH_ARRAY(0),
        NULL_TERMINATED_CHAR_ARRAY(1),
        VARYING_ARRAY(2),
        VARYING_CONTAINER(3),
        VARYING_NAMED_CONTAINER(4),
        WHITESPACE_COLLAPSE(5),
        FIXED_LENGTH_BINARY(6);

        private static final Map<Integer, VaryingLength> lookup;
        private int code;

        private VaryingLength(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static VaryingLength get(int code) {
            return lookup.get(code);
        }

        public static VaryingLength get(Integer code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, VaryingLength>();
            for (VaryingLength x : EnumSet.allOf(VaryingLength.class)) {
                lookup.put(x.getCode(), x);
            }
        }
    }

    public static enum XMLContentType {
        SOAP_REQUEST(0),
        SOAP_RESPONSE(1),
        XML_ELEMENT(2),
        XML_TYPE(3);

        private static final Map<Integer, XMLContentType> lookup;
        private int code;

        private XMLContentType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static XMLContentType get(int code) {
            return lookup.get(code);
        }

        public static XMLContentType get(Integer code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, XMLContentType>();
            for (XMLContentType x : EnumSet.allOf(XMLContentType.class)) {
                lookup.put(x.getCode(), x);
            }
        }
    }

    public static enum WhiteSpace {
        COLLAPSE(0),
        REPLACE(1),
        PRESERVE(2);

        private static final Map<Integer, WhiteSpace> lookup;
        private int code;

        private WhiteSpace(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static WhiteSpace get(int code) {
            return lookup.get(code);
        }

        public static WhiteSpace get(Integer code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, WhiteSpace>();
            for (WhiteSpace x : EnumSet.allOf(WhiteSpace.class)) {
                lookup.put(x.getCode(), x);
            }
        }
    }

    public static enum ICMDataType {
        CHAR_ARRAY(1),
        HEX_ARRAY(2),
        BYTE(3),
        UNSIGNED_BYTE(4),
        SHORT(5),
        UNSIGNED_SHORT(6),
        INT(7),
        UNSIGNED_INT(8),
        LONG(9),
        UNSIGNED_LONG(10),
        BOOLEAN(12),
        BFP_FLOAT(13),
        BFP_DOUBLE(14),
        DECIMAL(15),
        UNSIGNED_DECIMAL(16),
        BASE64_ARRAY(17),
        ZONED(18),
        UNSIGNED_ZONED(19),
        HFP_SHORT(20),
        HFP_LONG(21),
        ABSTIME(22),
        WIDE_CHAR_ARRAY(23),
        ENUM(24),
        BIT_ARRAY(25),
        UTF16_CHAR_ARRAY(26);

        private static final Map<Integer, ICMDataType> lookup;
        private int code;

        private ICMDataType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ICMDataType get(int code) {
            return lookup.get(code);
        }

        public static ICMDataType get(Integer code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, ICMDataType>();
            for (ICMDataType x : EnumSet.allOf(ICMDataType.class)) {
                lookup.put(x.getCode(), x);
            }
        }
    }

    public static enum BindingStyle {
        RPC_STYLE(0),
        DOCUMENT_STYLE(1),
        WRAPPED_STYLE(2);

        private static final Map<Integer, BindingStyle> lookup;
        private int code;

        private BindingStyle(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static BindingStyle get(int code) {
            return lookup.get(code);
        }

        public static BindingStyle get(Integer code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, BindingStyle>();
            for (BindingStyle x : EnumSet.allOf(BindingStyle.class)) {
                lookup.put(x.getCode(), x);
            }
        }
    }

    public static enum ICMRecord {
        DATA_ELEMENT_RECORD_TYPE(1),
        FIXED_REPEAT_RECORD_TYPE(2),
        VARIABLE_REPEAT_RECORD_TYPE(3),
        END_REPEAT_RECORD_TYPE(4),
        END_DATA_SECTION_TYPE(5),
        EXTENDED_DATA_ELEMENT_RECORD_TYPE(6),
        EXTENDED_FIXED_REPEAT_RECORD(7),
        EXTENDED_VARIABLE_REPEAT_RECORD(8),
        ATTRIBUTE_RECORD_TYPE(9),
        RAW_XML_RECORD_TYPE(10),
        START_CHOICE_GROUP_ENTRY_TYPE(11),
        END_CHOICE_GROUP_ENTRY_TYPE(12),
        CHOICE_GROUP_ENTRY_START_TYPE(13),
        CHOICE_GROUP_ENTRY_END_TYPE(14),
        ABSTRACT_TYPE_START_TYPE(15),
        ABSTRACT_TYPE_END_TYPE(16),
        ABSTRACT_TYPE_OPTION_TYPE(17),
        RAW_JSON_RECORD_TYPE(18);

        private static final Map<Integer, ICMRecord> lookup;
        private int code;

        private ICMRecord(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ICMRecord get(int code) {
            return lookup.get(code);
        }

        public static ICMRecord get(Integer code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, ICMRecord>();
            for (ICMRecord x : EnumSet.allOf(ICMRecord.class)) {
                lookup.put(x.getCode(), x);
            }
        }
    }
}

