/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.schema.impl.ICMBuilderImpl;
import com.ibm.cics.schema.utils.MessageHandler;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

class CICSResourceSetImpl
extends ResourceSetImpl {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private ICMBuilderImpl builder = null;
    private Map<URI, URI> URIMap = null;

    protected CICSResourceSetImpl(ICMBuilderImpl builder, Map<URI, URI> URIMap) {
        this.builder = builder;
        this.URIMap = URIMap;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        URI alias;
        if (this.builder.isTrace()) {
            this.builder.getLogger().println("<!-- loading: " + uri + " >");
        }
        if ((alias = this.URIMap.get(uri)) != null) {
            uri = alias;
        }
        Resource result = null;
        boolean forceResolution = true;
        try {
            new java.net.URI(uri.toString());
            if (uri.toString().equals("http://www.w3.org/2001/xml.xsd")) {
                uri = URI.createURI((String)Thread.currentThread().getContextClassLoader().getResource("cache/www.w3.org/2001/xml.xsd").toString());
            }
            result = super.getResource(uri, true);
        }
        catch (ICMRuntimeException ice) {
            throw ice;
        }
        catch (WrappedException we) {
            ICMRuntimeException icmEx = null;
            icmEx = new ICMRuntimeException(MessageHandler.buildMessage("DFHPI9026E", new Object[]{uri}));
            icmEx.initCause(we.exception());
            throw icmEx;
        }
        catch (Exception e) {
            ICMRuntimeException icmEx = new ICMRuntimeException(MessageHandler.buildMessage("DFHPI9026E", new Object[]{uri}));
            icmEx.initCause(e);
            throw icmEx;
        }
        if (this.builder.isTrace()) {
            this.builder.getLogger().println("<!-- loaded: " + uri + " >");
        }
        return result;
    }
}

