/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMBuilder;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMInputArrayEndDataType;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureEndDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.impl.ICMBuilderImpl;
import com.ibm.cics.schema.impl.ICMInputArrayEndDataTypeImpl;
import com.ibm.cics.schema.impl.ICMInputArrayStartDataTypeImpl;
import com.ibm.cics.schema.impl.ICMInputContainerDataTypeImpl;
import com.ibm.cics.schema.impl.ICMInputSimpleDataTypeImpl;
import com.ibm.cics.schema.impl.ICMInputStructureEndDataTypeImpl;
import com.ibm.cics.schema.impl.ICMInputStructureStartDataTypeImpl;
import java.io.PrintStream;

public class Factory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";

    public static ICMBuilder createICMBuilderFromWSDL(String filename, int language, PrintStream logger) throws ICMException {
        return new ICMBuilderImpl(filename, language, logger);
    }

    public static ICMBuilder createICMBuilderToWSDL(int language, PrintStream logger) throws ICMException {
        return new ICMBuilderImpl(language, logger);
    }

    public static ICMInputSimpleDataType createICMSimpleDataType(String name, ICM.ICMDataType type) {
        return new ICMInputSimpleDataTypeImpl(name, type);
    }

    public static ICMInputContainerDataType createICMContainerDataType(String containerName, ICM.ContainerDataType containerType, ICM.ContainerUsage containerUsage) {
        return new ICMInputContainerDataTypeImpl(containerName, containerType, containerUsage);
    }

    public static ICMInputArrayStartDataType createICMArrayStartDataType(String name, int minOccurs, int maxOccurs) {
        return new ICMInputArrayStartDataTypeImpl(name, minOccurs, maxOccurs, true);
    }

    public static ICMInputArrayStartDataType createICMArrayStartDataType(String name, int minOccurs, int maxOccurs, boolean structural) {
        return new ICMInputArrayStartDataTypeImpl(name, minOccurs, maxOccurs, structural);
    }

    public static ICMInputArrayStartDataType createICMArrayStartDataType(String name, int occurs) {
        return new ICMInputArrayStartDataTypeImpl(name, occurs, true);
    }

    public static ICMInputArrayStartDataType createICMArrayStartDataType(String name, int occurs, boolean structural) {
        return new ICMInputArrayStartDataTypeImpl(name, occurs, structural);
    }

    public static ICMInputArrayEndDataType createICMArrayEndDataType() {
        return new ICMInputArrayEndDataTypeImpl();
    }

    public static ICMInputStructureStartDataType createICMStructureStartDataType(String name, ICM.StructureType structureType) {
        return new ICMInputStructureStartDataTypeImpl(name, structureType);
    }

    public static ICMInputStructureEndDataType createICMStructureEndDataType() {
        return new ICMInputStructureEndDataTypeImpl();
    }
}

