/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMAbstractTypeOptionEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;

class ICMAbstractTypeOptionEntryImpl
extends ICMEntryImpl
implements ICMAbstractTypeOptionEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_NUMERIC_CONSTANT = 1;
    private static final int ICM_LENGTH_LOCAL_NAME = 1;
    private static final int ICM_LENGTH_NAMESPACE = 1;
    private static final int ICM_PADDING = 1;
    private static final int ICM_LENGTH_NAME_OFFSET = 4;
    private static final int ICM_LENGTH_NAMESPACE_OFFSET = 4;
    private static final int ICM_LENGTH_OF_PADDING_SUFFIX = 4;
    private static final int ICM_LENGTH_OF_ABSTRACT_TYPE_OPTION_RECORD = 40;
    private static final byte[] binaryType = new byte[]{17};
    private int thisNumber = -1;
    private QName qname = null;
    private ICMConstantsSectionEntry localName = null;
    private ICMConstantsSectionEntry namespace = null;
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ATTRIBUTES_NUMBER = 1;
    private static final int OFFSET_OF_ATTRIBUTES_NUMBER = 1;
    private static final int LENGTH_OF_ICMENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ICMENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int LENGTH_OF_ATTRIBUTES = 4;
    private static final int OFFSET_OF_ATTRIBUTES = 8;
    private static final int LENGTH_OF_GROUP_END = 4;
    private static final int OFFSET_OF_GROUP_END = 12;
    private static final int LENGTH_OF_COMMON_EXPANSION = 8;
    private static final int OFFSET_OF_COMMON_EXPANSION = 16;
    private static final int LENGTH_OF_OPTION_NUMBER = 1;
    private static final int OFFSET_OF_OPTION_NUMBER = 24;
    private static final int LENGTH_OF_TYPE_NAME_LENGTH = 1;
    private static final int OFFSET_OF_TYPE_NAME_LENGTH = 25;
    private static final int LENGTH_OF_TYPE_NAMESPACE_LENGTH = 1;
    private static final int OFFSET_OF_TYPE_NAMESPACE_LENGTH = 26;
    private static final int LENGTH_OF_TYPE_NAME_OFFSET_PADDING = 1;
    private static final int OFFSET_OF_TYPE_NAME_OFFSET_PADDING = 27;
    private static final int LENGTH_OF_TYPE_NAME_OFFSET_ = 4;
    private static final int OFFSET_OF_TYPE_NAME_OFFSET = 28;
    private static final int LENGTH_OF_TYPE_NAMESPACE_OFFSET = 4;
    private static final int OFFSET_OF_TYPE_NAMESPACE_OFFSET = 32;
    private static final int LENGTH_OF_TYPE_NAMESPACE_OFFSET_PADDING = 4;
    private static final int OFFSET_OF_TYPE_NAMESPACE_OFFSET_PADDING = 36;
    private static final int LENGTH_OF_TYPE17_ICMENTRY = 40;

    protected ICMAbstractTypeOptionEntryImpl(ICMConstantsSectionHolder cse, int mappingLevel, QName qname, int optionNumber, ICM icm) throws ICMException {
        super(ICM.ICMRecord.ABSTRACT_TYPE_OPTION_TYPE, cse, mappingLevel, null, false, false, icm);
        this.qname = qname;
        this.thisNumber = optionNumber;
        this.localName = cse.createConstant(qname.getLocalPart(), 255L);
        this.namespace = cse.createConstant(qname.getNamespaceURI(), 255L);
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 17, 40, null);
        sb.append(indentStr + "    NUMERIC VALUE = " + ByteArray.formatNumForDisplay(this.getNumericValue()) + LINE_SEPARATOR);
        sb.append(indentStr + "    XML TYPE LOCAL NAME = " + this.localName.toString(indentStr) + LINE_SEPARATOR);
        sb.append(indentStr + "    XML TYPE NAMESPACE = " + this.namespace.toString(indentStr) + LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 40, null);
        baos.write(ByteArray.numToByteArray(this.thisNumber, 1));
        baos.write(ByteArray.numToByteArray(this.localName.getLength(), 1));
        baos.write(ByteArray.numToByteArray(this.namespace.getLength(), 1));
        baos.write(ByteArray.numToByteArray(0L, 1));
        baos.write(ByteArray.numToByteArray(this.localName.getOffset(), 4));
        baos.write(ByteArray.numToByteArray(this.namespace.getOffset(), 4));
        baos.write(ByteArray.numToByteArray(0L, 4));
        this.setBinaryData(baos.toByteArray());
    }

    @Override
    public int getNumericValue() {
        return this.thisNumber;
    }

    @Override
    public QName getTypeQName() {
        return this.qname;
    }

    protected ICMAbstractTypeOptionEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.ABSTRACT_TYPE_OPTION_TYPE, null, 0, "", false, false, icm);
        this.setType(ICM.ICMRecord.get(ICMContents[offset + 0]));
        if (this.getTypeEnum() != ICM.ICMRecord.ABSTRACT_TYPE_OPTION_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset >= 0) {
            this.setLogicalNextOffset(nextICMEntryOffset);
        }
        this.thisNumber = ICMContents[offset + 24];
        byte typeNameLength = ICMContents[offset + 25];
        int typeNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 28);
        if (typeNameOffset >= 0) {
            String type_name = ByteArray.byteArrayToString(ICMContents, typeNameOffset, typeNameLength, CodePage, false);
            this.localName = constants.createConstant(type_name, 255L);
            this.localName.setOffset(typeNameOffset);
        }
        byte typeNameSpaceLength = ICMContents[offset + 26];
        int typeNameSpaceOffset = ByteArray.byteArrayToInt(ICMContents, offset + 32);
        if (typeNameSpaceOffset >= 0) {
            String type_namespace = ByteArray.byteArrayToString(ICMContents, typeNameSpaceOffset, typeNameSpaceLength, CodePage, false);
            this.namespace = constants.createConstant(type_namespace, 255L);
            this.namespace.setOffset(typeNameSpaceOffset);
        }
        if (this.namespace == null) {
            throw new ICMException("INTERNAL ERROR: namespace is null");
        }
        if (this.localName == null) {
            throw new ICMException("INTERNAL ERROR: localName is null");
        }
        this.qname = new QName(this.namespace.getConstant(), this.localName.getConstant());
        this.buildByteArray();
    }
}

