/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMAbstractTypeEndEntry;
import com.ibm.cics.schema.ICMAbstractTypeOptionEntry;
import com.ibm.cics.schema.ICMAbstractTypeStartEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMAbstractTypeEndEntryImpl;
import com.ibm.cics.schema.impl.ICMAbstractTypeOptionEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

class ICMAbstractTypeStartEntryImpl
extends ICMEntryImpl
implements ICMAbstractTypeStartEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_TOTAL_NUMBER_OF_OPTIONS = 1;
    private static final int ICM_ELEMENT_NAME_LENGTH = 1;
    private static final int ICM_XML_ELEMENT_NAME_OFFSET_LENGTH = 4;
    private static final int ICM_XML_ELEMENT_NMSP_OFFSET_LENGTH = 4;
    private static final int ICM_ELEMENT_NMSP_LENGTH = 1;
    private static final int ICM_OFFSET_WITHIN_STRUC_LENGTH = 4;
    private static final int ICM_LENGTH_OF_ABSTRACT_TYPE_START_RECORD = 48;
    private static final byte[] binaryType = new byte[]{15};
    private ICMAbstractTypeOptionEntryImpl currentOptionEntry = null;
    private List<ICMAbstractTypeOptionEntry> options = new ArrayList<ICMAbstractTypeOptionEntry>();
    private ICMAbstractTypeEndEntryImpl endEntry = null;
    private ICMConstantsSectionEntry elName = null;
    private ICMConstantsSectionEntry elNmsp = null;
    private QName element = null;
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ATTRIBUTES_NUMBER = 1;
    private static final int OFFSET_OF_ATTRIBUTES_NUMBER = 1;
    private static final int LENGTH_OF_ICMENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ICMENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int LENGTH_OF_ATTRIBUTES = 4;
    private static final int OFFSET_OF_ATTRIBUTES = 8;
    private static final int LENGTH_OF_GROUP_END = 4;
    private static final int OFFSET_OF_GROUP_END = 12;
    private static final int LENGTH_OF_COMMON_EXPANSION = 8;
    private static final int OFFSET_OF_COMMON_EXPANSION = 16;
    private static final int LENGTH_OF_OPTION_NUMBER = 1;
    private static final int OFFSET_OF_OPTION_NUMBER = 24;
    private static final int LENGTH_OF_LOC_NAME_LENGTH = 1;
    private static final int OFFSET_OF_LOC_NAME_LENGTH = 25;
    private static final int LENGTH_OF_ELEMENT_NAME_LENGTH = 1;
    private static final int OFFSET_OF_ELEMENT_NAME_LENGTH = 26;
    private static final int LENGTH_OF_ELEMENT_NAMESPACE_LENGTH = 1;
    private static final int OFFSET_OF_ELEMENT_NAMESPACE_LENGTH = 27;
    private static final int LENGTH_OF_CONTAINER_OFFSET = 4;
    private static final int OFFSET_OF_CONTAINER_OFFSET = 28;
    private static final int LENGTH_OF_LOC_NAME_OFFSET_PADDING = 4;
    private static final int OFFSET_OF_LOC_NAME_OFFSET_PADDING = 32;
    private static final int LENGTH_OF_LOC_NAME_OFFSET = 4;
    private static final int OFFSET_OF_LOC_NAME_OFFSET = 36;
    private static final int LENGTH_OF_ELEMENT_NAME_OFFSET = 4;
    private static final int OFFSET_OF_ELEMENT_NAME_OFFSET = 40;
    private static final int LENGTH_OF_ELEMENT_NAMESPACE_OFFSET = 4;
    private static final int OFFSET_OF_ELEMENT_NAMESPACE_OFFSET = 44;
    private static final int LENGTH_OF_TYPE15_ICMENTRY = 48;

    protected ICMAbstractTypeStartEntryImpl(String simplifiedXPath, ICMConstantsSectionHolder cse, int mappingLevel, String strucLocationName, QName element, long offsetInStruc, ICM icm) throws ICMException {
        super(ICM.ICMRecord.ABSTRACT_TYPE_START_TYPE, cse, mappingLevel, simplifiedXPath, false, false, icm);
        this.setXMLTemplateVariableName(strucLocationName);
        this.elName = cse.createConstant(element.getLocalPart(), 32767L);
        this.elNmsp = cse.createConstant(element.getNamespaceURI(), 32767L);
        this.element = element;
        this.setOffsetIntoStructure(offsetInStruc);
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 15, 48, this.endEntry);
        sb.append(indentStr + "    TOTAL NUMBER OF OPTIONS = " + this.currentOptionEntry.getNumericValue() + LINE_SEPARATOR);
        sb.append(indentStr + "    OFFSET WITHIN STRUCTURE = " + ByteArray.formatNumForDisplay(this.getOffsetIntoStructure()) + LINE_SEPARATOR);
        sb.append(indentStr + "    XML TEMPLATE LOCATION NAME = " + this.getXMLTemplateVariableNameEntry().toString(indentStr) + LINE_SEPARATOR);
        sb.append(indentStr + "    ELEMENT LOCAL NAME = " + this.elName.toString(indentStr) + LINE_SEPARATOR);
        sb.append(indentStr + "    ELEMENT NAMESPACE " + this.elNmsp.toString(indentStr) + LINE_SEPARATOR);
        return sb.toString();
    }

    protected void addOptionEntry(ICMAbstractTypeOptionEntryImpl entry) {
        this.currentOptionEntry = entry;
    }

    protected ICMAbstractTypeOptionEntryImpl getCurrentOption() {
        return this.currentOptionEntry;
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 48, this.endEntry);
        baos.write(ByteArray.numToByteArray(this.currentOptionEntry.getNumericValue(), 1));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getLength(), 1));
        baos.write(ByteArray.numToByteArray(this.elName.getLength(), 1));
        baos.write(ByteArray.numToByteArray(this.elNmsp.getLength(), 1));
        baos.write(ByteArray.numToByteArray(this.getOffsetIntoStructure(), 4));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getOffset(), 8));
        baos.write(ByteArray.numToByteArray(this.elName.getOffset(), 4));
        baos.write(ByteArray.numToByteArray(this.elNmsp.getOffset(), 4));
        this.setBinaryData(baos.toByteArray());
    }

    @Override
    public int getTotalOptions() {
        return this.currentOptionEntry.getNumericValue();
    }

    public void setEndEntry(ICMAbstractTypeEndEntryImpl endEntry) {
        this.endEntry = endEntry;
    }

    @Override
    public String getElementName() {
        return this.elName.getConstant();
    }

    protected ICMAbstractTypeStartEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.ABSTRACT_TYPE_START_TYPE, null, 0, "", false, false, icm);
        int group_end_offset;
        this.setType(ICM.ICMRecord.get(ICMContents[offset + 0]));
        if (this.getTypeEnum() != ICM.ICMRecord.ABSTRACT_TYPE_START_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        this.setOffsetIntoStructure(ByteArray.byteArrayToInt(ICMContents, offset + 28));
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset >= 0) {
            ICMEntryImpl nextICMEntry = icm.getICMEntry(ICMContents, nextICMEntryOffset, constants, CodePage);
            this.setLogicalNextEntry(nextICMEntry);
            this.currentOptionEntry = (ICMAbstractTypeOptionEntryImpl)nextICMEntry;
        }
        if ((group_end_offset = ByteArray.byteArrayToInt(ICMContents, offset + 12)) >= 0) {
            ICMAbstractTypeEndEntryImpl endChoice = (ICMAbstractTypeEndEntryImpl)icm.getICMEntry(ICMContents, group_end_offset, constants, CodePage);
            this.setEndEntry(endChoice);
        }
        byte locNameLength = ICMContents[offset + 25];
        int locNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 36);
        if (locNameOffset >= 0) {
            String loaction_name = ByteArray.byteArrayToString(ICMContents, locNameOffset, locNameLength, CodePage, false);
            this.xmlName = constants.createConstant(loaction_name, 255L);
            this.xmlName.setOffset(locNameOffset);
        }
        byte elementNameLength = ICMContents[offset + 26];
        int elementNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 40);
        String element_name = "";
        if (elementNameOffset >= 0) {
            element_name = ByteArray.byteArrayToString(ICMContents, elementNameOffset, elementNameLength, CodePage, false);
            this.elName = constants.createConstant(element_name, 255L);
            this.elName.setOffset(elementNameOffset);
        }
        byte elementNameSpaceLength = ICMContents[offset + 27];
        int elementNameSpaceOffset = ByteArray.byteArrayToInt(ICMContents, offset + 44);
        String element_namespace = "";
        if (elementNameSpaceOffset >= 0) {
            element_namespace = ByteArray.byteArrayToString(ICMContents, elementNameSpaceOffset, elementNameSpaceLength, CodePage, false);
            this.elNmsp = constants.createConstant(element_namespace, 255L);
            this.elNmsp.setOffset(elementNameSpaceOffset);
        }
        this.element = new QName(element_namespace, element_name);
        this.buildByteArray();
    }

    protected void addOption(ICMAbstractTypeOptionEntry option) {
        this.options.add(option);
    }

    @Override
    public List<ICMAbstractTypeOptionEntry> getOptions() {
        return this.options;
    }

    @Override
    public ICMAbstractTypeEndEntry getEndEntry() {
        return this.endEntry;
    }

    @Override
    public QName getElementQName() {
        return this.element;
    }
}

