/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMAttributeEntry;
import com.ibm.cics.schema.ICMDataElementEntry;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;

public class ICMAttributeEntryImpl
extends ICMEntryImpl
implements ICMAttributeEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private QName qname;
    private boolean optional = false;
    private ICMDataElementEntry dataElement = null;
    private ICMAttributeEntryImpl nextAttribute = null;
    private ICMConstantsSectionEntry prefix = null;
    private long offsetOfExistenceByte = -1L;
    private boolean nameSpaceRelevant = false;
    private boolean fixed = false;
    private boolean implied = false;
    private boolean nillable = false;
    private boolean contentType = false;
    private byte flagsByte = 0;
    private static final int ICM_FLAGS_BYTES_LENGTH = 1;
    private static final int LENGTH_OF_PREFIX_VALUE = 1;
    private static final int LENGTH_OF_OFFSET_OF_PREFIX = 8;
    private static final int LENGTH_OF_OFFSET_OF_EXISTENCE_BYTE = 4;
    private static final int LENGTH_OF_ATTR_FIELDS = 16;
    private static final int LENGTH_OF_VARIABLE_LENGTH_BUFFER = 0;
    private static final int LENGTH_OF_ATTRIBUTE_ENTRY = 40;
    private static final byte[] binaryType = new byte[]{9};
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_NUM_ATTRIBUTES = 1;
    private static final int OFFSET_OF_NUM_ATTRIBUTES = 1;
    private static final int LENGTH_OF_ENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICM_ENTRY = 4;
    private static final int OFFSET_OF_NEXT_ICM_ENTRY = 4;
    private static final int LENGTH_OF_FIRST_ATTRIBUTE_OFFSET = 4;
    private static final int OFFSET_OF_FIRST_ATTRIBUTE_OFFSET = 8;
    private static final int LENGTH_OF_PADDING = 12;
    private static final int OFFSET_OF_PADDING = 12;
    private static final int LENGTH_OF_FLAGBYTES = 1;
    private static final int OFFSET_OF_FLAGBYTES = 24;
    private static final int LENGTH_OF_TEMPLATE_LENGTH = 1;
    private static final int OFFSET_OF_TEMPLATE_LENGTH = 25;
    private static final int LENGTH_OF_TEMPLATE_LENGTH_PADDING = 2;
    private static final int OFFSET_OF_TEMPLATE_LENGTH_PADDING = 26;
    private static final int LENGTH_OF_EXISTENCE_BYTE = 4;
    private static final int OFFSET_OF_EXISTENCE_BYTE = 28;
    private static final int LENGTH_OF_EXISTENCE_BYTE_PADDING = 4;
    private static final int OFFSET_OF_EXISTENCE_BYTE_PADDING = 32;
    private static final int LENGTH_OF_TEMPLATE_OFFSET = 4;
    private static final int OFFSET_OF_TEMPLATE_OFFSET = 36;
    private static final int LENGTH_OF_TYPE9_ICMENTRY_PREFIX = 40;

    public ICMAttributeEntryImpl(ICMConstantsSectionHolder csh, QName qname, boolean optional, boolean implied, String prefix, long offsetOfExistenceByte, boolean nameSpaceRelevant, boolean fixed, boolean nillable, boolean contentType, int mappingLevel, ICM icm) throws ICMException {
        super(ICM.ICMRecord.ATTRIBUTE_RECORD_TYPE, csh, mappingLevel, null, false, false, icm);
        this.qname = qname;
        this.optional = optional;
        this.implied = implied;
        this.nillable = nillable;
        this.contentType = contentType;
        this.offsetOfExistenceByte = offsetOfExistenceByte;
        this.nameSpaceRelevant = nameSpaceRelevant;
        this.fixed = fixed;
        if (optional) {
            this.flagsByte = (byte)(this.flagsByte | 0x80);
        }
        if (nillable) {
            this.flagsByte = (byte)(this.flagsByte | 0x40);
        }
        if (fixed) {
            this.flagsByte = (byte)(this.flagsByte | 0x20);
        }
        if (implied) {
            this.flagsByte = (byte)(this.flagsByte | 0x10);
        }
        if (contentType) {
            this.flagsByte = (byte)(this.flagsByte | 8);
        }
        this.prefix = csh.createConstant(prefix, 255L);
        this.setHidden(true);
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 40, null);
        baos.write(ByteArray.numToByteArray(this.flagsByte, 1));
        baos.write(ByteArray.numToByteArray(this.prefix.getLength(), 1));
        baos.write(0);
        baos.write(0);
        baos.write(ByteArray.numToByteArray(this.offsetOfExistenceByte, 4));
        baos.write(ByteArray.numToByteArray(this.prefix.getOffset(), 8));
        baos.write(ByteArray.numToByteArray(0L, 0));
        this.setBinaryData(baos.toByteArray());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 9, 40, null);
        sb.append("    FLAGS BYTE: " + LINE_SEPARATOR);
        sb.append("        OPTIONAL = " + this.optional + LINE_SEPARATOR);
        sb.append("        NILLABLE = " + this.nillable + LINE_SEPARATOR);
        sb.append("        FIXED = " + this.fixed + LINE_SEPARATOR);
        sb.append("        IMPLIED = " + this.implied + LINE_SEPARATOR);
        sb.append("        CONTENT-TYPE = " + this.contentType + LINE_SEPARATOR);
        sb.append("    LENGTH OF PREFIX = " + this.prefix.getLength() + LINE_SEPARATOR);
        sb.append("    OFFSET WITHIN STRUCTURE OF EXISTENCE BYTE = " + this.offsetOfExistenceByte + LINE_SEPARATOR);
        sb.append("    OFFSET OF VALUE PREFIX = " + this.prefix.toString() + LINE_SEPARATOR);
        sb.append("    VARIABLE LENGTH BUFFER SPACE LENGTH = 0" + LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    public ICMDataElementEntry getDataElement() {
        return this.dataElement;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public String getNameSpace() {
        return this.qname.getNamespaceURI();
    }

    @Override
    public String getLocalName() {
        return this.qname.getLocalPart();
    }

    protected void setDataElement(ICMDataElementEntry dataElement) {
        this.dataElement = dataElement;
    }

    protected void setNextAttribute(ICMAttributeEntryImpl nextAttribute) {
        this.nextAttribute = nextAttribute;
    }

    @Override
    public boolean isNameSpaceRelevant() {
        return this.nameSpaceRelevant;
    }

    @Override
    public ICMEntry getLogicalNextEntry() {
        return this.dataElement;
    }

    @Override
    protected ICMAttributeEntryImpl getNextAttributeInChain() {
        return this.nextAttribute;
    }

    @Override
    public boolean isNillable() {
        return this.nillable;
    }

    @Override
    public boolean isContentType() {
        return this.contentType;
    }

    public ICMAttributeEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.ATTRIBUTE_RECORD_TYPE, null, 0, "", false, false, icm);
        ICMAttributeEntryImpl nextAttr;
        this.setType(ICM.ICMRecord.get(ICMContents[offset]));
        int nextAttributeOffset = ByteArray.byteArrayToInt(ICMContents, offset + 8);
        this.nextAttribute = nextAttributeOffset > 0 ? (nextAttr = (ICMAttributeEntryImpl)icm.getICMEntry(ICMContents, nextAttributeOffset, constants, CodePage)) : null;
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset >= 0) {
            ICMEntryImpl nextICMEntry = icm.getICMEntry(ICMContents, nextICMEntryOffset, constants, CodePage);
            this.dataElement = (ICMDataElementEntry)((Object)nextICMEntry);
            this.qname = new QName(this.dataElement.getNameSpace(), this.dataElement.getLocalName());
        }
        this.flagsByte = ICMContents[offset + 24];
        if ((this.flagsByte & 0x80) > 0) {
            this.optional = true;
        }
        if ((this.flagsByte & 0x40) > 0) {
            this.nillable = true;
        }
        if ((this.flagsByte & 0x20) > 0) {
            this.fixed = true;
        }
        if ((this.flagsByte & 0x10) > 0) {
            this.implied = true;
        }
        if ((this.flagsByte & 8) > 0) {
            this.contentType = true;
        }
        byte templateLength = ICMContents[offset + 25];
        int templateOffset = ByteArray.byteArrayToInt(ICMContents, offset + 36);
        String templatePrefix = ByteArray.byteArrayToString(ICMContents, templateOffset, templateLength, CodePage, false);
        if (templatePrefix.length() > 0) {
            this.prefix = constants.createConstant(templatePrefix, 255L);
            this.prefix.setOffset(templateOffset);
        }
        this.offsetOfExistenceByte = ByteArray.byteArrayToInt(ICMContents, offset + 28);
        this.setHidden(true);
        this.buildByteArray();
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public long getOffsetOfExitenceFlag() {
        return this.offsetOfExistenceByte;
    }

    @Override
    public boolean isImplied() {
        return this.implied;
    }

    @Override
    public String getPrefix() {
        return this.prefix.getConstant();
    }
}

