/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMBuilder;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.schema.impl.CICSResourceSetImpl;
import com.ibm.cics.schema.impl.ICMCreationParametersImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSDL;
import com.ibm.cics.schema.impl.ICMImplToWSDL;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.common.QNameComparator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class ICMBuilderImpl
implements ICMBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String toolsVersion = "@toolsVersion@";
    private static final String buildDate = "@buildDate@";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private List<XSDResourceImpl> schemas = null;
    private XSDSchema mainSchema = null;
    private boolean trace = false;
    private PrintStream logger = null;
    private boolean startingFromWSDL = false;
    private boolean runningLS2WS = false;
    private boolean needsValidating = false;
    private String fileName = null;
    private List<Object> URIs = null;
    private List<String> warnings = new LinkedList<String>();
    private static final List<String> EMPTY_LIST = new LinkedList<String>();
    private Map<QName, XSDElementDeclaration> qnameToElement = new HashMap<QName, XSDElementDeclaration>();
    private Map<QName, XSDTypeDefinition> qnameToType = new HashMap<QName, XSDTypeDefinition>();
    private Set<XSDSchema> validatedSchemas = new HashSet<XSDSchema>();
    private Set<XSDSchema> messageSchemas = new HashSet<XSDSchema>();
    private List<QName> allGlobalElements = null;
    private List<QName> allGlobalTypes = null;
    private Set<QName> allSubTypesForAbstractDataTypes = new TreeSet<QName>(new QNameComparator());
    private Set<QName> allNillableSubTypesForAbstractDataTypes = new TreeSet<QName>(new QNameComparator());

    protected ICMBuilderImpl(String filename, int language, PrintStream logger) throws ICMException {
        this.needsValidating = true;
        this.fileName = filename;
        this.startingFromWSDL = true;
        this.runningLS2WS = false;
        this.initialise(language, logger);
    }

    protected ICMBuilderImpl(XSDSchema schema, int language, PrintStream logger) throws ICMException {
        this.mainSchema = schema;
        this.startingFromWSDL = true;
        this.runningLS2WS = true;
        this.initialise(language, logger);
    }

    protected ICMBuilderImpl(int language, PrintStream logger) throws ICMException {
        this.startingFromWSDL = false;
        this.runningLS2WS = true;
        this.initialise(language, logger);
    }

    private void initialise(int language, PrintStream logger) throws ICMException {
        if (logger != null) {
            this.setTrace(true);
            this.setLogger(logger);
            logger.println("Build Version @toolsVersion@Build date @buildDate@");
        }
        if (language < 1 || language > 7) {
            throw new ICMException("INTERNAL ERROR: Invalid language '" + language + "'.");
        }
    }

    private URI getURI(String filename) throws ICMException, IOException {
        File schemaFile = new File(filename);
        URI schemaURI = null;
        if (!schemaFile.isFile()) {
            throw new ICMException("INTERNAL ERROR: File '" + filename + "' is not a file.");
        }
        if (!schemaFile.canRead()) {
            throw new ICMException("INTERNAL ERROR: File '" + filename + "' can't be read.");
        }
        schemaURI = URI.createFileURI((String)schemaFile.getCanonicalFile().toString());
        return schemaURI;
    }

    @Override
    public void addURIs(List<Object> uris) {
        this.URIs = uris;
    }

    public List<XSDResourceImpl> getSchemas(String schemaSource) throws ICMException, IOException {
        LinkedList<XSDResourceImpl> allXSDResourceImpls = new LinkedList<XSDResourceImpl>();
        URI mainURI = this.getURI(schemaSource);
        URI extraURI = null;
        if (this.getLogger() != null) {
            this.getLogger().println("Main input is from: " + mainURI);
        }
        ResourceSet resourceSet = this.createResourceSet();
        boolean forceResolve = true;
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceSet.getResource(mainURI, true);
        allXSDResourceImpls.add(xsdMainResource);
        if (this.getLogger() != null) {
            Node root = null;
            if (xsdMainResource.getSchema().getDocument() != null) {
                root = xsdMainResource.getSchema().getDocument().getFirstChild();
            }
            while (root != null && !(root instanceof Element)) {
                root = root.getNextSibling();
            }
            if (root != null) {
                this.getLogger().println("XML file");
                this.getLogger().println("--------" + LINE_SEPARATOR);
                this.printComponent(this.getLogger(), (Element)root);
                this.getLogger().println(LINE_SEPARATOR + LINE_SEPARATOR);
            } else {
                throw new ICMException(MessageHandler.buildMessage("DFHPI9035E", new String[]{schemaSource}));
            }
        }
        if (this.URIs != null) {
            for (Object nextURIObj : this.URIs) {
                if (nextURIObj instanceof String) {
                    String nextUri = (String)nextURIObj;
                    if (!nextUri.equals(schemaSource)) {
                        extraURI = nextUri.toUpperCase(Locale.ENGLISH).startsWith("HTTP") ? URI.createURI((String)nextUri) : this.getURI(nextUri);
                    }
                } else if (nextURIObj instanceof java.net.URI) {
                    extraURI = URI.createURI((String)nextURIObj.toString());
                } else {
                    throw new ICMException("Internal Error: bad URI type: " + nextURIObj.getClass().toString());
                }
                if (extraURI == null || mainURI.toFileString().equalsIgnoreCase(extraURI.toFileString())) continue;
                if (this.getLogger() != null) {
                    this.getLogger().println("Also getting input from: " + extraURI);
                }
                XSDResourceImpl extraResource = (XSDResourceImpl)resourceSet.getResource(extraURI, true);
                allXSDResourceImpls.add(extraResource);
            }
        }
        return allXSDResourceImpls;
    }

    protected void revalidate() throws ICMException {
        if (this.mainSchema != null) {
            this.validateResourceSet(this.mainSchema);
            return;
        }
        for (XSDResourceImpl xri : this.schemas) {
            for (XSDSchema schema : xri.getContents()) {
                if (schema.getElement() == null || !schema.getElement().getLocalName().equals("schema")) continue;
                this.validateResourceSet(schema);
            }
        }
    }

    protected void validateResourceSet(XSDSchema schema) throws ICMException {
        if (schema == null) {
            return;
        }
        if (this.validatedSchemas.contains(schema)) {
            return;
        }
        this.validatedSchemas.add(schema);
        for (Object content : schema.getContents()) {
            if (!(content instanceof XSDImport)) continue;
            XSDImport xsdImport = (XSDImport)content;
            xsdImport.resolveTypeDefinition(xsdImport.getNamespace(), "");
            this.validateResourceSet(xsdImport.getResolvedSchema());
        }
        schema.validate();
        String[] messages = this.getMessagesNonDestructive(EMPTY_LIST);
        if (this.isTrace()) {
            for (int i = 0; i < messages.length; ++i) {
                this.getLogger().println(messages[i]);
            }
        }
        if (messages.length > this.warnings.size()) {
            if (this.runningLS2WS) {
                this.logSchema(schema, 1);
            }
            throw new ICMException(messages[0]);
        }
    }

    protected int getMappingLevel() throws ICMException {
        int mappingLevel = 0;
        if (this.schemas != null) {
            for (XSDResourceImpl xri : this.schemas) {
                for (XSDSchema schema : xri.getContents()) {
                    mappingLevel = this.findMappingLevel(schema, mappingLevel);
                }
            }
        }
        if (this.mainSchema != null) {
            mappingLevel = this.findMappingLevel(this.mainSchema, mappingLevel);
        }
        return mappingLevel;
    }

    private int findMappingLevel(XSDSchema schema, int mappingLevel) throws ICMException {
        int localMappingLevel = mappingLevel;
        if (schema.getElement() != null && schema.getElement().getLocalName().equals("schema")) {
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(schema.getAnnotations(), this.logger);
            String mappingLevelString = p.getProperty("com.ibm.cics.wsdl.properties.mappingLevel");
            if (mappingLevelString != null && !"".equals(mappingLevelString)) {
                for (int i = 0; i <= 13; ++i) {
                    if (!ICM.MAPPING_LEVELS[i].equals(mappingLevelString)) continue;
                    localMappingLevel = i;
                }
            }
            if (localMappingLevel != 0 && mappingLevel != 0 && localMappingLevel != mappingLevel) {
                throw new ICMException("INTERNAL ERROR: mixed mapping levels found: " + mappingLevel + " " + localMappingLevel);
            }
        }
        if (localMappingLevel == 0) {
            return mappingLevel;
        }
        return localMappingLevel;
    }

    protected static Properties getAnnotationsAsProperties(EList<XSDAnnotation> annotationsList, PrintStream logger) {
        Properties p = new Properties();
        for (XSDAnnotation annotation : annotationsList) {
            p.putAll((Map<?, ?>)ICMBuilderImpl.getAnnotationsAsProperties(annotation, logger));
        }
        return p;
    }

    protected static Properties getAnnotationsAsProperties(XSDAnnotation annotation, PrintStream logger) {
        Properties p = new Properties();
        if (annotation == null) {
            return p;
        }
        for (Element cicsComment : annotation.getApplicationInformation("http://www.ibm.com/software/htp/cics/annotations")) {
            Node content = cicsComment.getFirstChild();
            if (!(content instanceof Text)) continue;
            Text textComment = (Text)content;
            StringBuilder text = new StringBuilder(textComment.getData());
            for (Node next = textComment.getNextSibling(); next != null; next = next.getNextSibling()) {
                if (!(next instanceof Text)) continue;
                String moreText = ((Text)next).getData();
                text.append(moreText);
            }
            try {
                ByteArrayInputStream input = new ByteArrayInputStream(text.toString().getBytes("ISO8859-1"));
                p.load(input);
            }
            catch (IOException ioe) {
                if (logger == null) continue;
                logger.println("Got the following (ignored) exception: ");
                ioe.printStackTrace(logger);
            }
        }
        return p;
    }

    private ResourceSet createResourceSet() {
        HashMap<URI, URI> URIMap = new HashMap<URI, URI>();
        CICSResourceSetImpl resourceSet = new CICSResourceSetImpl(this, URIMap);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XSDResourceFactoryImpl());
        resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        return resourceSet;
    }

    @Override
    public ICM createICM(ICMCreationParameters inputParms) throws ICMException, IOException {
        ICM.BindingStyle style = inputParms.getStyle();
        int mappingLevel = inputParms.getMappingLevel();
        if (mappingLevel < 0 || mappingLevel > 13) {
            throw new ICMException("INTERNAL ERROR: Invalid mapping constant - " + mappingLevel + ". Expected minimum " + 0 + ", maximum " + 13);
        }
        if (this.logger != null) {
            this.logger.println(LINE_SEPARATOR + LINE_SEPARATOR + "Creating ICM: " + inputParms.getName());
            this.logger.println("-------------" + LINE_SEPARATOR);
            this.logger.println(" style: " + ICM.STYLE_TYPES[style.getCode()]);
            this.logger.println(" wsdlOperationNS: " + inputParms.getWsdlOperation().getNamespaceURI());
            this.logger.println(" wsdlOperationName: " + inputParms.getWsdlOperation().getLocalPart());
            this.logger.println(" message type: " + ICM.MESSAGE_TYPES[inputParms.getMessageType().getCode()]);
            this.logger.println(" mapping level: " + ICM.MAPPING_LEVELS_FOR_DISPLAY[mappingLevel]);
            this.logger.println();
        }
        if (this.needsValidating) {
            this.schemas = this.getSchemas(this.fileName);
            this.revalidate();
            this.needsValidating = false;
        }
        if (this.startingFromWSDL) {
            return new ICMImplFromWSDL(this, inputParms, this.startingFromWSDL, this.allSubTypesForAbstractDataTypes, this.allNillableSubTypesForAbstractDataTypes);
        }
        if (this.logger != null) {
            this.logger.println(LINE_SEPARATOR + LINE_SEPARATOR + "Logging info for ICM: " + inputParms.getName());
            this.logger.println("---------------------" + LINE_SEPARATOR);
        }
        return new ICMImplToWSDL(this, inputParms, this.startingFromWSDL);
    }

    protected XSDTypeDefinition resolveTypeDefinition(QName qname) {
        XSDTypeDefinition defaultType = null;
        defaultType = this.qnameToType.get(qname);
        if (defaultType != null) {
            return defaultType;
        }
        if (this.mainSchema != null) {
            return this.mainSchema.resolveTypeDefinition(qname.getNamespaceURI(), qname.getLocalPart());
        }
        for (XSDResourceImpl xri : this.schemas) {
            for (XSDSchema schema : xri.getContents()) {
                XSDTypeDefinition typed;
                defaultType = typed = schema.resolveTypeDefinition(qname.getNamespaceURI(), qname.getLocalPart());
                if (!this.exists(typed)) continue;
                return typed;
            }
        }
        return defaultType;
    }

    private boolean exists(XSDTypeDefinition typed) {
        if (typed == null) {
            return false;
        }
        if (typed.getElement() == null) {
            return false;
        }
        return typed.getName() == null || typed.getTargetNamespace() == null || !typed.getName().equals("anyType") || !typed.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema");
    }

    protected XSDElementDeclaration resolveElementDeclaration(QName qname) {
        XSDElementDeclaration defaultElement = null;
        defaultElement = this.qnameToElement.get(qname);
        if (defaultElement != null) {
            return defaultElement;
        }
        if (this.mainSchema != null) {
            return this.mainSchema.resolveElementDeclaration(qname.getNamespaceURI(), qname.getLocalPart());
        }
        for (XSDResourceImpl xri : this.schemas) {
            for (XSDSchema schema : xri.getContents()) {
                XSDElementDeclaration ed;
                defaultElement = ed = schema.resolveElementDeclaration(qname.getNamespaceURI(), qname.getLocalPart());
                if (ed.getElement() == null) continue;
                return ed;
            }
        }
        return defaultElement;
    }

    @Override
    public List<QName> getGlobalElements() {
        if (this.allGlobalElements == null) {
            this.allGlobalElements = this.getGlobalItems(true);
        }
        return this.allGlobalElements;
    }

    @Override
    public List<QName> getGlobalTypes() {
        if (this.allGlobalTypes == null) {
            this.allGlobalTypes = this.getGlobalItems(false);
        }
        return this.allGlobalTypes;
    }

    public List<QName> getGlobalItems(boolean elements) {
        LinkedList<QName> allGlobalItems = new LinkedList<QName>();
        this.validatedSchemas.clear();
        if (this.mainSchema != null) {
            this.processGlobalItemsList(this.mainSchema, allGlobalItems, elements);
        }
        if (this.schemas != null) {
            for (XSDResourceImpl xri : this.schemas) {
                for (XSDSchema schema : xri.getContents()) {
                    this.processGlobalItemsList(schema, allGlobalItems, elements);
                }
            }
        }
        return allGlobalItems;
    }

    private void processGlobalItemsList(XSDSchema schema, List<QName> QNames, boolean elements) {
        String tns = schema.getTargetNamespace();
        if (tns != null && tns.equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        if (this.validatedSchemas.contains(schema)) {
            return;
        }
        this.validatedSchemas.add(schema);
        Object itemsList = null;
        itemsList = elements ? schema.getElementDeclarations() : schema.getTypeDefinitions();
        Iterator it = itemsList.iterator();
        while (it.hasNext()) {
            XSDElementDeclaration ed;
            QName qname;
            Object o = it.next();
            if (o instanceof XSDElementDeclaration && elements && !QNames.contains(qname = new QName((ed = (XSDElementDeclaration)o).getTargetNamespace(), ed.getName()))) {
                QNames.add(qname);
                this.qnameToElement.put(qname, ed);
            }
            if (!(o instanceof XSDTypeDefinition) || elements) continue;
            XSDTypeDefinition td = (XSDTypeDefinition)o;
            qname = new QName(td.getTargetNamespace(), td.getName());
            if (td instanceof XSDComplexTypeDefinition && ((XSDComplexTypeDefinition)td).isAbstract() || QNames.contains(qname)) continue;
            QNames.add(qname);
            this.qnameToType.put(qname, td);
        }
        for (Object content : schema.getContents()) {
            if (!(content instanceof XSDImport)) continue;
            XSDImport xsdImport = (XSDImport)content;
            this.processGlobalItemsList(xsdImport.getResolvedSchema(), QNames, elements);
        }
    }

    protected boolean isTrace() {
        return this.trace;
    }

    private void setTrace(boolean b) {
        this.trace = b;
    }

    protected PrintStream getLogger() {
        return this.logger;
    }

    private void setLogger(PrintStream stream) {
        this.logger = stream;
    }

    private void logSchema(XSDSchema schema, int number) {
        if (this.isTrace()) {
            this.getLogger().println(LINE_SEPARATOR);
            if (number == 0) {
                this.getLogger().println("Schema:");
                this.getLogger().println("-------" + LINE_SEPARATOR);
            } else {
                this.getLogger().println("Schema " + number + ":");
                this.getLogger().println("---------" + LINE_SEPARATOR);
            }
            this.printComponent(this.getLogger(), schema);
        }
    }

    private void printComponent(PrintStream printStream, XSDConcreteComponent xsdConcreteComponent) {
        Element element = xsdConcreteComponent.getElement();
        if (element == null) {
            xsdConcreteComponent.updateElement();
        }
        element = xsdConcreteComponent.getElement();
        this.printComponent(printStream, element);
    }

    private void printComponent(PrintStream printStream, Element element) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (element != null) {
            try {
                TransformerFactory fact = TransformerFactory.newInstance();
                Transformer trans = fact.newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                trans.setOutputProperty("encoding", "UTF-8");
                trans.transform(new DOMSource(element.getOwnerDocument()), new StreamResult(baos));
            }
            catch (TransformerConfigurationException e) {
                ICMRuntimeException ire = new ICMRuntimeException("INTERNAL ERROR: XML Transformer Configuration problem");
                ire.initCause(e);
                throw ire;
            }
            catch (TransformerException e) {
                ICMRuntimeException ire = new ICMRuntimeException("INTERNAL ERROR: XML Transformer problem");
                ire.initCause(e);
                throw ire;
            }
        }
        try {
            printStream.println(baos.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException une) {
            ICMRuntimeException ire = new ICMRuntimeException("INTERNAL ERROR: Codepage problem encountered.");
            ire.initCause(une);
            throw ire;
        }
    }

    @Override
    public String[] getMessages() {
        String[] messages = this.getMessagesNonDestructive(EMPTY_LIST);
        this.warnings.clear();
        return messages;
    }

    public String[] getMessages(List<String> warnings) {
        String[] messages = this.getMessagesNonDestructive(warnings);
        warnings.clear();
        return messages;
    }

    private String[] getMessagesNonDestructive(List<String> moreWarnings) {
        LinkedList<String> allMessages = new LinkedList<String>();
        if (this.mainSchema != null) {
            this.getMessageForSchema(this.mainSchema, allMessages);
        } else if (this.schemas != null) {
            for (XSDResourceImpl xri : this.schemas) {
                for (XSDSchema schema : xri.getContents()) {
                    this.getMessageForSchema(schema, allMessages);
                }
            }
        }
        allMessages.addAll(this.warnings);
        allMessages.addAll(moreWarnings);
        return allMessages.toArray(new String[allMessages.size()]);
    }

    private void getMessageForSchema(XSDSchema schema, List<String> messages) {
        if (schema == null) {
            return;
        }
        if (!this.messageSchemas.contains(schema)) {
            this.messageSchemas.add(schema);
            for (Object content : schema.getContents()) {
                if (!(content instanceof XSDImport)) continue;
                XSDImport xsdImport = (XSDImport)content;
                this.getMessageForSchema(xsdImport.getResolvedSchema(), messages);
            }
        }
        if (schema.getElement() != null && schema.getElement().getLocalName().equals("schema")) {
            for (XSDDiagnostic diagnostic : schema.getAllDiagnostics()) {
                String msg = diagnostic.getMessage();
                if (msg.startsWith("XSD: The content model with ") && msg.endsWith(" states is too large") || diagnostic.getSeverity().getValue() != 1 && diagnostic.getSeverity().getValue() != 0) continue;
                messages.add(MessageHandler.buildMessage("DFHPI9027E", new Object[]{msg, diagnostic.getLine(), diagnostic.getColumn(), diagnostic.getLocation()}));
            }
        }
    }

    protected void addWarningMessage(String message) {
        this.warnings.add(message);
    }

    @Override
    public ICMCreationParameters getICMCreationParameters() {
        return new ICMCreationParametersImpl();
    }

    @Override
    public Set<QName> getAbstractSubTypes() {
        return this.allSubTypesForAbstractDataTypes;
    }

    @Override
    public Set<QName> getNillableAbstractSubTypes() {
        return this.allNillableSubTypesForAbstractDataTypes;
    }

    @Override
    public Map<String, Element> getSchemasAsElements(String sourceFile) throws IOException, ICMException {
        HashMap<String, Element> allSchemasAsElements = new HashMap<String, Element>();
        for (XSDResourceImpl xri : this.getSchemas(sourceFile)) {
            for (XSDSchema schema : xri.getContents()) {
                if (schema.getElement() == null || !schema.getElement().getLocalName().equals("schema")) continue;
                allSchemasAsElements.put(schema.getTargetNamespace(), schema.getElement());
            }
        }
        return allSchemasAsElements;
    }
}

