/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMChoiceGroupEndEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.impl.ICMStartChoiceGroupEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class ICMChoiceGroupEndEntryImpl
extends ICMEntryImpl
implements ICMChoiceGroupEndEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_CHOICE_GROUP_END_ENTRY_RECORD = 24;
    private static final byte[] binaryType = new byte[]{14};
    private ICMStartChoiceGroupEntryImpl startChoice = null;
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ATTRIBUTES_NUMBER = 1;
    private static final int OFFSET_OF_ATTRIBUTES_NUMBER = 1;
    private static final int LENGTH_OF_ICMENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ICMENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int LENGTH_OF_NEXT_ATTRIBUTE_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ATTRIBUTE_OFFSET = 8;
    private static final int LENGTH_OF_GROUP_END = 4;
    private static final int OFFSET_OF_GROUP_END = 12;
    private static final int LENGTH_OF_ENTRY_END_PADDING = 8;
    private static final int OFFSET_OF_ENTRY_END_PADDING = 16;
    private static final int LENGTH_OF_TYPE14_ICMENTRY = 24;

    protected ICMChoiceGroupEndEntryImpl(ICMConstantsSectionHolder csh, int mappingLevel, boolean slackBytes, ICM icm) throws ICMException {
        super(ICM.ICMRecord.CHOICE_GROUP_ENTRY_END_TYPE, csh, mappingLevel, null, slackBytes, false, icm);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 14, 24, this.startChoice.getEndChoiceGroupEntry());
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 24, this.startChoice.getEndChoiceGroupEntry());
        this.setBinaryData(baos.toByteArray());
    }

    public void setStartChoiceGroupEntry(ICMStartChoiceGroupEntryImpl start) {
        this.startChoice = start;
    }

    public void toByteArray() throws IOException, ICMException {
        this.buildByteArray();
    }

    protected ICMChoiceGroupEndEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.CHOICE_GROUP_ENTRY_END_TYPE, null, 0, "", false, false, icm);
        this.setType(ICM.ICMRecord.get(ICMContents[offset + 0]));
        if (this.getTypeEnum() != ICM.ICMRecord.CHOICE_GROUP_ENTRY_END_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset >= 0) {
            ICMEntryImpl nextICMEntry = icm.getICMEntry(ICMContents, nextICMEntryOffset, constants, CodePage);
            int group_end_offset = ByteArray.byteArrayToInt(ICMContents, offset + 12);
            if (group_end_offset >= 0) {
                icm.getICMEntry(ICMContents, group_end_offset, constants, CodePage);
            }
            this.setLogicalNextEntry(nextICMEntry);
        }
    }
}

