/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMChoiceGroupEndEntry;
import com.ibm.cics.schema.ICMChoiceGroupEntry;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.ICMStartChoiceGroupEntry;
import com.ibm.cics.schema.impl.ICMChoiceGroupEndEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.impl.ICMRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMStartChoiceGroupEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

class ICMChoiceGroupEntryImpl
extends ICMRepeatEntryImpl
implements ICMChoiceGroupEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_START_ENTRY_OFFSET = 4;
    private static final int ICM_LENGTH_OF_NEXT_CHOICE_ENTRY_OFFSET = 4;
    private static final int ICM_LENGTH_OF_NUMERIC_CONSTANT = 1;
    private static final int ICM_LENGTH_OF_FLAG_BITS = 1;
    private static final int ICM_LENGTH_OF_PADDING_SUFFIX = 4;
    private static final int ICM_LENGTH_OF_CHOICE_GROUP_RECORD = 88;
    private static final byte[] binaryType = new byte[]{13};
    private ICMEntry startChoice = null;
    private ICMChoiceGroupEntry nextChoice = null;
    private int thisChoiceNumber = -1;
    private String structureName = null;
    private boolean mgWithinChoice = false;
    private String mgName = null;
    private int entryStartOffset = -1;
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ATTRIBUTES_NUMBER = 1;
    private static final int OFFSET_OF_ATTRIBUTES_NUMBER = 1;
    private static final int LENGTH_OF_ICMENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ICMENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int LENGTH_OF_NEXT_ATTRIBUTE_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ATTRIBUTE_OFFSET = 8;
    private static final int LENGTH_OF_END_MEMBER_OFFSET = 4;
    private static final int OFFSET_OF_END_MEMBER_OFFSET = 12;
    private static final int LENGTH_OF_END_MEMBER_OFFSET_PADDING = 8;
    private static final int OFFSET_OF_END_MEMBER_OFFSET_PADDING = 16;
    private static final int LENGTH_OF_START_ENTRY_OFFSET = 4;
    private static final int OFFSET_OF_START_ENTRY_OFFSET = 24;
    private static final int LENGTH_OF_NEXT_MEMBER_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_MEMBER_OFFSET = 28;
    private static final int LENGTH_OF_VALUE_CODE = 1;
    private static final int OFFSET_OF_VALUE_CODE = 32;
    private static final int LENGTH_OF_FLAGS = 1;
    private static final int OFFSET_OF_FLAGS = 33;
    private static final int LENGTH_OF_FLAGS_PADDING = 4;
    private static final int OFFSET_OF_FLAGS_PADDING = 34;
    private static final int LENGTH_OF_LOC_NAME_LENGTH = 1;
    private static final int OFFSET_OF_LOC_NAME_LENGTH = 38;
    private static final int LENGTH_OF_STRUCTURE_NAME_LENGTH = 1;
    private static final int OFFSET_OF_STRUCTURE_NAME_LENGTH = 39;
    private static final int LENGTH_OF_STRUCTURE_NAME_LENGTH_PADDING = 4;
    private static final int OFFSET_OF_STRUCTURE_NAME_LENGTH_PADDING = 40;
    private static final int LENGTH_OF_CONTENT_LENGTH = 4;
    private static final int OFFSET_OF_CONTENT_LENGTH = 44;
    private static final int LENGTH_OF_CONTAINER_PADDING = 4;
    private static final int OFFSET_OF_CONTAINER_PADDING = 48;
    private static final int LENGTH_OF_CONTAINER_OFFSET = 4;
    private static final int OFFSET_OF_CONTAINER_OFFSET = 52;
    private static final int LENGTH_OF_LOC_NAME_PADDING = 4;
    private static final int OFFSET_OF_LOC_NAME_PADDING = 56;
    private static final int LENGTH_OF_LOC_NAME_OFFSET = 4;
    private static final int OFFSET_OF_LOC_NAME_OFFSET = 60;
    private static final int LENGTH_OF_STRUCTURE_NAME_PADDING = 4;
    private static final int OFFSET_OF_STRUCTURE_NAME_PADDING = 64;
    private static final int LENGTH_OF_STRUCTURE_NAME_OFFSET = 4;
    private static final int OFFSET_OF_STRUCTURE_NAME_OFFSET = 68;
    private static final int LENGTH_OF_XML_TEMPLATE_LENGTH_PADDING = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_LENGTH_PADDING = 72;
    private static final int LENGTH_OF_XML_TEMPLATE_LENGTH = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_LENGTH = 76;
    private static final int LENGTH_OF_XML_TEMPLATE_OFFSET_PADDING = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_OFFSET_PADDING = 80;
    private static final int LENGTH_OF_XML_TEMPLATE_OFFSET = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_OFFSET = 84;
    private static final int LENGTH_OF_TYPE11_ICMENTRY = 88;

    protected ICMChoiceGroupEntryImpl(ICMConstantsSectionHolder cse, int mappingLevel, ICMStartChoiceGroupEntryImpl startChoice, int choiceNumber, ICM icm) throws ICMException {
        super(ICM.ICMRecord.CHOICE_GROUP_ENTRY_START_TYPE, cse, mappingLevel, null, false, icm);
        this.startChoice = startChoice;
        this.thisChoiceNumber = choiceNumber;
        ICMChoiceGroupEntry prev = startChoice.getCurrentChoice();
        if (prev != null) {
            ((ICMChoiceGroupEntryImpl)prev).setNextChoiceGroupEntry(this);
        }
        startChoice.addChoiceEntry(this);
        this.setStructural(false);
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 13, 88, this.getEndEntry());
        sb.append(indentStr + "    OFFSET OF START CHOICE ENTRY = " + ByteArray.formatNumForDisplay(this.startChoice.getOffsetIntoICM()) + LINE_SEPARATOR);
        long offsetOfNext = -1L;
        if (this.nextChoice != null) {
            offsetOfNext = this.nextChoice.getOffsetIntoICM();
        }
        sb.append(indentStr + "    OFFSET OF NEXT CHOICE ENTRY = " + ByteArray.formatNumForDisplay(offsetOfNext) + LINE_SEPARATOR);
        sb.append(indentStr + "    NUMERIC VALUE = " + this.thisChoiceNumber + LINE_SEPARATOR);
        sb.append(indentStr + "    MODEL GROUP INCLUDED = " + this.mgWithinChoice + LINE_SEPARATOR);
        sb.append(super.toString(indent));
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 88, this.getEndEntry());
        baos.write(ByteArray.numToByteArray(this.startChoice.getOffsetIntoICM(), 4));
        if (this.nextChoice != null) {
            baos.write(ByteArray.numToByteArray(this.nextChoice.getOffsetIntoICM(), 4));
        } else {
            baos.write(ByteArray.numToByteArray(-1L, 4));
        }
        baos.write(ByteArray.numToByteArray(this.getChoiceValue(), 1));
        int flags = 0;
        if (this.mgWithinChoice) {
            ++flags;
        }
        baos.write(ByteArray.numToByteArray(flags, 1));
        baos.write(ByteArray.numToByteArray(0L, 4));
        this.formatRepeatsection(baos);
        this.setBinaryData(baos.toByteArray());
    }

    protected void setNextChoiceGroupEntry(ICMChoiceGroupEntry next) {
        this.nextChoice = next;
    }

    @Override
    public int getChoiceValue() {
        return this.thisChoiceNumber;
    }

    @Override
    public ICMChoiceGroupEntry getNextChoiceGroupEntry() {
        return this.nextChoice;
    }

    @Override
    public ICMStartChoiceGroupEntry getStartChoiceGroupEntry() {
        if (this.startChoice instanceof ICMStartChoiceGroupEntry) {
            return (ICMStartChoiceGroupEntry)this.startChoice;
        }
        if (this.startChoice instanceof ICMRepeatEntry) {
            ICMRepeatEntry next = (ICMRepeatEntry)this.startChoice;
            if (next.getLogicalNextEntry() instanceof ICMStartChoiceGroupEntry) {
                return (ICMStartChoiceGroupEntry)next.getLogicalNextEntry();
            }
            return (ICMStartChoiceGroupEntry)next.getLogicalNextEntry().getLogicalNextEntry();
        }
        return null;
    }

    public void setChoiceGroupEntryEndEntry(ICMChoiceGroupEndEntry end) {
        this.setEndEntry(end);
    }

    @Override
    public void setEntry(ICMEntry entry) {
        this.startChoice = entry;
    }

    @Override
    public ICMEntry getEntry() {
        return this.startChoice;
    }

    @Override
    public void setChoiceStructureName(String structureName) {
        this.structureName = structureName;
    }

    @Override
    public String getChoiceStructureName() {
        return this.structureName;
    }

    @Override
    public void setMgWithinChoice(boolean mgWithinChoice) {
        this.mgWithinChoice = mgWithinChoice;
    }

    @Override
    public boolean isMgWithinChoice() {
        return this.mgWithinChoice;
    }

    @Override
    public String getMgName() {
        return this.mgName;
    }

    public void setMgName(String name) {
        this.mgName = name;
    }

    protected void setEntryStartOffset(int entryStartOffset) {
        this.entryStartOffset = entryStartOffset;
    }

    protected int getEntryStartOffset() {
        return this.entryStartOffset;
    }

    public void toByteArray() throws IOException {
        this.buildByteArray();
    }

    public ICMChoiceGroupEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.CHOICE_GROUP_ENTRY_START_TYPE, null, 0, "", false, icm);
        int nextMemberOffset;
        int memberEndOffset;
        int entryStartOffset;
        this.setType(ICM.ICMRecord.get(ICMContents[offset + 0]));
        if (this.getTypeEnum() != ICM.ICMRecord.CHOICE_GROUP_ENTRY_START_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset >= 0) {
            this.setLogicalNextOffset(nextICMEntryOffset);
        }
        if ((entryStartOffset = ByteArray.byteArrayToInt(ICMContents, offset + 24)) >= 0) {
            this.setEntryStartOffset(entryStartOffset);
        }
        if ((memberEndOffset = ByteArray.byteArrayToInt(ICMContents, offset + 12)) >= 0) {
            ICMChoiceGroupEndEntryImpl endChoice = (ICMChoiceGroupEndEntryImpl)icm.getICMEntry(ICMContents, memberEndOffset, constants, CodePage);
            this.setChoiceGroupEntryEndEntry(endChoice);
        }
        if ((nextMemberOffset = ByteArray.byteArrayToInt(ICMContents, offset + 28)) >= 0) {
            ICMChoiceGroupEntryImpl nextMemberChoice = (ICMChoiceGroupEntryImpl)icm.getICMEntry(ICMContents, nextMemberOffset, constants, CodePage);
            this.setNextChoiceGroupEntry(nextMemberChoice);
        }
        this.thisChoiceNumber = ICMContents[offset + 32];
        byte flags = ICMContents[offset + 33];
        if ((flags & 1) > 0) {
            this.setMgWithinChoice(true);
        }
        byte locNameLength = ICMContents[offset + 38];
        int locNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 60);
        if (locNameOffset >= 0) {
            String loaction_name = ByteArray.byteArrayToString(ICMContents, locNameOffset, locNameLength, CodePage, false);
            this.xmlName = constants.createConstant(loaction_name, 255L);
            this.xmlName.setOffset(locNameOffset);
        }
        byte structureNameLength = ICMContents[offset + 39];
        int structureNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 68);
        if (structureNameOffset >= 0) {
            String structure_name = ByteArray.byteArrayToString(ICMContents, structureNameOffset, structureNameLength, CodePage, false);
            this.name = constants.createConstant(structure_name, 255L);
            this.name.setOffset(structureNameOffset);
        }
        int content_length = ByteArray.byteArrayToInt(ICMContents, offset + 44);
        this.setStructureSize(content_length);
        int containerOffset = ByteArray.byteArrayToInt(ICMContents, offset + 52);
        this.setOffsetIntoStructure(containerOffset);
        int XML_template_length = ByteArray.byteArrayToInt(ICMContents, offset + 76);
        int XML_template_offset = ByteArray.byteArrayToInt(ICMContents, offset + 84);
        if (XML_template_offset >= 0) {
            String xml_template = ByteArray.byteArrayToString(ICMContents, XML_template_offset, XML_template_length, CodePage, false);
            this.xmlTemplate = constants.createConstant(xml_template, Long.MAX_VALUE);
            this.xmlTemplate.setOffset(XML_template_offset);
        }
    }
}

