/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMLengthException;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.util.CodePageHelper;
import java.util.Arrays;

class ICMConstantsSectionEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String constant = null;
    private byte[] bytes = null;
    private long constantOffset = -1L;
    private ICMConstantsSectionEntry delegate = null;
    private int delegateOffset = -1;

    protected ICMConstantsSectionEntry(String constant, long maxLength) throws ICMException {
        this.constant = constant;
        if (constant != null) {
            this.bytes = constant.getBytes(CodePageHelper.getCurrentCodePage());
            if (this.bytes != null && maxLength != -1L && (long)this.bytes.length > maxLength) {
                throw new ICMLengthException("INTERNAL ERROR: Value '" + constant + "' is larger than '" + maxLength + "' bytes and therefore cannot be supported.");
            }
        }
    }

    protected ICMConstantsSectionEntry(byte[] constant, long maxLength) throws ICMException {
        this.constant = ByteArray.formatBytesForDisplay(constant);
        if (constant != null) {
            this.bytes = constant;
            if (maxLength != -1L && (long)this.bytes.length > maxLength) {
                throw new ICMLengthException("INTERNAL ERROR: Value '" + this.constant + "' is larger than '" + maxLength + "' bytes and therefore cannot be supported.");
            }
        }
    }

    protected void setOffset(long offset) {
        if (this.constant != null) {
            this.constantOffset = offset;
        }
    }

    protected long getOffset() {
        if (this.delegate == null) {
            if (this.bytes != null) {
                return this.constantOffset;
            }
            return -1L;
        }
        return (long)this.delegateOffset + this.delegate.getOffset();
    }

    protected byte[] getBytes() {
        return this.bytes;
    }

    protected String getConstant() {
        return this.constant;
    }

    protected void assignDelegate(ICMConstantsSectionEntry delegate, int offset) {
        this.delegate = delegate;
        this.delegateOffset = offset;
    }

    protected int find(byte[] otherBytes) {
        if (this.bytes == null || otherBytes == null) {
            return -1;
        }
        for (int i = 1; i <= this.bytes.length - otherBytes.length; ++i) {
            boolean matchedAll = true;
            for (int j = 0; j < otherBytes.length; ++j) {
                if (this.bytes[i + j] == otherBytes[j]) continue;
                matchedAll = false;
                break;
            }
            if (!matchedAll) continue;
            return i;
        }
        return -1;
    }

    protected int getLength() {
        if (this.bytes == null) {
            return 0;
        }
        return this.bytes.length;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (this.delegate == null) {
            sb.append(LINE_SEPARATOR + prefix + "      OFFSET = ");
            sb.append(ByteArray.formatNumForDisplay(this.constantOffset));
        } else {
            sb.append(LINE_SEPARATOR + prefix + "      DELEGATED OFFSET = ");
            sb.append(ByteArray.formatNumForDisplay((long)this.delegateOffset + this.delegate.getOffset()));
        }
        sb.append(LINE_SEPARATOR + prefix + "      LENGTH = ");
        if (this.bytes == null) {
            sb.append("0");
        } else {
            sb.append(ByteArray.formatNumForDisplay(this.bytes.length));
        }
        sb.append(LINE_SEPARATOR + prefix + "      VALUE = ");
        sb.append(this.constant);
        return sb.toString();
    }

    public boolean equivalent(Object o) {
        String s;
        if (this.constant == null) {
            return false;
        }
        if (o instanceof ICMConstantsSectionEntry) {
            return this.equals(o);
        }
        return o instanceof String && this.constant.equals(s = (String)o);
    }

    public int hashCode() {
        return this.constant.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ICMConstantsSectionEntry)) {
            return false;
        }
        if (object.hashCode() != this.hashCode()) {
            return false;
        }
        ICMConstantsSectionEntry cse = (ICMConstantsSectionEntry)object;
        return Arrays.equals(this.bytes, cse.getBytes());
    }
}

