/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ICMConstantsSectionHolder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private List<ICMConstantsSectionEntry> allConstantsOrdered = new LinkedList<ICMConstantsSectionEntry>();
    private Map<Object, ICMConstantsSectionEntry> allConstantsMap = new HashMap<Object, ICMConstantsSectionEntry>();
    private Map<String, String> elementToNameSpace = new HashMap<String, String>();
    private boolean elementClashes = false;
    private boolean attributesUsed = false;

    public ICMConstantsSectionEntry createConstant(Object constant, long maxLength) throws ICMException {
        ICMConstantsSectionEntry sce = null;
        sce = this.allConstantsMap.get(constant);
        if (sce != null) {
            return sce;
        }
        if (constant instanceof String) {
            sce = new ICMConstantsSectionEntry((String)constant, maxLength);
        } else if (constant instanceof byte[]) {
            sce = new ICMConstantsSectionEntry((byte[])constant, maxLength);
        } else {
            if (constant != null) {
                throw new ICMException("INTERNAL ERROR: Invalid type: " + constant.getClass());
            }
            throw new ICMException("INTERNAL ERROR: constant is null");
        }
        this.allConstantsOrdered.add(sce);
        this.allConstantsMap.put(constant, sce);
        return sce;
    }

    protected boolean checkForNameSpaceClashes(String element, String namespace) {
        String target;
        if (this.elementToNameSpace.containsKey(element) && (target = this.elementToNameSpace.get(element)) != null && !target.equals(namespace)) {
            this.elementClashes = true;
            return true;
        }
        this.elementToNameSpace.put(element, namespace);
        return false;
    }

    protected boolean getElementClashes() {
        return this.elementClashes;
    }

    protected void setElementClashes(boolean clash) {
        this.elementClashes = clash;
    }

    protected boolean isAttributesUsed() {
        return this.attributesUsed;
    }

    protected void setAttributesUsed() {
        this.attributesUsed = true;
    }

    public void compressConstants() {
        ICMConstantsSectionEntry[] constants = this.allConstantsOrdered.toArray(new ICMConstantsSectionEntry[this.allConstantsOrdered.size()]);
        block0: for (int entry = 0; entry < constants.length; ++entry) {
            ICMConstantsSectionEntry constant = constants[entry];
            for (ICMConstantsSectionEntry candidate : this.allConstantsOrdered) {
                int pos;
                if (constant == candidate || (pos = candidate.find(constant.getBytes())) <= -1) continue;
                constant.assignDelegate(candidate, pos);
                this.allConstantsOrdered.remove(constant);
                continue block0;
            }
        }
    }

    protected long setOffsets(long baseOffset) throws ICMException {
        Iterator<ICMConstantsSectionEntry> it = this.allConstantsOrdered.iterator();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long offset = baseOffset;
        while (it.hasNext()) {
            ICMConstantsSectionEntry cse = it.next();
            cse.setOffset(offset);
            offset += (long)cse.getLength();
            try {
                if (cse.getConstant() == null) continue;
                baos.write(cse.getBytes());
            }
            catch (IOException ioe) {
                ICMException ex = new ICMException("INTERNAL ERROR: IO Exception.");
                ex.initCause(ioe);
                throw ex;
            }
        }
        return offset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ICMConstantsSectionEntry cse : this.allConstantsOrdered) {
            sb.append("  ");
            sb.append(cse.toString());
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    protected byte[] toByteArray() throws ICMException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (ICMConstantsSectionEntry cse : this.allConstantsOrdered) {
            try {
                if (cse.getBytes() == null) continue;
                baos.write(cse.getBytes());
            }
            catch (IOException ioe) {
                ICMException ex = new ICMException("INTERNAL ERROR: IO Exception.");
                ex.initCause(ioe);
                throw ex;
            }
        }
        return baos.toByteArray();
    }

    public byte[] sortEntry(Charset CodePage) throws UnsupportedEncodingException {
        ICMConstantsSectionEntry[] constants = this.allConstantsOrdered.toArray(new ICMConstantsSectionEntry[this.allConstantsOrdered.size()]);
        ICMConstants_COMP comparator = new ICMConstants_COMP();
        Arrays.sort(constants, comparator);
        int totalBytes = 0;
        for (int i = 0; i < constants.length; ++i) {
            totalBytes += constants[i].getLength();
        }
        byte[] constantsByteArray = new byte[totalBytes];
        int currentPos = 0;
        int XMLTemplateNum = constants.length;
        for (int currentTemplate = 0; currentTemplate < XMLTemplateNum; ++currentTemplate) {
            byte[] currentByteArray = constants[currentTemplate].getConstant().getBytes(CodePage);
            for (int i = 0; i < currentByteArray.length; ++i) {
                constantsByteArray[currentPos + i] = currentByteArray[i];
            }
            currentPos += currentByteArray.length;
        }
        return constantsByteArray;
    }

    static class ICMConstants_COMP
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -1347234564942264154L;

        ICMConstants_COMP() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            ICMConstantsSectionEntry constSec1 = (ICMConstantsSectionEntry)o1;
            ICMConstantsSectionEntry constSec2 = (ICMConstantsSectionEntry)o2;
            if (constSec1.getOffset() > constSec2.getOffset()) {
                return 1;
            }
            if (constSec1.getOffset() < constSec2.getOffset()) {
                return -1;
            }
            return 0;
        }
    }
}

