/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMChoiceGroupEntry;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMEndChoiceGroupEntry;
import com.ibm.cics.schema.ICMEndRepeatEntry;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMIndexEntry;
import com.ibm.cics.schema.ICMRawXMLElementEntry;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.ICMStartChoiceGroupEntry;
import com.ibm.cics.schema.ICMVariableRepeatEntry;
import com.ibm.cics.schema.impl.ICMAbstractTypeEndEntryImpl;
import com.ibm.cics.schema.impl.ICMAbstractTypeOptionEntryImpl;
import com.ibm.cics.schema.impl.ICMAbstractTypeStartEntryImpl;
import com.ibm.cics.schema.impl.ICMAttributeEntryImpl;
import com.ibm.cics.schema.impl.ICMChoiceGroupEndEntryImpl;
import com.ibm.cics.schema.impl.ICMChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMDataElementEntryImpl;
import com.ibm.cics.schema.impl.ICMEndChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMEndDataSectionEntryImpl;
import com.ibm.cics.schema.impl.ICMEndRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMExtendedDataElementEntryImpl;
import com.ibm.cics.schema.impl.ICMExtendedFixedRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMExtendedVariableRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMFixedRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMIndexEntryComparator;
import com.ibm.cics.schema.impl.ICMIndexEntryImpl;
import com.ibm.cics.schema.impl.ICMLevelState;
import com.ibm.cics.schema.impl.ICMRawJSONElementEntryImpl;
import com.ibm.cics.schema.impl.ICMRawXMLElementEntryImpl;
import com.ibm.cics.schema.impl.ICMRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMSlackBytesElementEntryImpl;
import com.ibm.cics.schema.impl.ICMSlackBytesEndRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMSlackBytesFixedRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMStartChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMVariableRepeatEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;

class ICMContentHolder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String name = null;
    private static final int UNKNOWN = -1;
    protected static final String EYE_CATCHER = ">DFHICM<";
    protected static final int EYE_CATCHER_LENGTH = 8;
    protected static final int EYE_CATCHER_OFFSET = 0;
    protected static final int VERSION_LENGTH = 8;
    protected static final int MAJOR_VERSION_LENGTH = 4;
    protected static final int MAJOR_VERSION_OFFSET = 8;
    protected static final int MINOR_VERSION_LENGTH = 4;
    protected static final int MINOR_VERSION_OFFSET = 12;
    private static final int LENGTH_OF_INT = 8;
    private static final int ICM_LENGTH_FIELD_LENGTH = 8;
    protected static final int ICM_LENGTH_PADDING_LENGTH = 4;
    private static final int ICM_LENGTH_PADDING_OFFSET = 16;
    protected static final int ICM_LENGTH_LENGTH = 4;
    protected static final int ICM_LENGTH_OFFSET = 20;
    protected static final int ICM_NAME_LENGTH = 32;
    protected static final int ICM_NAME_OFFSET = 24;
    private static final int ICM_COMMAREA_SIZE_LENGTH = 8;
    protected static final int STRUCTURE_SIZE_PADDING_LENGTH = 4;
    private static final int STRUCTURE_SIZE_PADDING_OFFSET = 56;
    protected static final int STRUCTURE_SIZE_LENGTH = 4;
    protected static final int STRUCTURE_SIZE_OFFSET = 60;
    private static final int ICM_LENGTH_OF_XML_TEMPLATE_LENGTH = 8;
    private static final int ICM_OFFSET_OF_XML_TEMPLATE_LENGTH = 8;
    private static final long ICM_MAX_TEMPLATE_LENGTH = Long.MAX_VALUE;
    protected static final int XML_TEMPLATE_OFFSET_PADDING_LENGTH = 4;
    private static final int XML_TEMPLATE_OFFSET_PADDING_OFFSET = 64;
    protected static final int XML_TEMPLATE_OFFSET_LENGTH = 4;
    protected static final int XML_TEMPLATE_OFFSET_OFFSET = 68;
    protected static final int XML_TEMPLATE_LENGTH_PADDING_LENGTH = 4;
    private static final int XML_TEMPLATE_LENGTH_PADDING_OFFSET = 72;
    protected static final int XML_TEMPLATE_LENGTH_LENGTH = 4;
    protected static final int XML_TEMPLATE_LENGTH_OFFSET = 76;
    protected static final int ICM_FLAGS_OVERFLOW_LENGTH = 4;
    protected static final int ICM_FLAGS_OVERFLOW_OFFSET = 80;
    private static final int ICM_DATA_OFFSET_LENGTH = 4;
    protected static final int DATA_OFFSET_PADDING_LENGTH = 0;
    private static final int DATA_OFFSET_PADDING_OFFSET = 84;
    protected static final int DATA_OFFSET_LENGTH = 4;
    protected static final int DATA_OFFSET_OFFSET = 84;
    protected static final int INDEX_ENTRY_NUMBER_LENGTH = 4;
    protected static final int INDEX_ENTRY_NUMBER_OFFSET = 88;
    protected static final int OPT_INDEX_OFFSET_LENGTH = 3;
    protected static final int OPT_INDEX_OFFSET_OFFSET = 92;
    protected static final int ICM_PROPERTY_FLAGS_LENGTH = 1;
    protected static final int ICM_PROPERTY_FLAGS_OFFSET = 95;
    protected static final int INDEX_ENTRY_OFFSET_LENGTH = 2;
    protected static final int FIRST_INDEX_ENTRY_OFFSET_OFFSET = 96;
    protected static final int NUMBER_OF_PARTS_LENGTH = 2;
    protected static final int NEXT_INDEX_ENTRY_OFFSET_LENGTH = 2;
    protected static final int OFFSET_IN_ICM_LENGTH = 4;
    protected static final int INDEX_ENTRY_HEADER_LENGTH = 8;
    protected static final int PART_NAMESPACE_LENGTH_LENGTH = 1;
    protected static final int PART_ELEMENT_LENGTH_LENGTH = 1;
    protected static final int INDEX_BODY_RESERVED_LENGTH = 6;
    protected static final int PART_NAMESPACE_OFFSET_LENGTH = 8;
    protected static final int PART_ELEMENT_OFFSET_LENGTH = 8;
    protected static final int INDEX_ENTRY_BODY_LENGTH = 24;
    private static final int ICM_NUM_OF_INDEX_ENTRIES_LENGTH = 4;
    private static final int ICM_OPT_INDEX_OFFSET_LENGTH = 3;
    private static final int ICM_FLAGS_BYTE_LENGTH = 1;
    private static final int ICM_INDEX_INDEX_ENTRY_LENGTH = 2;
    protected static final int ICM_FIRST_CHILD_LENGTH = 4;
    protected static final int ICM_LAST_CHILD_LENGTH = 4;
    protected static final int ICM_NESTING_LEVEL_LENGTH = 4;
    protected static final int ICM_INDEX_OFFSET_LENGTH = 4;
    protected static final int ICM_OPT_INDEX_ENTRY_LENGTH = 16;
    private ICMIndexEntryImpl prevIndexEntry = null;
    private int lengthOfHeaderWithoutXMLTemplate = 88;
    private int totalLengthofHeader = -1;
    private long sizeOfCommarea = -1L;
    private ICMConstantsSectionEntry xmlTemplate = null;
    private long dataOffset = -1L;
    private long constantsOffset = -1L;
    private long totalICMLength = -1L;
    private List<ICMIndexEntryImpl> indexEntries = new ArrayList<ICMIndexEntryImpl>();
    private List<ICMEntryImpl> dataSectionEntries = new ArrayList<ICMEntryImpl>(100000);
    private Stack<ICMEntry> repeatEntriesStack = new Stack();
    private Hashtable<String, ICMEntryImpl> allXpaths = new Hashtable();
    private ICMConstantsSectionHolder constants = new ICMConstantsSectionHolder();
    private int mappingLevel = 0;
    private ICM.XMLContentType messageType = ICM.XMLContentType.SOAP_REQUEST;
    private boolean xopSignificant = false;
    private boolean xsiType = false;
    private boolean dataTruncation = false;
    private boolean dataScreening = true;
    private boolean defaultsExist = false;
    private boolean optimisedIndex = false;
    private long offsetOfOptimisedIndex = 0L;
    private ICMCreationParameters props = null;
    private ICM icm = null;
    private static final Charset CHARSET_CP037 = Charset.forName("Cp037");

    ICMContentHolder(String name, ICM.XMLContentType messageType, boolean soap11, boolean dataTruncationSupported, ICMCreationParameters props, ICM icm) {
        this.name = name.length() > 32 ? name.substring(0, 32) : name;
        this.messageType = messageType;
        this.dataTruncation = dataTruncationSupported;
        this.props = props;
        this.icm = icm;
        this.dataScreening = !"DISABLED".equals(props.getInputParameters().getProperty("DATA-SCREENING"));
    }

    protected void setXMLTemplate(String xmlTemplate) throws ICMException {
        this.xmlTemplate = this.constants.createConstant(xmlTemplate, Long.MAX_VALUE);
        this.totalLengthofHeader = this.lengthOfHeaderWithoutXMLTemplate;
    }

    protected void addDataElement(ICM.ICMDataType datatype, int LAR, ICM.WhiteSpace whiteSpace, String localName, String nameSpace, String xmlLocationName, String defaultValue, List<String> comments, String xpath, String readableXPath, long levelOffset, int fractionDigits, boolean aligned, ICM.EncodingType encodingType, ICM.VaryingLength variableMappingStrategy, boolean signIsLeading, boolean separateChar, String containerName, ICMSlackBytesElementEntryImpl odoTarget, int minLength, boolean multiTypedElement) throws ICMException {
        ICMDataElementEntryImpl de = null;
        de = MappingLevelHelper.requiresMappingLevel_1(this.mappingLevel) ? new ICMDataElementEntryImpl(datatype, LAR, whiteSpace, localName, nameSpace, xmlLocationName, defaultValue, comments, this.constants, fractionDigits, aligned, encodingType, variableMappingStrategy, this.mappingLevel, readableXPath, signIsLeading, separateChar, false, containerName, odoTarget, false, minLength, multiTypedElement, this.icm) : new ICMExtendedDataElementEntryImpl(datatype, LAR, whiteSpace, localName, nameSpace, xmlLocationName, defaultValue, comments, this.constants, fractionDigits, aligned, encodingType, variableMappingStrategy, this.mappingLevel, readableXPath, signIsLeading, separateChar, false, containerName, odoTarget, false, minLength, multiTypedElement, this.icm);
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && defaultValue != null && !localName.equals("nil")) {
            this.defaultsExist = true;
        }
        this.initDataSectionEntry(xpath, de, levelOffset);
        if (datatype.equals((Object)ICM.ICMDataType.BASE64_ARRAY)) {
            this.xopSignificant = true;
        }
        this.processODO(odoTarget);
    }

    private void processODO(ICMSlackBytesElementEntryImpl odoTarget) throws ICMException {
        if (odoTarget != null) {
            ICMExtendedDataElementEntryImpl de = new ICMExtendedDataElementEntryImpl(odoTarget.getDataTypeEnum(), odoTarget.getLAR(), odoTarget.getWhiteSpaceEnum(), odoTarget.getLocalName(), odoTarget.getNameSpace(), odoTarget.getXMLTemplateVariableName(), odoTarget.getDefaultValue(), odoTarget.getComments(), this.constants, odoTarget.getFractionDigits(), odoTarget.getAligned(), odoTarget.getEncodingType(), odoTarget.getVariableLengthMappingStrategyEnum(), this.mappingLevel, null, odoTarget.isSignLeading(), odoTarget.isSignLeading(), false, null, null, true, odoTarget.getMinLength(), false, this.icm);
            this.initDataSectionEntry(null, de, odoTarget.getAbsoluteOffsetInStructure());
        }
    }

    protected ICMRawXMLElementEntry addRawXMLEntry(String typeName, String typeNameSpace, String xmlName, String xpath, String simplifiedXPath, ICMLevelState level, ICMRawXMLElementEntry.AnyType anyType, ICM.EncodingType encodingType) throws ICMException {
        ICMRawXMLElementEntryImpl rxe;
        if (!ICMRawXMLElementEntry.AnyType.JSON_PROPERTY.equals((Object)anyType)) {
            rxe = new ICMRawXMLElementEntryImpl(typeName, typeNameSpace, xmlName, simplifiedXPath, this.constants, this.mappingLevel, anyType, this.icm);
        } else {
            int size = Integer.parseInt(this.props.getInputParameters().getProperty("ADDITIONAL-PROPERTIES-SIZE"));
            rxe = new ICMRawJSONElementEntryImpl(typeName, xmlName, this.constants, this.mappingLevel, this.icm, size, encodingType);
        }
        this.initDataSectionEntry(xpath, rxe, level.getTotalLength());
        if (anyType.equals((Object)ICMRawXMLElementEntry.AnyType.any) || anyType.equals((Object)ICMRawXMLElementEntry.AnyType.JSON_PROPERTY)) {
            for (int i = this.repeatEntriesStack.size() - 1; i >= 0; --i) {
                ICMEntry entry = (ICMEntry)this.repeatEntriesStack.elementAt(i);
                if (entry instanceof ICMFixedRepeatEntry) {
                    if (((ICMFixedRepeatEntry)entry).isStructural() && ((ICMFixedRepeatEntry)entry).getOccurances() == 1 && !((ICMFixedRepeatEntry)entry).isVariablyRepeating()) {
                        if (((ICMFixedRepeatEntry)entry).isRawXMLContent()) {
                            ICMException newEx = new ICMException(MessageHandler.buildMessage("DFHPI9666E", new Object[]{typeName}));
                            throw newEx;
                        }
                        ((ICMFixedRepeatEntry)entry).setRawXMLContent(true);
                        break;
                    }
                    ((ICMRepeatEntryImpl)entry).setStructural(false);
                }
                if (!(entry instanceof ICMVariableRepeatEntry)) continue;
                ((ICMRepeatEntryImpl)entry).setStructural(false);
            }
        }
        this.constants.setElementClashes(true);
        return rxe;
    }

    protected ICMStartChoiceGroupEntryImpl addStartChoiceGroupEntry(String xpath, String simplifiedXPath, ICMLevelState level, String strucLocationName, String structureName) throws ICMException {
        ICMStartChoiceGroupEntryImpl sce = new ICMStartChoiceGroupEntryImpl(simplifiedXPath, this.constants, this.mappingLevel, strucLocationName, structureName, this.icm);
        this.initDataSectionEntry(null, sce, level.getTotalLength());
        return sce;
    }

    protected ICMAbstractTypeStartEntryImpl addAbstractTypeStartEntry(String xpath, String simplifiedXPath, ICMLevelState level, String strucLocationName, QName element, long levelOffset) throws ICMException {
        ICMAbstractTypeStartEntryImpl ats = new ICMAbstractTypeStartEntryImpl(simplifiedXPath, this.constants, this.mappingLevel, strucLocationName, element, levelOffset, this.icm);
        this.initDataSectionEntry(xpath, ats, level.getTotalLength());
        this.constants.setElementClashes(true);
        return ats;
    }

    protected ICMAbstractTypeOptionEntryImpl addAbstractTypeOption(ICMLevelState level, QName qname, int optionNumber) throws ICMException {
        ICMAbstractTypeOptionEntryImpl ato = new ICMAbstractTypeOptionEntryImpl(this.constants, this.mappingLevel, qname, optionNumber, this.icm);
        this.initDataSectionEntry(null, ato, level.getTotalLength());
        return ato;
    }

    protected ICMChoiceGroupEntryImpl addChoiceGroupEntryStartEntry(String xpath, String simplifiedXPath, ICMLevelState level, ICMStartChoiceGroupEntryImpl startChoice, int choiceNumber) throws ICMException {
        ICMChoiceGroupEntryImpl cge = this.addChoiceGroupEntryStartEntry(xpath, simplifiedXPath, level.getTotalLength(), startChoice, choiceNumber);
        return cge;
    }

    protected ICMChoiceGroupEntryImpl addChoiceGroupEntryStartEntry(String xpath, String simplifiedXPath, long offset, ICMStartChoiceGroupEntryImpl startChoice, int choiceNumber) throws ICMException {
        ICMChoiceGroupEntryImpl cge = new ICMChoiceGroupEntryImpl(this.constants, this.mappingLevel, startChoice, choiceNumber, this.icm);
        this.initDataSectionEntry(xpath, cge, offset);
        return cge;
    }

    protected void addChoiceGroupEntryEndEntry(ICMChoiceGroupEntryImpl start) throws ICMException {
        ICMChoiceGroupEndEntryImpl ece = new ICMChoiceGroupEndEntryImpl(this.constants, this.lengthOfHeaderWithoutXMLTemplate, this.optimisedIndex, this.icm);
        ece.setStartChoiceGroupEntry((ICMStartChoiceGroupEntryImpl)start.getStartChoiceGroupEntry());
        start.setChoiceGroupEntryEndEntry(ece);
        this.initDataSectionEntry(null, ece, -1L);
    }

    protected void addEndChoiceGroupEntry(ICMStartChoiceGroupEntryImpl start) throws ICMException {
        ICMEndChoiceGroupEntryImpl ece = new ICMEndChoiceGroupEntryImpl(this.constants, this.mappingLevel, this.icm);
        start.setEndChoiceGroupEntry(ece);
        this.initDataSectionEntry(null, ece, -1L);
    }

    protected void addAbstractTypeEndEntry(ICMAbstractTypeStartEntryImpl start) throws ICMException {
        ICMAbstractTypeEndEntryImpl ate = new ICMAbstractTypeEndEntryImpl(this.constants, this.mappingLevel, start.getElementName(), this.icm);
        start.setEndEntry(ate);
        this.initDataSectionEntry(null, ate, -1L);
    }

    protected void addSlackBytesDataElement(int LAR, long levelOffset) throws ICMException {
        ICMSlackBytesElementEntryImpl de = new ICMSlackBytesElementEntryImpl(LAR, this.constants, this.mappingLevel, this.icm);
        this.initDataSectionEntry(null, de, levelOffset);
    }

    protected void addSlackBytesDataElement(ICM.ICMDataType datatype, int LAR, ICM.WhiteSpace whiteSpace, String localName, String nameSpace, String xmlLocationName, String defaultValue, List<String> comments, String xpath, String readableXPath, long levelOffset, int fractionDigits, boolean aligned, ICM.EncodingType encodingType, ICM.VaryingLength variableMappingStrategy, boolean signIsLeading, boolean separateChar, ICMSlackBytesElementEntryImpl odoTarget, boolean odoTargetClone, String odoFieldName, int minLength, boolean multiTypedElement) throws ICMException {
        ICMSlackBytesElementEntryImpl de = new ICMSlackBytesElementEntryImpl(datatype, LAR, whiteSpace, localName, nameSpace, xmlLocationName, defaultValue, comments, this.constants, fractionDigits, aligned, encodingType, variableMappingStrategy, this.mappingLevel, signIsLeading, separateChar, odoTarget, odoTargetClone, odoFieldName, minLength, multiTypedElement, this.icm);
        this.initDataSectionEntry(null, de, levelOffset);
    }

    protected ICMRepeatEntryImpl addVariableRepeatsEntry(int maxOccurs, int minOccurs, boolean choice, String xpath, String readableXPath, long levelOffset, int totalChoices, int thisChoice, boolean mixedContent, boolean optionalModelGroup, String simpleNamedContainer, String structuralNamedContainer, boolean optionalArray, boolean innerArray) throws ICMException {
        ICMVariableRepeatEntryImpl variable = null;
        variable = MappingLevelHelper.requiresMappingLevel_1(this.mappingLevel) ? new ICMVariableRepeatEntryImpl(maxOccurs, minOccurs, choice, this.constants, totalChoices, thisChoice, mixedContent, this.mappingLevel, readableXPath, optionalModelGroup, simpleNamedContainer, structuralNamedContainer, this.icm, optionalArray, innerArray) : new ICMExtendedVariableRepeatEntryImpl(maxOccurs, minOccurs, choice, this.constants, totalChoices, thisChoice, mixedContent, this.mappingLevel, readableXPath, optionalModelGroup, simpleNamedContainer, structuralNamedContainer, this.icm, optionalArray, innerArray);
        this.initDataSectionEntry(xpath, variable, levelOffset);
        this.repeatEntriesStack.push(variable);
        return variable;
    }

    protected ICMFixedRepeatEntryImpl addFixedRepeatsEntry(int occurs, String xpath, String readableXPath, long levelOffset, boolean mixedContent, boolean inLineVariablyRepeating, int minInLineOccurs, int maxInLineOccurs, int thisChoiceNumber, int totalChoices, boolean optionalModelGroup, long offsetOfCountField, ICMSlackBytesElementEntryImpl odoTarget, boolean truncatableArray, String truncatableValues, boolean optionalArray, boolean innerArray, boolean multiTypedElement) throws ICMException {
        ICMFixedRepeatEntryImpl fixed = null;
        fixed = MappingLevelHelper.requiresMappingLevel_1(this.mappingLevel) ? new ICMFixedRepeatEntryImpl(occurs, this.constants, mixedContent, this.mappingLevel, readableXPath, false, inLineVariablyRepeating, minInLineOccurs, maxInLineOccurs, thisChoiceNumber, totalChoices, optionalModelGroup, offsetOfCountField, null, this.icm, false, null, optionalArray, innerArray, multiTypedElement) : new ICMExtendedFixedRepeatEntryImpl(occurs, this.constants, mixedContent, this.mappingLevel, readableXPath, false, inLineVariablyRepeating, minInLineOccurs, maxInLineOccurs, thisChoiceNumber, totalChoices, optionalModelGroup, offsetOfCountField, odoTarget, this.icm, truncatableArray, truncatableValues, optionalArray, innerArray, multiTypedElement);
        this.initDataSectionEntry(xpath, fixed, levelOffset);
        this.processODO(odoTarget);
        this.repeatEntriesStack.push(fixed);
        return fixed;
    }

    protected ICMFixedRepeatEntryImpl addSlackBytesFixedRepeatsEntry(int occurs, String xpath, String readableXPath, long levelOffset, boolean mixedContent) throws ICMException {
        ICMSlackBytesFixedRepeatEntryImpl fixed = new ICMSlackBytesFixedRepeatEntryImpl(occurs, this.constants, mixedContent, this.mappingLevel, readableXPath, this.icm);
        this.initDataSectionEntry(null, fixed, levelOffset);
        return fixed;
    }

    protected ICMAttributeEntryImpl addAttributeEntry(String localName, String nameSpace, long levelOffset, boolean optional, String prefix, boolean nameSpaceRelevant, boolean fixed, boolean implied, boolean nillable, boolean contentType) throws ICMException {
        if (this.dataSectionEntries.size() == 0) {
            return null;
        }
        ICMAttributeEntryImpl attr = null;
        QName qname = new QName(nameSpace, localName);
        attr = new ICMAttributeEntryImpl(this.constants, qname, optional, implied, prefix, levelOffset, nameSpaceRelevant, fixed, nillable, contentType, this.mappingLevel, this.icm);
        this.initDataSectionEntry(null, attr, levelOffset);
        this.constants.checkForNameSpaceClashes(localName, nameSpace);
        this.constants.setAttributesUsed();
        return attr;
    }

    protected void addEndRepeatsEntry(ICMRepeatEntryImpl repeatEntry) throws ICMException {
        ICMEndRepeatEntryImpl end = new ICMEndRepeatEntryImpl(this.constants, this.mappingLevel, false, repeatEntry, this.icm);
        this.initDataSectionEntry(null, end, -1L);
        repeatEntry.setEndEntry(end);
        this.repeatEntriesStack.pop();
    }

    protected void addSlackBytesEndRepeatsEntry(ICMRepeatEntryImpl repeatEntry) throws ICMException {
        ICMSlackBytesEndRepeatEntryImpl end = new ICMSlackBytesEndRepeatEntryImpl(this.constants, this.mappingLevel, repeatEntry, this.icm);
        this.initDataSectionEntry(null, end, -1L);
        repeatEntry.setEndEntry(end);
    }

    private void initDataSectionEntry(String xpath, ICMEntryImpl entry, long levelOffset) throws ICMException {
        ICMEntryImpl currentEntry;
        int currentIndex = this.dataSectionEntries.size() - 1;
        if (currentIndex >= 0 && (currentEntry = this.dataSectionEntries.get(currentIndex)) instanceof ICMChoiceGroupEntry) {
            if (xpath != null && !xpath.equals("")) {
                this.createIndexEntry(xpath, currentEntry);
            }
            xpath = null;
        }
        if (xpath != null && !xpath.equals("")) {
            this.createIndexEntry(xpath, entry);
        }
        if (currentIndex >= 0) {
            currentEntry = this.dataSectionEntries.get(currentIndex);
            if (entry.isODOTargetClone()) {
                entry.setHidden(true);
                currentEntry.setODOTarget((ICMDataElementEntryImpl)entry);
            }
            if (currentEntry.getTypeEnum().equals((Object)ICM.ICMRecord.ATTRIBUTE_RECORD_TYPE) && entry.getTypeEnum().equals((Object)ICM.ICMRecord.DATA_ELEMENT_RECORD_TYPE)) {
                ICMAttributeEntryImpl attrEntry = (ICMAttributeEntryImpl)currentEntry;
                attrEntry.setDataElement((ICMDataElementEntryImpl)entry);
                entry.setHidden(true);
            } else if (currentIndex >= 1 && entry.getTypeEnum().equals((Object)ICM.ICMRecord.ATTRIBUTE_RECORD_TYPE)) {
                int minusOneIndex = currentIndex - 1;
                ICMEntryImpl minusOne = this.dataSectionEntries.get(minusOneIndex);
                if (minusOne.getTypeEnum().equals((Object)ICM.ICMRecord.ATTRIBUTE_RECORD_TYPE)) {
                    ICMAttributeEntryImpl minusOneAttr = (ICMAttributeEntryImpl)minusOne;
                    minusOneAttr.setNextAttribute((ICMAttributeEntryImpl)entry);
                }
            } else {
                while (currentIndex > 0 && currentEntry.isHidden()) {
                    currentEntry = this.dataSectionEntries.get(--currentIndex);
                }
                currentEntry.setLogicalNextEntry(entry);
            }
            if (entry.getTypeEnum().equals((Object)ICM.ICMRecord.ATTRIBUTE_RECORD_TYPE)) {
                while (currentIndex > 0 && currentEntry.isHidden()) {
                    currentEntry = this.dataSectionEntries.get(--currentIndex);
                }
                currentEntry.addAttribute((ICMAttributeEntryImpl)entry);
            }
        }
        this.dataSectionEntries.add(entry);
        int repeatsToIgnore = 0;
        int entriesIndex = this.dataSectionEntries.size() - 1;
        ICMEntryImpl prev = this.dataSectionEntries.get(entriesIndex);
        boolean finished = false;
        ICMEntryImpl parent = null;
        while (!finished) {
            if (prev instanceof ICMEndRepeatEntry) {
                ++repeatsToIgnore;
            }
            if (prev instanceof ICMRepeatEntry && prev != entry) {
                if (repeatsToIgnore > 0) {
                    --repeatsToIgnore;
                } else {
                    finished = true;
                    parent = prev;
                }
            }
            if (--entriesIndex == -1) {
                parent = null;
                finished = true;
                continue;
            }
            prev = this.dataSectionEntries.get(entriesIndex);
        }
        entry.setParent(parent);
        if (levelOffset > -1L) {
            entry.setOffsetIntoStructure(levelOffset);
        }
    }

    private ICMIndexEntryImpl createIndexEntry(String xpath, ICMEntryImpl entry) throws ICMException {
        if (this.allXpaths.containsKey(xpath)) {
            ICMEntryImpl existingTarget = this.allXpaths.get(xpath);
            if ((existingTarget.getLogicalNextEntry() == null || existingTarget.getODOTarget() != null && existingTarget.getODOTarget().getLogicalNextEntry() == null || existingTarget instanceof ICMChoiceGroupEntry || entry instanceof ICMChoiceGroupEntry) && this.setNonStructural(existingTarget)) {
                if (entry instanceof ICMChoiceGroupEntry && existingTarget instanceof ICMRepeatEntry) {
                    entry.setIndexEntry(existingTarget.getIndexEntry());
                    existingTarget.setIndexEntry(null);
                }
                return null;
            }
            throw new ICMException(MessageHandler.buildMessage("DFHPI9033E", new Object[]{this.getSimpleXpath(xpath)}));
        }
        ICMIndexEntryImpl ie = new ICMIndexEntryImpl(xpath, entry, this.constants);
        this.indexEntries.add(ie);
        if (this.prevIndexEntry != null) {
            this.prevIndexEntry.setNextIndexEntry(ie);
        }
        this.prevIndexEntry = ie;
        if (entry != null) {
            entry.setIndexEntry(ie);
            this.allXpaths.put(xpath, entry);
        }
        return ie;
    }

    private boolean setNonStructural(ICMEntry target) {
        if (target instanceof ICMChoiceGroupEntry) {
            return this.setNonStructural(target.getLogicalNextEntry());
        }
        if (target instanceof ICMRepeatEntryImpl) {
            ((ICMRepeatEntryImpl)target).setStructural(false);
            return true;
        }
        return false;
    }

    protected ICMIndexEntryImpl createDummyIndexEntry(String xpath) throws ICMException {
        return this.createIndexEntry(xpath, null);
    }

    private void sortIndex() {
        int i;
        boolean nameSpacesSignificant = this.constants.getElementClashes();
        ICMIndexEntryComparator sorter = new ICMIndexEntryComparator(nameSpacesSignificant);
        Collections.sort(this.indexEntries, sorter);
        for (i = 0; i < this.indexEntries.size(); ++i) {
            ICMIndexEntryImpl entry = this.indexEntries.get(i);
            entry.setEntryNum(i + 1);
        }
        block1: for (i = 0; i < this.indexEntries.size() - 1; ++i) {
            ICMIndexEntryImpl parent = this.indexEntries.get(i);
            int potentialChildPos = i + 1;
            ICMIndexEntryImpl potentialChild = this.indexEntries.get(potentialChildPos);
            boolean firstMatchFound = false;
            while (parent.getNumOfParts() + 1 >= potentialChild.getNumOfParts()) {
                if (potentialChild.getParent() == null && parent.getNumOfParts() < potentialChild.getNumOfParts()) {
                    if (potentialChild.getXpathForSearchWithNS().startsWith(parent.getXpathForSearchWithNS())) {
                        parent.addChildTag(potentialChild);
                        firstMatchFound = true;
                    } else if (firstMatchFound) continue block1;
                }
                if (++potentialChildPos >= this.indexEntries.size()) continue block1;
                potentialChild = this.indexEntries.get(potentialChildPos);
            }
        }
    }

    public void log(PrintStream logger) {
        logger.println("ICM Header Section: " + LINE_SEPARATOR);
        logger.println("  EYECATCHER   = >DFHICM<");
        logger.println("  MAPPING LEVEL= " + ICM.MAPPING_LEVELS_AS_ICM_VERSION_NUMS_DISPLAY[this.mappingLevel]);
        logger.println("  ICM LENGTH   = " + ByteArray.formatNumForDisplay(this.totalICMLength));
        logger.println("  ICM NAME     = " + this.name);
        logger.println("  SIZE OF STRUCTURE = " + ByteArray.formatNumForDisplay(this.sizeOfCommarea));
        if (this.xmlTemplate != null) {
            logger.println("  XML TEMPLATE " + this.xmlTemplate);
        } else {
            logger.println("  TEMPLATE = -1");
        }
        logger.println("  DATA OFFSET  = " + ByteArray.formatNumForDisplay(this.dataOffset));
        logger.print(LINE_SEPARATOR + LINE_SEPARATOR + LINE_SEPARATOR + "ICM Index Section: ");
        logger.println("Offset Of Start of Index Section = " + ByteArray.formatNumForDisplay(this.totalLengthofHeader));
        logger.println(LINE_SEPARATOR + LINE_SEPARATOR + "  NUMBER OF INDEX ENTRIES = " + this.indexEntries.size() + LINE_SEPARATOR);
        logger.println("  OPTIMISED INDEX OFFSET = " + ByteArray.formatNumForDisplay(this.offsetOfOptimisedIndex));
        logger.print("  DATA TRUNCATION SUPPORTED = ");
        if (this.dataTruncation) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        logger.print("  DATA SCREENING SUPPORTED = ");
        if (this.dataScreening) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        logger.print("  DEFAULT VALUES EXIST IN ICM = ");
        if (this.defaultsExist) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        logger.print("  XSI TYPE IN FIRST TAG = ");
        if (this.xsiType) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        logger.print("  OPTIMISED INDEX AVAILABLE = ");
        if (this.optimisedIndex) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        logger.print("  XOP ELIGIBLE = ");
        if (this.xopSignificant) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            logger.print("  RESPONSE MESSAGE = ");
            if (this.messageType.equals((Object)ICM.XMLContentType.SOAP_RESPONSE)) {
                logger.println(" true");
            } else {
                logger.println(" false");
            }
            logger.print("  REQUEST MESSAGE = ");
            if (this.messageType.equals((Object)ICM.XMLContentType.SOAP_REQUEST)) {
                logger.println(" true");
            } else {
                logger.println(" false");
            }
        }
        logger.print("  ATTRIBUTES SIGNIFICANT = ");
        if (this.constants.isAttributesUsed()) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        logger.print("  NAMESPACE SIGNIFICANT = ");
        if (this.constants.getElementClashes()) {
            logger.println(" true");
        } else {
            logger.println(" false");
        }
        logger.print("  ENDIANNESS = ");
        if (this.props.getPlatform() != null) {
            logger.println((Object)this.props.getPlatform().getEndianness());
        } else {
            logger.println((Object)IPlatform.EndianType.BIG_ENDIAN);
        }
        logger.print("  ZONED ENCODING = ");
        if (this.props.getPlatform() != null) {
            logger.println((Object)((Object)this.props.getPlatform().getZonedEncoding()) + LINE_SEPARATOR);
        } else {
            logger.println((Object)((Object)IPlatform.ZonedEncodingType.ZONED_EBCDIC) + LINE_SEPARATOR);
        }
        for (ICMIndexEntryImpl entry : this.indexEntries) {
            logger.println("  Index Offset: " + ByteArray.formatNumForDisplay(entry.getIndexOffset()));
        }
        for (ICMIndexEntryImpl entry : this.indexEntries) {
            logger.print(entry);
        }
        if (this.optimisedIndex) {
            logger.println(LINE_SEPARATOR + "  ICM OPTIMISED INDEX: " + LINE_SEPARATOR);
            for (ICMIndexEntryImpl entry : this.indexEntries) {
                logger.println(LINE_SEPARATOR + "   ENTRY NUMBER: " + entry.getEntryNum());
                int firstChildPos = Short.MAX_VALUE;
                if (entry.getFirstChild() != null) {
                    firstChildPos = entry.getFirstChild().getEntryNum();
                }
                int lastChildPos = 0;
                if (entry.getLastChild() != null) {
                    lastChildPos = entry.getLastChild().getEntryNum();
                }
                logger.println("    FIRST CHILD POS = " + firstChildPos);
                logger.println("    LAST CHILD POS = " + lastChildPos);
                logger.println("    NESTING LEVEL = " + entry.getNumOfParts());
                logger.println("    ASSOCIATED INDEX ENTRY OFFSET = " + ByteArray.formatNumForDisplay(entry.getIndexOffset()));
            }
        }
        logger.println(LINE_SEPARATOR + LINE_SEPARATOR + LINE_SEPARATOR + "ICM Data Section: ");
        logger.println("Offset Of Start of Data Section = " + ByteArray.formatNumForDisplay(this.dataOffset));
        for (ICMEntryImpl entry : this.dataSectionEntries) {
            logger.print(entry);
        }
        logger.println(LINE_SEPARATOR + LINE_SEPARATOR + LINE_SEPARATOR + "ICM Constants Section: ");
        logger.println("Offset Of Start of Constants Section = " + ByteArray.formatNumForDisplay(this.constantsOffset) + LINE_SEPARATOR);
        logger.print(this.constants.toString());
    }

    protected byte[] toByteArray() throws IOException, ICMException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ByteArray.toCodePageByteArray(EYE_CATCHER, 8, CHARSET_CP037));
        baos.write(ICM.MAPPING_LEVELS_AS_ICM_VERSION_NUMS[this.mappingLevel]);
        baos.write(ByteArray.numToByteArray(this.totalICMLength, 8));
        baos.write(ByteArray.toCodePageByteArray(this.name, 32, CHARSET_CP037));
        baos.write(ByteArray.numToByteArray(this.sizeOfCommarea, 8));
        baos.write(ByteArray.numToByteArray(this.xmlTemplate.getOffset(), 8));
        baos.write(ByteArray.numToByteArray(this.xmlTemplate.getLength(), 8));
        int overflowFlags = 0;
        if ("DFHJS2LS".equals(this.props.getInputParameters().getProperty("INTERNAL_TOOLNAME"))) {
            overflowFlags |= 1;
        }
        if (this.props.getPlatform() != null && this.props.getPlatform().getEndianness().equals((Object)IPlatform.EndianType.LITTLE_ENDIAN)) {
            overflowFlags |= 2;
        }
        if (this.props.getPlatform() != null && this.props.getPlatform().getZonedEncoding().equals((Object)IPlatform.ZonedEncodingType.ZONED_ASCII)) {
            overflowFlags |= 4;
        }
        if (!this.dataScreening) {
            overflowFlags |= 0x10;
        }
        if (this.defaultsExist) {
            overflowFlags |= 0x20;
        }
        baos.write(ByteArray.numToByteArray(overflowFlags, 4));
        baos.write(ByteArray.numToByteArray(this.dataOffset, 4));
        baos.write(ByteArray.numToByteArray(this.indexEntries.size(), 4));
        baos.write(ByteArray.numToByteArray(this.offsetOfOptimisedIndex, 3));
        byte flags = 0;
        if (this.constants.getElementClashes()) {
            flags = (byte)(flags | 1);
        }
        if (this.constants.isAttributesUsed()) {
            flags = (byte)(flags | 2);
        }
        if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            if (this.messageType.equals((Object)ICM.XMLContentType.SOAP_REQUEST)) {
                flags = (byte)(flags | 4);
            } else if (this.messageType.equals((Object)ICM.XMLContentType.SOAP_RESPONSE)) {
                flags = (byte)(flags | 8);
            }
            if (this.xopSignificant) {
                flags = (byte)(flags | 0x10);
            }
            if (this.optimisedIndex) {
                flags = (byte)(flags | 0x20);
            }
        }
        if (this.xsiType) {
            flags = (byte)(flags | 0x40);
        }
        if (this.dataTruncation) {
            flags = (byte)(flags | 0x80);
        }
        baos.write(ByteArray.numToByteArray(flags, 1));
        for (ICMIndexEntryImpl entry : this.indexEntries) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && entry.getIndexOffset() > 65535L) {
                baos.write(ByteArray.numToByteArray(-1L, 2));
                continue;
            }
            baos.write(ByteArray.numToByteArray(entry.getIndexOffset(), 2));
        }
        int padding = this.indexEntries.size() * 2 % 8;
        if (padding > 0) {
            for (int i = padding; i < 8; ++i) {
                baos.write(new byte[]{0});
            }
        }
        for (ICMIndexEntryImpl entry : this.indexEntries) {
            baos.write(entry.toByteArray());
        }
        if (this.optimisedIndex) {
            int lastTopLevelIndexEntry;
            int firstTopLevelIndexEntry = 1;
            for (lastTopLevelIndexEntry = 0; lastTopLevelIndexEntry < this.indexEntries.size() && this.indexEntries.get(lastTopLevelIndexEntry).getNumOfParts() == 1; ++lastTopLevelIndexEntry) {
            }
            if (lastTopLevelIndexEntry == 0) {
                firstTopLevelIndexEntry = Short.MAX_VALUE;
            }
            ICMContentHolder.addOptimisedIndexEntry(baos, firstTopLevelIndexEntry, lastTopLevelIndexEntry, 0, -1L);
            for (ICMIndexEntryImpl entry : this.indexEntries) {
                int firstChildPos = Short.MAX_VALUE;
                if (entry.getFirstChild() != null) {
                    firstChildPos = entry.getFirstChild().getEntryNum();
                }
                int lastChildPos = 0;
                if (entry.getLastChild() != null) {
                    lastChildPos = entry.getLastChild().getEntryNum();
                }
                ICMContentHolder.addOptimisedIndexEntry(baos, firstChildPos, lastChildPos, entry.getNumOfParts(), entry.getIndexOffset());
            }
        }
        for (ICMEntryImpl entry : this.dataSectionEntries) {
            baos.write(entry.getBinaryData());
        }
        baos.write(this.constants.toByteArray());
        this.allXpaths.clear();
        this.constants = null;
        this.indexEntries.clear();
        this.prevIndexEntry = null;
        this.xmlTemplate = null;
        return baos.toByteArray();
    }

    protected static void addOptimisedIndexEntry(OutputStream out, int firstChildPos, int lastChildPos, int nestingLevel, long ICMIndexEntryOffset) throws ICMException, IOException {
        out.write(ByteArray.numToByteArray(firstChildPos, 4));
        out.write(ByteArray.numToByteArray(lastChildPos, 4));
        out.write(ByteArray.numToByteArray(nestingLevel, 4));
        out.write(ByteArray.numToByteArray(ICMIndexEntryOffset, 4));
    }

    protected void finishedWithWSDL(ICMLevelState topLevelState) throws ICMException, IOException {
        this.removeTrailingPaddingIfRequired(topLevelState);
        ICMEndDataSectionEntryImpl endDS = new ICMEndDataSectionEntryImpl(this.constants, this.mappingLevel, this.icm);
        this.initDataSectionEntry(null, endDS, -1L);
        this.setXMLTemplate(topLevelState.getTemplate().toString());
        this.xsiType = topLevelState.getTemplate().containsTypeInfo();
        this.sortIndex();
        this.constants.compressConstants();
        Iterator<ICMIndexEntryImpl> indexEntrys = this.indexEntries.iterator();
        long currentOffset = this.totalLengthofHeader + 4 + 3 + 1;
        currentOffset += (long)(2 * this.indexEntries.size());
        int padding = this.indexEntries.size() * 2 % 8;
        if (padding > 0) {
            for (int i = padding; i < 8; ++i) {
                ++currentOffset;
            }
        }
        while (indexEntrys.hasNext()) {
            ICMIndexEntryImpl ie = indexEntrys.next();
            ie.setIndexOffset(currentOffset);
            currentOffset += (long)ie.toByteArray().length;
        }
        if (this.optimisedIndex) {
            this.offsetOfOptimisedIndex = currentOffset;
            currentOffset += ((long)this.indexEntries.size() + 1L) * 16L;
        }
        this.dataOffset = currentOffset;
        this.sizeOfCommarea = topLevelState.getTotalLength();
        Stack<ICMFixedRepeatEntry> structStack = new Stack<ICMFixedRepeatEntry>();
        ICMEntry choiceRepeatEntry = null;
        for (int i = 0; i < this.dataSectionEntries.size(); ++i) {
            ICMEntryImpl entry = this.dataSectionEntries.get(i);
            entry.buildByteArray();
            entry.setOffsetIntoICM(currentOffset);
            if (entry instanceof ICMFixedRepeatEntry) {
                if (((ICMFixedRepeatEntry)((Object)entry)).isRawXMLContent()) {
                    structStack.push((ICMFixedRepeatEntry)((Object)entry));
                }
            } else if (entry instanceof ICMRawXMLElementEntry && (((ICMRawXMLElementEntry)((Object)entry)).getAnyType() == ICMRawXMLElementEntry.AnyType.any || ((ICMRawXMLElementEntry)((Object)entry)).getAnyType() == ICMRawXMLElementEntry.AnyType.JSON_PROPERTY)) {
                long offset = currentOffset;
                if (this.dataSectionEntries.size() > i && i > 0) {
                    ICMEntry repeatEntry = this.dataSectionEntries.get(i - 1);
                    if (repeatEntry instanceof ICMRepeatEntry && structStack.size() > 0 && repeatEntry != structStack.peek()) {
                        offset = repeatEntry.getOffsetIntoICM();
                        if (!(repeatEntry instanceof ICMChoiceGroupEntry) && this.dataSectionEntries.size() > 1 && (repeatEntry = (ICMEntry)this.dataSectionEntries.get(i - 2)) instanceof ICMChoiceGroupEntry) {
                            offset = repeatEntry.getOffsetIntoICM();
                        }
                    }
                    if (structStack.size() > 0) {
                        ICMFixedRepeatEntry struct = (ICMFixedRepeatEntry)structStack.pop();
                        struct.setRawXMLOffset(offset);
                    }
                }
            } else if (entry instanceof ICMStartChoiceGroupEntry) {
                if (this.dataSectionEntries.size() > i && i > 0) {
                    ICMEntry choiceRepeatEntryParent;
                    choiceRepeatEntry = this.dataSectionEntries.get(i - 1);
                    if (!(choiceRepeatEntry instanceof ICMRepeatEntry) || ((ICMRepeatEntry)choiceRepeatEntry).isStructural()) {
                        choiceRepeatEntry = null;
                    } else if (this.dataSectionEntries.size() > i - 2 && (choiceRepeatEntryParent = (ICMEntry)this.dataSectionEntries.get(i - 2)) instanceof ICMRepeatEntry && !((ICMRepeatEntry)choiceRepeatEntryParent).isStructural()) {
                        choiceRepeatEntry = choiceRepeatEntryParent;
                    }
                }
            } else if (entry instanceof ICMChoiceGroupEntry) {
                if (choiceRepeatEntry != null) {
                    ICMChoiceGroupEntry cgEntry = (ICMChoiceGroupEntry)((Object)entry);
                    for (ICMChoiceGroupEntry current = cgEntry.getStartChoiceGroupEntry().getFirstEntry(); current != null; current = current.getNextChoiceGroupEntry()) {
                        current.setEntry(choiceRepeatEntry);
                    }
                }
            } else if (entry instanceof ICMEndChoiceGroupEntry) {
                choiceRepeatEntry = null;
            }
            if (entry.getIndexEntry() != null) {
                entry.getIndexEntry().setTargetOffset(currentOffset);
            }
            currentOffset += (long)entry.getBinaryData().length;
        }
        this.constantsOffset = currentOffset;
        this.totalICMLength = currentOffset = this.constants.setOffsets(currentOffset);
        for (ICMEntryImpl entry : this.dataSectionEntries) {
            entry.buildByteArray();
        }
    }

    protected void removeTrailingPaddingIfRequired(ICMLevelState topLevelState) {
        int language = -1;
        if (this.props != null) {
            language = this.props.getLang();
        }
        if (language == 2 || language == 6 || language == 7) {
            int entryNumber = this.dataSectionEntries.size();
            while (--entryNumber >= 0) {
                ICMEntryImpl entry = this.dataSectionEntries.get(entryNumber);
                if (entry instanceof ICMEndRepeatEntry) {
                    ICMFixedRepeatEntry fixedRepeat;
                    ICMEndRepeatEntryImpl endRepeat = (ICMEndRepeatEntryImpl)entry;
                    ICMRepeatEntryImpl startRepeat = endRepeat.getStartEntry();
                    if (!(startRepeat instanceof ICMFixedRepeatEntry) || (fixedRepeat = (ICMFixedRepeatEntry)((Object)startRepeat)).getOccurances() <= 1) continue;
                    break;
                }
                if (!(entry instanceof ICMSlackBytesElementEntryImpl)) break;
                ICMSlackBytesElementEntryImpl paddingEntry = (ICMSlackBytesElementEntryImpl)entry;
                int lengthOfPadding = paddingEntry.getLAR();
                if (!paddingEntry.isPadding()) break;
                this.dataSectionEntries.remove(entryNumber);
                for (int trailingFixedRepeatNumber = entryNumber; trailingFixedRepeatNumber < this.dataSectionEntries.size(); ++trailingFixedRepeatNumber) {
                    ICMEndRepeatEntryImpl er = (ICMEndRepeatEntryImpl)this.dataSectionEntries.get(trailingFixedRepeatNumber);
                    ICMRepeatEntryImpl sr = er.getStartEntry();
                    if (sr.getStructureSize() - (long)lengthOfPadding >= 0L) {
                        sr.setStructureSize(sr.getStructureSize() - (long)lengthOfPadding);
                    } else {
                        sr.setStructureSize(0L);
                    }
                    if (trailingFixedRepeatNumber != this.dataSectionEntries.size() - 1) continue;
                    topLevelState.setTotalLength(sr.getStructureSize());
                }
            }
        }
    }

    protected List<ICMEntryImpl> getContents() {
        return this.dataSectionEntries;
    }

    protected List<ICMEntry> getNonHiddenContents() {
        LinkedList<ICMEntry> nonHiddenContents = new LinkedList<ICMEntry>();
        for (ICMEntryImpl entry : this.getContents()) {
            if (entry.isHidden()) continue;
            nonHiddenContents.add(entry);
        }
        this.dataSectionEntries = null;
        return nonHiddenContents;
    }

    protected String getName() {
        return this.name;
    }

    protected void setMappingLevel(int mappingLevel) {
        this.mappingLevel = mappingLevel;
        if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
            this.optimisedIndex = true;
        }
    }

    public void setRepeatEntryNonStructural(StringBuilder xpath) {
        ICMEntryImpl currentEntry = this.allXpaths.get(xpath.toString());
        if (currentEntry != null && currentEntry instanceof ICMRepeatEntry) {
            ((ICMRepeatEntry)((Object)currentEntry)).setStructural(false);
            ICMIndexEntry index = currentEntry.getIndexEntry();
            currentEntry.setIndexEntry(null);
            this.indexEntries.remove(index);
        }
    }

    String getSimpleXpath(String complexXpath) {
        if (complexXpath == null) {
            return null;
        }
        StringBuilder simpleXpath = new StringBuilder();
        String[] tokens = complexXpath.split("[+][+][+]");
        for (int i = 1; i < tokens.length; ++i) {
            String part = tokens[i];
            int delimiterPos = part.indexOf("~~~");
            String elementName = part.substring(delimiterPos + 3);
            simpleXpath.append("/");
            simpleXpath.append(elementName);
        }
        return simpleXpath.toString();
    }

    String getJsonKeyword(String complexXpath) {
        String simplifiedXPath = this.getSimpleXpath(complexXpath);
        String jsonKeyword = ICMContentHolder.convertSimplifiedXPath2JsonKeyword(simplifiedXPath);
        return jsonKeyword;
    }

    public static String convertSimplifiedXPath2JsonKeyword(String simplifiedXPath) {
        String[] parts;
        StringBuffer jsonKeyword = new StringBuffer();
        if (simplifiedXPath != null && (parts = simplifiedXPath.split("/")).length > 2) {
            jsonKeyword.append(parts[2]);
            if (parts.length > 3) {
                for (int i = 3; i < parts.length; ++i) {
                    jsonKeyword.append("->");
                    jsonKeyword.append(parts[i]);
                }
            }
        }
        return jsonKeyword.toString();
    }
}

