/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMDataElementEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.impl.ICMSlackBytesElementEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

class ICMDataElementEntryImpl
extends ICMEntryImpl
implements ICMDataElementEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private ICM.ICMDataType dataType = null;
    private static final int ICM_DATATYPE_LENGTH = 1;
    private int LAR = -1;
    private static final int ICM_LAR_LENGTH = 2;
    private int fractionDigits = -1;
    private static final int ICM_FRACTION_DIGITS_LENGTH = 1;
    private ICM.WhiteSpace whiteSpace = null;
    private static final int ICM_WHITESPACE_LENGTH = 1;
    private boolean aligned = true;
    private ICMConstantsSectionEntry containerName = null;
    private static final int ICM_CONTAINER_NAME_OFFSET_LENGTH = 4;
    private static final int ICM_CONTAINER_NAME_MAX_VALUE = 16;
    private ICMConstantsSectionEntry localName = null;
    private static final int ICM_ELEMENT_LOCALNAME_LENGTH_LENGTH = 2;
    private static final int ICM_ELEMENT_LOCALNAME_OFFSET_LENGTH = 4;
    private static final long ICM_ELEMENT_LOCALNAME_MAX_VALUE = 32767L;
    private ICMConstantsSectionEntry nameSpace = null;
    private static final int ICM_ELEMENT_NAMESPACE_LENGTH_LENGTH = 2;
    private static final int ICM_ELEMENT_NAMESPACE_OFFSET_LENGTH = 4;
    private static final long ICM_ELEMENT_NAMESPACE_MAX_VALUE = 32767L;
    private ICMConstantsSectionEntry defaultValue = null;
    private static final int ICM_DEFAULT_VALUE_LENGTH_LENGTH = 2;
    private static final int ICM_DEFAULT_VALUE_OFFSET_LENGTH = 8;
    private static final long ICM_DEFAULT_VALUE_MAX_VALUE = 32767L;
    private List<String> comments = null;
    private int offsetWithinExtendedStructure = 0;
    protected static final int ICM_LENGTH_OF_DATA_ELEMENT_RECORD = 64;
    private static final int ICM_CONTAINER_NAME_LENGTH_LENGTH = 1;
    private static final int ICM_UNUSED_OFFSET_LENGTH = 8;
    private byte flagsByte = 0;
    private byte flagsByte2 = 0;
    private ICM.EncodingType encodingType = ICM.EncodingType.SBCS;
    private static final int ICM_FLAGS_BYTES_LENGTH = 1;
    private ICM.VaryingLength variableLengthMappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
    private boolean useContainerMapping = false;
    private boolean useVaryingMapping = false;
    private boolean useNullTerminatedMapping = false;
    private boolean useNamedContainerMapping = false;
    private boolean signIsLeading = false;
    private boolean separateChar = false;
    private boolean multiTypedElement = false;
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ICM_DATATYPE = 1;
    private static final int OFFSET_OF_ICM_DATATYPE = 1;
    private static final int LENGTH_OF_ICM_LAR = 2;
    private static final int OFFSET_OF_ICM_LAR = 2;
    private static final int LENGTH_OF_FRACTION_DIGITS = 1;
    private static final int OFFSET_OF_FRACTION_DIGITS = 4;
    private static final int OFFSET_OF_WHITESPACE = 5;
    private static final int LENGTH_OF_NAMESPACE_LENGTH = 2;
    private static final int OFFSET_OF_NAMESPACE_LENGTH = 6;
    private static final int LENGTH_OF_LOCAL_NAME_LENGTH = 2;
    private static final int OFFSET_OF_LOCAL_NAME_LENGTH = 8;
    private static final int LENGTH_OF_EXTENDED_LAR = 1;
    private static final int OFFSET_OF_EXTENDED_LAR = 10;
    private static final int LENGTH_OF_LOCATION_NAME_LENGTH = 1;
    private static final int OFFSET_OF_LOCATION_NAME_LENGTH = 11;
    private static final int LENGTH_OF_DEFAULT_NAME_LENGTH = 2;
    private static final int OFFSET_OF_DEFAULT_NAME_LENGTH = 12;
    private static final int LENGTH_OF_FLAGS_BYTE = 1;
    private static final int OFFSET_OF_FLAGS_BYTE = 14;
    private static final int LENGTH_OF_CONTAINER_NAME_LENGTH = 1;
    private static final int OFFSET_OF_CONTAINER_NAME_LENGTH = 15;
    private static final int LENGTH_OF_FLAGS2_BYTE = 1;
    private static final int OFFSET_OF_FLAGS2_BYTE = 16;
    private static final int LENGTH_OF_CONTAINER_OFFSET_PADDING = 3;
    private static final int OFFSET_OF_CONTAINER_OFFSET_PADDING = 17;
    private static final int LENGTH_OF_DE_CONTAINER_OFFSET = 4;
    private static final int OFFSET_OF_DE_CONTAINER_OFFSET = 20;
    private static final int LENGTH_OF_DE_CONTAINER_NAME_OFFSET = 4;
    private static final int OFFSET_OF_DE_CONTAINER_NAME_OFFSET = 24;
    private static final int LENGTH_OF_ELEMENT_NAMESPACE_OFFSET = 4;
    private static final int OFFSET_OF_ELEMENT_NAMESPACE_OFFSET = 28;
    private static final int LENGTH_OF_ODO_TARGET_OFFSET = 4;
    private static final int OFFSET_OF_ODO_TARGET_OFFSET = 32;
    private static final int LENGTH_OF_LOCAL_NAME_OFFSET = 4;
    private static final int OFFSET_OF_LOCAL_NAME_OFFSET = 36;
    private static final int LENGTH_OF_LOCATION_NAME_PADDING = 4;
    private static final int OFFSET_OF_LOCATION_NAME_PADDING = 40;
    private static final int LENGTH_OF_LOCATION_NAME_OFFSET = 4;
    private static final int OFFSET_OF_LOCATION_NAME_OFFSET = 44;
    private static final int LENGTH_OF_DEFAULT_VALUE_PADDING = 4;
    private static final int OFFSET_OF_DEFAULT_VALUE_PADDING = 48;
    private static final int LENGTH_OF_DEFAULT_VALUE_OFFSET = 4;
    private static final int OFFSET_OF_DEFAULT_VALUE_OFFSET = 52;
    private static final int LENGTH_OF_TAIL_PADDING = 4;
    private static final int OFFSET_OF_TAIL_PADDING = 56;
    private static final int LENGTH_OF_TAIL_POINTER = 4;
    private static final int OFFSET_OF_TAIL_POINTER = 60;
    private static final int LENGTH_OF_TYPE1_ICMENTRY = 64;
    private ByteArray CACHED_NAME_VALUE;
    private Object[] traceParms = null;

    protected ICMDataElementEntryImpl(ICM.ICMDataType dataType, int LAR, ICM.WhiteSpace whiteSpace, String localName, String nameSpace, String xmlName, String defaultValue, List<String> comments, ICMConstantsSectionHolder cse, int fractionDigits, boolean aligned, ICM.EncodingType encodingType, ICM.VaryingLength variableLengthMappingStrategy, int mappingLevel, String simplifiedXPath, boolean signIsLeading, boolean separateChar, boolean slackBytes, String containerName, ICMSlackBytesElementEntryImpl odoTarget, boolean odoTargetClone, int minLength, boolean multiTypedElement, ICM icm) throws ICMException {
        super(ICM.ICMRecord.DATA_ELEMENT_RECORD_TYPE, cse, mappingLevel, simplifiedXPath, slackBytes, odoTargetClone, icm);
        this.dataType = dataType;
        this.LAR = LAR;
        this.whiteSpace = whiteSpace;
        this.localName = cse.createConstant(localName, 32767L);
        this.variableLengthMappingStrategy = variableLengthMappingStrategy;
        this.signIsLeading = signIsLeading;
        this.separateChar = separateChar;
        if (containerName != null) {
            this.containerName = cse.createConstant(containerName, 16L);
        }
        this.odoTarget = odoTarget;
        if (nameSpace != null) {
            this.nameSpace = cse.createConstant(nameSpace, 32767L);
        }
        this.setXMLTemplateVariableName(xmlName);
        this.fractionDigits = fractionDigits;
        this.aligned = aligned;
        if (defaultValue != null) {
            this.defaultValue = cse.createConstant(defaultValue, 32767L);
        }
        this.comments = comments;
        this.minLength = minLength;
        if (this.LAR > 0xFFFFFF) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9028E", new Object[]{localName, this.LAR, 0xFFFFFF}));
        }
        if (LAR == -1) {
            throw new ICMException("INTERNAL ERROR: LAR of '" + LAR + "' is invalid.");
        }
        if (xmlName == null) {
            throw new ICMException("INTERNAL ERROR: No XPATH provided for element '" + localName + "'.");
        }
        this.encodingType = encodingType;
        if (encodingType == ICM.EncodingType.DBCS) {
            this.flagsByte = (byte)(this.flagsByte | 0x80);
        } else if (encodingType == ICM.EncodingType.UTF16BE) {
            this.flagsByte2 = (byte)(this.flagsByte2 | 0x80);
        }
        this.multiTypedElement = multiTypedElement;
        if (multiTypedElement) {
            this.flagsByte2 = (byte)(this.flagsByte2 | 0x40);
        }
        if (!this.variableLengthMappingStrategy.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY)) {
            if (this.variableLengthMappingStrategy.getCode() < 0 || this.variableLengthMappingStrategy.getCode() > 4) {
                throw new ICMException("INTERNAL ERROR: Invalid variable length mapping strategy '" + (Object)((Object)this.variableLengthMappingStrategy) + "' requested.");
            }
            boolean mappingProblem = false;
            if (!this.variableLengthMappingStrategy.equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY) && MappingLevelHelper.requiresMappingLevel_1(mappingLevel)) {
                mappingProblem = true;
            }
            if (!(this.variableLengthMappingStrategy.equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY) || this.variableLengthMappingStrategy.equals((Object)ICM.VaryingLength.VARYING_CONTAINER) || MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel))) {
                mappingProblem = true;
            }
            if (mappingProblem) {
                throw new ICMException("INTERNAL ERROR: Requested mapping strategy '" + ICM.VARYING_LENGTH_OPTIONS[this.variableLengthMappingStrategy.getCode()] + "' is not available at this mapping level.");
            }
            switch (this.variableLengthMappingStrategy) {
                case FIXED_LENGTH_ARRAY: {
                    this.useContainerMapping = false;
                    this.useNullTerminatedMapping = false;
                    this.useVaryingMapping = false;
                    this.useNamedContainerMapping = false;
                    break;
                }
                case NULL_TERMINATED_CHAR_ARRAY: {
                    this.useContainerMapping = false;
                    this.useNullTerminatedMapping = true;
                    this.useVaryingMapping = false;
                    this.useNamedContainerMapping = false;
                    this.flagsByte = (byte)(this.flagsByte | 1);
                    break;
                }
                case VARYING_ARRAY: {
                    this.useContainerMapping = false;
                    this.useNullTerminatedMapping = false;
                    this.useVaryingMapping = true;
                    this.useNamedContainerMapping = false;
                    this.flagsByte = (byte)(this.flagsByte | 2);
                    break;
                }
                case VARYING_CONTAINER: {
                    this.useContainerMapping = true;
                    this.useNullTerminatedMapping = false;
                    this.useVaryingMapping = false;
                    this.useNamedContainerMapping = false;
                    this.flagsByte = (byte)(this.flagsByte | 4);
                    break;
                }
                case VARYING_NAMED_CONTAINER: {
                    this.useContainerMapping = false;
                    this.useNullTerminatedMapping = false;
                    this.useVaryingMapping = false;
                    this.useNamedContainerMapping = true;
                    this.flagsByte = (byte)(this.flagsByte | 8);
                    break;
                }
                default: {
                    throw new ICMException("INTERNAL ERROR: unexpected strategy: " + (Object)((Object)this.variableLengthMappingStrategy));
                }
            }
        }
        if (this.signIsLeading) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel) && (this.dataType.equals((Object)ICM.ICMDataType.ZONED) || this.dataType.equals((Object)ICM.ICMDataType.UNSIGNED_ZONED))) {
                this.flagsByte = (byte)(this.flagsByte | 0x40);
            } else {
                throw new ICMException("INTERNAL ERROR: SIGN LEADING is not available at this mapping level or for this data type.");
            }
        }
        if (this.separateChar) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel) && (this.dataType.equals((Object)ICM.ICMDataType.ZONED) || this.dataType.equals((Object)ICM.ICMDataType.UNSIGNED_ZONED))) {
                this.flagsByte = (byte)(this.flagsByte | 0x20);
            } else {
                throw new ICMException("INTERNAL ERROR: SEPARATE CHARACTER is not available at this mapping level or for this data type.");
            }
        }
        if (this.multiTypedElement) {
            if (MappingLevelHelper.supportsMappingLevel_5_0(mappingLevel)) {
                this.flagsByte2 = (byte)(this.flagsByte2 | 0x40);
            } else {
                throw new ICMException("INTERNAL ERROR: MULTI-TYPED ELEMENT is not available at this mapping level or for this data type.");
            }
        }
        if (this.odoTarget != null) {
            this.flagsByte = (byte)(this.flagsByte | 0x10);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR + indentStr + "  Data Element (Offset within ICM = " + ByteArray.formatNumForDisplay(this.getOffsetIntoICM() + (long)this.getOffsetWithinExtendedStructure()) + ")" + LINE_SEPARATOR);
        sb.append(indentStr + "    RECORD TYPE = " + this.getTypeEnum().getCode() + LINE_SEPARATOR);
        sb.append(indentStr + "    DATA TYPE = " + ICM.DATA_TYPES[this.dataType.getCode()] + LINE_SEPARATOR);
        if (this.dataType.equals((Object)ICM.ICMDataType.DECIMAL) || this.dataType.equals((Object)ICM.ICMDataType.UNSIGNED_DECIMAL) || this.dataType.equals((Object)ICM.ICMDataType.ZONED) || this.dataType.equals((Object)ICM.ICMDataType.UNSIGNED_ZONED)) {
            sb.append(indentStr + "    NON-FRACTION DIGITS = " + this.LAR + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    LAR = " + (this.LAR & 0xFFFF) + LINE_SEPARATOR);
            sb.append(indentStr + "    EXTENDED LAR = " + ((this.LAR & 0xFF0000) >>> 16) + " (TOTAL LAR = " + this.LAR + ")" + LINE_SEPARATOR);
        }
        sb.append(indentStr + "    FRACTION DIGITS = " + this.fractionDigits + LINE_SEPARATOR);
        sb.append(indentStr + "    WHITE SPACE = " + ICM.WHITESPACE_TYPES[this.whiteSpace.getCode()] + LINE_SEPARATOR);
        if (this.nameSpace != null) {
            sb.append(indentStr + "    ELEMENT NAMESPACE " + this.nameSpace.toString(indentStr) + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    ELEMENT NAMESPACE = null" + LINE_SEPARATOR);
        }
        sb.append(indentStr + "    ELEMENT LOCAL NAME " + this.localName.toString(indentStr) + LINE_SEPARATOR);
        sb.append(indentStr + "    XML TEMPLATE LOCATION NAME " + this.getXMLTemplateVariableNameEntry().toString(indentStr) + LINE_SEPARATOR);
        if (this.defaultValue == null) {
            sb.append(indentStr + "    DEFAULT VALUE LENGTH = UNSPECIFIED" + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    DEFAULT VALUE " + this.defaultValue.toString(indentStr) + LINE_SEPARATOR);
        }
        sb.append(indentStr + "    FLAGS BYTES: " + LINE_SEPARATOR);
        sb.append(indentStr + "        WIDE CHARS = " + (this.encodingType == ICM.EncodingType.DBCS) + LINE_SEPARATOR);
        sb.append(indentStr + "        UTF16-BE = " + (this.encodingType == ICM.EncodingType.UTF16BE) + LINE_SEPARATOR);
        sb.append(indentStr + "        JSON MULTI-TYPE ELEMENT = " + this.multiTypedElement + LINE_SEPARATOR);
        sb.append(indentStr + "        SIGN LEADING = " + this.signIsLeading + LINE_SEPARATOR);
        sb.append(indentStr + "        SEPARATE CHAR = " + this.separateChar + LINE_SEPARATOR);
        sb.append(indentStr + "        IS ODO = " + (this.odoTarget != null) + LINE_SEPARATOR);
        sb.append(indentStr + "        NAMED CONTAINER MAPPING = " + this.useNamedContainerMapping + LINE_SEPARATOR);
        sb.append(indentStr + "        CONTAINER MAPPING = " + this.useContainerMapping + LINE_SEPARATOR);
        sb.append(indentStr + "        VARIABLE MAPPING = " + this.useVaryingMapping + LINE_SEPARATOR);
        sb.append(indentStr + "        NULL TERMINATED MAPPING = " + this.useNullTerminatedMapping + LINE_SEPARATOR);
        sb.append(indentStr + "    OFFSET WITHIN STRUCTURE = " + ByteArray.formatNumForDisplay(this.getOffsetIntoStructure()) + LINE_SEPARATOR);
        sb.append(indentStr + "    ABSOLUTE OFFSET WITHIN STRUCTURE = " + ByteArray.formatNumForDisplay(this.getAbsoluteOffsetInStructure()) + LINE_SEPARATOR);
        if (this.containerName != null) {
            sb.append(indentStr + "    CONTAINER NAME = " + this.containerName.toString(indentStr) + LINE_SEPARATOR);
        }
        if (this.odoTarget != null) {
            sb.append(indentStr + "    ODO OLD TARGET = " + this.odoTarget.getODOFieldName() + " (AT ICM OFFSET " + ByteArray.formatNumForDisplay(this.odoTarget.getOffsetIntoICM()) + ")" + LINE_SEPARATOR);
        }
        if (this.getODOTarget() != null) {
            sb.append(indentStr + "    ODO NEW TARGET = " + ByteArray.formatNumForDisplay(this.getODOTarget().getOffsetIntoICM()) + LINE_SEPARATOR);
        }
        sb.append(indentStr + "    (COMMENTS = " + this.comments + ")" + LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(new byte[]{1});
        baos.write(ByteArray.numToByteArray(this.dataType.getCode(), 1));
        baos.write(ByteArray.numToByteArray(this.LAR & 0xFFFF, 2));
        baos.write(ByteArray.numToByteArray(this.fractionDigits, 1));
        baos.write(ByteArray.numToByteArray(this.whiteSpace.getCode(), 1));
        if (this.nameSpace != null) {
            baos.write(ByteArray.numToByteArray(this.nameSpace.getLength(), 2));
        } else {
            baos.write(ByteArray.numToByteArray(0L, 2));
        }
        baos.write(ByteArray.numToByteArray(this.localName.getLength(), 2));
        baos.write((byte)((this.LAR & 0xFF0000) >>> 16));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getLength(), 1));
        if (this.defaultValue != null) {
            baos.write(ByteArray.numToByteArray(this.defaultValue.getLength(), 2));
        } else {
            baos.write(ByteArray.numToByteArray(0L, 2));
        }
        baos.write(ByteArray.numToByteArray(this.flagsByte, 1));
        int containerNameLen = 0;
        if (this.containerName != null) {
            containerNameLen = this.containerName.getLength();
        }
        baos.write(ByteArray.numToByteArray(containerNameLen, 1));
        baos.write(ByteArray.numToByteArray(this.flagsByte2, 1));
        baos.write(ByteArray.numToByteArray(this.getOffsetIntoStructure(), 7));
        if (this.containerName != null) {
            baos.write(ByteArray.numToByteArray(this.containerName.getOffset(), 4));
        } else {
            int fillerValue = -1;
            if (this.nameSpace != null) {
                fillerValue = 0;
            }
            baos.write(ByteArray.numToByteArray(fillerValue, 4));
        }
        if (this.nameSpace != null) {
            baos.write(ByteArray.numToByteArray(this.nameSpace.getOffset(), 4));
        } else {
            baos.write(ByteArray.numToByteArray(-1L, 4));
        }
        if (this.getODOTarget() != null) {
            baos.write(ByteArray.numToByteArray(this.getODOTarget().getOffsetIntoICM(), 4));
        } else {
            baos.write(ByteArray.numToByteArray(0L, 4));
        }
        baos.write(ByteArray.numToByteArray(this.localName.getOffset(), 4));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getOffset(), 8));
        if (this.defaultValue != null) {
            baos.write(ByteArray.numToByteArray(this.defaultValue.getOffset(), 8));
        } else {
            baos.write(ByteArray.numToByteArray(-1L, 8));
        }
        baos.write(ByteArray.numToByteArray(-1L, 8));
        this.setBinaryData(baos.toByteArray());
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    @Deprecated
    public int getDataType() {
        return this.dataType.getCode();
    }

    @Override
    public String getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.defaultValue.getConstant();
    }

    @Override
    public int getLAR() {
        return this.LAR;
    }

    @Override
    public int getTotalDigits() {
        return this.LAR + this.fractionDigits;
    }

    @Override
    public int getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public int getNonFractionDigits() {
        return this.LAR;
    }

    @Override
    public String getLocalName() {
        return this.localName.getConstant();
    }

    @Override
    public String getNameSpace() {
        if (this.nameSpace != null) {
            return this.nameSpace.getConstant();
        }
        return "";
    }

    @Override
    @Deprecated
    public int getWhiteSpace() {
        return this.whiteSpace.getCode();
    }

    @Override
    public boolean getAligned() {
        return this.aligned;
    }

    protected int getOffsetWithinExtendedStructure() {
        return this.offsetWithinExtendedStructure;
    }

    protected void setOffsetWithinExtendedStructure(int offsetWithinExtendedStructure) {
        this.offsetWithinExtendedStructure = offsetWithinExtendedStructure;
    }

    @Override
    @Deprecated
    public int getVariableLengthMappingStrategy() {
        return this.variableLengthMappingStrategy.getCode();
    }

    @Override
    public boolean isSignLeading() {
        return this.signIsLeading;
    }

    @Override
    public boolean isPureDBCS() {
        return this.encodingType == ICM.EncodingType.DBCS;
    }

    @Override
    public boolean isSeparateChar() {
        return this.separateChar;
    }

    @Override
    public boolean isMultiTypedElement() {
        return this.multiTypedElement;
    }

    @Override
    public ByteArray getNamedContainerName() {
        if (this.CACHED_NAME_VALUE == null) {
            try {
                byte[] shortName = this.containerName.getBytes();
                if (shortName.length < 16) {
                    byte[] spacesArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
                    System.arraycopy(shortName, 0, spacesArray, 0, shortName.length);
                    this.CACHED_NAME_VALUE = new ByteArray(spacesArray, true);
                } else {
                    this.CACHED_NAME_VALUE = new ByteArray(shortName, true);
                }
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException();
                re.initCause(e);
                throw re;
            }
        }
        return this.CACHED_NAME_VALUE;
    }

    protected ICMDataElementEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws IOException, ICMException {
        super(ICM.ICMRecord.DATA_ELEMENT_RECORD_TYPE, null, 0, "", false, false, icm);
        int odoTargetOffset;
        this.setType(ICM.ICMRecord.get(ICMContents[offset + 0]));
        if (this.getTypeEnum() != ICM.ICMRecord.DATA_ELEMENT_RECORD_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        this.fractionDigits = ICMContents[offset + 4];
        this.whiteSpace = ICM.WhiteSpace.get(ICMContents[offset + 5]);
        if (this.whiteSpace == null) {
            throw new ICMException("INTERNAL ERROR: Invalid white space type '" + ICMContents[offset + 5] + "' requested.");
        }
        int namespaceLength = ByteArray.byteArrayToInt(ICMContents, offset + 6, 2);
        int namespaceOffset = ByteArray.byteArrayToInt(ICMContents, offset + 28);
        if (namespaceOffset >= 0) {
            String name_Space = ByteArray.byteArrayToString(ICMContents, namespaceOffset, namespaceLength, CodePage, false);
            this.nameSpace = constants.createConstant(name_Space, 32767L);
            this.nameSpace.setOffset(namespaceOffset);
        }
        if ((odoTargetOffset = ByteArray.byteArrayToInt(ICMContents, offset + 32)) > 0) {
            this.setODOTarget((ICMDataElementEntryImpl)icm.getICMEntry(ICMContents, odoTargetOffset, constants, CodePage));
        }
        int localNameLength = ByteArray.byteArrayToInt(ICMContents, offset + 8, 2);
        int localNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 36);
        if (localNameOffset >= 0) {
            String local_Name = ByteArray.byteArrayToString(ICMContents, localNameOffset, localNameLength, CodePage, false);
            this.localName = constants.createConstant(local_Name, 32767L);
            this.localName.setOffset(localNameOffset);
        }
        byte locationNameLength = ICMContents[offset + 11];
        int locationNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 44);
        if (locationNameOffset >= 0) {
            String location_Name = ByteArray.byteArrayToString(ICMContents, locationNameOffset, locationNameLength, CodePage, false);
            this.xmlName = constants.createConstant(location_Name, 255L);
            this.xmlName.setOffset(locationNameOffset);
        }
        int defaultValueLength = ByteArray.byteArrayToInt(ICMContents, offset + 12, 2);
        int defaultValueOffset = ByteArray.byteArrayToInt(ICMContents, offset + 52);
        if (defaultValueOffset >= 0) {
            String default_Value = ByteArray.byteArrayToString(ICMContents, defaultValueOffset, defaultValueLength, CodePage, false);
            this.defaultValue = constants.createConstant(default_Value, 32767L);
            this.defaultValue.setOffset(defaultValueOffset);
        }
        byte contNameLength = ICMContents[offset + 15];
        int contNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 24);
        if (contNameOffset >= 0) {
            String container_Name = ByteArray.byteArrayToString(ICMContents, contNameOffset, contNameLength, CodePage, false);
            this.containerName = constants.createConstant(container_Name, 16L);
            this.containerName.setOffset(contNameOffset);
        }
        this.dataType = ICM.ICMDataType.get(ICMContents[offset + 1]);
        this.flagsByte = ICMContents[offset + 14];
        this.flagsByte2 = ICMContents[offset + 16];
        if (this.dataType == null) {
            throw new ICMException("INTERNAL ERROR: Invalid data type '" + ICMContents[offset + 1] + "' requested.");
        }
        int containerOffset = ByteArray.byteArrayToInt(ICMContents, offset + 20);
        this.setOffsetIntoStructure(containerOffset);
        byte highByteOfLAR = ICMContents[offset + 10];
        int lowByteOfLAR = ByteArray.byteArrayToInt(ICMContents, offset + 2, 2);
        this.LAR = 0;
        this.LAR |= highByteOfLAR << 16 & 0xFF0000;
        this.LAR |= lowByteOfLAR & 0xFFFF;
        if (this.LAR > 0xFFFFFF) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9028E", new Object[]{this.localName, this.LAR, 0xFFFFFF}));
        }
        if (this.LAR == -1) {
            throw new ICMException("INTERNAL ERROR: LAR of '" + this.LAR + "' is invalid.");
        }
        byte tempFlags = this.flagsByte;
        byte tempFlags2 = this.flagsByte2;
        this.encodingType = (tempFlags & 0x80) != 0 ? ICM.EncodingType.DBCS : ((tempFlags2 & 0x80) != 0 ? ICM.EncodingType.UTF16BE : ICM.EncodingType.SBCS);
        if ((tempFlags2 & 0x40) != 0) {
            this.multiTypedElement = true;
        }
        if ((tempFlags & 1) != 0) {
            this.variableLengthMappingStrategy = ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY;
            this.useContainerMapping = false;
            this.useNullTerminatedMapping = true;
            this.useVaryingMapping = false;
            this.useNamedContainerMapping = false;
        } else if ((tempFlags & 2) != 0) {
            this.variableLengthMappingStrategy = ICM.VaryingLength.VARYING_ARRAY;
            this.useContainerMapping = false;
            this.useNullTerminatedMapping = false;
            this.useVaryingMapping = true;
            this.useNamedContainerMapping = false;
        } else if ((tempFlags & 4) != 0) {
            this.variableLengthMappingStrategy = ICM.VaryingLength.VARYING_CONTAINER;
            this.useContainerMapping = true;
            this.useNullTerminatedMapping = false;
            this.useVaryingMapping = false;
            this.useNamedContainerMapping = false;
        } else if ((tempFlags & 8) != 0) {
            this.variableLengthMappingStrategy = ICM.VaryingLength.VARYING_NAMED_CONTAINER;
            this.useContainerMapping = false;
            this.useNullTerminatedMapping = false;
            this.useVaryingMapping = false;
            this.useNamedContainerMapping = true;
        } else {
            this.variableLengthMappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
            this.useContainerMapping = false;
            this.useNullTerminatedMapping = false;
            this.useVaryingMapping = false;
            this.useNamedContainerMapping = false;
        }
        if (!(this.variableLengthMappingStrategy.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY) || this.variableLengthMappingStrategy.getCode() >= 0 && this.variableLengthMappingStrategy.getCode() <= 4)) {
            throw new ICMException("INTERNAL ERROR: Invalid variable length mapping strategy '" + (Object)((Object)this.variableLengthMappingStrategy) + "' requested.");
        }
        if ((tempFlags & 0x40) != 0) {
            this.signIsLeading = true;
        }
        if ((tempFlags & 0x20) != 0) {
            this.separateChar = true;
        }
        this.buildByteArray();
    }

    @Override
    public ICM.WhiteSpace getWhiteSpaceEnum() {
        return this.whiteSpace;
    }

    @Override
    public ICM.VaryingLength getVariableLengthMappingStrategyEnum() {
        return this.variableLengthMappingStrategy;
    }

    @Override
    public ICM.ICMDataType getDataTypeEnum() {
        return this.dataType;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public Object[] getTraceParameters() {
        if (this.traceParms != null) {
            return this.traceParms;
        }
        this.traceParms = new Object[]{"Name: " + this.getLocalName(), "Type: " + (Object)((Object)this.getDataTypeEnum()), "LAR: " + Integer.valueOf(this.getLAR()), "Offset: " + Long.valueOf(this.getOffsetIntoStructure()), "TotalDigits: " + Integer.valueOf(this.getTotalDigits()), "FractionDigits: " + Integer.valueOf(this.getFractionDigits()), "WhiteSpace: " + (Object)((Object)this.getWhiteSpaceEnum()), "Pure DBCS: " + Boolean.valueOf(this.isPureDBCS()), "Separate Char: " + Boolean.valueOf(this.isSeparateChar()), "Sign Leading: " + Boolean.valueOf(this.isSignLeading()), "Varying: " + (Object)((Object)this.getVariableLengthMappingStrategyEnum()), "Min Length: " + this.minLength, "ODO target: " + (this.getODOTarget() == null ? "N/A" : Long.valueOf(this.getODOTarget().getOffsetIntoICM())), "UTF-16BE: " + (this.encodingType == ICM.EncodingType.UTF16BE)};
        return this.traceParms;
    }

    @Override
    public ICM.EncodingType getEncodingType() {
        return this.encodingType;
    }
}

