/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMEndChoiceGroupEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

class ICMEndChoiceGroupEntryImpl
extends ICMEntryImpl
implements ICMEndChoiceGroupEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_END_CHOICE_GROUP_RECORD = 24;
    private static final byte[] binaryType = new byte[]{12};
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ATTRIBUTES_NUMBER = 1;
    private static final int OFFSET_OF_ATTRIBUTES_NUMBER = 1;
    private static final int LENGTH_OF_ICMENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ICMENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int LENGTH_OF_NEXT_ATTRIBUTE_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ATTRIBUTE_OFFSET = 8;
    private static final int LENGTH_OF_ENTRY_END = 4;
    private static final int OFFSET_OF_ENTRY_END = 12;
    private static final int LENGTH_OF_ENTRY_END_PADDING = 8;
    private static final int OFFSET_OF_ENTRY_END_PADDING = 16;
    private static final int LENGTH_OF_TYPE12_ICMENTRY = 24;

    protected ICMEndChoiceGroupEntryImpl(ICMConstantsSectionHolder cse, int mappingLevel, ICM icm) throws ICMException {
        super(ICM.ICMRecord.END_CHOICE_GROUP_ENTRY_TYPE, cse, mappingLevel, null, false, false, icm);
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 12, 24, null);
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 24, null);
        this.setBinaryData(baos.toByteArray());
    }

    protected ICMEndChoiceGroupEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.END_CHOICE_GROUP_ENTRY_TYPE, null, 0, "", false, false, icm);
        this.setType(ICM.ICMRecord.get(ICMContents[offset + 0]));
        if (this.getTypeEnum() != ICM.ICMRecord.END_CHOICE_GROUP_ENTRY_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset > 0) {
            this.setLogicalNextOffset(nextICMEntryOffset);
        }
        this.buildByteArray();
    }
}

