/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMEndDataSectionEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import java.io.IOException;
import java.nio.charset.Charset;

class ICMEndDataSectionEntryImpl
extends ICMEntryImpl
implements ICMEndDataSectionEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    protected ICMEndDataSectionEntryImpl(ICMConstantsSectionHolder csh, int mappingLevel, ICM icm) throws ICMException {
        super(ICM.ICMRecord.END_DATA_SECTION_TYPE, csh, mappingLevel, null, false, false, icm);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR + "  End Data Section (Offset within ICM = " + ByteArray.formatNumForDisplay(this.getOffsetIntoICM()) + ")" + LINE_SEPARATOR);
        sb.append("    RECORD TYPE = " + this.getTypeEnum().getCode() + LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        this.setBinaryData(new byte[]{5, 0, 0, 0, 0, 0, 0, 0});
    }

    protected ICMEndDataSectionEntryImpl(byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage, ICM icm) throws ICMException, IOException {
        super(ICM.ICMRecord.END_DATA_SECTION_TYPE, null, 0, "", false, false, icm);
        this.setType(ICM.ICMRecord.get(ICMContents[offset]));
        if (this.getTypeEnum() != ICM.ICMRecord.END_DATA_SECTION_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        this.buildByteArray();
    }
}

