/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMAttributeEntry;
import com.ibm.cics.schema.ICMChoiceGroupEntry;
import com.ibm.cics.schema.ICMEndEntry;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMIndexEntry;
import com.ibm.cics.schema.ICMVariableRepeatEntry;
import com.ibm.cics.schema.impl.ICMAttributeEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMContentHolder;
import com.ibm.cics.schema.impl.ICMDataElementEntryImpl;
import com.ibm.cics.schema.impl.ICMIndexEntryImpl;
import com.ibm.cics.schema.impl.ICMSlackBytesElementEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

public abstract class ICMEntryImpl
implements ICMEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ICMIndexEntryImpl indexEntry = null;
    private boolean odoTargetClone = false;
    private long offsetIntoStructure = -1L;
    protected static final int ICM_OFFSET_INTO_STRUCTURE_LENGTH = 4;
    private static final int ICM_EXTENDED_TYPE_LENGTH = 1;
    private static final int ICM_NUM_ATTRIBUTES_LENGTH = 1;
    static final int ICM_RECORD_LENGTH_LENGTH = 2;
    static final int ICM_OFFSET_OF_NEXT_LENGTH = 4;
    private static final int ICM_OFFSET_OF_ATTR_LENGTH = 4;
    private static final int ICM_OFFSET_OF_END_REPEAT_LENGTH = 4;
    private static final int ICM_EXPANSION_SPACE_LENGTH = 8;
    protected static final int ICM_EXTENDED_ENTRY_PREFIX_LENGTH = 24;
    private long offsetIntoICM = -1L;
    protected ICMConstantsSectionEntry xmlName = null;
    protected static final int ICM_XML_LOCATION_LENGTH_LENGTH = 1;
    protected static final int ICM_XML_LOCATION_OFFSET_LENGTH = 8;
    protected static final int ICM_XML_LOCATION_MAX_LENGTH = 255;
    private ICM.ICMRecord type = null;
    private byte[] binaryData = null;
    private ICMConstantsSectionHolder csh = null;
    private ICMEntry logicalNextEntry = null;
    private int logicalNextEntryOffset = -1;
    private boolean hidden = false;
    private List<ICMAttributeEntry> allAttributes = null;
    private String simplifiedXPath = null;
    private ICMEntryImpl parent = null;
    private boolean isSlackBytes = false;
    private String jsonKeyword;
    private ICMDataElementEntryImpl odoTargetField = null;
    protected int minLength = -1;
    private ICM theICM = null;
    protected ICMSlackBytesElementEntryImpl odoTarget = null;

    protected ICMEntryImpl(ICM.ICMRecord type, ICMConstantsSectionHolder csh, int mappingLevel, String simplifiedXPath, boolean slackBytes, boolean odoTargetClone, ICM icm) throws ICMException {
        this.setType(type);
        this.csh = csh;
        this.simplifiedXPath = simplifiedXPath;
        this.jsonKeyword = ICMContentHolder.convertSimplifiedXPath2JsonKeyword(simplifiedXPath);
        this.isSlackBytes = slackBytes;
        this.odoTargetClone = odoTargetClone;
        this.theICM = icm;
    }

    protected void setParent(ICMEntryImpl parent) {
        this.parent = parent;
    }

    protected long getAbsoluteOffsetInStructure() {
        if (this.isODOTargetClone()) {
            return this.getOffsetIntoStructure();
        }
        if (this.parent != null && !(this.parent instanceof ICMVariableRepeatEntry) && !(this.parent instanceof ICMChoiceGroupEntry)) {
            return this.parent.getAbsoluteOffsetInStructure() + this.getOffsetIntoStructure();
        }
        return this.getOffsetIntoStructure();
    }

    protected void setIndexEntry(ICMIndexEntry indexEntry) {
        this.indexEntry = (ICMIndexEntryImpl)indexEntry;
    }

    @Override
    public ICMIndexEntry getIndexEntry() {
        return this.indexEntry;
    }

    @Override
    public long getOffsetIntoStructure() {
        return this.offsetIntoStructure;
    }

    protected void setOffsetIntoStructure(long l) throws ICMException {
        this.offsetIntoStructure = l;
        if (l == -1L) {
            throw new ICMException("INTERNAL ERROR: Offset of '" + l + "' is not acceptable.");
        }
    }

    @Override
    public long getOffsetIntoICM() {
        return this.offsetIntoICM;
    }

    @Override
    public String getXMLTemplateVariableName() {
        return this.xmlName.getConstant();
    }

    public ICMConstantsSectionEntry getXMLTemplateVariableNameEntry() {
        return this.xmlName;
    }

    protected void setOffsetIntoICM(long l) {
        this.offsetIntoICM = l;
    }

    protected void setXMLTemplateVariableName(String name) throws ICMException {
        this.xmlName = this.csh.createConstant(name, 255L);
    }

    @Override
    @Deprecated
    public int getType() {
        return this.type.getCode();
    }

    @Override
    public ICM.ICMRecord getTypeEnum() {
        return this.type;
    }

    protected void setType(ICM.ICMRecord type) {
        this.type = type;
    }

    protected abstract void buildByteArray() throws IOException, ICMException;

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    protected void setBinaryData(byte[] bs) {
        this.binaryData = bs;
    }

    @Override
    public ICMEntry getLogicalNextEntry() {
        return this.logicalNextEntry;
    }

    protected void setLogicalNextEntry(ICMEntry logicalNextEntry) {
        this.logicalNextEntry = logicalNextEntry;
    }

    protected void setLogicalNextOffset(int offset) {
        this.logicalNextEntryOffset = offset;
    }

    protected int getLogicalNextOffset() {
        return this.logicalNextEntryOffset;
    }

    protected boolean isHidden() {
        return this.hidden;
    }

    protected void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    protected void addAttribute(ICMAttributeEntryImpl attr) {
        if (this.allAttributes == null) {
            this.allAttributes = new LinkedList<ICMAttributeEntry>();
        }
        this.allAttributes.add(attr);
    }

    @Override
    public List<ICMAttributeEntry> getAttributes() {
        return this.allAttributes;
    }

    protected void extendedEntryPrefixToString(StringBuilder sb, int dataType, int recordLength, ICMEndEntry endRepeat) {
        sb.append(LINE_SEPARATOR + "  " + ICM.RECORD_TYPES[dataType] + " (Offset within ICM = " + ByteArray.formatNumForDisplay(this.getOffsetIntoICM()) + ")" + LINE_SEPARATOR);
        sb.append("    RECORD TYPE = " + dataType + LINE_SEPARATOR);
        int size = 0;
        if (this.getAttributes() != null) {
            size = this.getAttributes().size();
        }
        sb.append("    NUM ATTRIBUTES = " + size + LINE_SEPARATOR);
        sb.append("    RECORD LENGTH = " + recordLength + LINE_SEPARATOR);
        if (this.getLogicalNextEntry() != null) {
            sb.append("    OFFSET OF NEXT LOGICAL ENTRY = " + ByteArray.formatNumForDisplay(this.getLogicalNextEntry().getOffsetIntoICM()) + LINE_SEPARATOR);
        } else {
            sb.append("    OFFSET OF NEXT LOGICAL ENTRY = " + ByteArray.formatNumForDisplay(-1L) + LINE_SEPARATOR);
        }
        ICMAttributeEntryImpl firstAttr = this.getNextAttributeInChain();
        if (firstAttr == null) {
            sb.append("    OFFSET OF FIRST/NEXT ATTRIBUTE = " + ByteArray.formatNumForDisplay(-1L) + LINE_SEPARATOR);
        } else {
            sb.append("    OFFSET OF FIRST/NEXT ATTRIBUTE = " + ByteArray.formatNumForDisplay(firstAttr.getOffsetIntoICM()) + LINE_SEPARATOR);
        }
        if (endRepeat != null) {
            sb.append("    OFFSET OF END REPEAT ENTRY = " + ByteArray.formatNumForDisplay(endRepeat.getOffsetIntoICM()) + LINE_SEPARATOR);
        } else {
            sb.append("    OFFSET OF END REPEAT ENTRY = " + ByteArray.formatNumForDisplay(-1L) + LINE_SEPARATOR);
        }
        sb.append("    SHARED EXPANSION SPACE LENGTH = 8" + LINE_SEPARATOR);
    }

    protected void buildExtendedByteArrayHeader(OutputStream os, byte[] dataType, int recordLength, ICMEndEntry endRepeat) throws IOException {
        os.write(dataType);
        int size = 0;
        if (this.getAttributes() != null) {
            size = this.getAttributes().size();
        }
        os.write(ByteArray.numToByteArray(size, 1));
        os.write(ByteArray.numToByteArray(recordLength, 2));
        if (this.getLogicalNextEntry() != null) {
            os.write(ByteArray.numToByteArray(this.getLogicalNextEntry().getOffsetIntoICM(), 4));
        } else {
            os.write(ByteArray.numToByteArray(-1L, 4));
        }
        ICMAttributeEntryImpl firstAttr = this.getNextAttributeInChain();
        if (firstAttr == null) {
            os.write(ByteArray.numToByteArray(-1L, 4));
        } else {
            os.write(ByteArray.numToByteArray(firstAttr.getOffsetIntoICM(), 4));
        }
        if (endRepeat != null) {
            os.write(ByteArray.numToByteArray(endRepeat.getOffsetIntoICM(), 4));
        } else {
            os.write(ByteArray.numToByteArray(-1L, 4));
        }
        os.write(ByteArray.numToByteArray(0L, 8));
    }

    protected ICMAttributeEntryImpl getNextAttributeInChain() {
        if (this.allAttributes != null && this.allAttributes.size() > 0) {
            return (ICMAttributeEntryImpl)this.allAttributes.get(0);
        }
        return null;
    }

    @Override
    public String getSimplifiedXPath() {
        return this.simplifiedXPath;
    }

    @Override
    public Object getJsonKeyword() {
        return this.jsonKeyword;
    }

    protected void setSimplifiedXPath(String xpath) {
        this.simplifiedXPath = xpath;
    }

    protected void setSlackBytes() {
        this.isSlackBytes = true;
    }

    protected boolean isSlackBytes() {
        return this.isSlackBytes;
    }

    protected boolean isODOTargetClone() {
        return this.odoTargetClone;
    }

    protected void setODOTarget(ICMDataElementEntryImpl odoTarget) {
        this.odoTargetField = odoTarget;
    }

    @Override
    public ICMDataElementEntryImpl getODOTarget() {
        return this.odoTargetField;
    }

    @Override
    public ICM getICM() {
        return this.theICM;
    }
}

