/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMExtendedDataElementEntry;
import com.ibm.cics.schema.impl.ICMAttributeEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMDataElementEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.impl.ICMSlackBytesElementEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

public class ICMExtendedDataElementEntryImpl
extends ICMDataElementEntryImpl
implements ICMExtendedDataElementEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_BUFFER = 0;
    private static final int ICM_LENGTH_OF_EXT_DATA_ELEMENT_RECORD = 88;
    private static final byte[] binaryType = new byte[]{6};
    private static final int LENGTH_OF_NUM_ATTRIBUTES = 1;
    private static final int OFFSET_OF_NUM_ATTRIBUTES = 1;
    private static final int LENGTH_OF_ENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICM_ENTRY = 4;
    private static final int OFFSET_OF_NEXT_ICM_ENTRY = 4;
    private static final int LENGTH_OF_FIRST_ATTRIBUTE_OFFSET = 4;
    private static final int OFFSET_OF_FIRST_ATTRIBUTE_OFFSET = 8;
    private static final int LENGTH_OF_END_REPEAT = 4;
    private static final int OFFSET_OF_END_REPEAT = 12;
    private static final int LENGTH_OF_PADDING = 8;
    private static final int OFFSET_OF_PADDING = 16;
    private static final int LENGTH_OF_TYPE6_ICMENTRY_PREFIX = 24;

    public ICMExtendedDataElementEntryImpl(ICM.ICMDataType dataType, int LAR, ICM.WhiteSpace whiteSpace, String localName, String nameSpace, String xmlName, String defaultValue, List<String> comments, ICMConstantsSectionHolder cse, int fractionDigits, boolean aligned, ICM.EncodingType encodingType, ICM.VaryingLength variableMappingStrategy, int mappingLevel, String simplifiedXPath, boolean signIsLeading, boolean separateChar, boolean slackBytes, String containerName, ICMSlackBytesElementEntryImpl odoTarget, boolean odoTargetClone, int minLength, boolean multiTypedElement, ICM icm) throws ICMException {
        super(dataType, LAR, whiteSpace, localName, nameSpace, xmlName, defaultValue, comments, cse, fractionDigits, aligned, encodingType, variableMappingStrategy, mappingLevel, simplifiedXPath, signIsLeading, separateChar, slackBytes, containerName, odoTarget, odoTargetClone, minLength, multiTypedElement, icm);
        if (!MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) && !this.isSlackBytes()) {
            throw new ICMException("INTERNAL ERROR: Extended data types are not supported at mapping level " + ICM.MAPPING_LEVELS[mappingLevel] + ".");
        }
        this.setOffsetWithinExtendedStructure(24);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 6, 88, null);
        sb.append("    EMBEDDED DATA ELEMENT: " + LINE_SEPARATOR);
        sb.append(super.toString(3));
        sb.append("    VARIABLE LENGTH BUFFER SPACE LENGTH = 0" + LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 88, null);
        super.buildByteArray();
        baos.write(this.getBinaryData());
        baos.write(ByteArray.numToByteArray(0L, 0));
        this.setBinaryData(baos.toByteArray());
    }

    public ICMExtendedDataElementEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(icm, ICMContents, offset + 24, length, constants, CodePage);
        int numAttributes;
        this.setType(ICM.ICMRecord.get(ICMContents[offset]));
        this.setOffsetWithinExtendedStructure(24);
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset >= 0) {
            this.setLogicalNextOffset(nextICMEntryOffset);
        }
        if ((numAttributes = ICMContents[offset + 1]) > 0) {
            int firstAttributeOffset = ByteArray.byteArrayToInt(ICMContents, offset + 8);
            ICMAttributeEntryImpl attr = new ICMAttributeEntryImpl(icm, ICMContents, firstAttributeOffset, length, constants, CodePage);
            this.addAttribute(attr);
            for (int i = 1; i < numAttributes; ++i) {
                ICMAttributeEntryImpl attr1 = attr.getNextAttributeInChain();
                if (attr1 == null) {
                    throw new ICMException("Wrong Attribute Number.");
                }
                this.addAttribute(attr1);
                attr = attr1;
            }
        }
        this.buildByteArray();
    }
}

