/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMEndEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMExtendedFixedRepeatEntry;
import com.ibm.cics.schema.impl.ICMAttributeEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMFixedRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.impl.ICMSlackBytesElementEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class ICMExtendedFixedRepeatEntryImpl
extends ICMFixedRepeatEntryImpl
implements ICMExtendedFixedRepeatEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_BUFFER = 0;
    private static final int ICM_LENGTH_OF_EXT_FIXED_REPEAT_RECORD = 80;
    private static final byte[] binaryType = new byte[]{7};
    private static final int LENGTH_OF_NUM_ATTRIBUTES = 1;
    private static final int OFFSET_OF_NUM_ATTRIBUTES = 1;
    private static final int LENGTH_OF_ENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICM_ENTRY = 4;
    private static final int OFFSET_OF_NEXT_ICM_ENTRY = 4;
    private static final int LENGTH_OF_FIRST_ATTRIBUTE_OFFSET = 4;
    private static final int OFFSET_OF_FIRST_ATTRIBUTE_OFFSET = 8;
    private static final int LENGTH_OF_END_REPEAT = 4;
    private static final int OFFSET_OF_END_REPEAT = 12;
    private static final int LENGTH_OF_PADDING = 8;
    private static final int OFFSET_OF_PADDING = 16;
    private static final int LENGTH_OF_TYPE7_ICMENTRY_PREFIX = 24;

    protected ICMExtendedFixedRepeatEntryImpl(int occurances, ICMConstantsSectionHolder csh, boolean mixedContent, int mappingLevel, String simplifiedXPath, boolean slackBytes, boolean inLineVariablyRepeating, int minInLineOccurs, int maxInLineOccurs, int thisChoiceNumber, int totalChoices, boolean optionalModelGroup, long offsetOfCountField, ICMSlackBytesElementEntryImpl odoTarget, ICM icm, boolean truncatableArray, String truncatableValues, boolean optionalArray, boolean innerArray, boolean multiTypedElement) throws ICMException {
        super(occurances, csh, mixedContent, mappingLevel, simplifiedXPath, slackBytes, inLineVariablyRepeating, minInLineOccurs, maxInLineOccurs, thisChoiceNumber, totalChoices, optionalModelGroup, offsetOfCountField, odoTarget, icm, truncatableArray, truncatableValues, optionalArray, innerArray, multiTypedElement);
        if (!MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) && !this.isSlackBytes()) {
            throw new ICMException("INTERNAL ERROR: Extended data types are not supported at mapping level " + ICM.MAPPING_LEVELS[mappingLevel] + ".");
        }
        this.setOffsetWithinExtendedStructure(24);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 7, 80, this.getEndEntry());
        sb.append("    EMBEDDED FIXED REPEAT: " + LINE_SEPARATOR);
        sb.append(super.toString(3));
        sb.append("    VARIABLE LENGTH BUFFER SPACE LENGTH = 0" + LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException, ICMException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 80, this.getEndEntry());
        super.buildByteArray();
        baos.write(this.getBinaryData());
        baos.write(ByteArray.numToByteArray(0L, 0));
        this.setBinaryData(baos.toByteArray());
    }

    protected ICMExtendedFixedRepeatEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(icm, ICMContents, offset + 24, length, constants, CodePage);
        this.setType(ICM.ICMRecord.get(ICMContents[offset]));
        this.setOffsetWithinExtendedStructure(24);
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        this.setLogicalNextOffset(nextICMEntryOffset);
        int numAttributes = ICMContents[offset + 1];
        if (numAttributes > 0) {
            int firstAttributeOffset = ByteArray.byteArrayToInt(ICMContents, offset + 8);
            ICMAttributeEntryImpl attr = new ICMAttributeEntryImpl(icm, ICMContents, firstAttributeOffset, length, constants, CodePage);
            this.addAttribute(attr);
            for (int i = 1; i < numAttributes; ++i) {
                ICMAttributeEntryImpl attr1 = attr.getNextAttributeInChain();
                if (attr1 == null) {
                    throw new ICMException("Wrong Attribute Number.");
                }
                this.addAttribute(attr1);
                attr = attr1;
            }
        }
        int endRepeatOffset = ByteArray.byteArrayToInt(ICMContents, offset + 12);
        this.endEntry = (ICMEndEntry)((Object)icm.getICMEntry(ICMContents, endRepeatOffset, constants, CodePage));
        this.buildByteArray();
    }
}

