/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMDataElementEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.impl.ICMRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMSlackBytesElementEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

class ICMFixedRepeatEntryImpl
extends ICMRepeatEntryImpl
implements ICMFixedRepeatEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private int numberOfOccurances = -1;
    private static final int ICM_NUMBER_OCCURANCES_LENGTH = 2;
    protected static final int ICM_LENGTH_OF_FIXED_REPEAT_RECORD = 56;
    private int offsetWithinExtendedStructure = 0;
    private static final int LENGTH_OF_CONTENT_DESC = 1;
    private static final int OFFSET_OF_CONTENT_DESC = 1;
    private static final int LENGTH_OF_CONTENT_COUNT = 2;
    private static final int OFFSET_OF_CONTENT_COUNT = 2;
    private static final int LENGTH_OF_MIN_OCCURS = 2;
    private static final int OFFSET_OF_MIN_OCCURS = 4;
    private static final int LENGTH_OF_LOCATION_NAME_LENGTH = 1;
    private static final int OFFSET_OF_LOCATION_NAME_LENGTH = 6;
    private static final int LENGTH_OF_STRUCT_NAME_LENGTH = 1;
    private static final int OFFSET_OF_STRUCT_NAME_LENGTH = 7;
    private static final int LENGTH_OF_VAR_COUNT_OFFSET = 4;
    private static final int OFFSET_OF_VAR_COUNT_OFFSET = 8;
    private static final int LENGTH_OF_CONTENT_LENGTH = 4;
    private static final int OFFSET_OF_CONTENT_LENGTH = 12;
    private static final int LENGTH_OF_FLAGS = 1;
    private static final int OFFSET_OF_FLAGS = 16;
    private static final int LENGTH_OF_FLAGS2 = 1;
    private static final int OFFSET_OF_FLAGS2 = 17;
    private static final int LENGTH_OF_CONTAINER_PADDING = 2;
    private static final int OFFSET_OF_CONTAINER_PADDING = 18;
    private static final int LENGTH_OF_CONTAINER = 4;
    private static final int OFFSET_OF_CONTAINER = 20;
    private static final int LENGTH_OF_LOCATION_NAME_PADDING = 4;
    private static final int OFFSET_OF_LOCATION_NAME_PADDING = 24;
    private static final int LENGTH_OF_LOCATION_NAME = 4;
    private static final int OFFSET_OF_LOCATION_NAME = 28;
    private static final int LENGTH_OF_ODO_TARGET_OFFSET = 4;
    private static final int OFFSET_OF_ODO_TARGET_OFFSET = 32;
    private static final int LENGTH_OF_STRUCT_NAME = 4;
    private static final int OFFSET_OF_STRUCT_NAME = 36;
    private static final int LENGTH_OF_ANY_ICM_ENTRY = 4;
    private static final int OFFSET_OF_ANY_ICM_ENTRY = 40;
    private static final int LENGTH_OF_XML_TEMPLATE_LENGTH = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_LENGTH = 44;
    private static final int LENGTH_OF_XML_TEMPLATE_LENGTH_PADDING = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_LENGTH_PADDING = 48;
    private static final int LENGTH_OF_XML_TEMPLATE = 4;
    private static final int OFFSET_OF_XML_TEMPLATE = 52;
    private static final int LENGTH_OF_TYPE2_ICMENTRY = 56;
    private ICMEntry rawXML = null;

    protected ICMFixedRepeatEntryImpl(int occurances, ICMConstantsSectionHolder csh, boolean mixedContent, int mappingLevel, String simplifiedXPath, boolean slackBytes, boolean inLineVariablyRepeating, int minInLineOccurs, int maxInLineOccurs, int thisChoiceNumber, int totalChoices, boolean optionalModelGroup, long offsetOfCountField, ICMSlackBytesElementEntryImpl odoTarget, ICM icm, boolean truncatableArray, String truncatableValues, boolean optionalArray, boolean innerArray, boolean multiTypedElement) throws ICMException {
        super(ICM.ICMRecord.FIXED_REPEAT_RECORD_TYPE, csh, mappingLevel, simplifiedXPath, slackBytes, icm);
        this.numberOfOccurances = occurances;
        this.setMixedContent(mixedContent);
        this.inLineVariablyRepeating = inLineVariablyRepeating;
        this.maxOccurance = maxInLineOccurs;
        this.minOccurance = minInLineOccurs;
        this.thisChoiceNumber = thisChoiceNumber;
        this.totalChoices = totalChoices;
        this.optionalModelGroup = optionalModelGroup;
        this.offsetOfCountField = offsetOfCountField;
        this.odoTarget = odoTarget;
        this.truncatableArray = truncatableArray;
        if (truncatableValues != null && truncatableValues.indexOf("NULL") > -1) {
            this.isTruncatableNull = true;
        }
        if (truncatableValues != null && truncatableValues.indexOf("SPACE") > -1) {
            this.isTruncatableSpace = true;
        }
        if (truncatableValues != null && truncatableValues.indexOf("ZERO") == 0) {
            this.isTruncatableZero = true;
        }
        if (truncatableValues != null && truncatableValues.indexOf(",ZERO") > 0) {
            this.isTruncatableZero = true;
        }
        if (truncatableValues != null && truncatableValues.indexOf(" ZERO") > 0) {
            this.isTruncatableZero = true;
        }
        if (truncatableValues != null && truncatableValues.indexOf("PACKEDZERO") > -1) {
            this.isTruncatablePackedZero = true;
        }
        this.innerArray = innerArray;
        this.isMultiTypedElement = multiTypedElement;
        this.optionalArray = optionalArray;
        if (!MappingLevelHelper.supportsMappingLevel_2_1(mappingLevel) && this.inLineVariablyRepeating) {
            throw new ICMRuntimeException("Internal Error: illegal use of in-line variably repeating content");
        }
    }

    @Override
    public int getOccurances() {
        return this.numberOfOccurances;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR + indentStr + "  Fixed Repeat (Offset within ICM = " + ByteArray.formatNumForDisplay(this.getOffsetIntoICM() + (long)this.getOffsetWithinExtendedStructure()) + ")" + LINE_SEPARATOR);
        sb.append(indentStr + "    RECORD TYPE = " + this.getTypeEnum().getCode() + LINE_SEPARATOR);
        sb.append(indentStr + "    CONTENT BITS = " + this.getContentByte() + LINE_SEPARATOR);
        sb.append(indentStr + "       STRUCTURAL CONTENT = " + this.isStructural() + LINE_SEPARATOR);
        sb.append(indentStr + "       MIXED CONTENT = " + this.isMixedContent() + LINE_SEPARATOR);
        sb.append(indentStr + "       IN-LINE VARIABLE REPEAT = " + this.isVariablyRepeating() + LINE_SEPARATOR);
        sb.append(indentStr + "       RAW XML CONTENT = " + this.isRawXMLContent() + LINE_SEPARATOR);
        sb.append(indentStr + "       CONTAINS_XSI_TYPE = " + this.containsTypeInfo() + LINE_SEPARATOR);
        sb.append(indentStr + "    OCCURRENCES = " + this.getOccurances() + LINE_SEPARATOR);
        sb.append(indentStr + "    IS ODO = " + (this.odoTarget != null) + LINE_SEPARATOR);
        if (this.odoTarget != null) {
            sb.append(indentStr + "        ODO OLD TARGET = " + this.odoTarget.getODOFieldName() + " (AT ICM OFFSET " + ByteArray.formatNumForDisplay(this.odoTarget.getOffsetIntoICM()) + ")" + LINE_SEPARATOR);
        }
        if (this.getODOTarget() != null) {
            sb.append(indentStr + "        ODO NEW TARGET = " + ByteArray.formatNumForDisplay(this.getODOTarget().getOffsetIntoICM()) + LINE_SEPARATOR);
        }
        sb.append(super.toString(indent));
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException, ICMException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(new byte[]{2});
        baos.write(ByteArray.numToByteArray(this.getContentByte(), 1));
        if (this.getOccurances() > 65535) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9040E", new Object[]{this.getStructureName(), this.getOccurances(), 65535}));
        }
        baos.write(ByteArray.numToByteArray(this.getOccurances(), 2));
        if (this.isVariablyRepeating()) {
            baos.write(ByteArray.numToByteArray(this.getMinOccurance(), 2));
        } else {
            baos.write(new byte[]{0, 0});
        }
        this.formatRepeatsection(baos);
        this.setBinaryData(baos.toByteArray());
    }

    protected int getOffsetWithinExtendedStructure() {
        return this.offsetWithinExtendedStructure;
    }

    protected void setOffsetWithinExtendedStructure(int offsetWithinExtendedStructure) {
        this.offsetWithinExtendedStructure = offsetWithinExtendedStructure;
    }

    @Override
    public boolean isVariablyRepeating() {
        return this.inLineVariablyRepeating;
    }

    @Override
    public boolean isRawXMLContent() {
        return this.rawXMLContent;
    }

    @Override
    public void setRawXMLContent(boolean rawXML) {
        this.rawXMLContent = rawXML;
    }

    public void setRawXMLContent(ICMEntry rawXML) {
        this.setRawXMLContent(true);
        this.rawXML = rawXML;
    }

    @Override
    public void setRawXMLOffset(long offset) {
        this.offsetOfRawXML = offset;
    }

    @Override
    public long getRawXMLOffset() {
        return this.offsetOfRawXML;
    }

    protected ICMFixedRepeatEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.FIXED_REPEAT_RECORD_TYPE, null, 0, "", false, icm);
        byte flags2;
        byte flags;
        int odoTargetOffset;
        this.setType(ICM.ICMRecord.get(ICMContents[offset]));
        byte contentDesc = ICMContents[offset + 1];
        if ((contentDesc & 1) > 0) {
            this.setStructural(true);
        } else {
            this.setStructural(false);
        }
        if ((contentDesc & 2) > 0) {
            this.setMixedContent(true);
        } else {
            this.setMixedContent(false);
        }
        this.inLineVariablyRepeating = (contentDesc & 4) > 0;
        this.rawXMLContent = (contentDesc & 8) > 0;
        this.containsTypeInfo = (contentDesc & 0x10) > 0;
        this.maxOccurance = this.numberOfOccurances = ByteArray.byteArrayToInt(ICMContents, offset + 2, 2);
        this.minOccurance = ByteArray.byteArrayToInt(ICMContents, offset + 4, 2);
        if (this.minOccurance > 0) {
            this.inLineVariablyRepeating = true;
        }
        byte locationNameLength = ICMContents[offset + 6];
        int locationNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 28);
        String loaction_name = ByteArray.byteArrayToString(ICMContents, locationNameOffset, locationNameLength, CodePage, false);
        if (loaction_name.length() > 0) {
            this.xmlName = constants.createConstant(loaction_name, 255L);
            this.xmlName.setOffset(locationNameOffset);
        }
        if ((odoTargetOffset = ByteArray.byteArrayToInt(ICMContents, offset + 32)) > 0) {
            this.setODOTarget((ICMDataElementEntryImpl)icm.getICMEntry(ICMContents, odoTargetOffset, constants, CodePage));
        }
        byte structureNameLength = ICMContents[offset + 7];
        int structureNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 36);
        String structure_name = ByteArray.byteArrayToString(ICMContents, structureNameOffset, structureNameLength, CodePage, false);
        if (structure_name.length() > 0) {
            this.name = constants.createConstant(structure_name, 255L);
            this.name.setOffset(structureNameOffset);
        }
        this.offsetOfCountField = ByteArray.byteArrayToInt(ICMContents, offset + 8);
        this.structureSize = ByteArray.byteArrayToInt(ICMContents, offset + 12);
        this.setOffsetIntoStructure(ByteArray.byteArrayToInt(ICMContents, offset + 20));
        this.offsetOfRawXML = ByteArray.byteArrayToInt(ICMContents, offset + 40);
        if (this.rawXMLContent) {
            this.rawXML = icm.getICMEntry(ICMContents, (int)this.offsetOfRawXML, constants, CodePage);
        }
        int xmlTemplateLength = ByteArray.byteArrayToInt(ICMContents, offset + 44);
        int xmlTemplateOffset = ByteArray.byteArrayToInt(ICMContents, offset + 52);
        String xml_template = ByteArray.byteArrayToString(ICMContents, xmlTemplateOffset, xmlTemplateLength, CodePage, false);
        if (xml_template.length() > 0) {
            this.xmlTemplate = constants.createConstant(xml_template, Long.MAX_VALUE);
            this.xmlTemplate.setOffset(xmlTemplateOffset);
        }
        if (((flags = ICMContents[offset + 16]) & 1) == 1) {
            this.truncatableArray = true;
        }
        if ((flags & 2) == 2) {
            this.isTruncatableNull = true;
        }
        if ((flags & 4) == 4) {
            this.isTruncatableSpace = true;
        }
        if ((flags & 8) == 8) {
            this.isTruncatableZero = true;
        }
        if ((flags & 0x10) == 16) {
            this.optionalArray = true;
        }
        if ((flags & 0x20) == 32) {
            this.innerArray = true;
        }
        if ((flags & 0x40) == 64) {
            this.isTruncatablePackedZero = true;
        }
        if (((flags2 = ICMContents[offset + 17]) & 0x80) == 128) {
            this.isMultiTypedElement = true;
        }
        this.buildByteArray();
    }

    @Override
    public long getCountOffset() {
        return this.offsetOfCountField;
    }

    @Override
    public ICMEntry getRawXMLEntry() {
        return this.rawXML;
    }
}

