/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.gen.api.IWSBindFile;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMAbstractTypeOptionEntry;
import com.ibm.cics.schema.ICMAbstractTypeStartEntry;
import com.ibm.cics.schema.ICMAttributeEntry;
import com.ibm.cics.schema.ICMEndDataSectionEntry;
import com.ibm.cics.schema.ICMEndRepeatEntry;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMIndexEntry;
import com.ibm.cics.schema.ICMInputArrayEndDataType;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureEndDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.ICMLengthException;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.impl.ICMAbstractTypeEndEntryImpl;
import com.ibm.cics.schema.impl.ICMAbstractTypeOptionEntryImpl;
import com.ibm.cics.schema.impl.ICMAbstractTypeStartEntryImpl;
import com.ibm.cics.schema.impl.ICMAttributeEntryImpl;
import com.ibm.cics.schema.impl.ICMChoiceGroupEndEntryImpl;
import com.ibm.cics.schema.impl.ICMChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMContentHolder;
import com.ibm.cics.schema.impl.ICMDataElementEntryImpl;
import com.ibm.cics.schema.impl.ICMEndChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMEndDataSectionEntryImpl;
import com.ibm.cics.schema.impl.ICMEndRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMExtendedDataElementEntryImpl;
import com.ibm.cics.schema.impl.ICMExtendedFixedRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMExtendedVariableRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMFixedRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMIndexEntryImpl;
import com.ibm.cics.schema.impl.ICMRawJSONElementEntryImpl;
import com.ibm.cics.schema.impl.ICMRawXMLElementEntryImpl;
import com.ibm.cics.schema.impl.ICMRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMStartChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMVariableRepeatEntryImpl;
import com.ibm.cics.schema.impl.XMLTemplateEvent;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class ICMImplFromWSBind
implements ICM {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2007, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    protected static final Charset default_CodePage = Charset.forName("Cp037");
    protected static final boolean TRIM = true;
    protected static final boolean NOTRIM = false;
    private static final long NOT_SET = -1L;
    private Map<QName, ICMIndexEntry> topLevelEntries = new HashMap<QName, ICMIndexEntry>();
    private List<ICMEntry> ICMEntryList = null;
    private List<ICMIndexEntryImpl> ICMIndexEntryList = new ArrayList<ICMIndexEntryImpl>(100);
    private ICMIndexEntryImpl[] ICMIndexEntries = null;
    private int currentICMEntryLength = 0;
    private ICMConstantsSectionEntry XMLTemplate = null;
    private List<XMLTemplateEvent> xmlTemplateEvents = null;
    private static final long ICM_XML_TEMPLATE_MAX_VALUE = Long.MAX_VALUE;
    private Charset currentCodePage = default_CodePage;
    private int OFFSET_OF_DATA_SECTION = 0;
    private long ICMLength = -1L;
    private String ICMEyeCatcher = null;
    private long MajorVersionNumber = -1L;
    private long MinorVersionNumber = -1L;
    private String ICMName = null;
    private long StructureSize = -1L;
    private long XMLTemplateOffset = -1L;
    private long XMLTemplateLength = -1L;
    private long flagsOverflow = -1L;
    private String XMLTemplateStr = null;
    private long IndexEntryNumber = -1L;
    private long OptIndexOffset = -1L;
    private long FirstIndexEntryOffset = -1L;
    private byte ICMIndexFlag = 0;
    private IPlatform.EndianType endianTypeOverride = null;
    private IPlatform.ZonedEncodingType zonedEncodingTypeOverride = null;
    private static final int DATA_ELEMENT_RECORD_TYPE_LENGTH = 64;
    private static final int FIXED_REPEAT_RECORD_TYPE_LENGTH = 56;
    private static final int VARIABLE_REPEAT_RECORD_TYPE_LENGTH = 56;
    private static final int END_REPEAT_RECORD_TYPE_LENGTH = 8;
    private static final int END_DATA_SECTION_TYPE_LENGTH = 8;
    private static final int EXTENDED_DATA_ELEMENT_RECORD_TYPE_LENGTH = 88;
    private static final int EXTENDED_FIXED_REPEAT_RECORD_LENGTH = 80;
    private static final int EXTENDED_VARIABLE_REPEAT_RECORD_LENGTH = 80;
    private static final int ATTRIBUTE_RECORD_TYPE_LENGTH = 40;
    private static final int RAW_XML_RECORD_TYPE_LENGTH = 48;
    private static final int START_CHOICE_GROUP_ENTRY_TYPE_LENGTH = 40;
    private static final int END_CHOICE_GROUP_ENTRY_TYPE_LENGTH = 24;
    private static final int CHOICE_GROUP_ENTRY_START_TYPE_LENGTH = 88;
    private static final int CHOICE_GROUP_ENTRY_END_TYPE_LENGTH = 24;
    private static final int ABSTRACT_TYPE_START_TYPE_LENGTH = 48;
    private static final int ABSTRACT_TYPE_END_TYPE_LENGTH = 24;
    private static final int ABSTRACT_TYPE_OPTION_TYPE_LENGTH = 40;
    private static final int RAW_JSON_RECORD_TYPE_LENGTH = 48;
    private static final int[] TYPE_LENGTH = new int[]{64, 56, 56, 8, 8, 88, 80, 80, 40, 48, 40, 24, 88, 24, 48, 24, 40, 48};
    private ICMConstantsSectionHolder constants = new ICMConstantsSectionHolder();
    private boolean useNamespaces;
    private ErrorToleration et;
    private Map<Integer, ICMEntry> ICMEntriesByOffset = new HashMap<Integer, ICMEntry>();
    private Map<Integer, ICMIndexEntryImpl> ICMIndexEntryMap = new HashMap<Integer, ICMIndexEntryImpl>();

    public ICMConstantsSectionHolder getConstants() {
        return this.constants;
    }

    public String getICMEyeCatcher() {
        return this.ICMEyeCatcher;
    }

    public long getMajorVersionNumber() {
        return this.MajorVersionNumber;
    }

    public long getMinorVersionNumber() {
        return this.MinorVersionNumber;
    }

    public IWSBindFile.MappingLevel getICMFormatVersionNumber() {
        if (this.MajorVersionNumber != 0L) {
            return null;
        }
        int intMappingLevel = (int)this.MajorVersionNumber;
        switch (intMappingLevel) {
            case 1: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_1_0;
            }
            case 2: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_1_1;
            }
            case 3: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_1_2;
            }
            case 4: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_2_0;
            }
            case 5: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_2_1;
            }
            case 6: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_2_2;
            }
            case 7: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_3_0;
            }
            case 8: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_0;
            }
            case 9: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_1;
            }
            case 10: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_2;
            }
            case 11: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_3;
            }
            case 12: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_4;
            }
            case 13: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_5_0;
            }
        }
        return null;
    }

    public String getICMName() {
        return this.ICMName;
    }

    public long getStructureSize() {
        return this.StructureSize;
    }

    public long getXMLTemplateOffset() {
        return this.XMLTemplateOffset;
    }

    private long getFlagsOverflow() {
        return this.flagsOverflow;
    }

    public boolean isTopDownJSON() {
        return (this.getFlagsOverflow() & 1L) == 1L;
    }

    @Override
    public IPlatform.EndianType getEndianType() {
        if (this.endianTypeOverride != null) {
            return this.endianTypeOverride;
        }
        if ((this.getFlagsOverflow() & 2L) == 2L) {
            return IPlatform.EndianType.LITTLE_ENDIAN;
        }
        return IPlatform.EndianType.BIG_ENDIAN;
    }

    public void setEndianType(IPlatform.EndianType endianness) {
        this.endianTypeOverride = endianness;
    }

    @Override
    public IPlatform.ZonedEncodingType getZonedEncodingType() {
        if (this.zonedEncodingTypeOverride != null) {
            return this.zonedEncodingTypeOverride;
        }
        if ((this.getFlagsOverflow() & 4L) == 4L) {
            return IPlatform.ZonedEncodingType.ZONED_ASCII;
        }
        return IPlatform.ZonedEncodingType.ZONED_EBCDIC;
    }

    public boolean defaultsSet() {
        return (this.getFlagsOverflow() & 0x20L) == 32L;
    }

    public void setZonedEncodingType(IPlatform.ZonedEncodingType zoned) {
        this.zonedEncodingTypeOverride = zoned;
    }

    public long getXMLTemplateLength() {
        return this.XMLTemplateLength;
    }

    public String getXMLTemplate() {
        return this.XMLTemplateStr;
    }

    public long getDataOffset() {
        return this.OFFSET_OF_DATA_SECTION;
    }

    public long getNumberOfIndexEntries() {
        return this.IndexEntryNumber;
    }

    public long getOptIndexOffset() throws ICMLengthException {
        return this.OptIndexOffset;
    }

    public long getFirstIndexEntryOffset() throws ICMLengthException {
        return this.FirstIndexEntryOffset;
    }

    public boolean isNamespaceSignificance() {
        return (this.ICMIndexFlag & 1) != 0;
    }

    public boolean isAttributeSignificance() {
        return (this.ICMIndexFlag & 2) != 0;
    }

    public boolean isRequestMessage() {
        return (this.ICMIndexFlag & 4) != 0;
    }

    public boolean isResponseMessage() {
        return (this.ICMIndexFlag & 8) != 0;
    }

    public boolean isXOPEligible() {
        return (this.ICMIndexFlag & 0x10) != 0;
    }

    public boolean isOptIndexAvailable() {
        return (this.ICMIndexFlag & 0x20) != 0;
    }

    public boolean isXsiStyle() {
        return (this.ICMIndexFlag & 0x40) != 0;
    }

    public boolean isDataTruncation() {
        return (this.ICMIndexFlag & 0x80) != 0;
    }

    public boolean isDataScreening() {
        return (this.getFlagsOverflow() & 0x10L) == 16L;
    }

    public ErrorToleration getErrorToleration() {
        if (this.et == null) {
            this.et = ErrorToleration.NONE;
            if (this.isDataTruncation()) {
                this.et = ErrorToleration.NULLS;
            }
            if (this.isDataScreening()) {
                this.et = ErrorToleration.ALL;
            }
        }
        return this.et;
    }

    public ICMImplFromWSBind(byte[] WSBindContent, int offset, Charset CodePage, boolean useNamespaces) throws ICMException, IOException {
        ICMEntryImpl current;
        int i;
        ICMEntryImpl current_ICM_Entry;
        if (offset < 0 || offset > WSBindContent.length) {
            throw new RuntimeException("Error detected in the WSBind file; ICM at address " + offset + " is outside the contents of the WSBind file (max len " + WSBindContent.length + ").");
        }
        if (offset + 84 > WSBindContent.length) {
            throw new RuntimeException("Error detected in the WSBind file; ICM at address " + offset + " has a header section which overflows the total WSBind file content (max len " + WSBindContent.length + ").");
        }
        this.useNamespaces = useNamespaces;
        this.ICMLength = ByteArray.byteArrayToInt(WSBindContent, offset + 20);
        if ((long)offset + this.ICMLength > (long)WSBindContent.length) {
            throw new RuntimeException("Error detected in the WSBind file; ICM at address " + offset + " overflows the total WSBind file content (max len " + WSBindContent.length + ").");
        }
        this.currentCodePage = CodePage;
        byte[] currentICMContents = new byte[(int)this.ICMLength];
        System.arraycopy(WSBindContent, offset, currentICMContents, 0, (int)this.ICMLength);
        this.ICMEyeCatcher = ByteArray.byteArrayToString(currentICMContents, 0, 8, default_CodePage, true);
        if (!this.ICMEyeCatcher.equals(">DFHICM<")) {
            throw new RuntimeException("Unrecognised ICM eyecatcher: " + this.ICMEyeCatcher);
        }
        this.MajorVersionNumber = ByteArray.byteArrayToInt(currentICMContents, 8);
        this.MinorVersionNumber = ByteArray.byteArrayToInt(currentICMContents, 12);
        this.ICMName = ByteArray.byteArrayToString(currentICMContents, 24, 32, default_CodePage, true);
        this.StructureSize = ByteArray.byteArrayToInt(currentICMContents, 60);
        this.XMLTemplateOffset = ByteArray.byteArrayToInt(currentICMContents, 68);
        this.XMLTemplateLength = ByteArray.byteArrayToInt(currentICMContents, 76);
        this.flagsOverflow = ByteArray.byteArrayToInt(currentICMContents, 80);
        this.XMLTemplateStr = ByteArray.byteArrayToString(currentICMContents, (int)this.getXMLTemplateOffset(), (int)this.getXMLTemplateLength(), this.currentCodePage, true);
        this.OFFSET_OF_DATA_SECTION = ByteArray.byteArrayToInt(currentICMContents, 84);
        this.IndexEntryNumber = ByteArray.byteArrayToInt(currentICMContents, 88);
        this.OptIndexOffset = ByteArray.byteArrayToInt(currentICMContents, 92, 3);
        this.FirstIndexEntryOffset = ByteArray.byteArrayToInt(currentICMContents, 96, 2);
        this.ICMIndexFlag = currentICMContents[95];
        if (this.ICMLength < (long)this.ICMEyeCatcher.length()) {
            throw new ICMException("ICM content length too short.");
        }
        if (!this.ICMEyeCatcher.equalsIgnoreCase(">DFHICM<")) {
            throw new ICMException("Not a correct ICM.");
        }
        int XML_template_offset = (int)this.XMLTemplateOffset;
        int XML_template_length = (int)this.XMLTemplateLength;
        if (XML_template_offset >= 0) {
            String xml_tempalte = ByteArray.byteArrayToString(WSBindContent, offset + XML_template_offset, XML_template_length, CodePage, false);
            this.XMLTemplate = this.constants.createConstant(xml_tempalte, Long.MAX_VALUE);
            this.XMLTemplate.setOffset(XML_template_offset);
        }
        int offset_currentIndexEntryOffset = -1;
        int currentIndexEntryOffset = -1;
        Integer currentIndexEntryOffsetInteger = null;
        ICMIndexEntryImpl prev = null;
        ICMIndexEntryImpl curr = null;
        int i2 = 0;
        while ((long)i2 < this.getNumberOfIndexEntries()) {
            offset_currentIndexEntryOffset = i2 * 2;
            if (!this.isOptIndexAvailable()) {
                currentIndexEntryOffset = ByteArray.byteArrayToInt(currentICMContents, 96 + offset_currentIndexEntryOffset, 2);
            } else {
                currentIndexEntryOffset = (int)this.getOptIndexOffset() + (i2 + 1) * 16;
                currentIndexEntryOffset += 12;
                currentIndexEntryOffset = ByteArray.byteArrayToInt(currentICMContents, currentIndexEntryOffset);
            }
            prev = curr;
            curr = this.getICMIndexEntry(currentICMContents, currentIndexEntryOffset, this.constants, CodePage);
            if (prev != null) {
                prev.setNextIndexEntry(curr);
            }
            currentIndexEntryOffsetInteger = currentIndexEntryOffset;
            this.ICMIndexEntryMap.get(currentIndexEntryOffsetInteger).setEntryNum(i2 + 1);
            this.ICMIndexEntryList.add(this.ICMIndexEntryMap.get(currentIndexEntryOffsetInteger));
            ++i2;
        }
        if (this.getNumberOfIndexEntries() > 0L && this.isOptIndexAvailable()) {
            block1: for (i2 = 0; i2 < this.ICMIndexEntryList.size() - 1; ++i2) {
                ICMIndexEntryImpl parent = this.ICMIndexEntryList.get(i2);
                int potentialChildPos = i2 + 1;
                ICMIndexEntryImpl potentialChild = this.ICMIndexEntryList.get(potentialChildPos);
                while (parent.getNumOfParts() + 1 >= potentialChild.getNumOfParts()) {
                    if (parent.getNumOfParts() < potentialChild.getNumOfParts() && potentialChild.getXpathForSearchWithNS().startsWith(parent.getXpathForSearchWithNS())) {
                        parent.addChildTag(potentialChild);
                    }
                    if (++potentialChildPos >= this.ICMIndexEntryList.size()) continue block1;
                    potentialChild = this.ICMIndexEntryList.get(potentialChildPos);
                }
            }
        }
        this.ICMEntryList = new ArrayList<ICMEntry>(100);
        ICM.ICMRecord ICMEntryType = null;
        for (int current_ICM_Entry_Offset = this.OFFSET_OF_DATA_SECTION; current_ICM_Entry_Offset < XML_template_offset; current_ICM_Entry_Offset += TYPE_LENGTH[current_ICM_Entry.getTypeEnum().getCode() - 1]) {
            ICMEntryType = ICM.ICMRecord.get(currentICMContents[current_ICM_Entry_Offset]);
            current_ICM_Entry = this.getICMEntry(currentICMContents, current_ICM_Entry_Offset, this.constants, CodePage);
            this.ICMEntryList.add(current_ICM_Entry);
            if (!ICMEntryType.equals((Object)ICM.ICMRecord.END_DATA_SECTION_TYPE)) continue;
            break;
        }
        Iterator<ICMEntry> iterator = this.getContents().iterator();
        while (iterator.hasNext()) {
            ICMEntry current_ICM = iterator.next();
            ICM.ICMRecord type = current_ICM.getTypeEnum();
            if (!type.equals((Object)ICM.ICMRecord.START_CHOICE_GROUP_ENTRY_TYPE)) continue;
            this.processComplexedType(iterator, current_ICM);
        }
        for (ICMEntry entry : this.getContents()) {
            ICMFixedRepeatEntry fr;
            if (!(entry instanceof ICMFixedRepeatEntry) || !(fr = (ICMFixedRepeatEntry)entry).isRawXMLContent()) continue;
            ((ICMEntryImpl)fr.getRawXMLEntry()).setIndexEntry(null);
        }
        int numEntries = this.ICMEntryList.size();
        for (i = 1; i < numEntries; ++i) {
            ICMEntryImpl previous;
            current = (ICMEntryImpl)this.ICMEntryList.get(i);
            if (current.getLogicalNextEntry() == null && current.getLogicalNextOffset() > 0) {
                ICMEntryImpl next = this.getICMEntry(currentICMContents, current.getLogicalNextOffset(), this.constants, CodePage);
                current.setLogicalNextEntry(next);
            }
            if ((previous = (ICMEntryImpl)this.ICMEntryList.get(i - 1)).getLogicalNextEntry() != null || current.getTypeEnum().equals((Object)ICM.ICMRecord.ATTRIBUTE_RECORD_TYPE)) continue;
            previous.setLogicalNextEntry(current);
        }
        for (i = 0; i < numEntries; ++i) {
            current = (ICMEntryImpl)this.ICMEntryList.get(i);
            if (current.getLogicalNextEntry() != null || current instanceof ICMEndDataSectionEntry) continue;
            int next = i + 1;
            while (this.ICMEntryList.get(next) instanceof ICMAttributeEntry) {
                next += 2;
            }
            current.setLogicalNextEntry(this.ICMEntryList.get(next));
        }
        for (ICMEntry entry : this.ICMEntryList) {
            ICMRepeatEntry repeat;
            if (!(entry instanceof ICMRepeatEntry) || (repeat = (ICMRepeatEntry)entry).getEndEntry() != null) continue;
            int nestedStarts = 0;
            ICMEntry next = repeat.getLogicalNextEntry();
            while (!(next instanceof ICMEndRepeatEntry) || nestedStarts > 0) {
                if (next instanceof ICMRepeatEntry) {
                    ++nestedStarts;
                }
                if (next instanceof ICMEndRepeatEntry) {
                    --nestedStarts;
                }
                next = next.getLogicalNextEntry();
            }
            ((ICMRepeatEntryImpl)repeat).setEndEntry((ICMEndRepeatEntry)next);
        }
        for (ICMEntry entry : this.ICMEntryList) {
            if (!(entry instanceof ICMAbstractTypeStartEntry)) continue;
            ICMAbstractTypeStartEntryImpl ats = (ICMAbstractTypeStartEntryImpl)entry;
            ICMEntry next = ats.getLogicalNextEntry();
            while (next instanceof ICMAbstractTypeOptionEntry) {
                ats.addOption((ICMAbstractTypeOptionEntry)next);
                next = next.getLogicalNextEntry();
            }
        }
        this.ICMEntriesByOffset.clear();
        this.ICMIndexEntryMap.clear();
    }

    private void processComplexedType(Iterator<ICMEntry> iterator, ICMEntry current_ICM) throws IOException, ICMException {
        while (iterator.hasNext()) {
            ICMEntry next_ICM = iterator.next();
            ICM.ICMRecord next_ICM_type = next_ICM.getTypeEnum();
            if (next_ICM_type.equals((Object)ICM.ICMRecord.END_CHOICE_GROUP_ENTRY_TYPE)) {
                return;
            }
            if (next_ICM_type.equals((Object)ICM.ICMRecord.CHOICE_GROUP_ENTRY_START_TYPE)) {
                Integer entryStartOffset = ((ICMChoiceGroupEntryImpl)next_ICM).getEntryStartOffset();
                ICMEntry startEntry = this.ICMEntriesByOffset.get(entryStartOffset);
                ((ICMChoiceGroupEntryImpl)next_ICM).setEntry(startEntry);
                ((ICMChoiceGroupEntryImpl)next_ICM).toByteArray();
            }
            if (next_ICM_type.equals((Object)ICM.ICMRecord.CHOICE_GROUP_ENTRY_END_TYPE)) {
                ((ICMChoiceGroupEndEntryImpl)next_ICM).setStartChoiceGroupEntry((ICMStartChoiceGroupEntryImpl)current_ICM);
                ((ICMChoiceGroupEndEntryImpl)next_ICM).toByteArray();
            }
            if (!next_ICM_type.equals((Object)ICM.ICMRecord.START_CHOICE_GROUP_ENTRY_TYPE)) continue;
            this.processComplexedType(iterator, next_ICM);
        }
    }

    public ICMIndexEntryImpl[] getICMIndexEntries() {
        if (this.ICMIndexEntries != null) {
            return this.ICMIndexEntries;
        }
        ICMIndexEntryImpl[] array = new ICMIndexEntryImpl[this.ICMIndexEntryList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.ICMIndexEntryList.get(i);
        }
        this.ICMIndexEntries = array;
        return this.ICMIndexEntries;
    }

    public ICMEntryImpl getICMEntry(byte[] ICMContents, int offset, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        Integer current_offset = offset;
        ICMEntry entry = this.ICMEntriesByOffset.get(current_offset);
        if (entry != null) {
            return (ICMEntryImpl)entry;
        }
        ICM.ICMRecord ICMEntryType = ICM.ICMRecord.get(ICMContents[offset]);
        ICMEntryImpl current_ICM_Entry = null;
        if (ICMEntryType == null) {
            throw new ICMException("INTERNAL ERROR: ICM Entry Type null");
        }
        switch (ICMEntryType) {
            case DATA_ELEMENT_RECORD_TYPE: {
                this.currentICMEntryLength = 64;
                current_ICM_Entry = new ICMDataElementEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case FIXED_REPEAT_RECORD_TYPE: {
                this.currentICMEntryLength = 56;
                current_ICM_Entry = new ICMFixedRepeatEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case VARIABLE_REPEAT_RECORD_TYPE: {
                this.currentICMEntryLength = 56;
                current_ICM_Entry = new ICMVariableRepeatEntryImpl(ICMContents, offset, this.currentICMEntryLength, constants, CodePage, (ICM)this);
                break;
            }
            case END_REPEAT_RECORD_TYPE: {
                this.currentICMEntryLength = 8;
                current_ICM_Entry = new ICMEndRepeatEntryImpl(ICMContents, offset, this.currentICMEntryLength, constants, CodePage, this);
                break;
            }
            case END_DATA_SECTION_TYPE: {
                this.currentICMEntryLength = 8;
                current_ICM_Entry = new ICMEndDataSectionEntryImpl(ICMContents, offset, this.currentICMEntryLength, constants, CodePage, this);
                break;
            }
            case EXTENDED_DATA_ELEMENT_RECORD_TYPE: {
                this.currentICMEntryLength = 88;
                current_ICM_Entry = new ICMExtendedDataElementEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case EXTENDED_FIXED_REPEAT_RECORD: {
                this.currentICMEntryLength = 80;
                current_ICM_Entry = new ICMExtendedFixedRepeatEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case EXTENDED_VARIABLE_REPEAT_RECORD: {
                this.currentICMEntryLength = 80;
                current_ICM_Entry = new ICMExtendedVariableRepeatEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case ATTRIBUTE_RECORD_TYPE: {
                this.currentICMEntryLength = 40;
                current_ICM_Entry = new ICMAttributeEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case RAW_XML_RECORD_TYPE: {
                this.currentICMEntryLength = 48;
                current_ICM_Entry = new ICMRawXMLElementEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage){};
                current_ICM_Entry.buildByteArray();
                break;
            }
            case START_CHOICE_GROUP_ENTRY_TYPE: {
                this.currentICMEntryLength = 40;
                current_ICM_Entry = new ICMStartChoiceGroupEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case END_CHOICE_GROUP_ENTRY_TYPE: {
                this.currentICMEntryLength = 24;
                current_ICM_Entry = new ICMEndChoiceGroupEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case CHOICE_GROUP_ENTRY_START_TYPE: {
                this.currentICMEntryLength = 88;
                current_ICM_Entry = new ICMChoiceGroupEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case CHOICE_GROUP_ENTRY_END_TYPE: {
                this.currentICMEntryLength = 24;
                current_ICM_Entry = new ICMChoiceGroupEndEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case ABSTRACT_TYPE_START_TYPE: {
                this.currentICMEntryLength = 48;
                current_ICM_Entry = new ICMAbstractTypeStartEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case ABSTRACT_TYPE_END_TYPE: {
                this.currentICMEntryLength = 24;
                current_ICM_Entry = new ICMAbstractTypeEndEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case ABSTRACT_TYPE_OPTION_TYPE: {
                this.currentICMEntryLength = 40;
                current_ICM_Entry = new ICMAbstractTypeOptionEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage);
                break;
            }
            case RAW_JSON_RECORD_TYPE: {
                this.currentICMEntryLength = 48;
                current_ICM_Entry = new ICMRawJSONElementEntryImpl(this, ICMContents, offset, this.currentICMEntryLength, constants, CodePage){};
                current_ICM_Entry.buildByteArray();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected Entry: " + (Object)((Object)ICMEntryType));
            }
        }
        this.ICMEntriesByOffset.put(current_offset, current_ICM_Entry);
        current_ICM_Entry.setOffsetIntoICM(offset);
        return current_ICM_Entry;
    }

    public ICMIndexEntryImpl getICMIndexEntry(byte[] currentICMContents, int currentIndexEntryOffset, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        Integer current_entry_offset = currentIndexEntryOffset;
        ICMIndexEntryImpl indexEntry = this.ICMIndexEntryMap.get(current_entry_offset);
        if (indexEntry != null) {
            return indexEntry;
        }
        ICMIndexEntryImpl currentIndexEntry = new ICMIndexEntryImpl(currentICMContents, currentIndexEntryOffset, constants, CodePage, this);
        this.ICMIndexEntryMap.put(current_entry_offset, currentIndexEntry);
        return currentIndexEntry;
    }

    @Override
    public void addDataElementEntry(ICMInputSimpleDataType fieldParameters) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public void addElementDeclaration(String wsdlPartNameSpace, String wsdlPartName, QName targetQName, boolean validate) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public void addEndRepeatEntry(ICMInputArrayEndDataType parms) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public void addFixedRepeatEntry(ICMInputArrayStartDataType parms) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public void addGlobalTypeDefinition(QName targetQName, boolean nillable) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public void addTypeDefinition(String wsdlPartNameSpace, String wsdlPartName, QName targetQName) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public void completedICM() throws ICMException, IOException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public long getCommAreaLength() throws ICMException {
        return this.getStructureSize();
    }

    @Override
    public List<ICMEntry> getContents() throws ICMException {
        return this.ICMEntryList;
    }

    @Override
    public long getICMLength() {
        return this.ICMLength;
    }

    @Override
    public String[] getMessages() {
        return null;
    }

    @Override
    public String getTargetNameSpace() {
        return null;
    }

    @Override
    public String getTopLevelElementLocalName() {
        return null;
    }

    @Override
    public void sendStructEnd(ICMInputStructureEndDataType data) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public void sendStructStart(ICMInputStructureStartDataType data) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    @Override
    public byte[] toByteArray() throws IOException, ICMException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ByteArray.toCodePageByteArray(this.getICMEyeCatcher(), 8, default_CodePage));
        baos.write(ByteArray.numToByteArray(this.getMajorVersionNumber(), 4));
        baos.write(ByteArray.numToByteArray(this.getMinorVersionNumber(), 4));
        baos.write(ByteArray.numToByteArray(this.getICMLength(), 8));
        baos.write(ByteArray.toCodePageByteArray(this.getICMName(), 32, default_CodePage));
        baos.write(ByteArray.numToByteArray(this.getStructureSize(), 8));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateOffset(), 8));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateLength(), 8));
        baos.write(ByteArray.numToByteArray(this.flagsOverflow, 4));
        baos.write(ByteArray.numToByteArray(this.getDataOffset(), 4));
        baos.write(ByteArray.numToByteArray(this.getNumberOfIndexEntries(), 4));
        baos.write(ByteArray.numToByteArray(this.getOptIndexOffset(), 3));
        byte flags = 0;
        if (this.isNamespaceSignificance()) {
            flags = (byte)(flags | 1);
        }
        if (this.isAttributeSignificance()) {
            flags = (byte)(flags | 2);
        }
        if (this.isRequestMessage()) {
            flags = (byte)(flags | 4);
        }
        if (this.isResponseMessage()) {
            flags = (byte)(flags | 8);
        }
        if (this.isXOPEligible()) {
            flags = (byte)(flags | 0x10);
        }
        if (this.isOptIndexAvailable()) {
            flags = (byte)(flags | 0x20);
        }
        if (this.isXsiStyle()) {
            flags = (byte)(flags | 0x40);
        }
        if (this.isDataTruncation()) {
            flags = (byte)(flags | 0x80);
        }
        baos.write(ByteArray.numToByteArray(flags, 1));
        for (ICMIndexEntryImpl entry : this.ICMIndexEntryList) {
            if (entry.getIndexOffset() > 65535L || entry.getIndexOffset() < 0L) {
                baos.write(ByteArray.numToByteArray(-1L, 2));
                continue;
            }
            baos.write(ByteArray.numToByteArray(entry.getIndexOffset(), 2));
        }
        int padding = this.ICMIndexEntryList.size() * 2 % 8;
        if (padding > 0) {
            for (int i = padding; i < 8; ++i) {
                baos.write(new byte[]{0});
            }
        }
        for (ICMIndexEntryImpl entry : this.ICMIndexEntryList) {
            baos.write(entry.toByteArray());
        }
        if (this.isOptIndexAvailable()) {
            int lastTopLevelIndexEntry;
            int firstTopLevelIndexEntry = 1;
            for (lastTopLevelIndexEntry = 0; lastTopLevelIndexEntry < this.ICMIndexEntryList.size() && this.ICMIndexEntryList.get(lastTopLevelIndexEntry).getNumOfParts() == 1; ++lastTopLevelIndexEntry) {
            }
            if (lastTopLevelIndexEntry == 0) {
                firstTopLevelIndexEntry = Short.MAX_VALUE;
            }
            ICMContentHolder.addOptimisedIndexEntry(baos, firstTopLevelIndexEntry, lastTopLevelIndexEntry, 0, -1L);
            for (ICMIndexEntryImpl entry : this.ICMIndexEntryList) {
                int firstChildPos = Short.MAX_VALUE;
                if (entry.getFirstChild() != null) {
                    firstChildPos = entry.getFirstChild().getEntryNum();
                }
                int lastChildPos = 0;
                if (entry.getLastChild() != null) {
                    lastChildPos = entry.getLastChild().getEntryNum();
                }
                ICMContentHolder.addOptimisedIndexEntry(baos, firstChildPos, lastChildPos, entry.getNumOfParts(), entry.getIndexOffset());
            }
        }
        for (ICMEntry entry : this.ICMEntryList) {
            baos.write(((ICMEntryImpl)entry).getBinaryData());
        }
        this.constants.compressConstants();
        byte[] constSecStringArray = this.constants.sortEntry(this.currentCodePage);
        baos.write(constSecStringArray);
        return baos.toByteArray();
    }

    @Override
    public Element toXMLElement() throws ICMException {
        return null;
    }

    @Override
    public void addContainerEntry(ICMInputContainerDataType inputParameters) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid method call.");
    }

    public Map<QName, ICMIndexEntry> getTopLevelIndexEntries() {
        return this.topLevelEntries;
    }

    public List<XMLTemplateEvent> getXMLTemplateEvents(boolean json) {
        if (this.xmlTemplateEvents == null) {
            this.xmlTemplateEvents = XMLTemplateEvent.parseXMLTemplate(this.XMLTemplateStr, json);
        }
        return this.xmlTemplateEvents;
    }

    public boolean useNamespaces() {
        return this.useNamespaces;
    }

    public static enum ErrorToleration {
        NONE,
        NULLS,
        ALL;

    }
}

