/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMInputArrayEndDataType;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureEndDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.ICMLengthException;
import com.ibm.cics.schema.ICMRawJSONElementEntry;
import com.ibm.cics.schema.ICMRawXMLElementEntry;
import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.schema.impl.ICMAbstractTypeOptionEntryImpl;
import com.ibm.cics.schema.impl.ICMAbstractTypeStartEntryImpl;
import com.ibm.cics.schema.impl.ICMAttributeEntryImpl;
import com.ibm.cics.schema.impl.ICMBuilderImpl;
import com.ibm.cics.schema.impl.ICMChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMContentHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMFixedRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMImplToWSDL;
import com.ibm.cics.schema.impl.ICMLevelState;
import com.ibm.cics.schema.impl.ICMRepeatEntryImpl;
import com.ibm.cics.schema.impl.ICMSchemaParsingState;
import com.ibm.cics.schema.impl.ICMSlackBytesElementEntryImpl;
import com.ibm.cics.schema.impl.ICMStartChoiceGroupEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.UniqueNameGenerator;
import com.ibm.cics.wsdl.common.ParmChecker;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.type.XSDAnySimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ICMImplFromWSDL
implements ICM {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String EXCLUSIVE_SUFFIX = "Exclusive";
    private static final String INCLUSIVE_SUFFIX = "Inclusive";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ICMBuilderImpl builder = null;
    private String[] messagesCache;
    private boolean trace = false;
    private PrintStream logger = null;
    private int indent = 1;
    private ICMContentHolder ich = null;
    private ICMLevelState topLevelState = null;
    private String wsdlOperationNameSpace = null;
    private String wsdlOperationName = null;
    private Set<String> allStructures = new TreeSet<String>();
    private boolean complete = false;
    private boolean startingFromWSDL = false;
    private Set<XSDTypeDefinition> allInScopeTypes = new HashSet<XSDTypeDefinition>();
    private StringBuilder seededXPATH = new StringBuilder();
    private static final String SCHEMA4SCHEMA = "http://www.w3.org/2001/XMLSchema";
    protected static final String SCHEMA4XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String WSADDRESSING_SUBMISSION_NS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSADDRESSING_RECOMMENDATION_NS = "http://www.w3.org/2005/08/addressing";
    protected static final String SOAPBODYTAG = "SOAP-ENV:Body";
    private static final String XMIME_NS = "http://www.w3.org/2005/05/xmlmime";
    private static final String XMIME_LOCAL = "contentType";
    private boolean displayTypeNotUsed = false;
    private static final boolean INHERITING_STYLE = true;
    private static final boolean NON_INHERITING_STYLE = false;
    private List<String> warnings = new LinkedList<String>();
    private static final int DEFAULT_LAR_BIN = 0xFFFFFF;
    private byte[] thisICM = null;
    private ICMCreationParameters parms = null;
    private Set<QName> subTypesForAbstractDataType = null;
    private Set<QName> nillableSubTypesForAbstractDataType = null;
    private int maxCharArraySize = 0;
    private Stack<StringBuilder> choiceElementName = new Stack();
    private boolean jsonMessages;
    private static final ElementNameComparator ELEMENT_NAME_COMPARATOR = new ElementNameComparator();
    private static final QNameComparator QNAME_COMPARATOR = new QNameComparator();
    private static final Charset CHARSET_CP037 = Charset.forName("Cp037");
    public static final boolean GLOBAL_TYPE = true;
    public static final boolean NOT_GLOBAL_TYPE = false;
    public static final boolean NILLABLE = true;
    public static final boolean NOT_NILLABLE = false;

    protected ICMImplFromWSDL(ICMBuilderImpl builder, ICMCreationParameters parms, boolean startingFromWSDL, Set<QName> subTypesForAbstractDataType, Set<QName> nillableSubTypesForAbstractDataType) throws ICMException {
        int mappingLevel;
        this.builder = builder;
        this.parms = parms;
        this.wsdlOperationName = parms.getWsdlOperation().getLocalPart();
        this.wsdlOperationNameSpace = parms.getWsdlOperation().getNamespaceURI();
        this.subTypesForAbstractDataType = subTypesForAbstractDataType;
        this.nillableSubTypesForAbstractDataType = nillableSubTypesForAbstractDataType;
        this.trace = builder.isTrace();
        this.logger = builder.getLogger();
        this.startingFromWSDL = startingFromWSDL;
        Properties inputParameters = this.parms.getInputParameters();
        String toolName = inputParameters.getProperty("INTERNAL_TOOLNAME");
        this.jsonMessages = toolName.equals("DFHJS2LS");
        this.maxCharArraySize = ParmChecker.getMaxCharArraySize(inputParameters);
        if (parms.getMessageType().equals((Object)ICM.XMLContentType.SOAP_REQUEST)) {
            parms.setName(parms.getName().concat("(Request)"));
        } else if (parms.getMessageType().equals((Object)ICM.XMLContentType.SOAP_RESPONSE)) {
            parms.setName(parms.getName().concat("(Response)"));
        }
        this.ich = new ICMContentHolder(parms.getName(), parms.getMessageType(), parms.isSoap11(), parms.isDataTruncationSupported(), parms, this);
        this.topLevelState = new ICMLevelState(0L, true, this.trace, this.logger, this.indent, parms.getMappingLevel(), "RANDOMGARBAGE", false, parms);
        ICM.BindingStyle style = parms.getStyle();
        if (style == null) {
            throw new ICMException("INTERNAL ERROR: Style is null");
        }
        if (parms.isGeneratedForWSDL()) {
            this.topLevelState.getTemplate().addStartTag("dummyVal", SOAPBODYTAG, false, null);
        }
        if ((mappingLevel = parms.getMappingLevel()) == 0) {
            mappingLevel = builder.getMappingLevel();
            if (this.logger != null && mappingLevel != 0) {
                this.logger.println(" Mapping Level has changed due to the schema. It is now set to: " + ICM.MAPPING_LEVELS_FOR_DISPLAY[mappingLevel]);
            }
        }
        this.ich.setMappingLevel(mappingLevel);
        if (style.equals((Object)ICM.BindingStyle.RPC_STYLE)) {
            if (parms.getMessageType().equals((Object)ICM.XMLContentType.SOAP_RESPONSE)) {
                this.wsdlOperationName = this.wsdlOperationName + "Response";
            }
            if (this.wsdlOperationName.length() > 255) {
                throw new ICMLengthException(MessageHandler.buildMessage("DFHPI9002E", new Object[]{this.wsdlOperationName}));
            }
            this.topLevelState.getTemplate().addStartTag(this.wsdlOperationNameSpace, this.wsdlOperationName, true, null);
            this.extendXPATH(this.seededXPATH, this.wsdlOperationNameSpace, this.wsdlOperationName);
            this.ich.createDummyIndexEntry(this.seededXPATH.toString());
        }
    }

    @Override
    public void addElementDeclaration(String wsdlPartNameSpace, String wsdlPartName, QName targetQName, boolean validate) throws ICMException {
        if (this.isTrace()) {
            this.getLogger().println("Adding element declaration: " + targetQName.toString());
        }
        if (!this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Illegal call of 'addElementDeclaration'.");
        }
        StringBuilder xpath = new StringBuilder(this.seededXPATH.toString());
        if (this.parms.getStyle().equals((Object)ICM.BindingStyle.RPC_STYLE) && wsdlPartName.length() > 255) {
            throw new ICMLengthException(MessageHandler.buildMessage("DFHPI9003E", new Object[]{wsdlPartName}));
        }
        if (targetQName.getNamespaceURI().equals(SCHEMA4SCHEMA)) {
            this.displayTypeNotUsed = true;
            this.addTypeDefinitionPart2(targetQName.getNamespaceURI(), targetQName.getLocalPart(), targetQName, true, xpath, false, false);
        } else {
            XSDElementDeclaration element = this.builder.resolveElementDeclaration(targetQName);
            XSDFactory xsdFactory = XSDFactory.eINSTANCE;
            XSDParticle particle = xsdFactory.createXSDParticle();
            particle.setMaxOccurs(1);
            particle.setMinOccurs(1);
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(element.getAnnotation(), this.logger);
            String min = p.getProperty("com.ibm.cics.wsdl.properties.minOccurs");
            int minInt = -1;
            if (null != min) {
                minInt = Integer.parseInt(min);
            }
            if (minInt >= 0) {
                particle.setMinOccurs(minInt);
            }
            String max = p.getProperty("com.ibm.cics.wsdl.properties.maxOccurs");
            int maxInt = -1;
            if (null != max) {
                maxInt = Integer.parseInt(max);
            }
            if (maxInt >= 0) {
                particle.setMaxOccurs(maxInt);
            }
            ICMSchemaParsingState state = new ICMSchemaParsingState();
            state.setCurrentLevelState(this.topLevelState);
            state.setTypeNameSpace(wsdlPartNameSpace);
            state.setXpath(xpath);
            state.setDelegate(element);
            state.setTotalChoices(0);
            state.setThisChoice(0);
            state.setSupressSuffixedPaddingMessage(true);
            state.setAttrsList(new LinkedList<XSDAttributeUse>());
            this.processParticle(particle, state);
        }
        if (this.parms.getStyle().equals((Object)ICM.BindingStyle.RPC_STYLE)) {
            // empty if block
        }
        if (validate) {
            this.builder.revalidate();
        }
        if (this.isTrace()) {
            this.getLogger().println("Finished adding element declaration: " + targetQName.toString());
        }
    }

    @Override
    public void addTypeDefinition(String wsdlPartNameSpace, String wsdlPartName, QName targetQName) throws ICMException {
        if (this.isTrace()) {
            this.getLogger().println("Adding type definition(1): " + targetQName.toString());
        }
        if (!this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Illegal call of 'addTypeDefinition'.");
        }
        if (this.parms.getStyle().equals((Object)ICM.BindingStyle.DOCUMENT_STYLE)) {
            throw new ICMException(MessageHandler.getMessage("DFHPI9004E"));
        }
        StringBuilder xpath = new StringBuilder(this.seededXPATH.toString());
        this.addTypeDefinitionPart2(wsdlPartNameSpace, wsdlPartName, targetQName, false, xpath, false, false);
        if (this.isTrace()) {
            this.getLogger().println("Finished adding type definition(1): " + targetQName.toString());
        }
    }

    private void addTypeDefinitionPart2(String wsdlPartNameSpace, String wsdlPartName, QName targetQName, boolean forceRPCStyle, StringBuilder xpath, boolean globalType, boolean nillable) throws ICMException {
        if (this.isTrace()) {
            this.getLogger().println("Adding type definition(2): " + targetQName.toString());
            this.getLogger().println("wsdlPartNameSpace: " + wsdlPartNameSpace);
            this.getLogger().println("wsdlPartName: " + wsdlPartName);
            this.getLogger().println("forceRPCStyle: " + forceRPCStyle);
        }
        XSDTypeDefinition type = this.builder.resolveTypeDefinition(targetQName);
        if (MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel()) && this.parms.getStyle().equals((Object)ICM.BindingStyle.RPC_STYLE) || globalType) {
            XSDFactory xsdFactory = XSDFactory.eINSTANCE;
            XSDElementDeclaration element = xsdFactory.createXSDElementDeclaration();
            element.setName(wsdlPartName);
            element.setTypeDefinition(type);
            QName xsiType = null;
            if (!globalType) {
                element.setTargetNamespace(null);
            } else {
                element.setTargetNamespace(wsdlPartNameSpace);
                xsiType = targetQName;
                if (nillable) {
                    element.setNillable(true);
                }
            }
            XSDParticle particle = xsdFactory.createXSDParticle();
            particle.setMaxOccurs(1);
            particle.setMinOccurs(1);
            particle.setContent(element);
            XSDElementDeclaration delegate = element;
            ICMSchemaParsingState state = new ICMSchemaParsingState();
            state.setCurrentLevelState(this.topLevelState);
            state.setTypeNameSpace(wsdlPartNameSpace);
            state.setXpath(xpath);
            state.setDelegate(delegate);
            state.setTotalChoices(0);
            state.setThisChoice(0);
            state.setSupressSuffixedPaddingMessage(true);
            state.setAttrsList(new LinkedList<XSDAttributeUse>());
            state.setSyntheticElement(true);
            state.setXsiType(xsiType);
            this.processParticle(particle, state);
        } else {
            if (this.parms.getStyle().equals((Object)ICM.BindingStyle.RPC_STYLE) || forceRPCStyle) {
                if (wsdlPartName.length() > 255) {
                    throw new ICMLengthException(MessageHandler.buildMessage("DFHPI9003E", new Object[]{wsdlPartName}));
                }
                if (forceRPCStyle && this.parms.getStyle().equals((Object)ICM.BindingStyle.DOCUMENT_STYLE)) {
                    this.addRPCPartAccessor(wsdlPartName, xpath, type instanceof XSDComplexTypeDefinition, wsdlPartNameSpace);
                } else {
                    this.addRPCPartAccessor(wsdlPartName, xpath, type instanceof XSDComplexTypeDefinition, null);
                }
            }
            ICMSchemaParsingState state = new ICMSchemaParsingState();
            state.setCurrentLevelState(this.topLevelState);
            state.setTypeName(wsdlPartName);
            state.setTypeNameSpace(wsdlPartNameSpace);
            state.setXpath(xpath);
            this.processTypeDef(type, state, null);
            this.builder.revalidate();
            if (this.parms.getStyle().equals((Object)ICM.BindingStyle.RPC_STYLE) || forceRPCStyle) {
                this.topLevelState.getTemplate().addEndTag(null, wsdlPartName, false);
            }
        }
        if (this.isTrace()) {
            this.getLogger().println("Finished adding type definition(2): " + targetQName.toString());
        }
    }

    private void addRPCPartAccessor(String wsdlPartName, StringBuilder xpath, boolean generateDummyIndexEntry, String namespace) throws ICMException {
        this.topLevelState.getTemplate().addStartTag(null, wsdlPartName, false, null);
        this.extendXPATH(xpath, namespace, wsdlPartName);
        if (generateDummyIndexEntry) {
            this.ich.createDummyIndexEntry(xpath.toString());
        }
    }

    private void extendXPATH(StringBuilder xpath, String namespace, String element) {
        xpath.append("+++");
        xpath.append(namespace);
        xpath.append("~~~");
        xpath.append(element);
    }

    private void doindent(int indent) {
        if (this.isTrace()) {
            StringBuilder indentStr = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                indentStr.append(' ');
            }
            this.getLogger().print(indentStr);
        }
    }

    private PrintStream getLogger() {
        return this.logger;
    }

    private boolean isTrace() {
        return this.trace;
    }

    private void processTypeDef(XSDTypeDefinition typedef, ICMSchemaParsingState state, List<String> comments) throws ICMException {
        if (typedef == null) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9025E", new Object[]{state.getTypeName()}));
        }
        if (this.allInScopeTypes.contains(typedef)) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9024E", new Object[]{typedef.getURI()}));
        }
        this.allInScopeTypes.add(typedef);
        if (typedef.getElement() == null && !state.getReplacementForSuppressedElement()) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9025E", new Object[]{typedef.getURI()}));
        }
        if (typedef instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition typed = (XSDSimpleTypeDefinition)typedef;
            this.processSimpleType(typed, state, false, null, null, comments);
            if (state.getNillable()) {
                this.addNillableAttr(state.getCurrentLevelState());
            }
        } else if (typedef instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition typed = (XSDComplexTypeDefinition)typedef;
            ++this.indent;
            this.processComplexType(typed, state, false, comments);
            --this.indent;
        } else {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9021E", new Object[]{typedef}));
        }
        this.allInScopeTypes.remove(typedef);
    }

    private void addNillableAttr(ICMLevelState currentLevelState) throws ICMException {
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.parms.getMappingLevel())) {
            XSDSimpleTypeDefinition nilValue = (XSDSimpleTypeDefinition)this.builder.resolveTypeDefinition(new QName(SCHEMA4SCHEMA, "boolean"));
            this.addAttribute(currentLevelState, "nil", SCHEMA4XSI, false, true, false, true, false, "false", nilValue);
        }
    }

    private void processFacets(XSDSimpleTypeDefinition typed, List<String> comments, int indentLevel) {
        String simpleTypeName = this.getPrimitiveSimpleType(typed).getName();
        if (this.jsonMessages) {
            if (this.isNumberType(simpleTypeName)) {
                this.addFacetComment(comments, indentLevel, "format", simpleTypeName);
            } else if (this.isStringType(simpleTypeName)) {
                if (simpleTypeName.equals("dateTime")) {
                    simpleTypeName = "date-time";
                } else if (simpleTypeName.equals("anyURI")) {
                    simpleTypeName = "uri";
                }
                this.addFacetComment(comments, indentLevel, "format", simpleTypeName);
            }
        }
        for (XSDConstrainingFacet facet : typed.getFacets()) {
            String facetValue = null;
            String facetName = facet.getFacetName();
            String exclusive = null;
            try {
                facetValue = facet.getEffectiveValue().toString();
                if (this.jsonMessages) {
                    if (facetName.contains(EXCLUSIVE_SUFFIX)) {
                        if ("maxExclusive".equals(facetName)) {
                            exclusive = "exclusiveMaximum";
                        } else if ("minExclusive".equals(facetName)) {
                            exclusive = "exclusiveMinimum";
                        }
                        facetName = facetName.replace(EXCLUSIVE_SUFFIX, "imum");
                    }
                    if (facetName.contains(INCLUSIVE_SUFFIX)) {
                        facetName = facetName.replace(INCLUSIVE_SUFFIX, "imum");
                    }
                    if (exclusive != null) {
                        this.addFacetComment(comments, indentLevel, exclusive, "true");
                    }
                    if (!(facetName.equals("whiteSpace") || facetName.equals("totalDigits") || facetName.equals("fractionDigits"))) {
                        if (simpleTypeName.equals("string")) {
                            if (facetName.equals("pattern") && facetValue.startsWith("[:") && facetValue.endsWith(":]")) {
                                facetValue = facetValue.substring(0, facetValue.length() - 2);
                                facetValue = facetValue.substring(2);
                                facetName = "format";
                            }
                            this.addFacetComment(comments, indentLevel, facetName, facetValue);
                        } else if (!facetName.equals("pattern")) {
                            this.addFacetComment(comments, indentLevel, facetName, facetValue);
                        }
                    }
                } else {
                    StringBuilder comment = new StringBuilder();
                    this.addIndent(comment, indentLevel);
                    comment.append(MessageHandler.buildMessage("HLL_COMMENT_FACET", new Object[]{facetName, facetValue}));
                    comments.add(comment.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace(this.getLogger());
            }
            if (!this.isTrace()) continue;
            this.doindent(this.indent);
            this.getLogger().println("facet: " + facetName + " value: " + facet.getEffectiveValue());
        }
    }

    private void addFacetComment(List<String> comments, int indentLevel, String facetName, String facetValue) {
        StringBuilder comment = new StringBuilder();
        this.addIndent(comment, indentLevel);
        comment.append(MessageHandler.buildMessage("HLL_COMMENT_JSON_SCHEMA_KEYWORD_VALUE", new Object[]{facetName, facetValue}));
        comments.add(comment.toString());
    }

    private XSDSimpleTypeDefinition getPrimitiveSimpleType(XSDSimpleTypeDefinition typed) {
        XSDSimpleTypeDefinition tmp = typed;
        while (!tmp.getURI().startsWith("http://www.w3.org/2001/XMLSchema#")) {
            if (tmp.getItemTypeDefinition() != null) {
                tmp = tmp.getItemTypeDefinition();
                continue;
            }
            tmp = tmp.getBaseTypeDefinition();
        }
        return tmp;
    }

    private void addIndent(StringBuilder comments, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            comments.append(" ");
        }
    }

    private int calculateStringLengthOfTypeAndProcessFacets(XSDSimpleTypeDefinition typed, List<String> comments, int indentLevel, ICM.EncodingType encodingType) throws ICMException {
        int maxLength = -1;
        block0 : switch (typed.getVariety().getValue()) {
            case 1: {
                int mappingLevel;
                XSDMaxLengthFacet maxLengthF;
                int maxListLength = 7;
                int maxEntryLength = 32;
                int whiteSpacePadding = 4;
                XSDLengthFacet length = typed.getEffectiveLengthFacet();
                if (length != null) {
                    maxListLength = length.getValue();
                }
                if ((maxLengthF = typed.getEffectiveMaxLengthFacet()) == null) {
                    maxLengthF = typed.getMaxLengthFacet();
                }
                if (!MappingLevelHelper.supportsMappingLevel_2_1(mappingLevel = this.parms.getMappingLevel()) && maxLengthF != null && length != null) {
                    maxListLength = length.getValue();
                } else if (MappingLevelHelper.supportsMappingLevel_2_1(mappingLevel) && maxLengthF != null) {
                    maxListLength = maxLengthF.getValue();
                }
                maxLength = maxListLength * (maxEntryLength + whiteSpacePadding);
                if (maxLength < 255) {
                    maxLength = 255;
                }
                StringBuilder comment = new StringBuilder();
                this.addIndent(comment, indentLevel);
                XSDSimpleTypeDefinition listType = typed.getItemTypeDefinition();
                if (listType == null) {
                    listType = typed.getBaseTypeDefinition();
                }
                switch (listType.getVariety().getValue()) {
                    case 0: {
                        comment.append(MessageHandler.buildMessage("HLL_COMMENT_LIST_SIMPLE", new Object[]{this.getPrimitiveSimpleType(listType).getName()}));
                        comments.add(comment.toString());
                        this.processFacets(typed, comments, indentLevel += 2);
                        break block0;
                    }
                    case 2: {
                        comment.append(MessageHandler.getMessage("HLL_COMMENT_LIST_UNION"));
                        comments.add(comment.toString());
                        this.calculateStringLengthOfTypeAndProcessFacets(listType, comments, indentLevel += 2, encodingType);
                        break block0;
                    }
                }
                throw new ICMException("INTERNAL ERROR: unsupported list type variety " + typed.getVariety().getName());
            }
            case 2: {
                maxLength = this.parms.getDefaultCharMaxLen();
                StringBuilder comment = new StringBuilder();
                this.addIndent(comment, indentLevel);
                comment.append(MessageHandler.getMessage("HLL_COMMENT_UNION"));
                comments.add(comment.toString());
                indentLevel += 2;
                for (XSDSimpleTypeDefinition unionMember : typed.getMemberTypeDefinitions()) {
                    XSDSimpleTypeDefinition tmpLocal = this.getPrimitiveSimpleType(unionMember);
                    comment.delete(0, comment.length());
                    this.addIndent(comment, indentLevel);
                    switch (unionMember.getVariety().getValue()) {
                        case 1: {
                            comment.append("list");
                            break;
                        }
                        case 2: {
                            comment.append("union");
                            break;
                        }
                        case 0: {
                            comment.append(tmpLocal.getName());
                            break;
                        }
                        default: {
                            throw new ICMException("INTERNAL ERROR: unsupported type variety " + typed.getVariety().getName());
                        }
                    }
                    comments.add(comment.toString());
                    int localLength = this.calculateStringLengthOfTypeAndProcessFacets(unionMember, comments, indentLevel + 2, encodingType);
                    if (localLength <= maxLength) continue;
                    maxLength = localLength;
                }
                break;
            }
            case 0: {
                maxLength = this.calculateLARForCharArrayType(typed, encodingType);
                if (this.getPrimitiveSimpleType(typed).getName().toUpperCase(Locale.ENGLISH).equals("BASE64BINARY")) {
                    maxLength = this.calculateBase64CharLength(maxLength);
                }
                if (this.getPrimitiveSimpleType(typed).getName().toUpperCase(Locale.ENGLISH).equals("HEXBINARY")) {
                    maxLength *= 2;
                }
                StringBuilder comment = new StringBuilder();
                this.addIndent(comment, indentLevel);
                comment.append(MessageHandler.buildMessage("HLL_COMMENT_FACET_TYPE", new Object[]{this.getPrimitiveSimpleType(typed).getName()}));
                comments.add(comment.toString());
                this.processFacets(typed, comments, indentLevel += 2);
                break;
            }
            default: {
                throw new ICMException("INTERNAL ERROR: unsupported type variety " + typed.getVariety().getName());
            }
        }
        return maxLength;
    }

    private boolean isAligned(int language) {
        boolean aligned = true;
        if (language == 2 || language == 6 || language == 7) {
            aligned = false;
        }
        return aligned;
    }

    private void processSimpleType(XSDSimpleTypeDefinition typed, ICMSchemaParsingState state, boolean attribute, String attributeXMLTemplateLocation, String containerName, List<String> comments) throws ICMException {
        XSDWhiteSpace ws;
        int packedDecimalLength;
        int maxLength;
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.logger.println("Processing simple type: " + typed.getURI() + " typeName: " + state.getTypeName());
        }
        state.setChoiceProcessing(false);
        if (state.getReplacementForSuppressedElement() && state.getOverRideProperties().isEmpty()) {
            throw new ICMRuntimeException("Internal Error: suppressed properties missing");
        }
        int mappingLevel = this.parms.getMappingLevel();
        int lang = this.parms.getLang();
        ICM.EncodingType encoding = ICM.EncodingType.SBCS;
        if (MappingLevelHelper.requiresMappingLevel_1(mappingLevel) && typed.getVariety().getValue() != 0) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9010E", new Object[]{typed.getURI()}));
        }
        if (comments == null) {
            comments = new LinkedList<String>();
        }
        XSDSimpleTypeDefinition tmp = this.getPrimitiveSimpleType(typed);
        String xmlName = null;
        if (!attribute) {
            if (!state.getReplacementForSuppressedElement()) {
                xmlName = state.getCurrentLevelState().getTemplate().addVariable(null, null, state.getTypeName());
            }
        } else {
            xmlName = attributeXMLTemplateLocation;
        }
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.getLogger().println("Found simple type derived from: " + tmp.getName());
            this.doindent(this.indent);
            this.getLogger().println("Type is: " + state.getTypeNameSpace() + "#" + state.getTypeName());
            this.doindent(this.indent);
            this.getLogger().println("XPATH is: " + state.getXpath());
            this.doindent(this.indent);
            this.getLogger().println("Default value is: " + state.getDefaultValue());
        }
        Properties p = ICMBuilderImpl.getAnnotationsAsProperties(typed.getAnnotations(), this.logger);
        if (state.getOverRideProperties() != null) {
            p = state.getOverRideProperties().get(0);
            state.getOverRideProperties().remove(p);
        }
        String alignedStr = p.getProperty("com.ibm.cics.wsdl.properties.synchronized");
        boolean aligned = this.isAligned(this.parms.getLang());
        if ("false".equals(alignedStr)) {
            aligned = false;
        } else if ("true".equals(alignedStr)) {
            aligned = true;
        }
        String varLenStratStr = p.getProperty("com.ibm.cics.wsdl.properties.charlength");
        ICM.VaryingLength variableLengthStrategy = this.parms.getDefaultCharVarying();
        boolean variableLengthStrategyOverriden = false;
        if ("fixed".equals(varLenStratStr)) {
            variableLengthStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
            variableLengthStrategyOverriden = true;
        }
        if ("null".equals(varLenStratStr)) {
            variableLengthStrategy = ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY;
            variableLengthStrategyOverriden = true;
        }
        if ("varying".equals(varLenStratStr)) {
            variableLengthStrategy = ICM.VaryingLength.VARYING_ARRAY;
            variableLengthStrategyOverriden = true;
        }
        boolean useHexFloating = this.parms.isUseHexFloat();
        String floatTypeStr = p.getProperty("com.ibm.cics.wsdl.properties.float.type");
        if ("hex".equals(floatTypeStr)) {
            useHexFloating = true;
        }
        if ("IEEE".equals(floatTypeStr)) {
            useHexFloating = false;
        }
        if (lang == 6 || lang == 7) {
            useHexFloating = true;
        }
        boolean decimalTypeIsPacked = true;
        String decimalTypeStr = p.getProperty("com.ibm.cics.wsdl.properties.decimal");
        if ("packed".equals(decimalTypeStr)) {
            decimalTypeIsPacked = true;
        }
        if ("zoned".equals(decimalTypeStr)) {
            decimalTypeIsPacked = false;
        }
        boolean signLeading = false;
        String signStr = p.getProperty("com.ibm.cics.wsdl.properties.sign");
        if ("leading".equals(signStr)) {
            signLeading = true;
        }
        if ("trailing".equals(signStr)) {
            signLeading = false;
        }
        boolean separateChar = false;
        String sepCharStr = p.getProperty("com.ibm.cics.wsdl.properties.sign.separate");
        if ("true".equals(sepCharStr)) {
            separateChar = true;
        }
        if ("false".equals(sepCharStr)) {
            separateChar = false;
        }
        ICM.ICMDataType dataType = null;
        int LAR = -1;
        long levelOffset = -1L;
        long maxPermittableValue = Long.MAX_VALUE;
        int fractionDigits = -1;
        ICM.VaryingLength variableMappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
        if (state.getXpath() != null) {
            if (this.jsonMessages) {
                comments.add(0, MessageHandler.buildMessage("HLL_COMMENT_JSON_HINT", new Object[]{this.ich.getJsonKeyword(state.getXpath().toString())}));
            } else {
                comments.add(0, MessageHandler.buildMessage("HLL_COMMENT_SOAP_HINT", new Object[]{this.ich.getSimpleXpath(state.getXpath().toString())}));
            }
        }
        if (typed.getVariety().getValue() == 0) {
            if (this.jsonMessages) {
                String jsonTypeName = tmp.getName();
                if (this.isIntegerType(jsonTypeName)) {
                    jsonTypeName = "integer";
                } else if (this.isNumberType(jsonTypeName)) {
                    jsonTypeName = "number";
                } else if (this.isStringType(jsonTypeName)) {
                    jsonTypeName = "string";
                }
                comments.add(MessageHandler.buildMessage("HLL_COMMENT_JSON_DATA_TYPE", new Object[]{jsonTypeName}));
            } else {
                comments.add(MessageHandler.buildMessage("HLL_COMMENT_SCHEMA_TYPE", new Object[]{tmp.getName()}));
            }
            this.processFacets(typed, comments, 0);
        }
        boolean list = false;
        int listLen = 0;
        if (typed.getVariety().getValue() == 1) {
            list = true;
            listLen = this.calculateStringLengthOfTypeAndProcessFacets(typed, comments, 0, encoding);
        }
        boolean union = false;
        int unionLen = 0;
        if (typed.getVariety().getValue() == 2) {
            union = true;
            unionLen = this.calculateStringLengthOfTypeAndProcessFacets(typed, comments, 0, encoding);
        }
        ValueHolder extraInfo = null;
        boolean variableLengthSupportNeeded = false;
        String typeNameStr = tmp.getName().toUpperCase(Locale.ENGLISH);
        if (typeNameStr.equals("STRING") || list || union) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = list ? listLen : (union ? unionLen : this.calculateLARForCharArrayType(typed, encoding));
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("BOOLEAN")) {
            dataType = ICM.ICMDataType.BOOLEAN;
            LAR = 0;
            levelOffset = state.getCurrentLevelState().addBooleanAlignedEntry(aligned, lang, this.indent, state.getTypeName());
        } else if (typeNameStr.equals("DECIMAL")) {
            if (lang == 1 || lang == 2 || lang == 6 || lang == 7) {
                maxLength = this.getMaxPackedDecimalLength(lang);
                if (!decimalTypeIsPacked) {
                    maxLength = Integer.MAX_VALUE;
                }
                LAR = this.calculateLARForDecimalType(typed, this.parms.getDefaultFractionDigits(), maxLength, this.parms);
                fractionDigits = this.calculateFDForDecimalType(typed, this.parms.getDefaultFractionDigits(), maxLength);
                if (LAR >= 0) {
                    dataType = decimalTypeIsPacked ? ICM.ICMDataType.UNSIGNED_DECIMAL : ICM.ICMDataType.UNSIGNED_ZONED;
                } else {
                    dataType = decimalTypeIsPacked ? ICM.ICMDataType.DECIMAL : ICM.ICMDataType.ZONED;
                    LAR = -1 - LAR;
                }
                if (decimalTypeIsPacked) {
                    packedDecimalLength = this.getPackedDecimalLength(LAR + fractionDigits);
                    levelOffset = state.getCurrentLevelState().addBinaryAlignedEntry(packedDecimalLength, lang, this.indent, state.getTypeName(), ICM.VaryingLength.NO_VARYING_STRATEGY);
                } else {
                    levelOffset = state.getCurrentLevelState().addZonedAlignedEntry(LAR + fractionDigits, lang, this.indent, state.getTypeName(), separateChar);
                }
            } else {
                dataType = ICM.ICMDataType.CHAR_ARRAY;
                LAR = 32;
                variableLengthSupportNeeded = true;
            }
        } else if (typeNameStr.equals("FLOAT")) {
            if (!MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                dataType = ICM.ICMDataType.CHAR_ARRAY;
                LAR = 32;
                variableLengthSupportNeeded = true;
            } else {
                dataType = useHexFloating ? ICM.ICMDataType.HFP_SHORT : ICM.ICMDataType.BFP_FLOAT;
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addFloatAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("DOUBLE")) {
            if (!MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                dataType = ICM.ICMDataType.CHAR_ARRAY;
                LAR = 32;
                variableLengthSupportNeeded = true;
            } else {
                dataType = useHexFloating ? ICM.ICMDataType.HFP_LONG : ICM.ICMDataType.BFP_DOUBLE;
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addDoubleAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("DURATION")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("DATETIME")) {
            if (MappingLevelHelper.supportsMappingLevel_3_0(mappingLevel) && this.parms.getUseAbstimeDates()) {
                dataType = ICM.ICMDataType.ABSTIME;
                LAR = 15;
                fractionDigits = 0;
                int packedDecimalLength2 = this.getPackedDecimalLength(LAR + fractionDigits);
                levelOffset = state.getCurrentLevelState().addBinaryAlignedEntry(packedDecimalLength2, lang, this.indent, state.getTypeName(), ICM.VaryingLength.NO_VARYING_STRATEGY);
                if (this.jsonMessages) {
                    this.warnings.add(MessageHandler.buildMessage("DFHPI9725W", new Object[0]));
                }
            } else {
                dataType = ICM.ICMDataType.CHAR_ARRAY;
                LAR = MappingLevelHelper.supportsMappingLevel_2(mappingLevel) ? 40 : 32;
                variableLengthSupportNeeded = true;
            }
        } else if (typeNameStr.equals("TIME")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("DATE")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("GYEARMONTH")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("GYEAR")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("GMONTHDAY")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("GDAY")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("GMONTH")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = 32;
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("HEXBINARY")) {
            dataType = ICM.ICMDataType.HEX_ARRAY;
            LAR = MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel) ? this.calculateLARForCharArrayType(typed, 0xFFFFFF, ICM.EncodingType.SBCS) : this.calculateLARForCharArrayType(typed, ICM.EncodingType.SBCS);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("BASE64BINARY")) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                dataType = ICM.ICMDataType.BASE64_ARRAY;
                LAR = this.calculateLARForCharArrayType(typed, 0xFFFFFF, encoding);
                variableLengthSupportNeeded = true;
            } else {
                dataType = ICM.ICMDataType.CHAR_ARRAY;
                LAR = this.calculateLARForCharArrayType(typed, encoding);
                LAR = this.calculateBase64CharLength(LAR);
                variableLengthSupportNeeded = true;
            }
        } else if (typeNameStr.equals("ANYURI")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("QNAME")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("NOTATION")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("NORMALIZEDSTRING")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("TOKEN")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("LANGUAGE")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("NMTOKEN")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("NMTOKENS")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("NAME")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("NCNAME")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("ID")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("IDREF")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("IDREFS")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("ENTITY")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("ENTITIES")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            encoding = this.setEncoding(p, mappingLevel);
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("INTEGER")) {
            if (lang == 1 || lang == 2 || lang == 6 || lang == 7) {
                maxLength = this.getMaxPackedDecimalLength(lang);
                LAR = this.calculateLARForDecimalType(typed, 0, maxLength, this.parms);
                fractionDigits = this.calculateFDForDecimalType(typed, 0, maxLength);
                if (LAR >= 0) {
                    dataType = ICM.ICMDataType.UNSIGNED_DECIMAL;
                } else {
                    dataType = ICM.ICMDataType.DECIMAL;
                    LAR = -1 - LAR;
                }
                packedDecimalLength = this.getPackedDecimalLength(LAR + fractionDigits);
                levelOffset = state.getCurrentLevelState().addBinaryAlignedEntry(packedDecimalLength, lang, this.indent, state.getTypeName(), ICM.VaryingLength.NO_VARYING_STRATEGY);
            } else {
                dataType = ICM.ICMDataType.CHAR_ARRAY;
                LAR = this.calculateLARForCharArrayNumericType(typed, 32, 0);
                variableLengthSupportNeeded = true;
            }
        } else if (typeNameStr.equals("NONPOSITIVEINTEGER")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = this.calculateLARForCharArrayNumericType(typed, 32, 0);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("NEGATIVEINTEGER")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = this.calculateLARForCharArrayNumericType(typed, 32, 0);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("LONG")) {
            dataType = ICM.ICMDataType.LONG;
            maxPermittableValue = Long.MAX_VALUE;
            LAR = this.processDisplayTypes(typed, maxPermittableValue, this.getMaxZonedDecimalLength(lang), state.getReplacementForSuppressedElement());
            if (LAR > 0) {
                levelOffset = state.getCurrentLevelState().addZonedAlignedEntry(LAR, lang, this.indent, state.getTypeName(), separateChar);
                if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                    dataType = ICM.ICMDataType.ZONED;
                    fractionDigits = 0;
                }
            } else {
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addLongAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("INT")) {
            dataType = ICM.ICMDataType.INT;
            maxPermittableValue = Integer.MAX_VALUE;
            LAR = this.processDisplayTypes(typed, maxPermittableValue, 9, state.getReplacementForSuppressedElement());
            if (LAR > 0) {
                levelOffset = state.getCurrentLevelState().addZonedAlignedEntry(LAR, lang, this.indent, state.getTypeName(), separateChar);
                if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                    dataType = ICM.ICMDataType.ZONED;
                    fractionDigits = 0;
                }
            } else {
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addIntAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("SHORT")) {
            dataType = ICM.ICMDataType.SHORT;
            maxPermittableValue = 32767L;
            LAR = this.processDisplayTypes(typed, maxPermittableValue, 5, state.getReplacementForSuppressedElement());
            if (LAR > 0) {
                levelOffset = state.getCurrentLevelState().addZonedAlignedEntry(LAR, lang, this.indent, state.getTypeName(), separateChar);
                if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                    dataType = ICM.ICMDataType.ZONED;
                    fractionDigits = 0;
                }
            } else {
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addShortAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("BYTE")) {
            dataType = ICM.ICMDataType.BYTE;
            maxPermittableValue = 127L;
            LAR = 0;
            levelOffset = state.getCurrentLevelState().addByteAlignedEntry(aligned, lang, this.indent, state.getTypeName());
        } else if (typeNameStr.equals("NONNEGATIVEINTEGER")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = this.calculateLARForCharArrayNumericType(typed, 32, 0);
            variableLengthSupportNeeded = true;
        } else if (typeNameStr.equals("UNSIGNEDLONG")) {
            dataType = ICM.ICMDataType.UNSIGNED_LONG;
            maxPermittableValue = Long.MAX_VALUE;
            LAR = this.processDisplayTypes(typed, maxPermittableValue, this.getMaxZonedDecimalLength(lang), state.getReplacementForSuppressedElement());
            if (LAR > 0) {
                levelOffset = state.getCurrentLevelState().addZonedAlignedEntry(LAR, lang, this.indent, state.getTypeName(), separateChar);
                if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                    dataType = ICM.ICMDataType.UNSIGNED_ZONED;
                    fractionDigits = 0;
                }
            } else {
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addUnsignedLongAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("UNSIGNEDINT")) {
            dataType = ICM.ICMDataType.UNSIGNED_INT;
            maxPermittableValue = 0xFFFFFFFFL;
            LAR = this.processDisplayTypes(typed, maxPermittableValue, 9, state.getReplacementForSuppressedElement());
            if (LAR > 0) {
                levelOffset = state.getCurrentLevelState().addZonedAlignedEntry(LAR, lang, this.indent, state.getTypeName(), separateChar);
                if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                    dataType = ICM.ICMDataType.UNSIGNED_ZONED;
                    fractionDigits = 0;
                }
            } else {
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addUnsignedIntAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("UNSIGNEDSHORT")) {
            dataType = ICM.ICMDataType.UNSIGNED_SHORT;
            maxPermittableValue = 65535L;
            LAR = this.processDisplayTypes(typed, maxPermittableValue, 5, state.getReplacementForSuppressedElement());
            if (LAR > 0) {
                levelOffset = state.getCurrentLevelState().addZonedAlignedEntry(LAR, lang, this.indent, state.getTypeName(), separateChar);
                if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
                    dataType = ICM.ICMDataType.UNSIGNED_ZONED;
                    fractionDigits = 0;
                }
            } else {
                LAR = 0;
                levelOffset = state.getCurrentLevelState().addUnsignedShortAlignedEntry(aligned, lang, this.indent, state.getTypeName());
            }
        } else if (typeNameStr.equals("UNSIGNEDBYTE")) {
            dataType = ICM.ICMDataType.UNSIGNED_BYTE;
            maxPermittableValue = 255L;
            LAR = 0;
            levelOffset = state.getCurrentLevelState().addUnsignedByteAlignedEntry(aligned, lang, this.indent, state.getTypeName());
        } else if (typeNameStr.equals("POSITIVEINTEGER")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = this.calculateLARForCharArrayNumericType(typed, 32, 0);
            variableLengthSupportNeeded = true;
        } else if (MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) && typeNameStr.equals("ANYSIMPLETYPE")) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            LAR = this.calculateLARForCharArrayType(typed, encoding);
            variableLengthSupportNeeded = true;
        } else {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9011E", new Object[]{tmp.getURI(), typed.getURI()}));
        }
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.getLogger().println("is aligned: " + aligned);
            this.doindent(this.indent);
            this.getLogger().println("are widechars: " + encoding.equals((Object)ICM.EncodingType.DBCS));
            this.doindent(this.indent);
            this.getLogger().println("is UTF-16BE: " + encoding.equals((Object)ICM.EncodingType.UTF16BE));
        }
        if (variableLengthSupportNeeded) {
            if (containerName != null) {
                variableLengthStrategy = ICM.VaryingLength.VARYING_NAMED_CONTAINER;
            }
            extraInfo = this.handleVariableMappingStrategy(typed, list || union, encoding, dataType, mappingLevel, LAR, state.getTypeName(), aligned, state.getCurrentLevelState(), variableLengthStrategy, variableLengthStrategyOverriden);
            levelOffset = extraInfo.getLevelOffset();
            variableMappingStrategy = extraInfo.getMappingStrategy();
        }
        if (variableMappingStrategy.equals((Object)ICM.VaryingLength.VARYING_CONTAINER) || variableMappingStrategy.equals((Object)ICM.VaryingLength.VARYING_NAMED_CONTAINER)) {
            LAR = 0xFFFFFF;
        }
        ICM.WhiteSpace whiteSpace = ICM.WhiteSpace.COLLAPSE;
        XSDWhiteSpaceFacet wsf = typed.getEffectiveWhiteSpaceFacet();
        if (wsf == null) {
            wsf = typed.getWhiteSpaceFacet();
        }
        if (wsf != null && dataType.equals((Object)ICM.ICMDataType.CHAR_ARRAY) && (ws = (XSDWhiteSpace)((Object)wsf.getEffectiveValue())) != null) {
            if (ws.getValue() == 2) {
                whiteSpace = ICM.WhiteSpace.COLLAPSE;
            } else if (ws.getValue() == 0) {
                whiteSpace = ICM.WhiteSpace.PRESERVE;
            } else if (ws.getValue() == 1) {
                whiteSpace = ICM.WhiteSpace.REPLACE;
            }
        }
        String xpathStr = null;
        if (state.getXpath() != null) {
            xpathStr = state.getXpath().toString();
        }
        String odoTargetName = p.getProperty("com.ibm.cics.wsdl.properties.odo");
        ICMSlackBytesElementEntryImpl odoTarget = null;
        if (odoTargetName != null && MappingLevelHelper.supportsMappingLevel_4_0(mappingLevel) && this.parms.getLang() == 1) {
            odoTarget = this.findOdoTarget(odoTargetName);
        }
        int minLength = this.getMinLength(typed);
        if (!state.getReplacementForSuppressedElement()) {
            this.ich.addDataElement(dataType, LAR, whiteSpace, state.getTypeName(), state.getTypeNameSpace(), "&" + xmlName + ";", state.getDefaultValue(), comments, xpathStr, this.ich.getSimpleXpath(xpathStr), levelOffset, fractionDigits, aligned, encoding, variableMappingStrategy, signLeading, separateChar, containerName, odoTarget, minLength, state.isMultiTypeElement());
        } else {
            String odoTargetNameStr = null;
            if (MappingLevelHelper.supportsMappingLevel_4_0(mappingLevel) && this.parms.getLang() == 1) {
                odoTargetNameStr = p.getProperty("com.ibm.cics.wsdl.properties.odo.target");
            }
            this.ich.addSlackBytesDataElement(dataType, LAR, whiteSpace, state.getTypeName(), state.getTypeNameSpace(), "&" + xmlName + ";", state.getDefaultValue(), comments, xpathStr, this.ich.getSimpleXpath(xpathStr), levelOffset, fractionDigits, aligned, encoding, variableMappingStrategy, signLeading, separateChar, odoTarget, false, odoTargetNameStr, minLength, false);
        }
    }

    private ICM.EncodingType setEncoding(Properties p, int mappingLevel) {
        if ("true".equals(p.getProperty("com.ibm.cics.wsdl.properties.widechars"))) {
            return ICM.EncodingType.DBCS;
        }
        if (MappingLevelHelper.supportsMappingLevel_4_0(mappingLevel)) {
            if (CodePageHelper.getApplicationCCSID(this.parms.getInputParameters().getProperty("CCSID")) == 1200) {
                if (!"false".equals(p.getProperty("com.ibm.cics.wsdl.properties.utf16be"))) {
                    return ICM.EncodingType.UTF16BE;
                }
            } else if ("true".equals(p.getProperty("com.ibm.cics.wsdl.properties.utf16be"))) {
                this.parms.getInputParameters().setProperty("UTF-16", "true");
                return ICM.EncodingType.UTF16BE;
            }
        }
        return ICM.EncodingType.SBCS;
    }

    private int getMinLength(XSDSimpleTypeDefinition definition) {
        int minLength = -1;
        if (definition.getEffectiveMinLengthFacet() != null) {
            minLength = definition.getEffectiveMinLengthFacet().getValue();
        }
        if (minLength == -1 && definition.getMinLengthFacet() != null) {
            minLength = definition.getMinLengthFacet().getValue();
        }
        return minLength;
    }

    private ICMSlackBytesElementEntryImpl findOdoTarget(String odoTargetName) throws ICMException {
        ICMSlackBytesElementEntryImpl odoTarget = null;
        Iterator<ICMEntryImpl> icmContentsIt = this.ich.getContents().iterator();
        boolean found = false;
        while (icmContentsIt.hasNext()) {
            ICMSlackBytesElementEntryImpl slackBytes;
            ICMEntryImpl entry = icmContentsIt.next();
            if (!(entry instanceof ICMSlackBytesElementEntryImpl) || !odoTargetName.equals((slackBytes = (ICMSlackBytesElementEntryImpl)entry).getODOFieldName())) continue;
            odoTarget = slackBytes;
            found = true;
        }
        if (!found) {
            throw new ICMException("INTERNAL ERROR: ODO target field '" + odoTargetName + "' not found.");
        }
        return odoTarget;
    }

    private boolean isNumberType(String typeName) {
        return typeName.equals("double") || typeName.equals("float") || typeName.equals("decimal");
    }

    private boolean isStringType(String typeName) {
        return typeName.equals("dateTime") || typeName.equals("anyURI") || typeName.equals("base64Binary") || typeName.equals("hexBinary");
    }

    private boolean isIntegerType(String typeName) {
        return typeName.endsWith("yte") || typeName.endsWith("hort") || typeName.endsWith("ong");
    }

    private int calculateBase64CharLength(int decodedLength) {
        int encodedLength = -1;
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.parms.getMappingLevel())) {
            int tmpLAR = decodedLength / 3;
            if (decodedLength % 3 != 0) {
                ++tmpLAR;
            }
            encodedLength = tmpLAR * 4;
        } else {
            int tmpLAR = (decodedLength *= 8) / 6;
            if (decodedLength % 6 != 0) {
                ++tmpLAR;
            }
            encodedLength = tmpLAR;
        }
        return encodedLength;
    }

    private ValueHolder handleVariableMappingStrategy(XSDSimpleTypeDefinition simple, boolean forceVarying, ICM.EncodingType encodingType, ICM.ICMDataType icmDataType, int mappingLevel, int LAR, String typeName, boolean aligned, ICMLevelState currentLevelState, ICM.VaryingLength desiredMapping, boolean variableLengthStrategyOverriden) throws ICMException {
        XSDMinLengthFacet minLF;
        XSDMaxLengthFacet maxLF;
        ICM.VaryingLength variableMappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
        int length = -1;
        boolean charContent = true;
        int lang = this.parms.getLang();
        charContent = icmDataType.equals((Object)ICM.ICMDataType.CHAR_ARRAY);
        if (MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) && !variableLengthStrategyOverriden && LAR > this.parms.getCharVaryingLimit() && !desiredMapping.equals((Object)ICM.VaryingLength.VARYING_NAMED_CONTAINER) && this.parms.allowsContainers()) {
            desiredMapping = ICM.VaryingLength.VARYING_CONTAINER;
        }
        if (desiredMapping.equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY) && variableLengthStrategyOverriden) {
            variableMappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
        }
        if ((maxLF = simple.getEffectiveMaxLengthFacet()) == null) {
            maxLF = simple.getMaxLengthFacet();
        }
        if ((minLF = simple.getEffectiveMinLengthFacet()) == null) {
            minLF = simple.getMinLengthFacet();
        }
        boolean fixedLen = simple.getEffectiveLengthFacet() != null || simple.getLengthFacet() != null;
        boolean sameLen = false;
        if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
            if (maxLF != null && minLF != null && maxLF.getValue() == minLF.getValue()) {
                sameLen = true;
            }
        } else {
            sameLen = false;
        }
        if (!forceVarying && (fixedLen || sameLen)) {
            variableMappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
            desiredMapping = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
        }
        if (variableMappingStrategy.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY) && (LAR > this.parms.getCharVaryingLimit() || !charContent)) {
            variableMappingStrategy = ICM.VaryingLength.VARYING_CONTAINER;
        }
        if (MappingLevelHelper.requiresMappingLevel_1(mappingLevel)) {
            variableMappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
        } else if (!MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
            if (variableMappingStrategy.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY)) {
                variableMappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
            }
        } else {
            if ((variableMappingStrategy.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY) && lang != 3 && lang != 4 || !charContent && LAR <= this.parms.getCharVaryingLimit()) && (desiredMapping.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY) || !variableMappingStrategy.equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY) && !charContent)) {
                desiredMapping = ICM.VaryingLength.VARYING_ARRAY;
            }
            if (charContent && (lang == 3 || lang == 4) && !variableMappingStrategy.equals((Object)ICM.VaryingLength.VARYING_CONTAINER) && desiredMapping.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY)) {
                desiredMapping = ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY;
            }
            switch (desiredMapping) {
                case FIXED_LENGTH_ARRAY: {
                    variableMappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
                    break;
                }
                case NULL_TERMINATED_CHAR_ARRAY: {
                    variableMappingStrategy = ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY;
                    break;
                }
                case VARYING_ARRAY: {
                    variableMappingStrategy = ICM.VaryingLength.VARYING_ARRAY;
                    break;
                }
                case VARYING_NAMED_CONTAINER: {
                    variableMappingStrategy = ICM.VaryingLength.VARYING_NAMED_CONTAINER;
                    break;
                }
            }
            if (variableMappingStrategy.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY)) {
                throw new ICMRuntimeException("Internal Error: mapping strategy undefined. Desired = " + (Object)((Object)desiredMapping));
            }
        }
        switch (variableMappingStrategy) {
            case FIXED_LENGTH_ARRAY: {
                length = LAR;
                int maxLength = 0xFFFFFF;
                if (this.maxCharArraySize != 0xFFFFFE && (lang == 2 || lang == 6 || lang == 7)) {
                    maxLength = Short.MAX_VALUE;
                }
                if (length <= maxLength || !MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) || !this.parms.allowsContainers()) break;
                variableMappingStrategy = ICM.VaryingLength.VARYING_CONTAINER;
                length = 16;
                break;
            }
            case NULL_TERMINATED_CHAR_ARRAY: {
                length = LAR + 1;
                if (encodingType != ICM.EncodingType.SBCS) {
                    ++length;
                }
                if (length <= 0xFFFFFF || !MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) || !this.parms.allowsContainers()) break;
                variableMappingStrategy = ICM.VaryingLength.VARYING_CONTAINER;
                length = 16;
                break;
            }
            case VARYING_ARRAY: {
                length = LAR;
                if (length <= Short.MAX_VALUE || !MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) || !this.parms.allowsContainers()) break;
                variableMappingStrategy = ICM.VaryingLength.VARYING_CONTAINER;
                length = 16;
                break;
            }
            case VARYING_CONTAINER: {
                length = 16;
                charContent = true;
                break;
            }
            case VARYING_NAMED_CONTAINER: {
                length = 0;
                charContent = true;
                break;
            }
        }
        long levelOffset = -1L;
        long newLevelOffset = -1L;
        if (variableMappingStrategy.equals((Object)ICM.VaryingLength.VARYING_ARRAY)) {
            levelOffset = currentLevelState.addShortAlignedEntry(aligned, lang, this.indent, "length for " + typeName);
        }
        newLevelOffset = charContent ? currentLevelState.addCharArrayAlignedEntry(length, lang, this.indent, typeName, variableMappingStrategy) : currentLevelState.addBinaryAlignedEntry(length, lang, this.indent, typeName, variableMappingStrategy);
        if (levelOffset == -1L) {
            levelOffset = newLevelOffset;
        }
        return new ValueHolder(levelOffset, variableMappingStrategy);
    }

    private int getPackedDecimalLength(int totalCharacters) {
        return (totalCharacters + 2) / 2;
    }

    private int getMaxPackedDecimalLength(int language) throws ICMException {
        switch (language) {
            case 1: {
                if (!this.parms.getInputParameters().getProperty("WIDE-COMP3").equalsIgnoreCase("NO")) {
                    return 31;
                }
                return 18;
            }
            case 2: {
                return 31;
            }
            case 6: 
            case 7: {
                return 15;
            }
        }
        throw new ICMException("INTERNAL ERROR: Packed Decimal is not supported for " + ICM.LANGUAGE_TYPES[language]);
    }

    private int getMaxZonedDecimalLength(int language) throws ICMException {
        boolean bottomUp;
        String toolName = this.parms.getInputParameters().getProperty("INTERNAL_TOOLNAME");
        boolean bl = bottomUp = toolName.equals("DFHLS2JS") || toolName.equals("DFHLS2SC") || toolName.equals("DFHLS2WS");
        if (language == 1 && bottomUp) {
            return 31;
        }
        return 18;
    }

    private int processDisplayTypes(XSDSimpleTypeDefinition typed, long maxPermittableValue, int max_LAR, boolean replacementForSuppressedElement) {
        int LAR = 0;
        if (this.parms.getLang() == 1) {
            LAR = this.calculateLARForPictureNumerics(typed, maxPermittableValue, replacementForSuppressedElement);
            if (LAR < 0) {
                if ((LAR = 0 - LAR) > max_LAR) {
                    LAR = max_LAR;
                }
            } else if (LAR > 0) {
                if (LAR > max_LAR) {
                    LAR = max_LAR;
                }
            } else {
                LAR = -1;
            }
        } else {
            LAR = -1;
        }
        return LAR;
    }

    private boolean isOptionalModelGroup(XSDParticle particle, boolean parentIsOptional) {
        if (!(particle.getContent() instanceof XSDModelGroup) && !(particle.getContent() instanceof XSDModelGroupDefinition)) {
            return false;
        }
        if (!MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel())) {
            return false;
        }
        if (particle.getMinOccurs() == 0 && particle.getMaxOccurs() == 1) {
            return true;
        }
        return parentIsOptional;
    }

    private XSDAnnotation processParticle(XSDParticle particle, ICMSchemaParsingState state) throws ICMException {
        XSDElementDeclaration el;
        XSDAnnotation comments = null;
        boolean parentConstructIsOptional = state.getForceOptional() || state.getOptionalModelGroup();
        boolean structural = this.isStructuralElement(particle, parentConstructIsOptional, state);
        boolean mixedContent = this.isMixedContent(particle, state.getDelegate());
        boolean optionalModelGroup = false;
        if (this.isOptionalModelGroup(particle, parentConstructIsOptional)) {
            optionalModelGroup = true;
            this.doindent(this.indent);
            this.getLogger().println("Optional ModelGroup");
        }
        if (this.isTrace()) {
            this.doindent(this.indent);
            if (!state.getTreatAsStructure()) {
                this.getLogger().println("Particle must appear " + particle.getMinOccurs() + " to " + particle.getMaxOccurs() + " times.");
            } else {
                this.getLogger().println("Struture");
            }
            this.doindent(this.indent);
            this.logger.println("is structural: " + structural);
            this.doindent(this.indent);
            this.logger.println("is mixed: " + mixedContent);
            this.doindent(this.indent);
            this.logger.println("suppress padding message: " + state.getSupressSuffixedPaddingMessage());
        }
        boolean cicsStructuredContainer = false;
        if (particle.getContent() != null && particle.getContent() instanceof XSDElementDeclaration && (el = (XSDElementDeclaration)particle.getContent()).getTypeDefinition() != null && el.getTypeDefinition().getBaseType() != null && "http://www.ibm.com/xmlns/prod/CICS/channel-instance".equals(el.getTypeDefinition().getBaseType().getTargetNamespace()) && "structuredContainerTypeWithAttribute".equals(el.getTypeDefinition().getBaseType().getName())) {
            cicsStructuredContainer = true;
        }
        String odo = null;
        String truncatable = null;
        if (particle.getContent() instanceof XSDElementDeclaration) {
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(((XSDElementDeclaration)particle.getContent()).getAnnotation(), this.logger);
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.parms.getMappingLevel())) {
                String multiType = p.getProperty("com.ibm.cics.wsdl.properties.multitype");
                if (multiType != null && multiType.equals("true")) {
                    state.setMultiTypeElement(true);
                } else {
                    state.setMultiTypeElement(false);
                }
                this.doindent(this.indent);
                this.getLogger().println("is JSON multi-typed element: " + state.isMultiTypeElement());
            }
            odo = p.getProperty("com.ibm.cics.wsdl.properties.odo");
            truncatable = p.getProperty("com.ibm.cics.wsdl.properties.truncateOnNull");
            String optionalArrayProperty = p.getProperty("com.ibm.cics.wsdl.properties.optionalarray");
            if (optionalArrayProperty != null && optionalArrayProperty.equals("true")) {
                state.setOptionalArray(true);
            } else {
                state.setOptionalArray(false);
            }
            this.doindent(this.indent);
            this.getLogger().println("is optional array: " + state.isOptionalArray());
        }
        if (particle.getMinOccurs() == particle.getMaxOccurs() && particle.getMinOccurs() > 1 && !parentConstructIsOptional && !cicsStructuredContainer || structural && !cicsStructuredContainer || state.getTreatAsStructure() || odo != null || "true".equals(truncatable)) {
            boolean localMixedContent = state.getMixedContent();
            state.setMixedContent(mixedContent);
            boolean localInlineVarying = state.getInLineVariablyRepeating();
            state.setInLineVariablyRepeating(false);
            long localOffsetCountField = state.getOffsetOfCountField();
            state.setOffsetOfCountField(0L);
            comments = this.processAnArray(particle, state);
            state.setMixedContent(localMixedContent);
            state.setInLineVariablyRepeating(localInlineVarying);
            state.setOffsetOfCountField(localOffsetCountField);
        } else if ((particle.getMinOccurs() != particle.getMaxOccurs() || parentConstructIsOptional || cicsStructuredContainer) && !optionalModelGroup) {
            boolean localMixedContent = state.getMixedContent();
            state.setMixedContent(mixedContent);
            comments = this.processAList(particle, state);
            state.setMixedContent(localMixedContent);
        } else if (particle.getMaxOccurs() != 0 || optionalModelGroup) {
            boolean localOptionalModelGroup = state.getOptionalModelGroup();
            state.setOptionalModelGroup(optionalModelGroup);
            comments = this.processParticleIgnoreCardinality(particle, state);
            state.setOptionalModelGroup(localOptionalModelGroup);
        }
        return comments;
    }

    private XSDAnnotation processAList(XSDParticle particle, ICMSchemaParsingState state) throws ICMException {
        XSDAnnotation comments = null;
        String simpleNamedContainer = null;
        String structuralNamedContainer = null;
        boolean innerArray = false;
        if (particle.getContent() != null && particle.getContent() instanceof XSDElementDeclaration) {
            XSDElementDeclaration el = (XSDElementDeclaration)particle.getContent();
            if (el.getTypeDefinition() != null && el.getTypeDefinition().getBaseType() != null && "http://www.ibm.com/xmlns/prod/CICS/channel-instance".equals(el.getTypeDefinition().getBaseType().getTargetNamespace())) {
                if ("structuredContainerTypeWithAttribute".equals(el.getTypeDefinition().getBaseType().getName())) {
                    structuralNamedContainer = el.getName();
                } else {
                    simpleNamedContainer = el.getName();
                }
            }
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(((XSDElementDeclaration)particle.getContent()).getAnnotation(), this.logger);
            innerArray = "true".equalsIgnoreCase(p.getProperty("com.ibm.cics.wsdl.properties.innerArray"));
        }
        int lang = this.parms.getLang();
        long start = state.getCurrentLevelState().getAbsoluteOffset();
        if (simpleNamedContainer == null && structuralNamedContainer == null) {
            start = state.getCurrentLevelState().addIntAlignedEntry(this.isAligned(lang), lang, this.indent, "instances count field");
        }
        if (MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel()) && particle.getMaxOccurs() != -1 && particle.getMaxOccurs() <= this.parms.getInlineMaxOccursLimit() && simpleNamedContainer == null && structuralNamedContainer == null) {
            boolean localInlineVarRepeatingValue = state.getInLineVariablyRepeating();
            state.setInLineVariablyRepeating(true);
            long localOffsetOfCountField = state.getOffsetOfCountField();
            state.setOffsetOfCountField(start);
            comments = this.processAnArray(particle, state);
            state.setInLineVariablyRepeating(localInlineVarRepeatingValue);
            state.setOffsetOfCountField(localOffsetOfCountField);
        } else {
            String elementName = this.getElementName(particle, state.getDelegate(), state.getTypeName());
            String nameSpaceName = this.getElementNameSpace(particle, state.getDelegate(), state.getTypeName());
            if (simpleNamedContainer == null && structuralNamedContainer == null) {
                state.getCurrentLevelState().addCharArrayAlignedEntry(16, lang, this.indent, "container name field", ICM.VaryingLength.NO_VARYING_STRATEGY);
            }
            StringBuilder tmp = new StringBuilder(state.getXpath().toString());
            this.extendXPATH(tmp, nameSpaceName, elementName);
            String newXpath = tmp.toString();
            ICMRepeatEntryImpl entry = this.ich.addVariableRepeatsEntry(particle.getMaxOccurs(), particle.getMinOccurs(), state.getForceOptional(), newXpath, this.ich.getSimpleXpath(newXpath), start, state.getTotalChoices(), state.getThisChoice(), state.getMixedContent(), state.getOptionalModelGroup(), simpleNamedContainer, structuralNamedContainer, state.isOptionalArray(), innerArray);
            boolean localSuppressPaddingMessage = state.getSupressSuffixedPaddingMessage();
            state.setSupressSuffixedPaddingMessage(true);
            ProcessRepeatICMEntryReturnType returnVal = this.processRepeatICMEntry(entry, particle, state, 0L);
            comments = returnVal.getComments();
            state.setSupressSuffixedPaddingMessage(localSuppressPaddingMessage);
        }
        return comments;
    }

    private XSDAnnotation processAnArray(XSDParticle particle, ICMSchemaParsingState state) throws ICMException {
        XSDAnnotation comments = null;
        String elementName = this.getElementName(particle, state.getDelegate(), state.getTypeName());
        String nameSpaceName = this.getElementNameSpace(particle, state.getDelegate(), state.getTypeName());
        String newXpath = state.getXpath().toString();
        int occurs = particle.getMaxOccurs();
        if (state.getTreatAsStructure()) {
            occurs = 1;
        }
        boolean localSuppressPaddingMessage = state.getSupressSuffixedPaddingMessage();
        if (occurs > 1) {
            state.setSupressSuffixedPaddingMessage(false);
        }
        StringBuilder tmp = new StringBuilder(state.getXpath().toString());
        this.extendXPATH(tmp, nameSpaceName, elementName);
        newXpath = tmp.toString();
        ICMSlackBytesElementEntryImpl odoTarget = null;
        boolean truncatableArray = false;
        String truncatableValues = null;
        boolean innerArray = false;
        if (occurs > 1 && particle.getContent() != null && particle.getContent() instanceof XSDElementDeclaration) {
            String truncation;
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(((XSDElementDeclaration)particle.getContent()).getAnnotation(), this.logger);
            String odoTargetName = p.getProperty("com.ibm.cics.wsdl.properties.odo");
            if (odoTargetName != null && MappingLevelHelper.supportsMappingLevel_4_0(this.parms.getMappingLevel()) && this.parms.getLang() == 1) {
                odoTarget = this.findOdoTarget(odoTargetName);
            }
            if ("true".equals(truncation = p.getProperty("com.ibm.cics.wsdl.properties.truncateOnNull")) && MappingLevelHelper.supportsMappingLevel_4_1(this.parms.getMappingLevel())) {
                truncatableArray = true;
            }
            truncatableValues = p.getProperty("com.ibm.cics.wsdl.properties.truncateValues");
            innerArray = "true".equalsIgnoreCase(p.getProperty("com.ibm.cics.wsdl.properties.innerArray"));
        }
        ICMFixedRepeatEntryImpl entry = null;
        entry = !state.getReplacementForSuppressedElement() ? this.ich.addFixedRepeatsEntry(occurs, newXpath, this.ich.getSimpleXpath(newXpath), state.getCurrentLevelState().getTotalLength(), state.getMixedContent(), state.getInLineVariablyRepeating(), particle.getMinOccurs(), particle.getMaxOccurs(), state.getThisChoice(), state.getTotalChoices(), state.getOptionalModelGroup(), state.getOffsetOfCountField(), odoTarget, truncatableArray, truncatableValues, state.isOptionalArray(), innerArray, state.isMultiTypeElement()) : this.ich.addSlackBytesFixedRepeatsEntry(occurs, newXpath, this.ich.getSimpleXpath(newXpath), state.getCurrentLevelState().getTotalLength(), state.getMixedContent());
        ProcessRepeatICMEntryReturnType returnVal = this.processRepeatICMEntry(entry, particle, state, state.getCurrentLevelState().getAbsoluteOffset());
        long length = returnVal.getLength();
        comments = returnVal.getComments();
        if (length != 0L && (long)occurs > Long.MAX_VALUE / length) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9741E", new Object[]{elementName, Long.MAX_VALUE}));
        }
        state.getCurrentLevelState().addBinaryAlignedEntry(length * (long)occurs, this.parms.getLang(), this.indent, "space for an array", ICM.VaryingLength.NO_VARYING_STRATEGY);
        state.setSupressSuffixedPaddingMessage(localSuppressPaddingMessage);
        return comments;
    }

    private boolean isStructuralElement(XSDParticle particle, boolean forceOptional, ICMSchemaParsingState state) throws ICMException {
        boolean returnType = false;
        XSDElementDeclaration delegate = state.getDelegate();
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.getLogger().print("  in isStructuralElement(particle, " + forceOptional + ") content is of type: ");
            if (delegate != null) {
                this.getLogger().println(delegate.getResolvedElementDeclaration().getClass().getName());
            } else {
                this.logger.println(particle.getContent().getClass().getName());
            }
        }
        if (forceOptional) {
            return false;
        }
        if (particle.getContent() instanceof XSDElementDeclaration || delegate != null) {
            XSDComplexTypeDefinition typeDef;
            XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
            if (delegate != null) {
                element = delegate;
            }
            element = element.getResolvedElementDeclaration();
            int minOccurs = particle.getMinOccurs();
            int maxOccurs = particle.getMaxOccurs();
            boolean isComplex = false;
            if (element.getTypeDefinition() instanceof XSDComplexTypeDefinition && this.isStructuralComplexType(typeDef = (XSDComplexTypeDefinition)element.getTypeDefinition()) && !this.isAbstract_2_2(typeDef)) {
                isComplex = true;
            }
            if (element.getSubstitutionGroup().size() > 1 && element != state.getCurrentSubstitutionGroup()) {
                isComplex = false;
            }
            if (this.isTrace()) {
                this.getLogger().println("   minOccurs = " + minOccurs + " maxOccurs = " + maxOccurs + " isComplex = " + isComplex + " delegate = " + delegate);
            }
            returnType = minOccurs == 1 && maxOccurs == 1 && isComplex;
        } else {
            returnType = false;
        }
        return returnType;
    }

    private boolean isMixedContent(XSDParticle particle, XSDElementDeclaration delegate) {
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.getLogger().print("  in isMixedContent(particle) content is of type: ");
            if (delegate != null) {
                this.getLogger().println(delegate.getResolvedElementDeclaration().getClass().getName());
            } else {
                this.logger.println(particle.getContent().getClass().getName());
            }
        }
        if (particle.getContent() instanceof XSDElementDeclaration || delegate != null) {
            XSDTypeDefinition type;
            XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
            if (delegate != null) {
                element = delegate;
            }
            if ((type = (element = element.getResolvedElementDeclaration()).getTypeDefinition()) instanceof XSDComplexTypeDefinition) {
                return ((XSDComplexTypeDefinition)type).isMixed();
            }
        }
        return false;
    }

    private boolean isRepeatingStructuralElement(XSDParticle particle, XSDElementDeclaration delegate) throws ICMException {
        XSDComplexTypeDefinition typeDef;
        XSDElementDeclaration target = null;
        if (delegate != null) {
            target = delegate;
        } else if (particle.getContent() instanceof XSDElementDeclaration) {
            target = (XSDElementDeclaration)particle.getContent();
        } else {
            return false;
        }
        target = target.getResolvedElementDeclaration();
        if (target.getSubstitutionGroup().size() > 1) {
            return false;
        }
        boolean complexContent = false;
        if (target.getResolvedElementDeclaration().getTypeDefinition() instanceof XSDComplexTypeDefinition && this.isStructuralComplexType(typeDef = (XSDComplexTypeDefinition)target.getResolvedElementDeclaration().getTypeDefinition()) && !this.isAbstract_2_2(typeDef)) {
            complexContent = true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_1_2(this.parms.getMappingLevel())) {
            return particle.getMaxOccurs() > 1 && complexContent;
        }
        return (particle.getMaxOccurs() != particle.getMinOccurs() || particle.getMaxOccurs() > 1) && complexContent;
    }

    private ProcessRepeatICMEntryReturnType processRepeatICMEntry(ICMRepeatEntryImpl repeat, XSDParticle particle, ICMSchemaParsingState state, long newLevelState) throws ICMException {
        XSDWildcard wc;
        Properties p;
        int slackBytesNeeded;
        ICMLevelState localLevelState;
        int mappingLevel;
        String elementName;
        state.setRepeat(repeat);
        String xmlName = elementName = this.getElementName(particle, state.getDelegate(), state.getTypeName());
        if (!state.getReplacementForSuppressedElement()) {
            xmlName = state.getCurrentLevelState().getTemplate().addVariable(null, null, elementName);
        }
        if (!MappingLevelHelper.supportsMappingLevel_2(mappingLevel = this.parms.getMappingLevel())) {
            elementName = xmlName;
        }
        String defNS = state.getCurrentLevelState().getTemplate().getCurrentDefaultNameSpace();
        ICMLevelState newLogicalLevel = null;
        boolean paddingBeforeStructure = false;
        int lang = this.parms.getLang();
        if (lang == 3 || lang == 4) {
            paddingBeforeStructure = true;
        }
        boolean pushBackSlackBytes = false;
        if (lang == 1) {
            pushBackSlackBytes = true;
        }
        newLogicalLevel = paddingBeforeStructure ? new ICMLevelState(0L, false, this.trace, this.logger, this.indent, mappingLevel, defNS, pushBackSlackBytes, this.parms) : new ICMLevelState(newLevelState, state.getSupressSuffixedPaddingMessage(), this.trace, this.logger, this.indent, mappingLevel, defNS, pushBackSlackBytes, this.parms);
        XSDAnnotation comments = null;
        if (!state.getTreatAsStructure() && this.isRepeatingStructuralElement(particle, state.getDelegate())) {
            localLevelState = state.getCurrentLevelState();
            state.setCurrentLevelState(newLogicalLevel);
            boolean localTreatAsStructure = state.getTreatAsStructure();
            state.setTreatAsStructure(true);
            boolean localForceOptional = state.getForceOptional();
            state.setForceOptional(false);
            int localTotalChoices = state.getTotalChoices();
            state.setTotalChoices(0);
            int localThisChoice = state.getThisChoice();
            state.setThisChoice(0);
            boolean localOptionalModelGroup = state.getOptionalModelGroup();
            state.setOptionalModelGroup(false);
            comments = this.processParticle(particle, state);
            state.setCurrentLevelState(localLevelState);
            state.setTreatAsStructure(localTreatAsStructure);
            state.setForceOptional(localForceOptional);
            state.setTotalChoices(localTotalChoices);
            state.setThisChoice(localThisChoice);
            state.setOptionalModelGroup(localOptionalModelGroup);
        } else {
            localLevelState = state.getCurrentLevelState();
            state.setCurrentLevelState(newLogicalLevel);
            boolean localOptionalModelGroup = state.getOptionalModelGroup();
            state.setOptionalModelGroup(false);
            comments = this.processParticleIgnoreCardinality(particle, state);
            state.setCurrentLevelState(localLevelState);
            state.setOptionalModelGroup(localOptionalModelGroup);
        }
        if (repeat instanceof ICMFixedRepeatEntry) {
            state.getCurrentLevelState().setAlignment(newLogicalLevel.getAlignment());
        }
        if ((slackBytesNeeded = (int)newLogicalLevel.getSuffixSlackBytesNeeded(lang, xmlName)) > 0 && (particle.getMaxOccurs() > 1 || particle.getMaxOccurs() == -1 || lang != 1)) {
            this.ich.addSlackBytesDataElement(slackBytesNeeded, newLogicalLevel.getTotalLength());
        }
        if (paddingBeforeStructure) {
            slackBytesNeeded = (int)newLogicalLevel.getPrefixSlackBytesNeeded(lang, newLevelState, xmlName);
            if (state.getCurrentLevelState().updateOffset(slackBytesNeeded)) {
                repeat.setOffsetIntoStructure(repeat.getOffsetIntoStructure() + (long)slackBytesNeeded);
            }
        }
        if (pushBackSlackBytes && (slackBytesNeeded = (int)newLogicalLevel.getPushBackBytes()) > 0 && state.getCurrentLevelState().updateOffset(slackBytesNeeded)) {
            repeat.setOffsetIntoStructure(repeat.getOffsetIntoStructure() + (long)slackBytesNeeded);
        }
        if (particle.getMaxOccurs() == 1 && lang == 1) {
            repeat.setStructureSize(newLogicalLevel.getTotalLength());
        } else {
            repeat.setStructureSize(newLogicalLevel.getTotalLengthForArray(lang, xmlName));
        }
        repeat.setXmlTemplate(newLogicalLevel.getTemplate());
        repeat.setXMLTemplateVariableName("&" + xmlName + ";");
        String structureName = elementName;
        if (particle.getContent() instanceof XSDWildcard && "true".equals((p = ICMBuilderImpl.getAnnotationsAsProperties((wc = (XSDWildcard)particle.getContent()).getAnnotation(), this.logger)).getProperty("com.ibm.cics.wsdl.properties.jsonAny"))) {
            structureName = structureName + "-props";
        }
        Properties inputParameters = this.parms.getInputParameters();
        structureName = (this.parms.getLang() == 2 || this.parms.getLang() == 1) && inputParameters.getProperty("NO-ARRAY-NAME-INDEXING") != null && inputParameters.getProperty("NO-ARRAY-NAME-INDEXING") == "YES" ? UniqueNameGenerator.ensureUnique(this.allStructures, structureName, true, mappingLevel, false, !state.getTreatAsStructure(), state.getXpath().toString()).getName() : UniqueNameGenerator.ensureUnique(this.allStructures, structureName, true, mappingLevel, false).getName();
        repeat.setStructureName(structureName);
        if (!state.getReplacementForSuppressedElement()) {
            this.ich.addEndRepeatsEntry(repeat);
        } else {
            this.ich.addSlackBytesEndRepeatsEntry(repeat);
        }
        state.setRepeat(null);
        ProcessRepeatICMEntryReturnType returnVar = new ProcessRepeatICMEntryReturnType(repeat.getStructureSize(), comments);
        return returnVar;
    }

    private String getElementName(XSDParticle particle, XSDElementDeclaration delegate, String typeName) throws ICMException {
        XSDElementDeclaration ed = this.getEffectiveElement(particle, delegate, typeName);
        if (ed == null) {
            return typeName;
        }
        if (ed.getName().startsWith("DFH_SURROGATE_NAME_")) {
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(ed.getAnnotation(), this.logger);
            return p.getProperty("com.ibm.cics.wsdl.properties.surrogateName");
        }
        return ed.getName();
    }

    private String getElementNameSpace(XSDParticle particle, XSDElementDeclaration delegate, String typeName) throws ICMException {
        XSDElementDeclaration ed = this.getEffectiveElement(particle, delegate, typeName);
        if (ed == null) {
            return "";
        }
        return ed.getTargetNamespace();
    }

    private XSDElementDeclaration getEffectiveElement(XSDParticle particle, XSDElementDeclaration delegate, String typeName) throws ICMException {
        XSDElementDeclaration effectiveElement = null;
        if (delegate != null) {
            effectiveElement = delegate.getResolvedElementDeclaration();
        } else if (particle.getContent() instanceof XSDElementDeclaration) {
            effectiveElement = (XSDElementDeclaration)particle.getContent();
            effectiveElement = effectiveElement.getResolvedElementDeclaration();
        } else if (particle.getContent() instanceof XSDWildcard) {
            if (!MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel())) {
                throw new ICMException(MessageHandler.getMessage("DFHPI9012E"));
            }
        } else {
            if (particle.getContent() instanceof XSDModelGroup) {
                throw new ICMException(MessageHandler.buildMessage("DFHPI9013E", new Object[]{typeName}));
            }
            throw new ICMException(MessageHandler.buildMessage("DFHPI9013E", new Object[]{particle.getContent().getClass()}));
        }
        return effectiveElement;
    }

    private void consumeAttributes(List<XSDAttributeUse> attrsList, ICMLevelState currentLevelState, boolean nillable) throws ICMException {
        if (nillable) {
            this.addNillableAttr(currentLevelState);
        }
        for (XSDAttributeUse attr : attrsList) {
            String localName = attr.getAttributeDeclaration().getName();
            String nameSpace = attr.getAttributeDeclaration().getTargetNamespace();
            boolean optional = attr.getUse().getValue() == 0;
            XSDConstraint tmp = null;
            String defaultVal = null;
            boolean fixed = false;
            tmp = attr.getConstraint();
            if (tmp != null) {
                if (attr.getLexicalValue() != null) {
                    defaultVal = attr.getLexicalValue();
                }
                if (tmp.getValue() == 1) {
                    fixed = true;
                }
            }
            boolean implied = optional & defaultVal == null;
            boolean contentType = false;
            if (XMIME_NS.equals(nameSpace) && XMIME_LOCAL.equals(localName)) {
                contentType = true;
            }
            this.addAttribute(currentLevelState, localName, nameSpace, implied, optional, fixed, false, contentType, defaultVal, attr.getAttributeDeclaration().getTypeDefinition());
        }
    }

    private void addAttribute(ICMLevelState currentLevelState, String localName, String nameSpace, boolean implied, boolean optional, boolean fixed, boolean nillable, boolean contentType, String defaultVal, XSDSimpleTypeDefinition valueType) throws ICMException {
        ICMAttributeEntryImpl attrEntry;
        long levelOffset = -1L;
        if (implied) {
            levelOffset = currentLevelState.addBooleanAlignedEntry(this.isAligned(this.parms.getLang()), this.parms.getLang(), this.indent, "attribute existence byte");
        }
        StringBuilder nsPrefix = new StringBuilder();
        String xmlAttributeTemplateLocation = currentLevelState.getTemplate().addAttribute(localName, nameSpace, nsPrefix);
        String nsPrefixStr = nsPrefix.toString();
        String prefix = null;
        prefix = "".equals(nsPrefixStr) ? " " + localName + "=\"" : " " + nsPrefixStr + ":" + localName + "=\"";
        boolean nameSpaceRelevant = true;
        if (nameSpace == null) {
            nameSpaceRelevant = false;
        }
        if ((attrEntry = this.ich.addAttributeEntry(localName, nameSpace, levelOffset, optional, prefix, nameSpaceRelevant, fixed, implied, nillable, contentType)) != null) {
            ICMSchemaParsingState state = new ICMSchemaParsingState();
            state.setCurrentLevelState(currentLevelState);
            state.setTypeName(localName);
            state.setTypeNameSpace(nameSpace);
            state.setDefaultValue(defaultVal);
            this.processSimpleType(valueType, state, true, xmlAttributeTemplateLocation, null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XSDAnnotation processParticleIgnoreCardinality(XSDParticle particle, ICMSchemaParsingState state) throws ICMException {
        XSDAnnotation comments = null;
        if (particle.getContent() instanceof XSDModelGroup) {
            XSDModelGroup mg = (XSDModelGroup)particle.getContent();
            ++this.indent;
            this.processModelGroup(mg, state, null);
            --this.indent;
            return comments;
        } else if (particle.getContent() instanceof XSDWildcard) {
            XSDWildcard wc = (XSDWildcard)particle.getContent();
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(wc.getAnnotation(), this.logger);
            if (!MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel())) throw new ICMException(MessageHandler.getMessage("DFHPI9012E"));
            String jsonAny = p.getProperty("com.ibm.cics.wsdl.properties.jsonAny");
            if ("true".equalsIgnoreCase(jsonAny)) {
                this.processRawXMLElement(ICMRawXMLElementEntry.AnyType.JSON_PROPERTY, state);
                return comments;
            } else {
                this.processRawXMLElement(ICMRawXMLElementEntry.AnyType.any, state);
            }
            return comments;
        } else {
            if (particle.getContent() instanceof XSDElementDeclaration || state.getDelegate() != null) {
                XSDElementDeclaration ed = (XSDElementDeclaration)particle.getContent();
                if (state.getDelegate() != null) {
                    ed = state.getDelegate();
                }
                this.processElementDeclaration(ed.getResolvedElementDeclaration(), state);
                return ed.getAnnotation();
            }
            if (!(particle.getContent() instanceof XSDModelGroupDefinition)) throw new ICMException(MessageHandler.buildMessage("DFHPI9015E", new Object[]{particle.getContent()}));
            XSDModelGroupDefinition mgd = (XSDModelGroupDefinition)particle.getContent();
            if (mgd.getResolvedModelGroupDefinition() != null) {
                mgd = mgd.getResolvedModelGroupDefinition();
            }
            if (mgd.getModelGroup() == null) throw new ICMException(MessageHandler.buildMessage("DFHPI9014E", new Object[]{mgd.getURI()}));
            this.processModelGroup(mgd.getModelGroup(), state, mgd.getName());
        }
        return comments;
    }

    private List<XSDElementDeclaration> findValidSubstitutions(XSDElementDeclaration ed, ICMSchemaParsingState state) {
        ArrayList<XSDElementDeclaration> subGroups = new ArrayList<XSDElementDeclaration>();
        if (ed.getSubstitutionGroup() == null) {
            return subGroups;
        }
        if (ed.getSubstitutionGroup().contains((Object)state.getCurrentSubstitutionGroup())) {
            return subGroups;
        }
        for (XSDElementDeclaration sgElement : ed.getSubstitutionGroup()) {
            if (sgElement.isAbstract()) continue;
            subGroups.add(sgElement);
        }
        if (subGroups.size() == 1 && subGroups.contains(ed)) {
            subGroups.clear();
        }
        Collections.sort(subGroups, ELEMENT_NAME_COMPARATOR);
        if (subGroups.contains(ed)) {
            subGroups.remove(ed);
            subGroups.add(0, ed);
        }
        return subGroups;
    }

    private boolean processSubstitutiongroup(XSDElementDeclaration ed, ICMSchemaParsingState state) throws ICMException {
        Iterator<XSDElementDeclaration> subs = this.findValidSubstitutions(ed, state).iterator();
        if (subs.hasNext()) {
            if (MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel())) {
                XSDFactory xsdFactory = XSDFactory.eINSTANCE;
                XSDModelGroup modelGroup = xsdFactory.createXSDModelGroup();
                modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
                while (subs.hasNext()) {
                    XSDElementDeclaration sgElement = subs.next();
                    XSDElementDeclaration sgRefElement = xsdFactory.createXSDElementDeclaration();
                    sgRefElement.setResolvedElementDeclaration(sgElement);
                    XSDParticle particle = xsdFactory.createXSDParticle();
                    particle.setContent(sgRefElement);
                    modelGroup.getContents().add((Object)particle);
                }
                if (ed.isAbstract()) {
                    StringBuilder tempXpath = new StringBuilder(state.getXpath());
                    this.extendXPATH(tempXpath, ed.getTargetNamespace(), ed.getName());
                    this.ich.setRepeatEntryNonStructural(tempXpath);
                }
                XSDElementDeclaration delegate = state.getDelegate();
                state.setDelegate(null);
                XSDElementDeclaration localSG = state.getCurrentSubstitutionGroup();
                state.setCurrentSubstitutionGroup(ed);
                state.setTypeName(ed.getName());
                this.processModelGroup(modelGroup, state, ed.getName());
                state.setDelegate(delegate);
                state.setCurrentSubstitutionGroup(localSG);
                return true;
            }
            while (subs.hasNext()) {
                XSDElementDeclaration sub = subs.next();
                if (sub == ed) continue;
                throw new ICMException(MessageHandler.buildMessage("DFHPI9017E", new Object[]{"substitutionGroup", ed.getName()}));
            }
        }
        return false;
    }

    private void processElementDeclaration(XSDElementDeclaration ed, ICMSchemaParsingState state) throws ICMException {
        XSDComplexTypeDefinition typed;
        XSDTypeDefinition type;
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.logger.println("Processing element: " + ed.getURI() + " type namespace: " + state.getTypeNameSpace());
        }
        if (!state.getSyntheticElement() && ed.getElement() == null && !state.getReplacementForSuppressedElement()) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9016E", new Object[]{ed.getURI()}));
        }
        if (!this.choiceElementName.empty()) {
            StringBuilder buf = this.choiceElementName.peek();
            buf.replace(0, buf.length(), ed.getName());
        }
        if (this.processSubstitutiongroup(ed, state)) {
            return;
        }
        String nameSpace = ed.getTargetNamespace();
        String elementLocalName = ed.getName();
        if (elementLocalName.startsWith("DFH_SURROGATE_NAME_")) {
            Properties p = ICMBuilderImpl.getAnnotationsAsProperties(ed.getAnnotation(), this.logger);
            elementLocalName = p.getProperty("com.ibm.cics.wsdl.properties.surrogateName");
        }
        String xmlTagNamespace = null;
        String xmlTagLocalName = null;
        if (state.getXsiType() == null) {
            xmlTagNamespace = nameSpace;
            xmlTagLocalName = elementLocalName;
        } else {
            xmlTagNamespace = "&nmsp;";
            xmlTagLocalName = "&elName;";
        }
        if (!(state.getReplacementForSuppressedElement() || this.hasAnyType(ed) || this.isAbstract_2_2(ed.getTypeDefinition()))) {
            state.getCurrentLevelState().getTemplate().addStartTag(xmlTagNamespace, xmlTagLocalName, true, state.getXsiType());
        }
        if (ed.isAbstract()) {
            if (MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel())) {
                String localTypeName = state.getTypeName();
                state.setTypeName(elementLocalName);
                this.processRawXMLElement(ICMRawXMLElementEntry.AnyType.any, state);
                state.setTypeName(localTypeName);
            } else {
                throw new ICMException(MessageHandler.buildMessage("DFHPI9017E", new Object[]{"abstract", elementLocalName}));
            }
        }
        this.extendXPATH(state.getXpath(), ed.getTargetNamespace(), elementLocalName);
        String localDefaultValue = state.getDefaultValue();
        if (ed.getConstraint().getValue() == 0 && ed.getValue() != null) {
            state.setDefaultValue(ed.getValue().toString());
        }
        if (ed.getConstraint().getValue() == 1 && ed.getValue() != null) {
            if (MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel())) {
                state.setDefaultValue(ed.getValue().toString());
            } else {
                throw new ICMException(MessageHandler.buildMessage("DFHPI9017E", new Object[]{"fixed", elementLocalName}));
            }
        }
        if ((type = ed.getTypeDefinition()) == null) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9018E", new Object[]{ed.getURI()}));
        }
        if (type instanceof XSDComplexTypeDefinition && (typed = (XSDComplexTypeDefinition)type).isAbstract() && !MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel())) {
            this.warnings.add(MessageHandler.buildMessage("DFHPI9036W", new Object[]{typed.getName(), elementLocalName}));
        }
        if (!ed.isAbstract()) {
            String localTypeName = state.getTypeName();
            state.setTypeName(elementLocalName);
            String localNameSpace = state.getTypeNameSpace();
            state.setTypeNameSpace(nameSpace);
            boolean localNillable = ed.isNillable();
            state.setNillable(ed.isNillable());
            ArrayList<String> annotations = new ArrayList<String>();
            if (ed.getAnnotation() != null) {
                XSDAnnotation annotation = ed.getAnnotation();
                for (Element item : annotation.getUserInformation()) {
                    StringBuffer sb = new StringBuffer();
                    this.accumulateText(item.getChildNodes(), sb);
                    String comment = sb.toString().trim();
                    if (!comment.endsWith(".")) {
                        comment = comment + ".";
                    }
                    annotations.add(comment);
                }
            }
            this.processTypeDef(type, state, annotations);
            state.setTypeName(localTypeName);
            state.setTypeNameSpace(localNameSpace);
            state.setNillable(localNillable);
        }
        state.getXpath().replace(state.getXpath().lastIndexOf("+++"), state.getXpath().length(), "");
        if (!(state.getReplacementForSuppressedElement() || this.hasAnyType(ed) || this.isAbstract_2_2(ed.getTypeDefinition()))) {
            if (ed.isGlobal()) {
                state.getCurrentLevelState().getTemplate().addEndTag(xmlTagNamespace, xmlTagLocalName, true);
            } else {
                state.getCurrentLevelState().getTemplate().addEndTag(null, xmlTagLocalName, false);
            }
        }
        state.setDefaultValue(localDefaultValue);
    }

    private void accumulateText(NodeList nodes, StringBuffer output) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nextChild = nodes.item(i);
            if (nextChild.getNodeType() == 3) {
                output.append(" ");
                output.append(nextChild.getNodeValue());
                continue;
            }
            if (!nextChild.hasChildNodes()) continue;
            this.accumulateText(nextChild.getChildNodes(), output);
        }
    }

    private void handleSuppressionComments(XSDAnnotation annotation, ICMLevelState currentLevelState, StringBuilder xpath) throws ICMException {
        if (annotation == null) {
            return;
        }
        Properties p = ICMBuilderImpl.getAnnotationsAsProperties(annotation, this.logger);
        ICMImplToWSDL wsdlCreator = new ICMImplToWSDL(annotation.getSchema(), this.parms);
        int annotationNum = 1;
        String currentCommentName = "com.ibm.cics.wsdl.properties.suppressedField" + annotationNum;
        LinkedList<XSDParticle> suppressedFieldsList = new LinkedList<XSDParticle>();
        LinkedList<Properties> suppressedFieldsPropertiesList = new LinkedList<Properties>();
        LinkedList<XSDModelGroup> suppressedStructuralFields = new LinkedList<XSDModelGroup>();
        while (p.containsKey(currentCommentName)) {
            String commentValue = p.getProperty(currentCommentName);
            XSDParticle suppressedParticle = null;
            XSDModelGroup newModelGroup = null;
            StringTokenizer st = new StringTokenizer(commentValue, ",=");
            String token = st.nextToken();
            if ("DE".equals(token)) {
                Properties props = new Properties();
                suppressedFieldsPropertiesList.add(props);
                suppressedParticle = wsdlCreator.createDataElementFromSuppressionString(st, props);
            } else if ("FR".equals(token)) {
                suppressedParticle = wsdlCreator.createFixedRepeatFromSuppressionString(st);
                newModelGroup = wsdlCreator.getCurrentModelGroup();
            } else if ("ST".equals(token)) {
                suppressedParticle = wsdlCreator.createStructuralFromSuppressionString();
                newModelGroup = wsdlCreator.getCurrentModelGroup();
            } else if ("ER".equals(token)) {
                suppressedStructuralFields.remove(suppressedStructuralFields.size() - 1);
            } else {
                throw new ICMRuntimeException("INTERNAL ERROR: bad suppression type " + token);
            }
            if (suppressedParticle != null) {
                if (suppressedStructuralFields.isEmpty()) {
                    suppressedFieldsList.add(suppressedParticle);
                } else {
                    XSDModelGroup parentStructure = (XSDModelGroup)suppressedStructuralFields.get(suppressedStructuralFields.size() - 1);
                    parentStructure.getContents().add((Object)suppressedParticle);
                }
            }
            if (newModelGroup != null) {
                suppressedStructuralFields.add(newModelGroup);
            }
            currentCommentName = "com.ibm.cics.wsdl.properties.suppressedField" + ++annotationNum;
        }
        for (XSDParticle currentParticle : suppressedFieldsList) {
            ICMSchemaParsingState state = new ICMSchemaParsingState();
            state.setCurrentLevelState(currentLevelState);
            state.setTypeName("**filler**");
            state.setXpath(xpath);
            state.setTotalChoices(-1);
            state.setThisChoice(-1);
            state.setReplacementForSuppressedElement(true);
            state.setOverRideProperties(suppressedFieldsPropertiesList);
            this.processParticle(currentParticle, state);
        }
    }

    private void processModelGroup(XSDModelGroup mg, ICMSchemaParsingState state, String structureName) throws ICMException {
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.getLogger().println("Model Group composition is a " + (Object)((Object)mg.getCompositor()) + " of: ");
            this.doindent(this.indent);
            this.getLogger().println("(optional = " + state.getOptionalModelGroup() + ")");
        }
        this.handleSuppressionComments(mg.getAnnotation(), state.getCurrentLevelState(), state.getXpath());
        if (mg.getContents().isEmpty()) {
            return;
        }
        boolean localOptionalModelGroup = state.getOptionalModelGroup();
        boolean localForceOptional = state.getForceOptional();
        ICMStartChoiceGroupEntryImpl choiceStart = null;
        String choiceLocationName = null;
        boolean localChoiceProcessing = state.isChoiceProcessing();
        ICMStartChoiceGroupEntryImpl localChoiceGroup = state.getChoiceGroup();
        int localChoiceCount = state.getThisChoice();
        boolean processingMGWithinChoice = false;
        if (mg.getCompositor().getValue() == 1) {
            state.setForceOptional(true);
            state.setOptionalModelGroup(false);
            if (MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel())) {
                choiceLocationName = "&" + state.getCurrentLevelState().getTemplate().addVariable(null, null, "CHOICE") + ";";
                choiceStart = this.ich.addStartChoiceGroupEntry(state.getXpath().toString(), this.ich.getSimpleXpath(state.getXpath().toString()), state.getCurrentLevelState(), choiceLocationName, structureName);
                state.setChoiceLevel(state.getCurrentLevelState());
                state.setForceOptional(false);
                state.setChoiceProcessing(true);
                state.setChoiceGroup(choiceStart);
                state.setChoiceLocation(choiceLocationName);
            }
        } else if (localChoiceProcessing) {
            choiceLocationName = "&A;";
            choiceStart = state.getChoiceGroup();
            processingMGWithinChoice = true;
        }
        EList<XSDParticle> contents = mg.getContents();
        Iterator it1 = contents.iterator();
        int totalNumberOfOptions = contents.size();
        int currentChoice = 0;
        if (processingMGWithinChoice && choiceStart != null) {
            currentChoice = localChoiceCount;
            totalNumberOfOptions += choiceStart.getTotalOptions() - 1;
        }
        if (choiceStart != null) {
            choiceStart.setTotalOptions(totalNumberOfOptions);
        }
        if (choiceStart != null && totalNumberOfOptions > 255) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9038E", new Object[0]));
        }
        while (it1.hasNext()) {
            if (this.isTrace()) {
                this.getLogger().println("");
            }
            this.choiceElementName.push(new StringBuilder(""));
            XSDParticle particle = (XSDParticle)it1.next();
            ++this.indent;
            if (!processingMGWithinChoice) {
                ++currentChoice;
            }
            boolean localTreatAsStructure = state.getTreatAsStructure();
            state.setTreatAsStructure(false);
            XSDElementDeclaration localDelegate = state.getDelegate();
            state.setDelegate(null);
            int localTotalChoices = state.getTotalChoices();
            state.setTotalChoices(totalNumberOfOptions);
            int localThisChoice = state.getThisChoice();
            state.setThisChoice(currentChoice);
            List<XSDAttributeUse> localAttrsList = state.getAttrsList();
            state.setAttrsList(new LinkedList<XSDAttributeUse>());
            boolean localSynthElement = state.getSyntheticElement();
            state.setSyntheticElement(false);
            QName localXsiType = state.getXsiType();
            state.setXsiType(null);
            boolean veryLocalChoiceProcessing = state.isChoiceProcessing();
            ICMLevelState localChoiceLevel = state.getChoiceLevel();
            ICMLevelState localLevelState = state.getCurrentLevelState();
            ICMRepeatEntryImpl cge = null;
            if (choiceStart != null && (!(particle.getContent() instanceof XSDModelGroup) && !(particle.getContent() instanceof XSDModelGroupDefinition) || mg.getCompositor().getValue() == 1)) {
                long offsetCGES = state.getCurrentLevelState().getTotalLength();
                if (processingMGWithinChoice) {
                    offsetCGES = state.getChoiceLevel().getTotalLength();
                }
                if (!(particle.getContent() instanceof XSDModelGroup) && !(particle.getContent() instanceof XSDModelGroupDefinition)) {
                    cge = this.ich.addChoiceGroupEntryStartEntry(null, null, offsetCGES, choiceStart, state.getThisChoice());
                    ((ICMChoiceGroupEntryImpl)cge).setMgName(structureName);
                }
                if (!processingMGWithinChoice || localThisChoice != state.getThisChoice()) {
                    boolean pushBackSlackBytes = false;
                    if (this.parms.getLang() == 1) {
                        pushBackSlackBytes = true;
                    }
                    state.setCurrentLevelState(new ICMLevelState(0L, true, this.trace, this.logger, this.indent, this.parms.getMappingLevel(), state.getCurrentLevelState().getTemplate().getCurrentDefaultNameSpace(), pushBackSlackBytes, this.parms));
                } else {
                    state.getCurrentLevelState().switchTemplate();
                }
                if (cge != null) {
                    cge.setXMLTemplateVariableName(choiceLocationName);
                    ((ICMChoiceGroupEntryImpl)cge).setMgWithinChoice(processingMGWithinChoice);
                }
            }
            if (!MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel())) {
                if (mg.getCompositor().getValue() == 1 && (particle.getContent() instanceof XSDModelGroup || particle.getContent() instanceof XSDModelGroupDefinition)) {
                    throw new ICMException(MessageHandler.buildMessage("DFHPI9037E", new Object[]{state.getTypeName()}));
                }
            } else if (state.isChoiceProcessing()) {
                XSDModelGroup particleMG = null;
                if (particle.getContent() instanceof XSDModelGroup) {
                    particleMG = (XSDModelGroup)particle.getContent();
                }
                if (particle.getContent() instanceof XSDModelGroupDefinition) {
                    XSDModelGroupDefinition mdg = (XSDModelGroupDefinition)particle.getContent();
                    particleMG = mdg.getResolvedModelGroupDefinition().getModelGroup();
                }
                if (particleMG != null && particleMG.getCompositor().getValue() == 1) {
                    throw new ICMException(MessageHandler.buildMessage("DFHPI9037E", new Object[]{state.getTypeName()}));
                }
            }
            XSDAnnotation comments = this.processParticle(particle, state);
            if (cge != null) {
                cge.setStructureName(this.choiceElementName.pop().toString());
                cge.setXmlTemplate(state.getCurrentLevelState().getTemplate());
                cge.setStructureSize(state.getCurrentLevelState().getTotalLength());
                if (processingMGWithinChoice) {
                    state.getCurrentLevelState().switchTemplate();
                    state.getCurrentLevelState().resetAltTemplate();
                }
                this.ich.addChoiceGroupEntryEndEntry((ICMChoiceGroupEntryImpl)cge);
            }
            --this.indent;
            state.setTreatAsStructure(localTreatAsStructure);
            state.setDelegate(localDelegate);
            state.setTotalChoices(localTotalChoices);
            state.setThisChoice(localThisChoice);
            state.setAttrsList(localAttrsList);
            state.setSyntheticElement(localSynthElement);
            state.setXsiType(localXsiType);
            state.setCurrentLevelState(localLevelState);
            state.setChoiceProcessing(veryLocalChoiceProcessing);
            state.setChoiceLevel(localChoiceLevel);
            if (comments == null) continue;
            this.handleSuppressionComments(comments, state.getCurrentLevelState(), state.getXpath());
        }
        if (choiceStart != null && !processingMGWithinChoice && MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel())) {
            this.ich.addEndChoiceGroupEntry(choiceStart);
            long totalSize = 0L;
            ICMEntry entry = choiceStart;
            ArrayList<ICMChoiceGroupEntryImpl> list = new ArrayList<ICMChoiceGroupEntryImpl>();
            while (entry != null) {
                if (entry instanceof ICMChoiceGroupEntryImpl && ((ICMChoiceGroupEntryImpl)entry).isMgWithinChoice() && ((ICMChoiceGroupEntryImpl)entry).getStartChoiceGroupEntry() == choiceStart) {
                    int seq = ((ICMChoiceGroupEntryImpl)entry).getChoiceValue();
                    while (entry != null) {
                        if (entry instanceof ICMChoiceGroupEntryImpl) {
                            ICMChoiceGroupEntryImpl choice = (ICMChoiceGroupEntryImpl)entry;
                            choice.setXMLTemplateVariableName("&A;");
                            if (seq != choice.getChoiceValue()) break;
                            totalSize = choice.getStructureSize();
                            list.add(choice);
                            entry = choice.getNextChoiceGroupEntry();
                            continue;
                        }
                        entry = entry.getLogicalNextEntry();
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        ((ICMChoiceGroupEntryImpl)list.get(i)).setStructureSize(totalSize);
                    }
                    list = new ArrayList();
                    totalSize = 0L;
                    continue;
                }
                entry = entry.getLogicalNextEntry();
            }
            state.getCurrentLevelState().addCharArrayAlignedEntry(1, this.parms.getLang(), this.indent, "discriminator field", ICM.VaryingLength.NO_VARYING_STRATEGY);
            state.getCurrentLevelState().addCharArrayAlignedEntry(16, this.parms.getLang(), this.indent, "container name", ICM.VaryingLength.NO_VARYING_STRATEGY);
        }
        state.setChoiceGroup(localChoiceGroup);
        state.setThisChoice(localChoiceCount);
        state.setChoiceProcessing(localChoiceProcessing);
        state.setOptionalModelGroup(localOptionalModelGroup);
        state.setForceOptional(localForceOptional);
    }

    private void processComplexType(XSDComplexTypeDefinition typed, ICMSchemaParsingState state, boolean processingSuperType, List<String> comments) throws ICMException {
        XSDTypeDefinition superType;
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.logger.println("Processing complex type: " + typed.getURI());
            String content = null;
            if (typed.getContent() != null) {
                content = typed.getContent().getClass().getName();
            }
            this.doindent(this.indent);
            this.logger.println("Content is of type: " + content);
        }
        state.setChoiceProcessing(false);
        boolean abstractNoSubTypes = false;
        if (typed.isAbstract() && MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel()) && !processingSuperType) {
            Set<QName> allSubTypes = this.getDerivedDataTypes(typed);
            this.subTypesForAbstractDataType.addAll(allSubTypes);
            if (state.getNillable()) {
                this.nillableSubTypesForAbstractDataType.addAll(allSubTypes);
            }
            if (allSubTypes.isEmpty()) {
                abstractNoSubTypes = true;
            } else {
                this.processAbstractDataType(typed, state, allSubTypes);
                return;
            }
        }
        LinkedList<XSDAttributeUse> attrsList = new LinkedList<XSDAttributeUse>();
        if (!processingSuperType) {
            this.findAttributes(typed, attrsList);
            if (this.isStructuralComplexType(typed)) {
                this.consumeAttributes(attrsList, state.getCurrentLevelState(), state.getNillable());
            }
            XSDTypeDefinition parent = typed.getBaseType();
            this.testCicsContainerInstanceAttribute(parent, state, "channelType", "channel");
            this.testCicsContainerInstanceAttribute(parent, state, "charContainerTypeWithAttribute", "charContainer");
            this.testCicsContainerInstanceAttribute(parent, state, "bitContainerTypeWithAttribute", "bitContainer");
            this.testCicsContainerInstanceAttribute(parent, state, "structuredContainerTypeWithAttribute", "structuredContainer");
        }
        if (typed.getName() != null && typed.getTargetNamespace() != null && typed.getName().equals("anyType") && typed.getTargetNamespace().equals(SCHEMA4SCHEMA) || abstractNoSubTypes) {
            if (!MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel())) {
                throw new ICMException(MessageHandler.buildMessage("DFHPI9019E", new Object[]{typed.getURI()}));
            }
            this.processRawXMLElement(ICMRawXMLElementEntry.AnyType.anyType, state);
            return;
        }
        if (this.isSchemaType(typed)) {
            this.processRawXMLElement(ICMRawXMLElementEntry.AnyType.schema, state);
            return;
        }
        if (typed.getName() != null && typed.getTargetNamespace() != null && typed.getName().equals("EndpointReferenceType") && (typed.getTargetNamespace().equals(WSADDRESSING_RECOMMENDATION_NS) || typed.getTargetNamespace().equals(WSADDRESSING_SUBMISSION_NS)) && this.parms.isWSAddrEPRAny()) {
            this.processRawXMLElement(ICMRawXMLElementEntry.AnyType.any, state);
            return;
        }
        if (typed.getDerivationMethod().getValue() == 0 && !"http://www.ibm.com/xmlns/prod/CICS/channel-instance".equals((superType = typed.getBaseTypeDefinition()).getTargetNamespace()) && this.isStructuralComplexType(superType)) {
            boolean localNillable = state.getNillable();
            state.setNillable(false);
            this.processComplexType((XSDComplexTypeDefinition)superType, state, true, comments);
            state.setNillable(localNillable);
        }
        if (typed.getContent() instanceof XSDParticle) {
            boolean localTreatAsStructure = state.getTreatAsStructure();
            state.setTreatAsStructure(false);
            boolean localForceOptional = state.getForceOptional();
            state.setForceOptional(false);
            XSDElementDeclaration localDelegate = state.getDelegate();
            state.setDelegate(null);
            int localTotalChoices = state.getTotalChoices();
            state.setTotalChoices(0);
            int localThisChoice = state.getThisChoice();
            state.setThisChoice(0);
            List<XSDAttributeUse> localAttrsList = state.getAttrsList();
            state.setAttrsList(attrsList);
            boolean localOptionalModelGroup = state.getOptionalModelGroup();
            state.setOptionalModelGroup(false);
            boolean localSyntheticElement = state.getSyntheticElement();
            state.setSyntheticElement(false);
            QName localXsiType = state.getXsiType();
            state.setXsiType(null);
            XSDParticle particle = (XSDParticle)typed.getContent();
            this.processParticle(particle, state);
            state.setTreatAsStructure(localTreatAsStructure);
            state.setForceOptional(localForceOptional);
            state.setDelegate(localDelegate);
            state.setTotalChoices(localTotalChoices);
            state.setThisChoice(localThisChoice);
            state.setAttrsList(localAttrsList);
            state.setOptionalModelGroup(localOptionalModelGroup);
            state.setSyntheticElement(localSyntheticElement);
            state.setXsiType(localXsiType);
        } else if (!(typed.getContent() instanceof XSDSimpleTypeDefinition) && typed.getContent() != null) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9021E", new Object[]{typed.getContent()}));
        }
        XSDSimpleTypeDefinition simpleContent = null;
        String typeName = null;
        if (typed.getBaseType() != null && "http://www.ibm.com/xmlns/prod/CICS/channel-instance".equals(typed.getBaseType().getTargetNamespace()) && typed.getBaseType() instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition tmp = (XSDSimpleTypeDefinition)typed.getBaseType();
            if (tmp.getName().equals("charContainerTypeWithAttribute")) {
                simpleContent = typed.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string");
            } else if (tmp.getName().equals("bitContainerTypeWithAttribute")) {
                simpleContent = typed.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("base64Binary");
            }
            if (simpleContent != null) {
                typeName = state.getTypeName();
            }
        } else {
            simpleContent = typed.getSimpleType();
        }
        if (simpleContent != null) {
            this.processSimpleType(simpleContent, state, false, null, typeName, comments);
        }
        if (!this.isStructuralComplexType(typed)) {
            this.consumeAttributes(attrsList, state.getCurrentLevelState(), state.getNillable());
        }
    }

    private void testCicsContainerInstanceAttribute(XSDTypeDefinition parent, ICMSchemaParsingState state, String targetTypeName, String instanceTypeName) {
        if (parent != null && parent.hasNameAndTargetNamespace(targetTypeName, "http://www.ibm.com/xmlns/prod/CICS/channel-instance")) {
            state.getCurrentLevelState().getTemplate().addAttributeWithValue(instanceTypeName, "http://www.ibm.com/xmlns/prod/CICS/channel-instance", "true");
        }
    }

    private void processAbstractDataType(XSDComplexTypeDefinition typed, ICMSchemaParsingState state, Set<QName> allSubTypesSet) throws ICMException {
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.getLogger().println("Found Abstract Data Type: " + state.getTypeName());
            this.doindent(this.indent);
            this.getLogger().println("NS is: " + state.getTypeNameSpace());
            this.doindent(this.indent);
            this.getLogger().println("XPATH is: " + state.getXpath());
        }
        String xmlName = state.getCurrentLevelState().getTemplate().addVariable(null, null, state.getTypeName());
        String ns = state.getTypeNameSpace();
        if (ns == null) {
            ns = "";
        }
        ICMAbstractTypeStartEntryImpl start = this.ich.addAbstractTypeStartEntry(state.getXpath().toString(), this.ich.getSimpleXpath(state.getXpath().toString()), state.getCurrentLevelState(), "&" + xmlName + ";", new QName(ns, state.getTypeName()), state.getCurrentLevelState().getTotalLength());
        ArrayList<QName> allSubTypes = new ArrayList<QName>(allSubTypesSet);
        Collections.sort(allSubTypes, QNAME_COMPARATOR);
        Iterator it = allSubTypes.iterator();
        int optionNum = 0;
        while (it.hasNext()) {
            QName qname = (QName)it.next();
            ICMAbstractTypeOptionEntryImpl option = this.ich.addAbstractTypeOption(state.getCurrentLevelState(), qname, ++optionNum);
            start.addOptionEntry(option);
        }
        this.ich.addAbstractTypeEndEntry(start);
        state.getCurrentLevelState().addCharArrayAlignedEntry(1, this.parms.getLang(), this.indent, "abstract discriminator field", ICM.VaryingLength.NO_VARYING_STRATEGY);
        state.getCurrentLevelState().addCharArrayAlignedEntry(16, this.parms.getLang(), this.indent, "abstract container name", ICM.VaryingLength.NO_VARYING_STRATEGY);
    }

    private Set<QName> getDerivedDataTypes(XSDTypeDefinition parent) {
        TreeSet<QName> allSubTypes = new TreeSet<QName>(new QNameComparator());
        for (QName qname : this.builder.getGlobalTypes()) {
            XSDTypeDefinition candidateType = this.builder.resolveTypeDefinition(qname);
            if (candidateType.getBadTypeDerivation(parent, true, true) != null) continue;
            allSubTypes.add(qname);
        }
        return allSubTypes;
    }

    private void processRawXMLElement(ICMRawXMLElementEntry.AnyType icmAny, ICMSchemaParsingState state) throws ICMException {
        if (!this.choiceElementName.empty()) {
            StringBuilder buf = this.choiceElementName.peek();
            buf.replace(0, buf.length(), "xsdany");
        }
        StringBuilder localXPath = state.getXpath();
        if (icmAny.equals((Object)ICMRawXMLElementEntry.AnyType.any) || icmAny.equals((Object)ICMRawXMLElementEntry.AnyType.JSON_PROPERTY)) {
            state.setXpath(new StringBuilder());
        }
        if (this.isTrace()) {
            this.doindent(this.indent);
            this.getLogger().println("Found wildcard xml type derived from: " + state.getTypeName());
            this.doindent(this.indent);
            this.getLogger().println("Type is: " + state.getTypeNameSpace() + "#" + state.getTypeName());
            this.doindent(this.indent);
            this.getLogger().println("XPATH is: " + state.getXpath());
        }
        String xmlName = null;
        if (!state.getReplacementForSuppressedElement()) {
            xmlName = state.getCurrentLevelState().getTemplate().addVariable(null, null, state.getTypeName());
        }
        ICM.EncodingType encoding = ICM.EncodingType.SBCS;
        if ("1200".equals(this.parms.getInputParameters().getProperty("CCSID"))) {
            encoding = ICM.EncodingType.UTF16BE;
        }
        ICMRawXMLElementEntry rxe = this.ich.addRawXMLEntry(state.getTypeName(), state.getTypeNameSpace(), xmlName, state.getXpath().toString(), this.ich.getSimpleXpath(state.getXpath().toString()), state.getCurrentLevelState(), icmAny, encoding);
        if (ICMRawXMLElementEntry.AnyType.JSON_PROPERTY.equals((Object)icmAny)) {
            ICMRawJSONElementEntry rje = (ICMRawJSONElementEntry)rxe;
            int sizeOfBuffer = rje.getLengthOfTargetField();
            if (ICM.EncodingType.UTF16BE.equals((Object)rje.getEncodingType())) {
                sizeOfBuffer *= 2;
            }
            state.getCurrentLevelState().addCharArrayAlignedEntry(sizeOfBuffer, this.parms.getLang(), this.indent, "raw xml container name field", ICM.VaryingLength.NO_VARYING_STRATEGY);
        } else {
            state.getCurrentLevelState().addCharArrayAlignedEntry(16, this.parms.getLang(), this.indent, "raw xml container name field", ICM.VaryingLength.NO_VARYING_STRATEGY);
            state.getCurrentLevelState().addCharArrayAlignedEntry(16, this.parms.getLang(), this.indent, "raw xml namespace container name field", ICM.VaryingLength.NO_VARYING_STRATEGY);
        }
        state.setXpath(localXPath);
    }

    private boolean isStructuralComplexType(XSDTypeDefinition typed) throws ICMException {
        boolean returnValue = false;
        if (typed instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complex = (XSDComplexTypeDefinition)typed;
            returnValue = complex.getSimpleType() == null && !this.isAnyType(complex);
            if (complex.getBaseTypeDefinition() != null && "http://www.ibm.com/xmlns/prod/CICS/channel-instance".equals(complex.getBaseTypeDefinition().getTargetNamespace()) && ("bitContainerTypeWithAttribute".equals(complex.getBaseTypeDefinition().getName()) || "charContainerTypeWithAttribute".equals(complex.getBaseTypeDefinition().getName()))) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    private boolean hasAnyType(XSDElementDeclaration element) throws ICMException {
        boolean anyType = this.isAnyType(element.getTypeDefinition());
        if (!anyType && element.isAbstract() && MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel())) {
            return true;
        }
        return anyType;
    }

    private boolean isAnyType(XSDTypeDefinition typed) throws ICMException {
        XSDComplexTypeDefinition complex;
        boolean returnType = false;
        if (typed instanceof XSDComplexTypeDefinition && (complex = (XSDComplexTypeDefinition)typed).getName() != null && complex.getName().equals("anyType") && complex.getTargetNamespace() != null && complex.getTargetNamespace().equals(SCHEMA4SCHEMA)) {
            returnType = true;
        }
        if (this.isSchemaType(typed)) {
            returnType = true;
        }
        return returnType;
    }

    private boolean isSchemaType(XSDTypeDefinition typed) throws ICMException {
        if (typed.getAliasName() != null && typed.getAliasName().equals("schema_._type") && typed.getTargetNamespace() != null && typed.getTargetNamespace().equals(SCHEMA4SCHEMA)) {
            if (!MappingLevelHelper.supportsMappingLevel_2_1(this.parms.getMappingLevel())) {
                throw new ICMException(MessageHandler.buildMessage("DFHPI9019E", new Object[]{typed.getURI()}));
            }
            return true;
        }
        return false;
    }

    private boolean isAbstract_2_2(XSDTypeDefinition typed) {
        XSDComplexTypeDefinition complex;
        return typed instanceof XSDComplexTypeDefinition && (complex = (XSDComplexTypeDefinition)typed).isAbstract() && MappingLevelHelper.supportsMappingLevel_2_2(this.parms.getMappingLevel());
    }

    private void findAttributes(XSDComplexTypeDefinition typed, List<XSDAttributeUse> attrsList) throws ICMException {
        XSDTypeDefinition superType;
        if (typed.getTargetNamespace() != null && typed.getTargetNamespace().equals("http://www.ibm.com/xmlns/prod/CICS/channel-instance")) {
            return;
        }
        if (typed.getDerivationMethod().getValue() == 0 && (superType = typed.getBaseTypeDefinition()) instanceof XSDComplexTypeDefinition) {
            this.findAttributes((XSDComplexTypeDefinition)superType, attrsList);
        }
        if (!typed.getAttributeContents().isEmpty()) {
            for (Object next : typed.getAttributeContents()) {
                if (next instanceof XSDAttributeUse) {
                    this.processAttributeUses((XSDAttributeUse)next, typed.getURI(), attrsList);
                    continue;
                }
                if (next instanceof XSDAttributeGroupDefinition) {
                    XSDAttributeGroupDefinition group = (XSDAttributeGroupDefinition)next;
                    group = group.getResolvedAttributeGroupDefinition();
                    Iterator groupAttrs = group.getAttributeUses().iterator();
                    while (groupAttrs.hasNext()) {
                        this.processAttributeUses((XSDAttributeUse)groupAttrs.next(), typed.getURI(), attrsList);
                    }
                    XSDWildcard otherAttrs = group.getAttributeWildcard();
                    if (otherAttrs == null) continue;
                    this.warnings.add(MessageHandler.buildMessage("DFHPI9032W", new Object[0]));
                    continue;
                }
                throw new ICMException("INTERNAL ERROR unexpected attribute content: " + next.getClass().getName());
            }
        }
    }

    private void processAttributeUses(XSDAttributeUse attr, String nameSpace, List<XSDAttributeUse> attrsList) {
        String name = attr.getAttributeDeclaration().getResolvedAttributeDeclaration().getQName();
        if (attr.getUse().getValue() != 1) {
            if (MappingLevelHelper.requiresMappingLevel_1(this.parms.getMappingLevel())) {
                this.warnings.add(MessageHandler.buildMessage("DFHPI9020W", new Object[]{name, nameSpace}));
            } else if (!attrsList.contains(attr)) {
                attrsList.add(attr);
            }
        }
    }

    public void log(PrintStream logger) {
        this.ich.log(logger);
    }

    @Override
    public Element toXMLElement() throws ICMException {
        throw new ICMException("INTERNAL ERROR: ICM is not for creating WSDL.");
    }

    @Override
    public byte[] toByteArray() throws IOException, ICMException {
        if (!this.complete) {
            throw new ICMException("INTERNAL ERROR: ICM is not complete.");
        }
        if (this.thisICM != null) {
            return this.thisICM;
        }
        this.thisICM = this.ich.toByteArray();
        this.allInScopeTypes.clear();
        this.allStructures.clear();
        this.seededXPATH = null;
        this.messagesCache = this.builder.getMessages(this.warnings);
        this.builder = null;
        return this.thisICM;
    }

    @Override
    public void completedICM() throws ICMException, IOException {
        if (this.complete) {
            throw new ICMException("INTERNAL ERROR: completedICM() called twice for the same ICM.");
        }
        if (this.parms.getStyle().equals((Object)ICM.BindingStyle.RPC_STYLE)) {
            this.topLevelState.getTemplate().addEndTag(this.wsdlOperationNameSpace, this.wsdlOperationName, true);
        }
        if (this.parms.isGeneratedForWSDL()) {
            this.topLevelState.getTemplate().addEndTag(null, SOAPBODYTAG, false);
        }
        this.ich.finishedWithWSDL(this.topLevelState);
        this.complete = true;
        if (this.isTrace()) {
            this.getLogger().println(LINE_SEPARATOR);
            this.getLogger().println("ICM as text: " + this.ich.getName());
            this.getLogger().println("------------" + LINE_SEPARATOR);
            this.log(this.getLogger());
            try {
                String name = this.ich.getName();
                ByteArray bytes = new ByteArray(this.toByteArray(), true);
                this.getLogger().println(LINE_SEPARATOR);
                this.getLogger().println("ICM as data: " + name);
                this.getLogger().println("------------" + LINE_SEPARATOR);
                bytes.logReadableBinaryData(CHARSET_CP037, this.getLogger());
                this.getLogger().println();
                this.getLogger().println("Total length of binary data is: " + ByteArray.formatNumForDisplay(bytes.length()));
                this.getLogger().println(LINE_SEPARATOR);
            }
            catch (Exception e) {
                this.getLogger().println("Exception: " + e);
                e.printStackTrace(this.getLogger());
            }
        }
        if (this.parms.getICMInterceptor() != null) {
            this.parms.getICMInterceptor().interceptICM(this);
        }
    }

    private int calculateLARForCharArrayType(XSDSimpleTypeDefinition typed, ICM.EncodingType encodingType) {
        return this.calculateLARForCharArrayType(typed, this.parms.getDefaultCharMaxLen(), encodingType);
    }

    private int calculateLARForCharArrayType(XSDSimpleTypeDefinition typed, int defaultValue, ICM.EncodingType encodingType) {
        Integer minl;
        XSDMinLengthFacet minlf;
        XSDEnumerationFacet ef;
        XSDLengthFacet lf;
        int LAR = -1;
        XSDMaxLengthFacet mlf = typed.getEffectiveMaxLengthFacet();
        if (mlf == null) {
            mlf = typed.getMaxLengthFacet();
        }
        if (mlf != null) {
            Integer ml = (Integer)mlf.getEffectiveValue();
            LAR = ml;
        }
        if ((lf = typed.getEffectiveLengthFacet()) == null) {
            lf = typed.getLengthFacet();
        }
        if (lf != null) {
            Integer l = (Integer)lf.getEffectiveValue();
            LAR = l;
        }
        if (LAR == -1 && (ef = typed.getEffectiveEnumerationFacet()) != null) {
            List enums = (List)ef.getEffectiveValue();
            for (Object o : enums) {
                if (o instanceof XSDAnySimpleType.ByteSequence) {
                    XSDAnySimpleType.ByteSequence bytes = (XSDAnySimpleType.ByteSequence)o;
                    if (bytes.getBytes().length <= LAR) continue;
                    LAR = bytes.getBytes().length;
                    continue;
                }
                String value = o.toString();
                if (value.length() <= LAR) continue;
                LAR = value.length();
            }
        }
        if (LAR == -1) {
            LAR = defaultValue;
        }
        if ((minlf = typed.getEffectiveMinLengthFacet()) == null) {
            minlf = typed.getMinLengthFacet();
        }
        if (minlf != null && (minl = (Integer)minlf.getEffectiveValue()) > LAR) {
            LAR = minl;
        }
        if (encodingType != ICM.EncodingType.SBCS) {
            LAR *= 2;
            if (encodingType == ICM.EncodingType.UTF16BE && this.parms.getCharMultiplier() > 1) {
                LAR *= this.parms.getCharMultiplier() / 2;
            }
        } else {
            LAR *= this.parms.getCharMultiplier();
        }
        return LAR;
    }

    private int calculateLARForDecimalType(XSDSimpleTypeDefinition typed, int fracDef, int defaultValue, ICMCreationParameters parms) {
        int LAR = -1;
        XSDTotalDigitsFacet total = typed.getEffectiveTotalDigitsFacet();
        if (total == null) {
            total = typed.getTotalDigitsFacet();
        }
        if (total != null) {
            Integer t = (Integer)total.getEffectiveValue();
            LAR = t;
        } else {
            XSDEnumerationFacet ef = typed.getEffectiveEnumerationFacet();
            if (ef != null) {
                List enums = (List)ef.getEffectiveValue();
                Iterator it = enums.iterator();
                int LARinteger = 0;
                int LARfraction = 0;
                while (it.hasNext()) {
                    Object o = it.next();
                    String value = o.toString();
                    int integerDigits = value.length();
                    int fractionDigits = 0;
                    if (value.indexOf(46) > -1) {
                        integerDigits = value.indexOf(46);
                        fractionDigits = value.length() - value.indexOf(46) - 1;
                    }
                    if (value.indexOf(45) > -1) {
                        --integerDigits;
                    }
                    if (value.indexOf(43) > -1) {
                        --integerDigits;
                    }
                    if (integerDigits > LARinteger) {
                        LARinteger = integerDigits;
                    }
                    if (fractionDigits <= LARfraction) continue;
                    LARfraction = fractionDigits;
                }
                if (LARinteger + LARfraction > LAR) {
                    LAR = LARinteger + LARfraction;
                }
            } else {
                LAR = defaultValue;
            }
        }
        boolean signed = true;
        XSDMinFacet minlf = typed.getEffectiveMinFacet();
        if (minlf == null) {
            minlf = typed.getMinFacet();
        }
        if (minlf != null) {
            BigDecimal minl = (BigDecimal)minlf.getEffectiveValue();
            if (minl == null) {
                minl = new BigDecimal(minlf.getLexicalValue());
            }
            if (minl.doubleValue() >= 0.0) {
                signed = false;
            }
        }
        int fractionDigits = this.calculateFDForDecimalType(typed, fracDef, LAR);
        if (parms.getInputParameters().getProperty("WIDE-COMP3").equalsIgnoreCase("FULL")) {
            LAR += fractionDigits;
        }
        if (LAR > defaultValue) {
            LAR = defaultValue;
            String message = null;
            switch (this.parms.getMessageType()) {
                case SOAP_REQUEST: {
                    message = MessageHandler.buildMessage("DFHPI9023W", new Object[]{typed.getURI(), defaultValue, this.wsdlOperationName});
                    break;
                }
                case SOAP_RESPONSE: {
                    message = MessageHandler.buildMessage("DFHPI9022W", new Object[]{typed.getURI(), defaultValue, this.wsdlOperationName});
                    break;
                }
                case XML_ELEMENT: 
                case XML_TYPE: {
                    message = MessageHandler.buildMessage("DFHPI9034W", new Object[]{typed.getURI(), defaultValue});
                    break;
                }
                default: {
                    throw new RuntimeException("INTERNAL ERROR: bad message type - " + (Object)((Object)this.parms.getMessageType()));
                }
            }
            this.warnings.add(message);
        }
        LAR -= fractionDigits;
        if (signed) {
            LAR = -1 - LAR;
        }
        return LAR;
    }

    private int calculateFDForDecimalType(XSDSimpleTypeDefinition typed, int defaultValue, int maxValue) {
        int fd = -1;
        XSDFractionDigitsFacet frac = typed.getEffectiveFractionDigitsFacet();
        if (frac == null) {
            frac = typed.getFractionDigitsFacet();
        }
        if (frac != null) {
            Integer f = (Integer)frac.getEffectiveValue();
            fd = f;
        } else {
            XSDEnumerationFacet ef = typed.getEffectiveEnumerationFacet();
            if (ef != null) {
                List enums = (List)ef.getEffectiveValue();
                for (Object o : enums) {
                    int fractionDigits;
                    String value = o.toString();
                    int decimalPlace = value.indexOf(46);
                    if (decimalPlace <= -1 || (fractionDigits = value.length() - decimalPlace - 1) <= fd) continue;
                    fd = fractionDigits;
                }
                if (fd == -1) {
                    fd = 0;
                }
            } else {
                int fractionDigits;
                String maxl;
                int decimalPlace;
                XSDMaxFacet maxlf;
                int fractionDigits2;
                String minl;
                int decimalPlace2;
                XSDMinFacet minlf = typed.getEffectiveMinFacet();
                if (minlf == null) {
                    minlf = typed.getMinFacet();
                }
                if (minlf != null && (decimalPlace2 = (minl = minlf.getEffectiveValue().toString()).indexOf(46)) > -1 && (fractionDigits2 = minl.length() - decimalPlace2 - 1) > fd) {
                    fd = fractionDigits2;
                }
                if ((maxlf = typed.getEffectiveMaxFacet()) == null) {
                    maxlf = typed.getMaxFacet();
                }
                if (maxlf != null && (decimalPlace = (maxl = maxlf.getEffectiveValue().toString()).indexOf(46)) > -1 && (fractionDigits = maxl.length() - decimalPlace - 1) > defaultValue && fractionDigits > fd) {
                    fd = fractionDigits;
                }
            }
        }
        if (fd == -1) {
            fd = defaultValue;
        }
        if (fd > maxValue) {
            fd = maxValue;
        }
        return fd;
    }

    private int calculateLARForCharArrayNumericType(XSDSimpleTypeDefinition typed, int defaultValue, int defaultFractionDigits) {
        XSDMinFacet minf;
        XSDMaxFacet maxf;
        int LAR = -1;
        int maxFractionDigits = defaultFractionDigits;
        int maxNonFractionDigits = -1;
        XSDTotalDigitsFacet tdf = typed.getEffectiveTotalDigitsFacet();
        if (tdf == null) {
            tdf = typed.getTotalDigitsFacet();
        }
        if (tdf != null) {
            Integer ml = (Integer)tdf.getEffectiveValue();
            LAR = ml + 2;
            return LAR;
        }
        XSDEnumerationFacet ef = typed.getEffectiveEnumerationFacet();
        if (ef != null) {
            List enums = (List)ef.getEffectiveValue();
            for (Object o : enums) {
                String value = o.toString();
                if (value.length() <= LAR) continue;
                LAR = value.length();
            }
            return LAR;
        }
        XSDFractionDigitsFacet fdf = typed.getEffectiveFractionDigitsFacet();
        if (fdf == null) {
            fdf = typed.getFractionDigitsFacet();
        }
        if (fdf != null) {
            Integer fd = (Integer)fdf.getEffectiveValue();
            maxFractionDigits = fd;
        }
        if ((maxf = typed.getEffectiveMaxFacet()) == null) {
            maxf = typed.getMaxFacet();
        }
        if (maxf != null) {
            String maxStr = maxf.getEffectiveValue().toString();
            if (maxStr.indexOf(".") > -1) {
                int digitsToLeftOfDot = maxStr.indexOf(".") - 1;
                int digitsToRightOfDot = maxStr.length() - maxStr.indexOf(".");
                if (digitsToLeftOfDot > maxNonFractionDigits) {
                    maxNonFractionDigits = digitsToLeftOfDot;
                }
                if (digitsToRightOfDot > maxFractionDigits) {
                    maxFractionDigits = digitsToRightOfDot;
                }
            } else if (maxStr.length() > maxNonFractionDigits) {
                maxNonFractionDigits = maxStr.length();
            }
        }
        if ((minf = typed.getEffectiveMinFacet()) == null) {
            minf = typed.getMinFacet();
        }
        if (minf != null) {
            String minStr = minf.getEffectiveValue().toString();
            if (minStr.indexOf(".") > -1) {
                int digitsToLeftOfDot = minStr.indexOf(".") - 1;
                int digitsToRightOfDot = minStr.length() - minStr.indexOf(".");
                if (digitsToLeftOfDot > maxNonFractionDigits) {
                    maxNonFractionDigits = digitsToLeftOfDot;
                }
                if (digitsToRightOfDot > maxFractionDigits) {
                    maxFractionDigits = digitsToRightOfDot;
                }
            } else if (minStr.length() > maxNonFractionDigits) {
                maxNonFractionDigits = minStr.length();
            }
        }
        int totalDigits = maxNonFractionDigits + maxFractionDigits + 3;
        if ((maxf == null || minf == null) && totalDigits < defaultValue) {
            totalDigits = defaultValue;
        }
        return totalDigits;
    }

    private int calculateLARForPictureNumerics(XSDSimpleTypeDefinition typed, long maxPermittableValue, boolean replacementForSuppressedElement) {
        int i;
        XSDTotalDigitsFacet td = typed.getTotalDigitsFacet();
        if (td != null) {
            return 0;
        }
        XSDEnumerationFacet en = typed.getEffectiveEnumerationFacet();
        if (en != null) {
            return 0;
        }
        if (this.displayTypeNotUsed) {
            return 0;
        }
        XSDMaxFacet maxf = typed.getMaxFacet();
        XSDMinFacet minf = typed.getMinFacet();
        if (maxf == null || minf == null || (maxf.getElement() == null || minf.getElement() == null) && !replacementForSuppressedElement) {
            return 0;
        }
        if (SCHEMA4SCHEMA.equals(typed.getTargetNamespace())) {
            return 0;
        }
        String maxfV = maxf.getLexicalValue();
        String minfV = minf.getLexicalValue();
        String maxPermissableValueStr = String.valueOf(maxPermittableValue);
        String minPermissableValueStr = String.valueOf(-1L - maxPermittableValue);
        if (maxfV.equals(maxPermissableValueStr) && (minfV.equals("0") || minfV.equals(minPermissableValueStr))) {
            if (minfV.startsWith("-")) {
                return 0 - maxfV.length();
            }
            return maxfV.length();
        }
        for (i = 0; i < maxfV.length(); ++i) {
            if (maxfV.charAt(i) == '9') continue;
            return 0;
        }
        if (minfV.equals("0")) {
            return maxfV.length();
        }
        if (minfV.length() != maxfV.length() + 1) {
            return 0;
        }
        if (minfV.charAt(0) != '-') {
            return 0;
        }
        for (i = 1; i < minfV.length(); ++i) {
            if (minfV.charAt(i) == '9') continue;
            return 0;
        }
        if (this.parms.getLang() == 2 || this.parms.getLang() == 6 || this.parms.getLang() == 7) {
            return 0;
        }
        return 0 - maxfV.length();
    }

    @Override
    public List<ICMEntry> getContents() throws ICMException {
        if (!this.complete) {
            throw new ICMException("INTERNAL ERROR: ICM is not complete.");
        }
        List<ICMEntry> toReturn = this.ich.getNonHiddenContents();
        this.ich = null;
        return toReturn;
    }

    @Override
    public void addDataElementEntry(ICMInputSimpleDataType field) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
    }

    @Override
    public void addFixedRepeatEntry(ICMInputArrayStartDataType data) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
    }

    @Override
    public void addEndRepeatEntry(ICMInputArrayEndDataType data) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
    }

    @Override
    public void sendStructStart(ICMInputStructureStartDataType data) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
    }

    @Override
    public void sendStructEnd(ICMInputStructureEndDataType data) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
    }

    @Override
    public String[] getMessages() {
        return this.messagesCache;
    }

    @Override
    public long getCommAreaLength() throws ICMException {
        if (!this.complete) {
            throw new ICMException("INTERNAL ERROR: ICM is not complete.");
        }
        return this.topLevelState.getTotalLength();
    }

    @Override
    public long getICMLength() {
        if (this.thisICM == null) {
            return -1L;
        }
        return this.thisICM.length;
    }

    @Override
    public String getTargetNameSpace() {
        return this.wsdlOperationNameSpace;
    }

    @Override
    public String getTopLevelElementLocalName() {
        return null;
    }

    @Override
    public void addGlobalTypeDefinition(QName targetQName, boolean nillable) throws ICMException {
        if (this.isTrace()) {
            this.getLogger().println("Adding Global type definition(1): " + targetQName.toString());
        }
        if (!this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Illegal call of 'addGlobalTypeDefinition'.");
        }
        StringBuilder xpath = new StringBuilder(this.seededXPATH.toString());
        this.addTypeDefinitionPart2(targetQName.getNamespaceURI(), targetQName.getLocalPart(), targetQName, false, xpath, true, nillable);
        if (this.isTrace()) {
            this.getLogger().println("Finished adding Global type definition(1): " + targetQName.toString());
        }
    }

    @Override
    public void addContainerEntry(ICMInputContainerDataType inputParameters) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
    }

    @Override
    public IPlatform.EndianType getEndianType() {
        if (this.parms.getPlatform() != null) {
            return this.parms.getPlatform().getEndianness();
        }
        return IPlatform.EndianType.BIG_ENDIAN;
    }

    @Override
    public IPlatform.ZonedEncodingType getZonedEncodingType() {
        if (this.parms.getPlatform() != null) {
            return this.parms.getPlatform().getZonedEncoding();
        }
        return IPlatform.ZonedEncodingType.ZONED_EBCDIC;
    }

    private static class ProcessRepeatICMEntryReturnType {
        private long length = -1L;
        private XSDAnnotation comments = null;

        public ProcessRepeatICMEntryReturnType(long length, XSDAnnotation comments) {
            this.length = length;
            this.comments = comments;
        }

        public long getLength() {
            return this.length;
        }

        public XSDAnnotation getComments() {
            return this.comments;
        }
    }

    public static class QNameComparator
    implements Comparator<QName>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(QName arg1, QName arg2) {
            QName obj1 = arg1;
            QName obj2 = arg2;
            int comp = obj1.getLocalPart().compareTo(obj2.getLocalPart());
            if (comp == 0) {
                comp = obj1.getNamespaceURI().compareTo(obj2.getNamespaceURI());
            }
            return comp;
        }
    }

    protected static class ElementNameComparator
    implements Comparator<XSDElementDeclaration>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected ElementNameComparator() {
        }

        @Override
        public int compare(XSDElementDeclaration arg1, XSDElementDeclaration arg2) {
            XSDElementDeclaration obj1 = arg1;
            XSDElementDeclaration obj2 = arg2;
            return obj1.getName().compareTo(obj2.getName());
        }
    }

    private static class ValueHolder {
        private long levelOffset = -1L;
        private ICM.VaryingLength mappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;

        protected ValueHolder(long levelOffset, ICM.VaryingLength mappingStrategy) {
            this.levelOffset = levelOffset;
            this.mappingStrategy = mappingStrategy;
        }

        protected long getLevelOffset() {
            return this.levelOffset;
        }

        protected ICM.VaryingLength getMappingStrategy() {
            return this.mappingStrategy;
        }
    }
}

