/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMInputArrayEndDataType;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureEndDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.schema.impl.ICMBuilderImpl;
import com.ibm.cics.schema.impl.ICMInputSimpleDataTypeImpl;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexFinal;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDProhibitedSubstitutions;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.w3c.dom.Element;

public class ICMImplToWSDL
implements ICM {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ICMBuilderImpl builder = null;
    private boolean trace = false;
    private PrintStream logger = null;
    private boolean complete = false;
    private boolean startingFromWSDL = false;
    private XSDFactory xsdFactory = null;
    private XSDSchema schema = null;
    private XSDModelGroup currentModelGroup = null;
    private XSDParticle currentParticle = null;
    private Properties currentAnnotations = null;
    private static final String CONTENT_TYPE_NAME = "ProgramInterface";
    private ICM delegate_ICM = null;
    public static final String URI_FOR_COMMENTS = "http://www.ibm.com/software/htp/cics/annotations";
    private boolean content_found = true;
    private static final boolean DOCUMENTATION_ANNOTATION = true;
    private static final boolean APPLICATION_ANNOTATION = false;
    public static final String PROPERTY_FOR_MIN_OCCURS = "com.ibm.cics.wsdl.properties.minOccurs";
    public static final String PROPERTY_FOR_MAX_OCCURS = "com.ibm.cics.wsdl.properties.maxOccurs";
    public static final String PROPERTY_FOR_SURROGATE_NAME = "com.ibm.cics.wsdl.properties.surrogateName";
    public static final String DFH_SURROGATE_NAME = "DFH_SURROGATE_NAME_";
    public static final String PROPERTY_FOR_JSON_ANY = "com.ibm.cics.wsdl.properties.jsonAny";
    public static final String PROPERTY_FOR_INNER_ARRAY = "com.ibm.cics.wsdl.properties.innerArray";
    public static final String PROPERTY_FOR_OUTER_NAME = "com.ibm.cics.wsdl.properties.outerArrayName";
    protected static final String PROPERTY_FOR_SUPPRESSED_FIELD = "com.ibm.cics.wsdl.properties.suppressedField";
    protected static final String PROPERTY_FOR_ALLIGNMENT = "com.ibm.cics.wsdl.properties.synchronized";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_ALLIGNMENT = "a1";
    protected static final String PROPERTY_FOR_WIDECHARS = "com.ibm.cics.wsdl.properties.widechars";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_WIDECHARS = "a2";
    protected static final String PROPERTY_FOR_MAPPING_LEVEL = "com.ibm.cics.wsdl.properties.mappingLevel";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_MAPPING_LEVEL = "a3";
    protected static final String PROPERTY_FOR_VARIABLE_LENGTH = "com.ibm.cics.wsdl.properties.charlength";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_VARIABLE_LENGTH = "a4";
    protected static final String PROPERTY_FOR_FLOAT_TYPE = "com.ibm.cics.wsdl.properties.float.type";
    protected static final String PROPERTY_FOR_DECIMAL_TYPE = "com.ibm.cics.wsdl.properties.decimal";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_DECIMAL_TYPE = "a5";
    protected static final String PROPERTY_FOR_SIGN_ENDIANNESS = "com.ibm.cics.wsdl.properties.sign";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_SIGN_ENDIANNESS = "a6";
    protected static final String PROPERTY_FOR_SEPARATE_SIGN = "com.ibm.cics.wsdl.properties.sign.separate";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_SEPARATE_SIGN = "a7";
    protected static final String PROPERTY_FOR_ODO = "com.ibm.cics.wsdl.properties.odo";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_ODO = "a8";
    protected static final String PROPERTY_FOR_ODO_TARGET = "com.ibm.cics.wsdl.properties.odo.target";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_ODO_TARGET = "a9";
    protected static final String PROPERTY_FOR_UTF16 = "com.ibm.cics.wsdl.properties.utf16be";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_UTF16 = "a10";
    protected static final String PROPERTY_FOR_TRUNCATE_NULL_ARRAYS = "com.ibm.cics.wsdl.properties.truncateOnNull";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_TRUNCATE_NULL_ARRAYS = "a11";
    protected static final String PROPERTY_FOR_TRUNCATE_NULL_ARRAY_VALUES = "com.ibm.cics.wsdl.properties.truncateValues";
    protected static final String ANNOTATION_SHORT_PROPERTY_FOR_TRUNCATE_NULL_ARRAY_VALUES = "a12";
    public static final String PROPERTY_FOR_OPTIONAL_ARRAYS = "com.ibm.cics.wsdl.properties.optionalarray";
    public static final String PROPERTY_FOR_MULTI_TYPE_ELEMENTS = "com.ibm.cics.wsdl.properties.multitype";
    protected static final String ANNOTATION_VALUE_FOR_VARIABLE_LENGTH_FIXED = "fixed";
    protected static final String ANNOTATION_VALUE_FOR_VARIABLE_LENGTH_VARYING = "varying";
    protected static final String ANNOTATION_VALUE_FOR_VARIABLE_LENGTH_NULL = "null";
    protected static final String ANNOTATION_SHORT_TYPE = "de1";
    protected static final String ANNOTATION_SHORT_LAR = "de2";
    protected static final String ANNOTATION_SHORT_FRACTION_DIGITS = "de3";
    protected static final String ANNOTATION_SHORT_ICM_DATA_ELEMENT = "DE";
    protected static final String ANNOTATION_SHORT_ICM_FIXED_REPEAT = "FR";
    protected static final String ANNOTATION_SHORT_ICM_STRUCTURE = "ST";
    protected static final String ANNOTATION_SHORT_ICM_END_REPEAT = "ER";
    protected static final String ANNOTATION_SHORT_ICM_OCCURENCES = "oc";
    protected static final String ANNOTATION_SHORT_ICM_DATA_ELEMENT_TYPE = "type";
    protected static final String ANNOTATION_SUPPRESSED_FIELD_NAME = "**filler**";
    protected static final String VALUE_FOR_FLOAT_TYPE_IEEE = "IEEE";
    protected static final String VALUE_FOR_FLOAT_TYPE_HEX = "hex";
    protected static final String VALUE_FOR_DECIMAL_PACKED = "packed";
    protected static final String VALUE_FOR_DECIMAL_ZONED = "zoned";
    protected static final String VALUE_FOR_SIGN_LEADING = "leading";
    protected static final String VALUE_FOR_SIGN_TRAILING = "trailing";
    protected static final String VALUE_FOR_SIGN_SEPARATE_TRUE = "true";
    protected static final String VALUE_FOR_SIGN_SEPARATE_FALSE = "false";
    private String localNameForWrapperElement = null;
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    private ICMCreationParameters parms = null;
    protected static final String SCHEMA_FOR_CHANNEL_INSTANCE = "http://www.ibm.com/xmlns/prod/CICS/channel-instance";
    protected static final String LOCAL_NAME_FOR_CHANNEL_TYPE = "channelType";
    protected static final String LOCAL_NAME_FOR_STRUCTURED_CONT = "structuredContainerTypeWithAttribute";
    protected static final String LOCAL_NAME_FOR_BIT_CONT = "bitContainerTypeWithAttribute";
    protected static final String LOCAL_NAME_FOR_CHAR_CONT = "charContainerTypeWithAttribute";
    protected static final String LOCAL_NAME_FOR_CHANNEL_TYPE_INST = "channel";
    protected static final String LOCAL_NAME_FOR_STRUCTURED_CONT_INST = "structuredContainer";
    protected static final String LOCAL_NAME_FOR_BIT_CONT_INST = "bitContainer";
    protected static final String LOCAL_NAME_FOR_CHAR_CONT_INST = "charContainer";
    protected XSDComplexTypeDefinition stringContainer = null;
    protected XSDComplexTypeDefinition bitContainer = null;
    private static final Charset CHARSET_ISO8859_1 = Charset.forName("ISO8859-1");

    protected ICMImplToWSDL(XSDSchema currentSchema, ICMCreationParameters parms) {
        this.xsdFactory = XSDFactory.eINSTANCE;
        this.schema = currentSchema;
        this.parms = parms;
    }

    protected ICMImplToWSDL(ICMBuilderImpl builder, ICMCreationParameters parms, boolean startingFromWSDL) throws ICMException {
        this.builder = builder;
        this.parms = parms;
        this.trace = builder.isTrace();
        this.logger = builder.getLogger();
        if (this.logger != null) {
            this.logger.println("Creating an ICM, name '" + parms.getName() + "' style '" + (Object)((Object)parms.getStyle()) + "' namespace '" + parms.getWsdlOperation().getNamespaceURI() + "' operation '" + parms.getWsdlOperation().getLocalPart() + "' message type '" + ICM.MESSAGE_TYPES[parms.getMessageType().getCode()] + "' language '" + ICM.LANGUAGE_TYPES[parms.getLang()] + "' startingFromWSDL '" + startingFromWSDL + "' mappingLevel '" + ICM.MAPPING_LEVELS_FOR_DISPLAY[parms.getMappingLevel()] + "'.");
        }
        if (!parms.getStyle().equals((Object)ICM.BindingStyle.WRAPPED_STYLE)) {
            throw new ICMException("INTERNAL ERROR: Style '" + (Object)((Object)parms.getStyle()) + "' is invalid.");
        }
        this.initialiseSchema();
    }

    private void initialiseSchema() throws ICMException {
        this.xsdFactory = XSDFactory.eINSTANCE;
        this.schema = this.xsdFactory.createXSDSchema();
        this.schema.setTargetNamespace(this.parms.getWsdlOperation().getNamespaceURI());
        this.schema.setElementFormDefault(XSDForm.QUALIFIED_LITERAL);
        this.schema.setAttributeFormDefault(XSDForm.QUALIFIED_LITERAL);
        this.schema.setSchemaForSchemaQNamePrefix("xsd");
        Map<String, String> qNamePrefixToNamespaceMap = this.schema.getQNamePrefixToNamespaceMap();
        qNamePrefixToNamespaceMap.put("tns", this.schema.getTargetNamespace());
        qNamePrefixToNamespaceMap.put(this.schema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        if (this.parms.isComplexChannelBased()) {
            qNamePrefixToNamespaceMap.put("cics", SCHEMA_FOR_CHANNEL_INSTANCE);
        }
        XSDComplexTypeDefinition content = this.createComplexType(CONTENT_TYPE_NAME, 1);
        XSDModelGroup localModelGroupCopy = this.currentModelGroup;
        int mappingLevel = this.parms.getMappingLevel();
        if (mappingLevel != 0) {
            if (this.parms.isGeneratedForWSDL()) {
                this.addComment(MessageHandler.getMessage("WSDL_COMMENT_CICS_INFO"), this.schema, true);
            } else {
                this.addComment(MessageHandler.getMessage("SCHEMA_COMMENT_CICS_INFO"), this.schema, true);
            }
            Properties p = new Properties();
            p.setProperty(PROPERTY_FOR_MAPPING_LEVEL, ICM.MAPPING_LEVELS[mappingLevel]);
            this.addPropertiesComment(p, this.schema);
            this.schema.getContents().add((Object)content);
        } else {
            this.schema.getContents().add((Object)content);
            this.addComment(MessageHandler.getMessage("WSDL_COMMENT_CICS_INFO"), content, true);
        }
        XSDElementDeclaration globalElement = null;
        switch (this.parms.getMessageType()) {
            case XML_ELEMENT: 
            case XML_TYPE: 
            case SOAP_REQUEST: {
                this.localNameForWrapperElement = this.parms.getWsdlOperation().getLocalPart();
                break;
            }
            case SOAP_RESPONSE: {
                this.localNameForWrapperElement = this.parms.getWsdlOperation().getLocalPart() + "Response";
                break;
            }
            default: {
                throw new RuntimeException("INTERNAL ERROR: bad message type - " + (Object)((Object)this.parms.getMessageType()));
            }
        }
        globalElement = this.createElement(this.localNameForWrapperElement);
        XSDComplexTypeDefinition typeDef = this.schema.resolveComplexTypeDefinition(CONTENT_TYPE_NAME);
        if (this.parms.isComplexChannelBased()) {
            XSDComplexTypeDefinition parentType = this.xsdFactory.createXSDComplexTypeDefinition();
            parentType.setTargetNamespace(SCHEMA_FOR_CHANNEL_INSTANCE);
            parentType.setName(LOCAL_NAME_FOR_CHANNEL_TYPE);
            typeDef.setBaseTypeDefinition(parentType);
            typeDef.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        }
        globalElement.setTypeDefinition(typeDef);
        this.currentModelGroup = localModelGroupCopy;
        this.schema.getContents().add((Object)globalElement);
        this.stringContainer = this.getDefinitionForCICSCharContainer();
        this.bitContainer = this.getDefinitionForCICSBitContainer();
    }

    private XSDComplexTypeDefinition getDefinitionForCICSCharContainer() {
        return this.createDefinitionForCICSType(LOCAL_NAME_FOR_CHAR_CONT, "charContainerType", "string");
    }

    private XSDComplexTypeDefinition getDefinitionForCICSBitContainer() {
        return this.createDefinitionForCICSType(LOCAL_NAME_FOR_BIT_CONT, "bitContainerType", "base64Binary");
    }

    private XSDElementDeclaration createElement(String name) {
        if (this.logger != null) {
            this.logger.println("Creating a global element named: " + name);
        }
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(name);
        element.setNillable(false);
        return element;
    }

    private XSDElementDeclaration createElementWithComplexType(String name, int occurs, boolean container) {
        XSDElementDeclaration element = this.createElement(name);
        XSDComplexTypeDefinition anonComplexType = this.createComplexType(null, occurs);
        if (container) {
            XSDComplexTypeDefinition parent = this.xsdFactory.createXSDComplexTypeDefinition();
            parent.setTargetNamespace(SCHEMA_FOR_CHANNEL_INSTANCE);
            parent.setName(LOCAL_NAME_FOR_STRUCTURED_CONT);
            anonComplexType.setBaseTypeDefinition(parent);
            anonComplexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        }
        element.setAnonymousTypeDefinition(anonComplexType);
        return element;
    }

    private XSDElementDeclaration createElementWithSimpleType(ICMInputSimpleDataType field, StringBuilder typeAsText) throws ICMException {
        XSDElementDeclaration element = this.createElement(field.getName());
        XSDSimpleTypeDefinition anonSimpleType = this.createSimpleType(field);
        typeAsText.append(ANNOTATION_SHORT_ICM_DATA_ELEMENT);
        typeAsText.append(",");
        typeAsText.append(ANNOTATION_SHORT_TYPE);
        typeAsText.append("=");
        typeAsText.append(field.getType().getCode());
        typeAsText.append(",");
        typeAsText.append(ANNOTATION_SHORT_LAR);
        typeAsText.append("=");
        typeAsText.append(field.getLar());
        typeAsText.append(",");
        typeAsText.append(ANNOTATION_SHORT_FRACTION_DIGITS);
        typeAsText.append("=");
        typeAsText.append(field.getFractionDigits());
        element.setAnonymousTypeDefinition(anonSimpleType);
        return element;
    }

    private void addComment(String comment, Object element, boolean documentation) {
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        if (element instanceof XSDElementDeclaration) {
            ((XSDElementDeclaration)element).setAnnotation(annotation);
        } else if (element instanceof XSDTypeDefinition) {
            ((XSDTypeDefinition)element).setAnnotation(annotation);
        } else if (element instanceof XSDSchema) {
            ((XSDSchema)element).getContents().add((Object)annotation);
        } else if (element instanceof XSDModelGroup) {
            ((XSDModelGroup)element).setAnnotation(annotation);
        } else {
            throw new ICMRuntimeException("INTERNAL ERROR: Bad type: " + element.getClass());
        }
        Element el = null;
        el = documentation ? annotation.createUserInformation(URI_FOR_COMMENTS) : annotation.createApplicationInformation(URI_FOR_COMMENTS);
        annotation.getElement().appendChild(el);
        el.appendChild(el.getOwnerDocument().createTextNode(comment));
    }

    private XSDSimpleTypeDefinition createSimpleType(ICMInputSimpleDataType field) throws ICMException {
        XSDSimpleTypeDefinition simpleType = null;
        switch (field.getType()) {
            case HEX_ARRAY: {
                simpleType = this.createHexBinary(field.getLar());
                break;
            }
            case BYTE: 
            case UNSIGNED_BYTE: 
            case SHORT: 
            case UNSIGNED_SHORT: 
            case INT: 
            case UNSIGNED_INT: 
            case LONG: 
            case UNSIGNED_LONG: {
                simpleType = this.createNumeric(field.getType(), field.getLar());
                break;
            }
            case BOOLEAN: {
                simpleType = this.createBoolean();
                break;
            }
            case DECIMAL: 
            case UNSIGNED_DECIMAL: 
            case ZONED: 
            case UNSIGNED_ZONED: {
                simpleType = this.createDecimal(field.getType(), field.getLar(), field.getFractionDigits());
                break;
            }
            case WIDE_CHAR_ARRAY: 
            case UTF16_CHAR_ARRAY: {
                simpleType = this.createString(field.getLar(), field.getMinLength(), field.getMappingStrategy());
                break;
            }
            case CHAR_ARRAY: {
                if (field.getMappingStrategy().equals((Object)ICM.VaryingLength.FIXED_LENGTH_BINARY)) {
                    simpleType = this.createBase64Binary(field.getLar());
                    break;
                }
                simpleType = this.createString(field.getLar(), field.getMinLength(), field.getMappingStrategy());
                break;
            }
            case BFP_FLOAT: 
            case HFP_SHORT: {
                simpleType = this.createFloat();
                break;
            }
            case BFP_DOUBLE: 
            case HFP_LONG: {
                simpleType = this.createDouble();
                break;
            }
            case ABSTIME: {
                simpleType = this.createDateTime();
                break;
            }
            default: {
                throw new ICMException("INTERNAL ERROR: Illegal type value: " + (Object)((Object)field.getType()));
            }
        }
        return simpleType;
    }

    private XSDSimpleTypeDefinition createString(int maxLength, int minLength, ICM.VaryingLength mappingStrategy) throws ICMException {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        if (maxLength < 1) {
            throw new ICMException("INTERNAL ERROR: Invalid LAR value for a CHAR_ARRAY: " + maxLength);
        }
        this.addMaxLengthFacet(simpleType, maxLength);
        if (minLength > 0) {
            this.addMinLengthFacet(simpleType, minLength);
        }
        XSDWhiteSpaceFacet ws = this.xsdFactory.createXSDWhiteSpaceFacet();
        if (mappingStrategy.equals((Object)ICM.VaryingLength.WHITESPACE_COLLAPSE)) {
            ws.setLexicalValue("collapse");
        } else {
            ws.setLexicalValue("preserve");
        }
        simpleType.getFacetContents().add((Object)ws);
        return simpleType;
    }

    private XSDSimpleTypeDefinition createBase64Binary(int lar) throws ICMException {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("base64Binary"));
        if (lar < 1) {
            throw new ICMException("INTERNAL ERROR: Invalid LAR value for a CHAR_ARRAY: " + lar);
        }
        this.addLengthFacet(simpleType, lar);
        return simpleType;
    }

    private XSDSimpleTypeDefinition createHexBinary(int lar) throws ICMException {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("hexBinary"));
        if (lar < 1) {
            throw new ICMException("INTERNAL ERROR: Invalid LAR value for a HEX_ARRAY: " + lar);
        }
        this.addLengthFacet(simpleType, lar);
        return simpleType;
    }

    private XSDSimpleTypeDefinition createNumeric(ICM.ICMDataType type, int lar) throws ICMException {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        String typeStr = null;
        BigDecimal maxVal = null;
        boolean unsigned = false;
        switch (type) {
            case BYTE: {
                typeStr = "byte";
                maxVal = new BigDecimal(127L);
                break;
            }
            case UNSIGNED_BYTE: {
                typeStr = "unsignedByte";
                maxVal = new BigDecimal(255L);
                unsigned = true;
                break;
            }
            case SHORT: {
                typeStr = "short";
                maxVal = new BigDecimal(32767L);
                break;
            }
            case UNSIGNED_SHORT: {
                typeStr = "unsignedShort";
                maxVal = new BigDecimal(65535L);
                unsigned = true;
                break;
            }
            case INT: {
                typeStr = "int";
                maxVal = new BigDecimal((long)Integer.MAX_VALUE);
                break;
            }
            case UNSIGNED_INT: {
                typeStr = "unsignedInt";
                maxVal = new BigDecimal(0xFFFFFFFFL);
                unsigned = true;
                break;
            }
            case LONG: {
                typeStr = "long";
                maxVal = new BigDecimal("9999999999999999999999999999999");
                break;
            }
            case UNSIGNED_LONG: {
                typeStr = "unsignedLong";
                maxVal = new BigDecimal("9999999999999999999999999999999");
                unsigned = true;
                break;
            }
            default: {
                throw new ICMException("INTERNAL ERROR: Invalid numeric type: " + (Object)((Object)type));
            }
        }
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition(typeStr));
        if (lar > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < lar; ++i) {
                sb.append("9");
            }
            String maxStr = sb.toString();
            String minStr = null;
            minStr = unsigned ? "0" : "-" + maxStr;
            BigDecimal desiredMaxValue = new BigDecimal(maxStr);
            if (desiredMaxValue.compareTo(maxVal) > 0) {
                maxStr = maxVal.toPlainString();
                if (!minStr.equals("0")) {
                    BigDecimal minVal = maxVal.negate();
                    minVal = minVal.subtract(BigDecimal.valueOf(1L));
                    minStr = minVal.toPlainString();
                }
            }
            this.addMaxInclusiveFacet(simpleType, maxStr);
            this.addMinInclusiveFacet(simpleType, minStr);
        }
        return simpleType;
    }

    private XSDSimpleTypeDefinition createDecimal(ICM.ICMDataType type, int nonFractionDigits, int fractionDigits) {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("decimal"));
        this.addTotalDigitsFacet(simpleType, Integer.toString(nonFractionDigits + fractionDigits));
        this.addFractionDigitsFacet(simpleType, Integer.toString(fractionDigits));
        if (type.equals((Object)ICM.ICMDataType.UNSIGNED_DECIMAL) || type.equals((Object)ICM.ICMDataType.UNSIGNED_ZONED)) {
            this.addMinInclusiveFacet(simpleType, "0");
        }
        return simpleType;
    }

    private XSDSimpleTypeDefinition createBoolean() {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("boolean"));
        return simpleType;
    }

    private XSDSimpleTypeDefinition createFloat() {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("float"));
        return simpleType;
    }

    private XSDSimpleTypeDefinition createDouble() {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("double"));
        return simpleType;
    }

    private XSDSimpleTypeDefinition createDateTime() {
        XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("dateTime"));
        return simpleType;
    }

    private void addLengthFacet(XSDSimpleTypeDefinition type, int length) {
        XSDLengthFacet len = this.xsdFactory.createXSDLengthFacet();
        len.setLexicalValue(Integer.toString(length));
        type.getFacetContents().add((Object)len);
    }

    private void addMaxLengthFacet(XSDSimpleTypeDefinition type, int maxLength) {
        XSDMaxLengthFacet len = this.xsdFactory.createXSDMaxLengthFacet();
        len.setLexicalValue(Integer.toString(maxLength));
        type.getFacetContents().add((Object)len);
    }

    private void addMinLengthFacet(XSDSimpleTypeDefinition type, int minLength) {
        XSDMinLengthFacet len = this.xsdFactory.createXSDMinLengthFacet();
        len.setLexicalValue(Integer.toString(minLength));
        type.getFacetContents().add((Object)len);
    }

    private void addMaxInclusiveFacet(XSDSimpleTypeDefinition type, String maxInclusive) {
        XSDMaxInclusiveFacet len = this.xsdFactory.createXSDMaxInclusiveFacet();
        len.setLexicalValue(maxInclusive);
        type.getFacetContents().add((Object)len);
    }

    private void addMinInclusiveFacet(XSDSimpleTypeDefinition type, String minInclusive) {
        XSDMinInclusiveFacet len = this.xsdFactory.createXSDMinInclusiveFacet();
        len.setLexicalValue(minInclusive);
        type.getFacetContents().add((Object)len);
    }

    private void addTotalDigitsFacet(XSDSimpleTypeDefinition type, String totalDigits) {
        XSDTotalDigitsFacet len = this.xsdFactory.createXSDTotalDigitsFacet();
        len.setLexicalValue(totalDigits);
        type.getFacetContents().add((Object)len);
    }

    private void addFractionDigitsFacet(XSDSimpleTypeDefinition type, String fractionDigits) {
        XSDFractionDigitsFacet len = this.xsdFactory.createXSDFractionDigitsFacet();
        len.setLexicalValue(fractionDigits);
        type.getFacetContents().add((Object)len);
    }

    private XSDComplexTypeDefinition createComplexType(String name, int occurs) {
        XSDComplexTypeDefinition complexType = this.xsdFactory.createXSDComplexTypeDefinition();
        if (name != null) {
            complexType.setName(name);
            complexType.setAbstract(false);
            complexType.getBlock().add((Object)XSDProhibitedSubstitutions.ALL_LITERAL);
            complexType.getLexicalFinal().add((Object)XSDComplexFinal.ALL_LITERAL);
        }
        complexType.setDerivationMethod(XSDDerivationMethod.RESTRICTION_LITERAL);
        complexType.setMixed(false);
        XSDParticle particle = this.xsdFactory.createXSDParticle();
        complexType.setContent(particle);
        if (occurs > 1) {
            particle.setMaxOccurs(occurs);
            particle.setMinOccurs(occurs);
        }
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        particle.setContent(modelGroup);
        this.currentModelGroup = modelGroup;
        return complexType;
    }

    @Override
    public void addElementDeclaration(String wsdlPartNameSpace, String wsdlPartName, QName target, boolean validate) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid use of method.");
    }

    @Override
    public void addTypeDefinition(String wsdlPartNameSpace, String wsdlPartName, QName target) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid use of method.");
    }

    private PrintStream getLogger() {
        return this.logger;
    }

    private boolean isTrace() {
        return this.trace;
    }

    @Override
    public byte[] toByteArray() throws IOException, ICMException {
        if (!this.complete) {
            throw new ICMException("INTERNAL ERROR: ICM is not complete.");
        }
        return this.delegate_ICM.toByteArray();
    }

    @Override
    public Element toXMLElement() throws ICMException {
        if (!this.complete) {
            throw new ICMException("INTERNAL ERROR: ICM is not complete.");
        }
        Element element = this.schema.getElement();
        if (element == null) {
            this.schema.updateElement();
        }
        return this.schema.getElement();
    }

    @Override
    public void completedICM() throws ICMException, IOException {
        if (this.complete) {
            throw new ICMException("INTERNAL ERROR: completedICM() called twice for the same ICM.");
        }
        this.complete = true;
        if (!this.content_found) {
            throw new ICMException(MessageHandler.getMessage("DFHPI9031E"));
        }
        if (this.parms.isComplexChannelBased()) {
            XSDImport channelNS = this.xsdFactory.createXSDImport();
            channelNS.setNamespace(SCHEMA_FOR_CHANNEL_INSTANCE);
            this.schema.getContents().add(2, (Object)channelNS);
        }
        if (this.parms.getICMInterceptor() == null) {
            this.builder.validateResourceSet(this.schema);
        }
        ICMBuilderImpl newBuilder = new ICMBuilderImpl(this.schema, this.parms.getLang(), this.logger);
        ICM.VaryingLength charVarying = this.parms.getDefaultCharVarying();
        if (charVarying.equals((Object)ICM.VaryingLength.FIXED_LENGTH_BINARY) || charVarying.equals((Object)ICM.VaryingLength.WHITESPACE_COLLAPSE)) {
            this.parms.setDefaultCharVarying(ICM.VaryingLength.FIXED_LENGTH_ARRAY);
        }
        this.delegate_ICM = newBuilder.createICM(this.parms);
        String accessorElementName = this.parms.getWsdlOperation().getLocalPart();
        if (this.parms.getMessageType().equals((Object)ICM.XMLContentType.SOAP_RESPONSE)) {
            accessorElementName = accessorElementName + "Response";
        }
        QName name = new QName(this.parms.getWsdlOperation().getNamespaceURI(), accessorElementName);
        this.delegate_ICM.addElementDeclaration("", "", name, false);
        this.delegate_ICM.completedICM();
    }

    @Override
    public List<ICMEntry> getContents() throws ICMException {
        if (!this.complete) {
            throw new ICMException("INTERNAL ERROR: ICM is not complete.");
        }
        return this.delegate_ICM.getContents();
    }

    private void handleComments(XSDElementDeclaration element, ICMInputSimpleDataType field, StringBuilder commentsAsString) throws ICMException {
        int mappingLevel;
        Properties p;
        block28: {
            block27: {
                if (field.getComment() != null && !field.getComment().equals("")) {
                    this.addComment(field.getComment(), element, true);
                }
                p = new Properties();
                if (this.parms.getLang() == 2 || this.parms.getLang() == 6 || this.parms.getLang() == 7) {
                    if (field.isAligned()) {
                        this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_ALLIGNMENT, ANNOTATION_SHORT_PROPERTY_FOR_ALLIGNMENT, "true");
                    }
                } else if (!field.isAligned()) {
                    this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_ALLIGNMENT, ANNOTATION_SHORT_PROPERTY_FOR_ALLIGNMENT, "false");
                }
                if (field.getType().equals((Object)ICM.ICMDataType.WIDE_CHAR_ARRAY)) {
                    this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_WIDECHARS, ANNOTATION_SHORT_PROPERTY_FOR_WIDECHARS, "true");
                }
                if (!MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel = this.parms.getMappingLevel())) break block27;
                switch (field.getMappingStrategy()) {
                    case WHITESPACE_COLLAPSE: 
                    case FIXED_LENGTH_BINARY: 
                    case FIXED_LENGTH_ARRAY: {
                        this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_SHORT_PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_VALUE_FOR_VARIABLE_LENGTH_FIXED);
                        break block28;
                    }
                    case NULL_TERMINATED_CHAR_ARRAY: {
                        this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_SHORT_PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_VALUE_FOR_VARIABLE_LENGTH_NULL);
                        break block28;
                    }
                    case VARYING_ARRAY: {
                        this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_SHORT_PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_VALUE_FOR_VARIABLE_LENGTH_VARYING);
                        break block28;
                    }
                    case NO_VARYING_STRATEGY: {
                        break block28;
                    }
                    default: {
                        throw new ICMException("INTERNAL ERROR: Bad mapping strategy: " + (Object)((Object)field.getMappingStrategy()));
                    }
                }
            }
            if (MappingLevelHelper.supportsMappingLevel_1_1(mappingLevel) && field.getMappingStrategy().equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY) && field.getLar() > this.parms.getCharVaryingLimit()) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_SHORT_PROPERTY_FOR_VARIABLE_LENGTH, ANNOTATION_VALUE_FOR_VARIABLE_LENGTH_FIXED);
            }
        }
        if (MappingLevelHelper.supportsMappingLevel_1_2(mappingLevel)) {
            if (field.getType().equals((Object)ICM.ICMDataType.DECIMAL) || field.getType().equals((Object)ICM.ICMDataType.UNSIGNED_DECIMAL)) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_DECIMAL_TYPE, ANNOTATION_SHORT_PROPERTY_FOR_DECIMAL_TYPE, VALUE_FOR_DECIMAL_PACKED);
            }
            if (field.getType().equals((Object)ICM.ICMDataType.ZONED) || field.getType().equals((Object)ICM.ICMDataType.UNSIGNED_ZONED)) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_DECIMAL_TYPE, ANNOTATION_SHORT_PROPERTY_FOR_DECIMAL_TYPE, VALUE_FOR_DECIMAL_ZONED);
            }
            if (field.isSignLeading()) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_SIGN_ENDIANNESS, ANNOTATION_SHORT_PROPERTY_FOR_SIGN_ENDIANNESS, VALUE_FOR_SIGN_LEADING);
            }
            if (field.isSeparateCharacter()) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_SEPARATE_SIGN, ANNOTATION_SHORT_PROPERTY_FOR_SEPARATE_SIGN, "true");
            }
        }
        if (MappingLevelHelper.supportsMappingLevel_4_0(mappingLevel)) {
            if (field.getType().equals((Object)ICM.ICMDataType.HFP_LONG) || field.getType().equals((Object)ICM.ICMDataType.HFP_SHORT)) {
                p.setProperty(PROPERTY_FOR_FLOAT_TYPE, VALUE_FOR_FLOAT_TYPE_HEX);
            }
            if (field.getType().equals((Object)ICM.ICMDataType.BFP_DOUBLE) || field.getType().equals((Object)ICM.ICMDataType.BFP_FLOAT)) {
                p.setProperty(PROPERTY_FOR_FLOAT_TYPE, VALUE_FOR_FLOAT_TYPE_IEEE);
            }
            if (field.getODOTarget() != null) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_ODO, ANNOTATION_SHORT_PROPERTY_FOR_ODO, field.getODOTarget().getName());
            }
            if (field.isODOTarget()) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_ODO_TARGET, ANNOTATION_SHORT_PROPERTY_FOR_ODO_TARGET, field.getName());
            }
            if (field.getType().equals((Object)ICM.ICMDataType.UTF16_CHAR_ARRAY)) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_UTF16, ANNOTATION_SHORT_PROPERTY_FOR_UTF16, "true");
            } else if (field.getType().equals((Object)ICM.ICMDataType.CHAR_ARRAY)) {
                this.processIndividualComment(p, commentsAsString, PROPERTY_FOR_UTF16, ANNOTATION_SHORT_PROPERTY_FOR_UTF16, "false");
            }
        }
        if (!field.isSuppressed()) {
            this.addPropertiesComment(p, element.getTypeDefinition());
        }
    }

    private void addPropertiesComment(Properties p, Object element) throws ICMException {
        if (!p.isEmpty()) {
            String propertiesAsString = null;
            if (MappingLevelHelper.supportsMappingLevel_2(this.parms.getMappingLevel())) {
                StringBuilder sb = new StringBuilder();
                for (String string : p.keySet()) {
                    String value = p.getProperty(string);
                    sb.append(LINE_SEPARATOR);
                    sb.append(string);
                    sb.append("=");
                    sb.append(value);
                }
                propertiesAsString = sb.toString();
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    p.store(baos, null);
                }
                catch (IOException ioe) {
                    ICMException iCMException = new ICMException("INTERNAL ERROR: Problem encountered storing properties");
                    iCMException.initCause(ioe);
                    throw iCMException;
                }
                propertiesAsString = new String(baos.toByteArray(), CHARSET_ISO8859_1);
            }
            this.addComment(propertiesAsString, element, false);
        }
    }

    private XSDComplexTypeDefinition createDefinitionForCICSType(String contentTypeName, String baseTypeName, String baseDataType) {
        XSDComplexTypeDefinition type = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        type.setName(contentTypeName);
        type.setTargetNamespace(SCHEMA_FOR_CHANNEL_INSTANCE);
        XSDComplexTypeDefinition parentType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        parentType.setName(baseTypeName);
        parentType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDAnnotation annotation = XSDFactory.eINSTANCE.createXSDAnnotation();
        parentType.setAnnotation(annotation);
        XSDSimpleTypeDefinition anonymousSimpleTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        parentType.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition(baseDataType));
        parentType.setContent(anonymousSimpleTypeDefinition);
        type.setBaseTypeDefinition(parentType);
        type.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        return type;
    }

    @Override
    public void addContainerEntry(ICMInputContainerDataType inputParameters) throws ICMException {
        XSDComplexTypeDefinition base = this.stringContainer;
        if (inputParameters.getType() == ICM.ContainerDataType.CONT_TYPE_BIT) {
            base = this.bitContainer;
        }
        XSDParticle elementParticle = this.xsdFactory.createXSDParticle();
        if (inputParameters.getUsage() == ICM.ContainerUsage.CONT_USE_OPTIONAL) {
            elementParticle.setMinOccurs(0);
        }
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(inputParameters.getName());
        element.setNillable(false);
        elementParticle.setContent(element);
        XSDComplexTypeDefinition typeDef = this.xsdFactory.createXSDComplexTypeDefinition();
        typeDef.setMixed(false);
        element.setAnonymousTypeDefinition(typeDef);
        typeDef.setBaseTypeDefinition(base);
        typeDef.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        this.currentModelGroup.getContents().add((Object)elementParticle);
    }

    @Override
    public void addDataElementEntry(ICMInputSimpleDataType field) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
        if (this.isTrace()) {
            this.getLogger().println("Adding a Data Element entry. " + field);
        }
        this.addElementToWSDL(field);
    }

    private void addElementToWSDL(ICMInputSimpleDataType field) throws ICMException {
        StringBuilder suppressionComment = new StringBuilder();
        XSDElementDeclaration element = this.createElementWithSimpleType(field, suppressionComment);
        if (!field.isSuppressed()) {
            XSDParticle particle = this.currentParticle != null ? this.currentParticle : this.xsdFactory.createXSDParticle();
            particle.setContent(element);
            this.currentModelGroup.getContents().add((Object)particle);
            if (this.currentAnnotations != null) {
                this.addPropertiesComment(this.currentAnnotations, particle.getContent());
                this.currentAnnotations = null;
            }
        }
        this.handleComments(element, field, suppressionComment);
        if (field.isSuppressed()) {
            this.addSuppressionCommentToPreviousElement(suppressionComment.toString());
        } else {
            this.content_found = true;
        }
    }

    @Override
    public void addFixedRepeatEntry(ICMInputArrayStartDataType arrayParameters) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
        if (this.isTrace()) {
            this.getLogger().println("Adding a Fixed Repeat entry. Name: '" + arrayParameters);
        }
        if (this.currentParticle != null) {
            throw new RuntimeException("Assertion error: Current Particle not equal to null: " + this.currentParticle);
        }
        if (this.currentAnnotations != null) {
            throw new RuntimeException("Assertion error: Current Annotations not equal to null: " + this.currentAnnotations);
        }
        if (arrayParameters.isSuppressed()) {
            this.addSuppressionCommentToPreviousElement("FR,oc=" + arrayParameters.getOccurs());
        } else {
            XSDParticle particle;
            this.content_found = false;
            XSDModelGroup localModelGroupCopy = this.currentModelGroup;
            Properties annotationsToAdd = new Properties();
            if (arrayParameters.isStructural() || !MappingLevelHelper.supportsMappingLevel_4_1(this.parms.getMappingLevel())) {
                int minOccurs = arrayParameters.getMinOccurs();
                if (arrayParameters.isStructural() && MappingLevelHelper.supportsMappingLevel_4_1(this.parms.getMappingLevel()) && arrayParameters.getODOTarget() == null && "ENABLED".equalsIgnoreCase(this.parms.getInputParameters().getProperty("TRUNCATE-NULL-ARRAYS"))) {
                    minOccurs = 0;
                    this.processIndividualComment(annotationsToAdd, new StringBuilder(), PROPERTY_FOR_TRUNCATE_NULL_ARRAYS, ANNOTATION_SHORT_PROPERTY_FOR_TRUNCATE_NULL_ARRAYS, "true");
                    this.processIndividualComment(annotationsToAdd, new StringBuilder(), PROPERTY_FOR_TRUNCATE_NULL_ARRAY_VALUES, ANNOTATION_SHORT_PROPERTY_FOR_TRUNCATE_NULL_ARRAY_VALUES, this.parms.getInputParameters().getProperty("TRUNCATE-NULL-ARRAY-VALUES"));
                }
                particle = this.createParticleForComplexType(arrayParameters.getName(), minOccurs, arrayParameters.getOccurs(), false, arrayParameters.getODOTarget());
                localModelGroupCopy.getContents().add((Object)particle);
            } else {
                particle = this.xsdFactory.createXSDParticle();
                if (arrayParameters.getMinOccurs() != 1 || arrayParameters.getOccurs() != 1) {
                    particle.setMinOccurs(arrayParameters.getMinOccurs());
                    particle.setMaxOccurs(arrayParameters.getOccurs());
                }
                this.currentParticle = particle;
            }
            if (arrayParameters.getODOTarget() != null) {
                this.processIndividualComment(annotationsToAdd, new StringBuilder(), PROPERTY_FOR_ODO, ANNOTATION_SHORT_PROPERTY_FOR_ODO, arrayParameters.getODOTarget().getName());
                if (this.currentParticle != null) {
                    this.currentAnnotations = annotationsToAdd;
                }
            }
            if (annotationsToAdd.size() > 0 && this.currentParticle == null) {
                this.addPropertiesComment(annotationsToAdd, particle.getContent());
            }
        }
    }

    @Override
    public void addEndRepeatEntry(ICMInputArrayEndDataType fieldParms) throws ICMException {
        this.sendStructEnd(fieldParms);
    }

    @Override
    public void sendStructStart(ICMInputStructureStartDataType structureParms) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
        if (this.isTrace()) {
            this.getLogger().println("Adding a structural entry. " + structureParms);
        }
        if (structureParms.isSuppressed()) {
            this.addSuppressionCommentToPreviousElement(ANNOTATION_SHORT_ICM_STRUCTURE);
        } else {
            this.content_found = false;
            XSDModelGroup localModelGroupCopy = this.currentModelGroup;
            XSDParticle particle = this.createParticleForComplexType(structureParms.getName(), 1, 1, structureParms.getType() != ICM.StructureType.STRUCTURE_STANDARD, null);
            if (structureParms.getType() == ICM.StructureType.STRUCTURE_CONTAINER_OPTIONAL) {
                particle.setMinOccurs(0);
            }
            localModelGroupCopy.getContents().add((Object)particle);
        }
    }

    @Override
    public void sendStructEnd(ICMInputStructureEndDataType field) throws ICMException {
        if (this.startingFromWSDL) {
            throw new ICMException("INTERNAL ERROR: Invalid method call.");
        }
        if (this.isTrace()) {
            this.getLogger().println("Adding an end structural/repeat entry. " + field);
        }
        if (field.isSuppressed()) {
            this.addSuppressionCommentToPreviousElement(ANNOTATION_SHORT_ICM_END_REPEAT);
        } else {
            if (!this.content_found) {
                throw new ICMException(MessageHandler.getMessage("DFHPI9031E"));
            }
            if (this.currentParticle != null) {
                this.currentParticle = null;
                this.currentAnnotations = null;
            } else {
                XSDConcreteComponent comp = this.currentModelGroup.getContainer();
                comp = comp.getContainer();
                comp = comp.getContainer();
                comp = comp.getContainer();
                if (!((comp = comp.getContainer()) instanceof XSDModelGroup)) {
                    throw new ICMException("INTERNAL ERROR: Schema Integrity error detected");
                }
                this.currentModelGroup = (XSDModelGroup)comp;
            }
        }
    }

    @Override
    public String toString() {
        if (!this.complete) {
            return "INTERNAL ERROR: ICM is not complete";
        }
        return this.delegate_ICM.toString();
    }

    @Override
    public String[] getMessages() {
        return new String[0];
    }

    @Override
    public long getCommAreaLength() throws ICMException {
        if (!this.complete) {
            throw new ICMException("INTERNAL ERROR: ICM is not complete.");
        }
        return this.delegate_ICM.getCommAreaLength();
    }

    @Override
    public long getICMLength() {
        return this.delegate_ICM.getICMLength();
    }

    @Override
    public String getTargetNameSpace() {
        return this.parms.getWsdlOperation().getNamespaceURI();
    }

    @Override
    public String getTopLevelElementLocalName() {
        return this.localNameForWrapperElement;
    }

    private void addSuppressionCommentToPreviousElement(String comment) {
        if (!this.currentModelGroup.getContents().isEmpty()) {
            XSDParticle prevParticle = (XSDParticle)this.currentModelGroup.getContents().get(this.currentModelGroup.getContents().size() - 1);
            XSDElementDeclaration prevElement = (XSDElementDeclaration)prevParticle.getContent();
            XSDAnnotation prevAnnotation = prevElement.getAnnotation();
            if (prevAnnotation == null) {
                this.addComment("", prevElement, false);
                prevAnnotation = prevElement.getAnnotation();
            }
            this.processSuppressionAnnotation(prevAnnotation, comment);
        } else {
            XSDAnnotation annotation = this.currentModelGroup.getAnnotation();
            if (annotation == null) {
                this.addComment("", this.currentModelGroup, false);
                annotation = this.currentModelGroup.getAnnotation();
            }
            this.processSuppressionAnnotation(annotation, comment);
        }
    }

    private void processSuppressionAnnotation(XSDAnnotation annotation, String comment) {
        Element firstElement = (Element)annotation.getApplicationInformation(URI_FOR_COMMENTS).get(0);
        int total = firstElement.getChildNodes().getLength();
        firstElement.appendChild(annotation.getElement().getOwnerDocument().createTextNode(LINE_SEPARATOR + PROPERTY_FOR_SUPPRESSED_FIELD + total + "=" + comment));
    }

    private void processIndividualComment(Properties p, StringBuilder commentsAsString, String property, String shortProperty, String value) {
        p.setProperty(property, value);
        commentsAsString.append(",");
        commentsAsString.append(shortProperty);
        commentsAsString.append("=");
        commentsAsString.append(value);
    }

    protected XSDParticle createDataElementFromSuppressionString(StringTokenizer st, Properties p) throws ICMException {
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        int lar = -1;
        ICM.ICMDataType type = null;
        int fractionDigits = -1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (ANNOTATION_SHORT_TYPE.equals(token)) {
                type = ICM.ICMDataType.get(Integer.parseInt(st.nextToken()));
                continue;
            }
            if (ANNOTATION_SHORT_LAR.equals(token)) {
                lar = Integer.parseInt(st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_FRACTION_DIGITS.equals(token)) {
                fractionDigits = Integer.parseInt(st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_ALLIGNMENT.equals(token)) {
                p.put(PROPERTY_FOR_ALLIGNMENT, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_DECIMAL_TYPE.equals(token)) {
                p.put(PROPERTY_FOR_DECIMAL_TYPE, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_MAPPING_LEVEL.equals(token)) {
                p.put(PROPERTY_FOR_MAPPING_LEVEL, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_SEPARATE_SIGN.equals(token)) {
                p.put(PROPERTY_FOR_SEPARATE_SIGN, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_SIGN_ENDIANNESS.equals(token)) {
                p.put(PROPERTY_FOR_SIGN_ENDIANNESS, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_VARIABLE_LENGTH.equals(token)) {
                p.put(PROPERTY_FOR_VARIABLE_LENGTH, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_WIDECHARS.equals(token)) {
                p.put(PROPERTY_FOR_WIDECHARS, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_ODO.equals(token)) {
                p.put(PROPERTY_FOR_ODO, st.nextToken());
                continue;
            }
            if (ANNOTATION_SHORT_PROPERTY_FOR_ODO_TARGET.equals(token)) {
                p.put(PROPERTY_FOR_ODO_TARGET, st.nextToken());
                continue;
            }
            if (!ANNOTATION_SHORT_PROPERTY_FOR_UTF16.equals(token)) continue;
            p.put(PROPERTY_FOR_UTF16, st.nextToken());
        }
        ICMInputSimpleDataTypeImpl field = new ICMInputSimpleDataTypeImpl(ANNOTATION_SUPPRESSED_FIELD_NAME, type);
        field.setLar(lar);
        field.setFractionDigits(fractionDigits);
        field.setMappingStrategy(this.parms.getDefaultCharVarying());
        XSDElementDeclaration newEl = this.createElementWithSimpleType(field, new StringBuilder());
        particle.setContent(newEl);
        return particle;
    }

    private XSDParticle createParticleForComplexType(String name, int minOccurs, int occurs, boolean container, ICMInputSimpleDataType odoTarget) throws ICMException {
        XSDElementDeclaration element = this.createElementWithComplexType(name, 1, container);
        XSDParticle particle = this.xsdFactory.createXSDParticle();
        particle.setContent(element);
        if (occurs != 1 || minOccurs != 1) {
            particle.setMaxOccurs(occurs);
            particle.setMinOccurs(minOccurs);
        }
        return particle;
    }

    protected XSDParticle createFixedRepeatFromSuppressionString(StringTokenizer st) throws ICMException {
        int occurs = -1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!ANNOTATION_SHORT_ICM_OCCURENCES.equals(token)) continue;
            occurs = Integer.parseInt(st.nextToken());
        }
        return this.createParticleForComplexType("filler", occurs, occurs, false, null);
    }

    protected XSDParticle createStructuralFromSuppressionString() throws ICMException {
        return this.createParticleForComplexType("filler", 1, 1, false, null);
    }

    protected XSDModelGroup getCurrentModelGroup() {
        return this.currentModelGroup;
    }

    @Override
    public void addGlobalTypeDefinition(QName targetQName, boolean nillable) throws ICMException {
        throw new ICMException("INTERNAL ERROR: Invalid use of method.");
    }

    @Override
    public IPlatform.EndianType getEndianType() {
        if (this.parms.getPlatform() != null) {
            return this.parms.getPlatform().getEndianness();
        }
        return IPlatform.EndianType.BIG_ENDIAN;
    }

    @Override
    public IPlatform.ZonedEncodingType getZonedEncodingType() {
        if (this.parms.getPlatform() != null) {
            return this.parms.getPlatform().getZonedEncoding();
        }
        return IPlatform.ZonedEncodingType.ZONED_EBCDIC;
    }
}

