/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.schema.impl.ICMIndexEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import java.io.Serializable;
import java.util.Comparator;

class ICMIndexEntryComparator
implements Comparator<ICMIndexEntryImpl>,
Serializable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private boolean nsImportant = false;
    private static final long serialVersionUID = 42L;

    public ICMIndexEntryComparator(boolean nsImportant) {
        this.nsImportant = nsImportant;
    }

    @Override
    public int compare(ICMIndexEntryImpl arg0, ICMIndexEntryImpl arg1) {
        ICMIndexEntryImpl ie1 = arg0;
        ICMIndexEntryImpl ie2 = arg1;
        if (ie1.getNumOfParts() < ie2.getNumOfParts()) {
            return -1;
        }
        if (ie1.getNumOfParts() > ie2.getNumOfParts()) {
            return 1;
        }
        try {
            byte[] index1Bytes = null;
            byte[] index2Bytes = null;
            if (this.nsImportant) {
                index1Bytes = ByteArray.toEBCDICByteArray(ie1.getXpathForSearchWithNS(), -1);
                index2Bytes = ByteArray.toEBCDICByteArray(ie2.getXpathForSearchWithNS(), -1);
            } else {
                index1Bytes = ByteArray.toEBCDICByteArray(ie1.getXpathForSearch(), -1);
                index2Bytes = ByteArray.toEBCDICByteArray(ie2.getXpathForSearch(), -1);
            }
            for (int pos = 0; pos < index1Bytes.length; ++pos) {
                int index2val;
                if (pos >= index2Bytes.length) {
                    return 1;
                }
                int index1val = index1Bytes[pos];
                if (index1val < 0) {
                    index1val += 256;
                }
                if ((index2val = index2Bytes[pos]) < 0) {
                    index2val += 256;
                }
                if (index1val > index2val) {
                    return 1;
                }
                if (index1val >= index2val) continue;
                return -1;
            }
            return -1;
        }
        catch (Exception e) {
            this.throwException(e);
            return 0;
        }
    }

    private void throwException(Exception e) {
        ICMRuntimeException ire = new ICMRuntimeException("INTERNAL ERROR: Unexpected exception caught during an index entry compare.");
        ire.initCause(e);
        throw ire;
    }
}

