/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMIndexEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class ICMIndexEntryImpl
implements ICMIndexEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int NOT_SET = -1;
    private long targetOffset = -1L;
    private long indexOffset = -1L;
    private ICMIndexEntryImpl nextIndexEntry = null;
    private long nextIndexEntryOffset = -1L;
    private static final int NUM_PARTS_LENGTH = 2;
    private static final int XPATH_OFFSET_LENGTH = 8;
    private static final int XPATH_PART_LENGTH = 1;
    private static final int ICM_XPATH_PART_MAX_LENGTH = 255;
    private static final int OFFSET_IN_ICM_LENGTH = 4;
    private static final int OFFSET_OF_PROBABLE_NEXT_LENGTH = 2;
    private List<ICMConstantsSectionEntry> xpathParts = new LinkedList<ICMConstantsSectionEntry>();
    private int numOfParts = 0;
    private int entryNum = -1;
    private ICMIndexEntry firstChild = null;
    private ICMIndexEntry lastChild = null;
    private List<QName> qNameParts = new LinkedList<QName>();
    private ICMEntry currentEntryInICM = null;
    private Map<QName, ICMIndexEntry> children = new HashMap<QName, ICMIndexEntry>();
    private String xpathForSearchWithNS = null;
    private String xpathForSearch = null;
    private ICMIndexEntry parent = null;

    public List<QName> getQNameList() {
        return this.qNameParts;
    }

    public long getNextIndexEntryOffset() {
        return this.nextIndexEntryOffset;
    }

    public ICMIndexEntryImpl getNextIndexEntry() {
        return this.nextIndexEntry;
    }

    public long getEntryOffsetInICM() {
        return this.targetOffset;
    }

    @Override
    public ICMEntry getCurrentEntryInICM() {
        return this.currentEntryInICM;
    }

    ICMIndexEntryImpl(String xpath, ICMEntryImpl entry, ICMConstantsSectionHolder cse) throws ICMException {
        String[] tokens = xpath.split("[+][+][+]");
        for (int i = 1; i < tokens.length; ++i) {
            String part = tokens[i];
            int delimiterPos = part.indexOf("~~~");
            String nameSpace = part.substring(0, delimiterPos);
            String elementName = part.substring(delimiterPos + 3);
            if (nameSpace.equals("null")) {
                nameSpace = "";
            }
            this.xpathParts.add(cse.createConstant(nameSpace, 255L));
            this.xpathParts.add(cse.createConstant(elementName, 255L));
            ++this.numOfParts;
            cse.checkForNameSpaceClashes(elementName, nameSpace);
        }
    }

    public ICMIndexEntryImpl(byte[] currentICMContents, int currentIndexEntryOffset, ICMConstantsSectionHolder constants, Charset CodePage, ICMImplFromWSBind icm) throws ICMException, IOException {
        this.numOfParts = ByteArray.byteArrayToInt(currentICMContents, currentIndexEntryOffset, 2);
        this.indexOffset = currentIndexEntryOffset;
        this.targetOffset = ByteArray.byteArrayToInt(currentICMContents, currentIndexEntryOffset + 2 + 2);
        if (this.targetOffset >= 0L) {
            this.currentEntryInICM = icm.getICMEntry(currentICMContents, (int)this.targetOffset, constants, CodePage);
            ((ICMEntryImpl)this.currentEntryInICM).setIndexEntry(this);
        }
        int currentOffsetOfNamespaceOffset = 0;
        int currentOffsetOfLocalnameOffset = 0;
        int currentOffsetOfNamespace = 0;
        int currentOffsetOfLocalname = 0;
        int currentLengthOfNamespace = 0;
        int currentLengthOfLocalname = 0;
        String currentNamespace = null;
        String currentLocalname = null;
        QName currentQName = null;
        String tempConstantsSection = null;
        this.nextIndexEntryOffset = ByteArray.byteArrayToInt(currentICMContents, currentIndexEntryOffset + 2, 2);
        ICMIndexEntry parent = null;
        for (int i = 0; i < this.numOfParts; ++i) {
            int currentOffsetOfIndexEntryBody = currentIndexEntryOffset + 8 + i * 24;
            currentOffsetOfNamespaceOffset = currentOffsetOfIndexEntryBody + 1 + 1 + 6;
            currentOffsetOfLocalnameOffset = currentOffsetOfNamespaceOffset + 8;
            currentOffsetOfNamespace = ByteArray.byteArrayToInt(currentICMContents, currentOffsetOfNamespaceOffset + 4);
            currentOffsetOfLocalname = ByteArray.byteArrayToInt(currentICMContents, currentOffsetOfLocalnameOffset + 4);
            currentLengthOfNamespace = ByteArray.byteArrayToInt(currentICMContents, currentOffsetOfIndexEntryBody, 1);
            currentLengthOfLocalname = ByteArray.byteArrayToInt(currentICMContents, currentOffsetOfIndexEntryBody + 1, 1);
            currentNamespace = ByteArray.byteArrayToString(currentICMContents, currentOffsetOfNamespace, currentLengthOfNamespace, CodePage, true);
            currentLocalname = ByteArray.byteArrayToString(currentICMContents, currentOffsetOfLocalname, currentLengthOfLocalname, CodePage, true);
            currentQName = icm.useNamespaces() ? new QName(currentNamespace, currentLocalname) : new QName(null, currentLocalname);
            this.qNameParts.add(currentQName);
            tempConstantsSection = currentNamespace;
            ICMConstantsSectionEntry currentICMConstantsSectionEntry = constants.createConstant(tempConstantsSection, 255L);
            currentICMConstantsSectionEntry.setOffset(currentOffsetOfNamespace);
            this.xpathParts.add(currentICMConstantsSectionEntry);
            tempConstantsSection = currentLocalname;
            currentICMConstantsSectionEntry = constants.createConstant(tempConstantsSection, 255L);
            currentICMConstantsSectionEntry.setOffset(currentOffsetOfLocalname);
            this.xpathParts.add(currentICMConstantsSectionEntry);
            if (this.numOfParts == 1) {
                icm.getTopLevelIndexEntries().put(currentQName, this);
                continue;
            }
            if (i == 0) {
                parent = icm.getTopLevelIndexEntries().get(currentQName);
                if (parent != null) continue;
                throw new RuntimeException("Failure to resolve parent qname (1): " + currentQName);
            }
            if (i >= this.numOfParts - 1) continue;
            if (parent == null) {
                throw new RuntimeException("Failure to resolve parent qname (2): " + currentQName);
            }
            if ((parent = parent.getChildren().get(currentQName)) != null) continue;
            throw new RuntimeException("Failure to resolve parent qname (3): " + currentQName);
        }
        if (parent != null) {
            parent.addChildTag(currentQName, this);
        }
        if (this.nextIndexEntryOffset < 0L || this.nextIndexEntryOffset > 65535L) {
            this.nextIndexEntryOffset = -1L;
            this.nextIndexEntry = null;
        }
    }

    protected void setNextIndexEntry(ICMIndexEntryImpl entry) {
        this.nextIndexEntry = entry;
    }

    @Override
    public void setTargetOffset(long l) {
        this.targetOffset = l;
    }

    protected void setIndexOffset(long l) {
        this.indexOffset = l;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR + "  Index Entry (Offset within ICM = " + ByteArray.formatNumForDisplay(this.indexOffset) + ")" + LINE_SEPARATOR);
        sb.append("    POSITION NUMBER = " + this.getEntryNum() + LINE_SEPARATOR);
        sb.append("    XPATH " + this.getXpath() + LINE_SEPARATOR);
        sb.append("    OFFSET = " + ByteArray.formatNumForDisplay(this.targetOffset) + LINE_SEPARATOR);
        sb.append("    PROBABLE NEXT INDEX ENTRY = ");
        if (this.nextIndexEntry != null) {
            sb.append(ByteArray.formatNumForDisplay(this.nextIndexEntry.indexOffset) + LINE_SEPARATOR);
        } else {
            sb.append(" unknown." + LINE_SEPARATOR);
        }
        return sb.toString();
    }

    protected byte[] toByteArray() throws ICMException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ByteArray.numToByteArray(this.numOfParts, 2));
        if (this.nextIndexEntry != null && this.nextIndexEntry.getIndexOffset() < 65536L) {
            baos.write(ByteArray.numToByteArray(this.nextIndexEntry.getIndexOffset(), 2));
        } else {
            baos.write(ByteArray.numToByteArray(-1L, 2));
        }
        baos.write(ByteArray.numToByteArray(this.targetOffset, 4));
        Iterator<ICMConstantsSectionEntry> parts = this.xpathParts.iterator();
        while (parts.hasNext()) {
            ICMConstantsSectionEntry ns = parts.next();
            ICMConstantsSectionEntry name = parts.next();
            if (ns != null) {
                baos.write(ByteArray.numToByteArray(ns.getLength(), 1));
            } else {
                baos.write(ByteArray.numToByteArray(-1L, 1));
            }
            baos.write(ByteArray.numToByteArray(name.getLength(), 1));
            int padding = 2;
            if (padding > 0) {
                for (int i = padding; i < 8; ++i) {
                    baos.write(new byte[]{0});
                }
            }
            if (ns != null) {
                baos.write(ByteArray.numToByteArray(ns.getOffset(), 8));
            } else {
                baos.write(ByteArray.numToByteArray(-1L, 8));
            }
            baos.write(ByteArray.numToByteArray(name.getOffset(), 8));
        }
        return baos.toByteArray();
    }

    protected String getXpath() {
        StringBuilder sb = new StringBuilder();
        sb.append("(TEXT = ");
        Iterator<ICMConstantsSectionEntry> parts = this.xpathParts.iterator();
        while (parts.hasNext()) {
            parts.next();
            String element = parts.next().getConstant();
            sb.append("/");
            sb.append(element);
        }
        sb.append(")" + LINE_SEPARATOR);
        sb.append("      XPATH PARTS = ");
        sb.append(this.numOfParts);
        sb.append(LINE_SEPARATOR);
        parts = this.xpathParts.iterator();
        while (parts.hasNext()) {
            ICMConstantsSectionEntry nameSpace = parts.next();
            ICMConstantsSectionEntry element = parts.next();
            sb.append("       NAMESPACE" + LINE_SEPARATOR);
            if (nameSpace != null) {
                sb.append("        value '");
                sb.append(nameSpace.getConstant());
                sb.append("'" + LINE_SEPARATOR);
                sb.append("        offset '");
                sb.append(ByteArray.formatNumForDisplay(nameSpace.getOffset()));
                sb.append("'" + LINE_SEPARATOR);
                sb.append("        length '");
                sb.append(nameSpace.getLength());
                sb.append("'" + LINE_SEPARATOR);
            } else {
                sb.append("        NULL" + LINE_SEPARATOR);
            }
            sb.append("       ELEMENT" + LINE_SEPARATOR);
            sb.append("        value '");
            sb.append(element.getConstant());
            sb.append("'" + LINE_SEPARATOR);
            sb.append("        offset '");
            sb.append(ByteArray.formatNumForDisplay(element.getOffset()));
            sb.append("'" + LINE_SEPARATOR);
            sb.append("        length '");
            sb.append(element.getLength());
            sb.append("'" + LINE_SEPARATOR + LINE_SEPARATOR);
        }
        for (int i = 0; i < LINE_SEPARATOR.length(); ++i) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String getXpathForSearch() {
        if (this.xpathForSearch != null) {
            return this.xpathForSearch;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<ICMConstantsSectionEntry> parts = this.xpathParts.iterator();
        while (parts.hasNext()) {
            parts.next();
            String element = parts.next().getConstant();
            sb.append("/");
            sb.append(element);
        }
        this.xpathForSearch = sb.toString();
        return this.xpathForSearch;
    }

    protected String getXpathForSearchWithNS() {
        if (this.xpathForSearchWithNS != null) {
            return this.xpathForSearchWithNS;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<ICMConstantsSectionEntry> parts = this.xpathParts.iterator();
        while (parts.hasNext()) {
            ICMConstantsSectionEntry nsEntry = parts.next();
            String ns = null;
            if (nsEntry != null) {
                ns = nsEntry.getConstant();
            }
            String element = parts.next().getConstant();
            sb.append("/");
            sb.append(element);
            sb.append("(");
            if (ns != null) {
                sb.append(ns);
            }
            sb.append(")");
        }
        this.xpathForSearchWithNS = sb.toString();
        return this.xpathForSearchWithNS;
    }

    protected long getIndexOffset() {
        return this.indexOffset;
    }

    protected int getNumOfParts() {
        return this.numOfParts;
    }

    protected void setEntryNum(int entryNum) {
        this.entryNum = entryNum;
    }

    @Override
    public int getEntryNum() {
        return this.entryNum;
    }

    @Override
    public void addChildTag(QName qname, ICMIndexEntry child) {
        this.addChildTag(child);
        this.children.put(qname, child);
    }

    @Override
    public QName getLastChildTag() {
        return this.qNameParts.get(this.qNameParts.size() - 1);
    }

    protected void addChildTag(ICMIndexEntry child) {
        if (this.firstChild == null) {
            this.firstChild = child;
        }
        this.lastChild = child;
        child.setParent(this);
    }

    protected ICMIndexEntry getFirstChild() {
        return this.firstChild;
    }

    protected ICMIndexEntry getLastChild() {
        return this.lastChild;
    }

    @Override
    public Map<QName, ICMIndexEntry> getChildren() {
        return this.children;
    }

    @Override
    public void setParent(ICMIndexEntry parent) {
        this.parent = parent;
    }

    @Override
    public ICMIndexEntry getParent() {
        return this.parent;
    }
}

