/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMXMLTemplateHolder;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

class ICMLevelState {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private ICMXMLTemplateHolder template = null;
    private ICMXMLTemplateHolder altTemplate = null;
    private String defaultNameSpace = null;
    private long offset = 0L;
    private int levelAllignment = 0;
    private long initialOffset = -1L;
    private ByteArrayOutputStream commareaTemplate = new ByteArrayOutputStream();
    private static final int TEXT_TYPE = 0;
    private static final int NUMERIC_TYPE = 1;
    private static final String[] TYPES = new String[]{"TEXT", "NUMERIC"};
    private static final String[] ALIGNMENTS = new String[]{"ERROR-0", "BYTE", "HALF-WORD", "ERROR-3", "FULL-WORD", "ERROR-5", "ERROR-6", "ERROR-7", "DOUBLE-WORD"};
    private boolean tracing = false;
    private PrintStream logger = null;
    private boolean supressSuffixedPaddingMessage = false;
    private int mappingLevel = 0;
    private boolean pushBackSlackBytes = false;
    private boolean firstEntry = true;
    private long numPushBackBytes = 0L;
    private ICMCreationParameters parms = null;
    private IPlatform platform = null;

    private void doindent(int indent) {
        if (this.tracing) {
            StringBuilder indentStr = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                indentStr.append(' ');
            }
            this.logger.print(indentStr);
        }
    }

    protected ICMLevelState(long initialOffset, boolean supressSuffixedPaddingMessage, boolean tracing, PrintStream logger, int indent, int mappingLevel, String defaultNameSpace, boolean pushBackSlackBytesEnabled, ICMCreationParameters parms) {
        this.initialOffset = initialOffset;
        this.tracing = tracing;
        this.logger = logger;
        this.supressSuffixedPaddingMessage = supressSuffixedPaddingMessage;
        this.mappingLevel = mappingLevel;
        this.parms = parms;
        this.platform = this.parms.getPlatform();
        if (tracing) {
            this.doindent(indent);
            logger.println("Creating a new level with initial offset " + initialOffset + " and identity " + this.hashCode());
        }
        this.template = new ICMXMLTemplateHolder(mappingLevel, defaultNameSpace);
        this.altTemplate = new ICMXMLTemplateHolder(mappingLevel, defaultNameSpace);
        this.pushBackSlackBytes = pushBackSlackBytesEnabled;
        this.defaultNameSpace = defaultNameSpace;
    }

    protected ICMXMLTemplateHolder getTemplate() {
        return this.template;
    }

    protected void setTemplate(ICMXMLTemplateHolder template) {
        this.template = template;
    }

    protected byte[] getCommAreaTemplate() {
        return this.commareaTemplate.toByteArray();
    }

    private long addAllignedEntry(int requiredAllignment, long length, int type, int language, int indent, String name, ICM.VaryingLength variableMappingStrategy) throws ICMException {
        while ((this.offset + this.initialOffset) % (long)requiredAllignment != 0L) {
            ++this.offset;
            if (language != 2 && language != 6 && language != 7) continue;
            throw new ICMException(MessageHandler.buildMessage("DFHPI9029E", new Object[]{name}));
        }
        this.handlePushBackBytes(this.offset);
        long startOffset = this.offset;
        this.offset += length;
        if (this.levelAllignment < requiredAllignment) {
            this.levelAllignment = requiredAllignment;
        }
        if (this.tracing) {
            String variableMappingStrategyString = null;
            variableMappingStrategyString = variableMappingStrategy.equals((Object)ICM.VaryingLength.NO_VARYING_STRATEGY) ? "NOT APPLIC" : ICM.VARYING_LENGTH_OPTIONS[variableMappingStrategy.getCode()];
            this.doindent(indent);
            this.logger.println(" Adding entry for '" + name + "' for type '" + TYPES[type] + "' and language '" + ICM.LANGUAGE_TYPES[language] + "' of length '" + length + "' and required alignment '" + ALIGNMENTS[requiredAllignment] + "' at offset '" + startOffset + "' with mapping strategy '" + variableMappingStrategyString + "' to level '" + this.hashCode() + "'.");
        }
        return startOffset;
    }

    private void handlePushBackBytes(long bytesToPushBack) {
        if (this.firstEntry && this.pushBackSlackBytes) {
            this.numPushBackBytes = bytesToPushBack;
            this.initialOffset += bytesToPushBack;
            this.offset = 0L;
        }
        this.firstEntry = false;
    }

    protected long getPushBackBytes() {
        return this.numPushBackBytes;
    }

    protected long addCharArrayAlignedEntry(int numChars, int language, int indent, String name, ICM.VaryingLength variableMappingStrategy) throws ICMException {
        return this.addAllignedEntry(1, numChars, 0, language, indent, name, variableMappingStrategy);
    }

    protected long addLongAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        long levelOffset = 0L;
        int alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.LONG).getAlignmentLevel() : (language == 1 ? 4 : 8)) : 1;
        levelOffset = this.addAllignedEntry(alignment, 8L, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        return levelOffset;
    }

    protected long addUnsignedLongAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        return this.addLongAlignedEntry(aligned, language, indent, name);
    }

    protected long addIntAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        long levelOffset = 0L;
        int alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.INT).getAlignmentLevel() : 4) : 1;
        levelOffset = this.addAllignedEntry(alignment, 4L, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        return levelOffset;
    }

    protected long addUnsignedIntAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        int alignment;
        int size;
        long levelOffset = 0L;
        if (language == 6) {
            size = 8;
            alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.LONG).getAlignmentLevel() : 8) : 1;
        } else {
            size = 4;
            alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.INT).getAlignmentLevel() : 4) : 1;
        }
        levelOffset = this.addAllignedEntry(alignment, size, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        if (language == 6) {
            levelOffset += 4L;
        }
        return levelOffset;
    }

    protected long addShortAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        long levelOffset = 0L;
        int alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.SHORT).getAlignmentLevel() : 2) : 1;
        levelOffset = this.addAllignedEntry(alignment, 2L, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        return levelOffset;
    }

    protected long addUnsignedShortAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        int alignment;
        int size;
        long levelOffset = 0L;
        if (language == 6) {
            size = 4;
            alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.INT).getAlignmentLevel() : 4) : 1;
        } else {
            size = 2;
            alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.SHORT).getAlignmentLevel() : 2) : 1;
        }
        levelOffset = this.addAllignedEntry(alignment, size, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        if (language == 6) {
            levelOffset += 2L;
        }
        return levelOffset;
    }

    protected long addByteAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        int alignment;
        int size;
        long levelOffset = 0L;
        if (language == 6) {
            size = 2;
            alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.SHORT).getAlignmentLevel() : 2) : 1;
        } else {
            size = 1;
            alignment = 1;
        }
        levelOffset = this.addAllignedEntry(alignment, size, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        if (language == 6) {
            ++levelOffset;
        }
        return levelOffset;
    }

    protected long addUnsignedByteAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        return this.addByteAlignedEntry(aligned, language, indent, name);
    }

    protected long addBinaryAlignedEntry(long numBytes, int language, int indent, String name, ICM.VaryingLength variableMappingStrategy) throws ICMException {
        return this.addAllignedEntry(1, numBytes, 1, language, indent, name, variableMappingStrategy);
    }

    protected long addBooleanAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        int alignment;
        int size;
        long levelOffset = 0L;
        if (!(language != 3 && language != 6 || MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel))) {
            size = 2;
            alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.SHORT).getAlignmentLevel() : 2) : 1;
        } else {
            alignment = 1;
            size = 1;
        }
        levelOffset = this.addAllignedEntry(alignment, size, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        if (size == 2) {
            ++levelOffset;
        }
        return levelOffset;
    }

    protected long addFloatAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        long levelOffset = 0L;
        int alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.FLOAT).getAlignmentLevel() : 4) : 1;
        levelOffset = this.addAllignedEntry(alignment, 4L, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        return levelOffset;
    }

    protected long addDoubleAlignedEntry(boolean aligned, int language, int indent, String name) throws ICMException {
        long levelOffset = 0L;
        int alignment = aligned ? (this.platform != null ? this.platform.getAlignment(IPlatform.AlignableDataType.DOUBLE).getAlignmentLevel() : 8) : 1;
        levelOffset = this.addAllignedEntry(alignment, 8L, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
        return levelOffset;
    }

    protected long addZonedAlignedEntry(int length, int language, int indent, String name, boolean isSeparateCharacter) throws ICMException {
        if (isSeparateCharacter) {
            ++length;
        }
        return this.addAllignedEntry(1, length, 1, language, indent, name, ICM.VaryingLength.NO_VARYING_STRATEGY);
    }

    protected long getTotalLengthForArray(int language, String strucName) throws ICMException {
        if (this.levelAllignment == 0) {
            return this.offset;
        }
        this.offset += this.getSuffixSlackBytesNeeded(language, strucName);
        return this.offset;
    }

    protected long getSuffixSlackBytesNeeded(int language, String strucName) throws ICMException {
        if (this.levelAllignment == 0) {
            return 0L;
        }
        long slackBytesNeeded = this.offset;
        while (slackBytesNeeded % (long)this.levelAllignment != 0L) {
            ++slackBytesNeeded;
        }
        if (!(language != 2 && language != 6 && language != 7 || (slackBytesNeeded -= this.offset) <= 0L || this.initialOffset <= 0L && (this.initialOffset != 0L || this.supressSuffixedPaddingMessage))) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9030E", new Object[]{strucName}));
        }
        return slackBytesNeeded;
    }

    protected long getPrefixSlackBytesNeeded(int language, long localInitialOffset, String strucName) throws ICMException {
        if (this.levelAllignment == 0) {
            return 0L;
        }
        long slackBytesNeeded = 0L;
        while ((slackBytesNeeded + localInitialOffset) % (long)this.levelAllignment != 0L) {
            ++slackBytesNeeded;
        }
        if ((language == 2 || language == 6 || language == 7) && slackBytesNeeded > 0L && this.initialOffset > 0L) {
            throw new ICMException(MessageHandler.buildMessage("DFHPI9030E", new Object[]{strucName}));
        }
        return slackBytesNeeded;
    }

    protected long getTotalLength() {
        return this.offset;
    }

    protected void setTotalLength(long totalLength) {
        this.offset = totalLength;
    }

    protected long getAbsoluteOffset() {
        return this.offset + this.initialOffset;
    }

    protected int getAlignment() {
        return this.levelAllignment;
    }

    protected void setAlignment(int alignment) {
        if (this.levelAllignment < alignment) {
            this.levelAllignment = alignment;
        }
    }

    protected boolean updateOffset(int toAdd) {
        if (this.firstEntry && this.pushBackSlackBytes) {
            this.handlePushBackBytes(toAdd);
            return false;
        }
        this.offset += (long)toAdd;
        return true;
    }

    public void switchTemplate() {
        ICMXMLTemplateHolder temp = this.altTemplate;
        this.altTemplate = this.template;
        this.template = temp;
    }

    public void resetAltTemplate() {
        this.altTemplate = new ICMXMLTemplateHolder(this.mappingLevel, this.defaultNameSpace);
    }
}

