/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMRawJSONElementEntry;
import com.ibm.cics.schema.ICMRawXMLElementEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.impl.ICMRawXMLElementEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

class ICMRawJSONElementEntryImpl
extends ICMRawXMLElementEntryImpl
implements ICMRawJSONElementEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2007, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_CONTROL_BITS_LENGTH = 1;
    private static final int ICM_OUTPUT_AREA_LENGTH = 2;
    private static final int OFFSET_OF_OUTPUT_AREA_LENGTH = 46;
    private int lengthOfOutputField;
    private ICM.EncodingType encodingType = ICM.EncodingType.SBCS;

    protected ICMRawJSONElementEntryImpl(String typeName, String xmlName, ICMConstantsSectionHolder cse, int mappingLevel, ICM icm, int lengthOfOutputField, ICM.EncodingType encodingType) throws ICMException {
        super(typeName, null, xmlName, null, cse, mappingLevel, ICMRawXMLElementEntry.AnyType.JSON_PROPERTY, icm);
        this.setType(ICM.ICMRecord.RAW_JSON_RECORD_TYPE);
        this.lengthOfOutputField = lengthOfOutputField;
        this.encodingType = encodingType;
    }

    public ICMRawJSONElementEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(icm, ICMContents, offset, length, constants, CodePage);
        this.setType(ICM.ICMRecord.RAW_JSON_RECORD_TYPE);
        this.lengthOfOutputField = ByteArray.byteArrayToShort(ICMContents, offset + 46);
        byte controlBits = ICMContents[offset + 45];
        this.encodingType = (controlBits & 0x80) == 128 ? ICM.EncodingType.SBCS : ICM.EncodingType.UTF16BE;
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(new byte[]{18});
        this.buildByteArrayCommonSubset(baos);
        int controlBits = -1;
        if (ICM.EncodingType.UTF16BE.equals((Object)this.encodingType)) {
            controlBits = (byte)(controlBits & 0x7F);
        }
        baos.write(controlBits);
        baos.write(ByteArray.numToByteArray(this.lengthOfOutputField, 2));
        this.setBinaryData(baos.toByteArray());
    }

    @Override
    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR + "  " + ICM.RECORD_TYPES[18] + " (Offset within ICM = " + ByteArray.formatNumForDisplay(this.getOffsetIntoICM()) + ")" + LINE_SEPARATOR);
        this.toStringCommonSubset(sb, indentStr);
        sb.append(indentStr + "    BUFFER LENGTH = " + this.lengthOfOutputField + LINE_SEPARATOR);
        sb.append(indentStr + "    ENCODING  = " + (Object)((Object)this.encodingType) + LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    public int getLengthOfTargetField() {
        return this.lengthOfOutputField;
    }

    @Override
    public ICM.EncodingType getEncodingType() {
        return this.encodingType;
    }
}

