/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMRawXMLElementEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

class ICMRawXMLElementEntryImpl
extends ICMEntryImpl
implements ICMRawXMLElementEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2007, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_RECORD_TYPE_LENGTH = 1;
    private static final int ICM_RESERVED_LENGTH = 1;
    private ICMConstantsSectionEntry localName = null;
    private static final int ICM_ELEMENT_LOCALNAME_LENGTH_LENGTH = 2;
    private static final int ICM_ELEMENT_LOCALNAME_OFFSET_LENGTH = 4;
    private static final long ICM_ELEMENT_LOCALNAME_MAX_VALUE = 32767L;
    private ICMConstantsSectionEntry nameSpace = null;
    private static final int ICM_ELEMENT_NAMESPACE_LENGTH_LENGTH = 2;
    private static final int ICM_ELEMENT_NAMESPACE_OFFSET_LENGTH = 4;
    private static final long ICM_ELEMENT_NAMESPACE_MAX_VALUE = 32767L;
    private static final int ICM_XML_LOCATION_SIZE_LENGTH = 1;
    private static final int ICM_EXTENDED_HEADER_PADDING = 16;
    private static final int ICM_XML_LOCATION_OFFSET_LENGTH = 4;
    protected static final int ICM_OFFSET_INTO_STRUCTURE_LENGTH = 4;
    private static final int ICM_SPARE_BYTES_LENGTH = 3;
    private static final int ICM_LENGTH_OF_RAW_XML_ELEMENT_RECORD = 48;
    private ICMRawXMLElementEntry.AnyType anyType = ICMRawXMLElementEntry.AnyType.any;
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ATTRIBUTES_NUMBER = 1;
    private static final int OFFSET_OF_ATTRIBUTES_NUMBER = 1;
    private static final int LENGTH_OF_ICMENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ICMENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int LENGTH_OF_ATTR_END_REPEAT_PADDING = 8;
    private static final int OFFSET_OF_ATTR_END_REPEAT_PADDING = 8;
    private static final int LENGTH_OF_COMMON_EXPANSION_PADDING = 8;
    private static final int OFFSET_OF_COMMON_EXPANSION_PADDING = 16;
    private static final int LENGTH_OF_NAMESPACE_LENGTH = 2;
    private static final int OFFSET_OF_NAMESPACE_LENGTH = 24;
    private static final int LENGTH_OF_LOCAL_NAME_LENGTH = 2;
    private static final int OFFSET_OF_LOCAL_NAME_LENGTH = 26;
    private static final int LENGTH_OF_NAMESPACE_OFFSET = 4;
    private static final int OFFSET_OF_NAMESPACE_OFFSET = 28;
    private static final int LENGTH_OF_LOCAL_NAME_OFFSET = 4;
    private static final int OFFSET_OF_LOCAL_NAME_OFFSET = 32;
    private static final int LENGTH_OF_CONTAINER_OFFSET = 4;
    private static final int OFFSET_OF_CONTAINER_OFFSET = 36;
    private static final int LENGTH_OF_LOC_NAME_OFFSET = 4;
    private static final int OFFSET_OF_LOC_NAME_OFFSET = 40;
    private static final int LENGTH_OF_LOC_NAME_LENGTH = 1;
    private static final int OFFSET_OF_LOC_NAME_LENGTH = 44;
    private static final int LENGTH_OF_LOC_NAME_LENGTH_PADDING = 3;
    protected static final int OFFSET_OF_LOC_NAME_LENGTH_PADDING = 45;
    private static final int LENGTH_OF_TYPE10_ICMENTRY = 48;

    protected ICMRawXMLElementEntryImpl(String typeName, String typeNameSpace, String xmlName, String simplifiedXPath, ICMConstantsSectionHolder cse, int mappingLevel, ICMRawXMLElementEntry.AnyType anyType, ICM icm) throws ICMException {
        super(ICM.ICMRecord.RAW_XML_RECORD_TYPE, cse, mappingLevel, simplifiedXPath, false, false, icm);
        if (typeName != null && !typeName.equals("")) {
            this.localName = cse.createConstant(typeName, 32767L);
        }
        if (typeNameSpace != null && !typeNameSpace.equals("")) {
            this.nameSpace = cse.createConstant(typeNameSpace, 32767L);
        }
        this.setXMLTemplateVariableName("&" + xmlName + ";");
        if (xmlName == null) {
            throw new ICMException("INTERNAL ERROR: No XPATH provided for element '" + this.localName + "'.");
        }
        this.anyType = anyType;
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR + "  " + ICM.RECORD_TYPES[10] + " (Offset within ICM = " + ByteArray.formatNumForDisplay(this.getOffsetIntoICM()) + ")" + LINE_SEPARATOR);
        this.toStringCommonSubset(sb, indentStr);
        return sb.toString();
    }

    protected void toStringCommonSubset(StringBuilder sb, String indentStr) {
        sb.append(indentStr + "    RECORD TYPE = " + this.getTypeEnum().getCode() + LINE_SEPARATOR);
        if (this.nameSpace != null) {
            sb.append(indentStr + "    ELEMENT NAMESPACE " + this.nameSpace.toString(indentStr) + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    ELEMENT NAMESPACE = null" + LINE_SEPARATOR);
        }
        if (this.localName != null) {
            sb.append(indentStr + "    ELEMENT LOCAL NAME " + this.localName.toString(indentStr) + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    ELEMENT LOCAL NAME = null" + LINE_SEPARATOR);
        }
        sb.append(indentStr + "    XML TEMPLATE LOCATION NAME " + this.getXMLTemplateVariableNameEntry().toString(indentStr) + LINE_SEPARATOR);
        sb.append(indentStr + "    XML TEMPLATE LOCATION NAME LENGTH " + this.getXMLTemplateVariableNameEntry().getLength() + LINE_SEPARATOR);
        sb.append(indentStr + "    OFFSET WITHIN STRUCTURE = " + ByteArray.formatNumForDisplay(this.getOffsetIntoStructure()) + LINE_SEPARATOR);
        sb.append(indentStr + "    ABSOLUTE OFFSET WITHIN STRUCTURE = " + ByteArray.formatNumForDisplay(this.getAbsoluteOffsetInStructure()) + LINE_SEPARATOR);
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(new byte[]{10});
        this.buildByteArrayCommonSubset(baos);
        baos.write(ByteArray.numToByteArray(-1L, 3));
        this.setBinaryData(baos.toByteArray());
    }

    protected void buildByteArrayCommonSubset(ByteArrayOutputStream baos) throws IOException {
        baos.write(new byte[]{0});
        baos.write(ByteArray.numToByteArray(48L, 2));
        if (this.getLogicalNextEntry() != null) {
            baos.write(ByteArray.numToByteArray(this.getLogicalNextEntry().getOffsetIntoICM(), 4));
        } else {
            baos.write(ByteArray.numToByteArray(-1L, 4));
        }
        baos.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        if (this.nameSpace != null && this.anyType != ICMRawXMLElementEntry.AnyType.any && this.anyType != ICMRawXMLElementEntry.AnyType.JSON_PROPERTY) {
            baos.write(ByteArray.numToByteArray(this.nameSpace.getLength(), 2));
        } else {
            baos.write(ByteArray.numToByteArray(0L, 2));
        }
        if (this.localName != null && this.anyType != ICMRawXMLElementEntry.AnyType.any && this.anyType != ICMRawXMLElementEntry.AnyType.JSON_PROPERTY) {
            baos.write(ByteArray.numToByteArray(this.localName.getLength(), 2));
        } else {
            baos.write(ByteArray.numToByteArray(0L, 2));
        }
        if (this.nameSpace != null && this.anyType != ICMRawXMLElementEntry.AnyType.any && this.anyType != ICMRawXMLElementEntry.AnyType.JSON_PROPERTY) {
            baos.write(ByteArray.numToByteArray(this.nameSpace.getOffset(), 4));
        } else {
            baos.write(ByteArray.numToByteArray(-1L, 4));
        }
        if (this.localName != null && this.anyType != ICMRawXMLElementEntry.AnyType.any && this.anyType != ICMRawXMLElementEntry.AnyType.JSON_PROPERTY) {
            baos.write(ByteArray.numToByteArray(this.localName.getOffset(), 4));
        } else {
            baos.write(ByteArray.numToByteArray(-1L, 4));
        }
        baos.write(ByteArray.numToByteArray(this.getOffsetIntoStructure(), 4));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getOffset(), 4));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getLength(), 1));
    }

    @Override
    public String getLocalName() {
        if (this.localName != null) {
            return this.localName.getConstant();
        }
        return null;
    }

    @Override
    public String getNameSpace() {
        if (this.nameSpace != null) {
            return this.nameSpace.getConstant();
        }
        return null;
    }

    @Override
    public ICMRawXMLElementEntry.AnyType getAnyType() {
        return this.anyType;
    }

    public ICMRawXMLElementEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.RAW_XML_RECORD_TYPE, null, 0, "", false, false, icm);
        this.setType(ICM.ICMRecord.get(ICMContents[offset + 0]));
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset >= 0) {
            this.setLogicalNextOffset(nextICMEntryOffset);
        }
        int namespaceLength = ByteArray.byteArrayToInt(ICMContents, offset + 24, 2);
        int namespaceOffset = ByteArray.byteArrayToInt(ICMContents, offset + 28);
        if (namespaceOffset >= 0) {
            String name_space = ByteArray.byteArrayToString(ICMContents, namespaceOffset, namespaceLength, CodePage, false);
            this.nameSpace = constants.createConstant(name_space, 32767L);
            this.nameSpace.setOffset(namespaceOffset);
        }
        int localNameLength = ByteArray.byteArrayToInt(ICMContents, offset + 26, 2);
        int localNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 32);
        if (localNameOffset >= 0) {
            String local_name = ByteArray.byteArrayToString(ICMContents, localNameOffset, localNameLength, CodePage, false);
            this.localName = constants.createConstant(local_name, 32767L);
            this.localName.setOffset(localNameOffset);
        }
        int containerOffset = ByteArray.byteArrayToInt(ICMContents, offset + 36);
        this.setOffsetIntoStructure(containerOffset);
        int locNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 40);
        byte locNameLength = ICMContents[offset + 44];
        if (locNameOffset >= 0) {
            String xml_template = ByteArray.byteArrayToString(ICMContents, locNameOffset, locNameLength, CodePage, false);
            this.xmlName = constants.createConstant(xml_template, 255L);
            this.xmlName.setOffset(locNameOffset);
        }
        this.anyType = namespaceLength != 0 || namespaceOffset != 0 || localNameLength != 0 || localNameOffset != 0 ? ICMRawXMLElementEntry.AnyType.anyType : ICMRawXMLElementEntry.AnyType.any;
    }
}

