/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMEndEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.ICMVariableRepeatEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMXMLTemplateHolder;
import com.ibm.cics.schema.impl.XMLTemplateEvent;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

abstract class ICMRepeatEntryImpl
extends ICMEntryImpl
implements ICMRepeatEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    protected long structureSize = -1L;
    private static final int ICM_SIZE_OF_FLAGS = 4;
    private static final int ICM_SIZE_OF_STRUCTURE_LENGTH = 4;
    private static final int ICM_SIZE_OF_COUNT_OFFSET = 4;
    private static final int ICM_SIZE_OF_RAW_XML_OFFSET = 4;
    private boolean structural = true;
    protected static final int ICM_CONTENT_LENGTH = 1;
    private static final int ICM_ODO_TARGET_OFFSET_LEGNTH = 4;
    protected ICMConstantsSectionEntry name = null;
    private static final int ICM_STRUCTURE_NAME_LENGTH_LENGTH = 1;
    private static final int ICM_STRUCTURE_NAME_OFFSET_LENGTH = 4;
    protected static final int ICM_STRUCTURE_NAME_MAX_VALUE = 255;
    protected ICMConstantsSectionEntry xmlTemplate = null;
    private static final int ICM_LENGTH_OF_XML_TEMPLATE_LENGTH = 4;
    private static final int ICM_LENGTH_OF_XML_TEMPLATE_OFFSET = 8;
    protected static final long ICM_MAX_XML_TEMPLATE_LENGTH = Long.MAX_VALUE;
    private List<XMLTemplateEvent> xmlTemplateEvents = null;
    protected static final int ICM_LENGTH_OF_REPEAT_DATA = 50;
    private boolean mixedContent = false;
    private ICMConstantsSectionHolder csh = null;
    protected static final byte STRUCTURAL_CONTENT = 1;
    protected static final byte MIXED_CONTENT = 2;
    protected static final byte INLINE_VAR_REPEAT = 4;
    protected static final byte RAW_XML_CONTENT = 8;
    protected static final byte CONTAINS_TYPE_INFO = 16;
    protected static final byte SIMPLE_NAMED_CONTAINER = 32;
    protected static final byte STRUCTURAL_NAMED_CONTAINER = 64;
    protected ICMEndEntry endEntry = null;
    public ICMConstantsSectionEntry simpleNamedContainer = null;
    public ICMConstantsSectionEntry structuralNamedContainer = null;
    public boolean choice = false;
    public int totalChoices = 0;
    public int thisChoiceNumber = 0;
    public boolean optionalModelGroup = false;
    public int maxOccurance = -1;
    public int minOccurance = -1;
    public long offsetOfCountField = 0L;
    public boolean inLineVariablyRepeating = false;
    public long offsetOfRawXML = 0L;
    public boolean rawXMLContent = false;
    public boolean containsTypeInfo = false;
    protected boolean truncatableArray = false;
    protected boolean isTruncatableNull;
    protected boolean isTruncatableSpace;
    protected boolean isTruncatableZero;
    protected boolean isTruncatablePackedZero;
    protected boolean isMultiTypedElement;
    protected boolean innerArray = false;
    protected boolean optionalArray = false;

    @Override
    public ICMEndEntry getEndEntry() {
        return this.endEntry;
    }

    protected void setEndEntry(ICMEndEntry endEntry) {
        this.endEntry = endEntry;
    }

    protected ICMRepeatEntryImpl(ICM.ICMRecord type, ICMConstantsSectionHolder csh, int mappingLevel, String simplifiedXPath, boolean slackBytes, ICM icm) throws ICMException {
        super(type, csh, mappingLevel, simplifiedXPath, slackBytes, false, icm);
        this.csh = csh;
    }

    @Override
    public String getStructureName() {
        return this.name.getConstant();
    }

    @Override
    public boolean isStructural() {
        return this.structural;
    }

    @Override
    public long getStructureSize() {
        return this.structureSize;
    }

    @Override
    public String getXmlTemplate() {
        return this.xmlTemplate.toString();
    }

    @Override
    public String getXmlTemplateValue() {
        return this.xmlTemplate.getConstant();
    }

    protected void setStructureName(String string) throws ICMException {
        this.name = this.csh.createConstant(string, 255L);
    }

    @Override
    public void setStructural(boolean b) {
        this.structural = b;
    }

    protected void setStructureSize(long l) {
        this.structureSize = l;
    }

    protected void setXmlTemplate(ICMXMLTemplateHolder holder) throws ICMException {
        this.xmlTemplate = this.csh.createConstant(holder.toString(), Long.MAX_VALUE);
        this.containsTypeInfo = holder.containsTypeInfo();
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        if (this.getXMLTemplateVariableName() != null) {
            sb.append(indentStr + "    XML TEMPLATE LOCATION NAME " + this.getXMLTemplateVariableNameEntry().toString(indentStr) + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    XML TEMPLATE LOCATION NAME = UNKNOWN" + LINE_SEPARATOR);
        }
        if (this.getStructureName() != null) {
            sb.append(indentStr + "    STRUCTURE NAME " + this.name.toString(indentStr) + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    STRUCTURE NAME = UNKNOWN" + LINE_SEPARATOR);
        }
        if (this instanceof ICMFixedRepeatEntry) {
            sb.append(indentStr + "    OFFSET OF COUNT FIELD = " + ByteArray.formatNumForDisplay(this.offsetOfCountField) + LINE_SEPARATOR);
        } else if (this instanceof ICMVariableRepeatEntry) {
            if (this.simpleNamedContainer != null) {
                sb.append(indentStr + "    NAMED CONTAINER = " + this.simpleNamedContainer.toString(indentStr) + LINE_SEPARATOR);
            } else if (this.structuralNamedContainer != null) {
                sb.append(indentStr + "    NAMED CONTAINER = " + this.structuralNamedContainer.toString(indentStr) + LINE_SEPARATOR);
            }
        }
        sb.append(indentStr + "    SIZE OF STRUCTURE = " + ByteArray.formatNumForDisplay(this.getStructureSize()) + LINE_SEPARATOR);
        sb.append(indentStr + "    FLAGS" + LINE_SEPARATOR);
        sb.append(indentStr + "      1 Bit Reserved" + LINE_SEPARATOR);
        sb.append(indentStr + "      TRUNCATE PACKEDZERO     = " + this.isTruncatablePackedZero + LINE_SEPARATOR);
        sb.append(indentStr + "      INNER ARRAY       = " + this.innerArray + LINE_SEPARATOR);
        sb.append(indentStr + "      OPTIONAL ARRAY    = " + this.optionalArray + LINE_SEPARATOR);
        sb.append(indentStr + "      TRUNCATE ZERO     = " + this.isTruncatableZero + LINE_SEPARATOR);
        sb.append(indentStr + "      TRUNCATE SPACE    = " + this.isTruncatableSpace + LINE_SEPARATOR);
        sb.append(indentStr + "      TRUNCATE NULL     = " + this.isTruncatableNull + LINE_SEPARATOR);
        sb.append(indentStr + "      TRUNCATABLE ARRAY = " + this.truncatableArray + LINE_SEPARATOR);
        sb.append(indentStr + "    FLAGS2" + LINE_SEPARATOR);
        sb.append(indentStr + "      JSON MULTI-FORMAT ELEMENT = " + this.isMultiTypedElement + LINE_SEPARATOR);
        sb.append(indentStr + "    OFFSET INTO STRUCTURE = " + ByteArray.formatNumForDisplay(this.getOffsetIntoStructure()) + LINE_SEPARATOR);
        sb.append(indentStr + "    ABSOLUTE OFFSET WITHIN STRUCTURE = " + ByteArray.formatNumForDisplay(this.getAbsoluteOffsetInStructure()) + LINE_SEPARATOR);
        if (this instanceof ICMFixedRepeatEntry) {
            sb.append(indentStr + "    OFFSET OF RAW XML ICM = " + ByteArray.formatNumForDisplay(this.offsetOfRawXML) + LINE_SEPARATOR);
        }
        if (this.xmlTemplate != null) {
            sb.append(indentStr + "    XML TEMPLATE " + this.xmlTemplate.toString(indentStr) + LINE_SEPARATOR);
        } else {
            sb.append(indentStr + "    XML TEMPLATE = UNKNOWN" + LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    protected abstract void buildByteArray() throws IOException, ICMException;

    protected void formatRepeatsection(ByteArrayOutputStream baos) throws IOException {
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getLength(), 1));
        baos.write(ByteArray.numToByteArray(this.name.getLength(), 1));
        if (this instanceof ICMFixedRepeatEntry) {
            baos.write(ByteArray.numToByteArray(this.offsetOfCountField, 4));
        } else if (this instanceof ICMVariableRepeatEntry) {
            if (this.simpleNamedContainer != null) {
                baos.write(ByteArray.numToByteArray(this.simpleNamedContainer.getOffset(), 4));
            } else if (this.structuralNamedContainer != null) {
                baos.write(ByteArray.numToByteArray(this.structuralNamedContainer.getOffset(), 4));
            } else {
                baos.write(ByteArray.numToByteArray(0L, 4));
            }
        } else {
            baos.write(ByteArray.numToByteArray(0L, 4));
        }
        baos.write(ByteArray.numToByteArray(this.getStructureSize(), 4));
        byte flags = 0;
        int flags2 = 0;
        if (this.truncatableArray) {
            flags = (byte)(flags | 1);
        }
        if (this.isTruncatableNull) {
            flags = (byte)(flags | 2);
        }
        if (this.isTruncatableSpace) {
            flags = (byte)(flags | 4);
        }
        if (this.isTruncatableZero) {
            flags = (byte)(flags | 8);
        }
        if (this.isTruncatablePackedZero) {
            flags = (byte)(flags | 0x40);
        }
        if (this.optionalArray) {
            flags = (byte)(flags | 0x10);
        }
        if (this.innerArray) {
            flags = (byte)(flags | 0x20);
        }
        baos.write(ByteArray.numToByteArray(flags, 1));
        if (this.isMultiTypedElement) {
            flags2 = (byte)(flags2 | 0xFFFFFF80);
        }
        baos.write(ByteArray.numToByteArray(flags2, 1));
        baos.write(ByteArray.numToByteArray(0L, 2));
        baos.write(ByteArray.numToByteArray(this.getOffsetIntoStructure(), 4));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getOffset(), 8));
        if (this.getODOTarget() != null) {
            baos.write(ByteArray.numToByteArray(this.getODOTarget().getOffsetIntoICM(), 4));
        } else {
            baos.write(ByteArray.numToByteArray(0L, 4));
        }
        baos.write(ByteArray.numToByteArray(this.name.getOffset(), 4));
        if (this instanceof ICMFixedRepeatEntry) {
            baos.write(ByteArray.numToByteArray(this.offsetOfRawXML, 4));
        } else if (this instanceof ICMVariableRepeatEntry) {
            if (this.simpleNamedContainer != null) {
                baos.write(ByteArray.numToByteArray(this.simpleNamedContainer.getLength(), 1));
            } else if (this.structuralNamedContainer != null) {
                baos.write(ByteArray.numToByteArray(this.structuralNamedContainer.getLength(), 1));
            } else {
                baos.write(ByteArray.numToByteArray(0L, 1));
            }
            baos.write(ByteArray.numToByteArray(0L, 3));
        } else {
            baos.write(ByteArray.numToByteArray(0L, 4));
        }
        baos.write(ByteArray.numToByteArray(this.xmlTemplate.getLength(), 4));
        baos.write(ByteArray.numToByteArray(this.xmlTemplate.getOffset(), 8));
    }

    protected boolean isMixedContent() {
        return this.mixedContent;
    }

    protected void setMixedContent(boolean mixedContent) {
        this.mixedContent = mixedContent;
    }

    protected byte getContentByte() {
        byte content = 0;
        if (this.isStructural()) {
            content = (byte)(content | 1);
        }
        if (this.isMixedContent()) {
            content = (byte)(content | 2);
        }
        if (this.inLineVariablyRepeating) {
            content = (byte)(content | 4);
        }
        if (this.rawXMLContent) {
            content = (byte)(content | 8);
        }
        if (this.containsTypeInfo) {
            content = (byte)(content | 0x10);
        }
        if (this.simpleNamedContainer != null) {
            content = (byte)(content | 0x20);
        }
        if (this.structuralNamedContainer != null) {
            content = (byte)(content | 0x40);
        }
        return content;
    }

    @Override
    public int getMaxOccurance() {
        return this.maxOccurance;
    }

    @Override
    public int getMinOccurance() {
        return this.minOccurance;
    }

    @Override
    public boolean isPartOfAChoiceGroup() {
        return this.choice;
    }

    @Override
    public int getTotalNumberOfOptions() {
        return this.totalChoices;
    }

    @Override
    public int getOptionNumber() {
        return this.thisChoiceNumber;
    }

    @Override
    public boolean isPartOfOptionalModelGroup() {
        return this.optionalModelGroup;
    }

    protected boolean containsTypeInfo() {
        return this.containsTypeInfo;
    }

    @Override
    public List<XMLTemplateEvent> getXMLTemplateEvents(boolean json) {
        if (this.xmlTemplateEvents == null) {
            this.xmlTemplateEvents = XMLTemplateEvent.parseXMLTemplate(this.getXmlTemplateValue(), json);
        }
        return this.xmlTemplateEvents;
    }

    @Override
    public boolean isTruncatable() {
        return this.truncatableArray;
    }

    @Override
    @Deprecated
    public String getTruncatableValues() {
        return null;
    }

    @Override
    public boolean isInnerArray() {
        return this.innerArray;
    }

    @Override
    public boolean isOptionalArray() {
        return this.optionalArray;
    }

    @Override
    public boolean isTruncatableNull() {
        return this.isTruncatableNull;
    }

    @Override
    public boolean isTruncatableSpace() {
        return this.isTruncatableSpace;
    }

    @Override
    public boolean isTruncatableZero() {
        return this.isTruncatableZero;
    }

    @Override
    public boolean isTruncatablePackedZero() {
        return this.isTruncatablePackedZero;
    }

    @Override
    public boolean isMultiFormatElement() {
        return this.isMultiTypedElement;
    }
}

