/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMExtendedDataElementEntryImpl;
import com.ibm.cics.schema.utils.MessageHandler;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

class ICMSlackBytesElementEntryImpl
extends ICMExtendedDataElementEntryImpl {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final String VAR_NAME = "filler";
    private static final String COMMENT = MessageHandler.getMessage("HLL_COMMENT_PADDING");
    private static final List<String> COMMENTS = new LinkedList<String>();
    private boolean isPadding = false;
    private String odoFieldName = null;

    protected ICMSlackBytesElementEntryImpl(int LAR, ICMConstantsSectionHolder cse, int mappingLevel, ICM icm) throws ICMException {
        super(ICM.ICMDataType.CHAR_ARRAY, LAR, ICM.WhiteSpace.PRESERVE, VAR_NAME, "", "", "", COMMENTS, cse, 0, true, ICM.EncodingType.SBCS, ICM.VaryingLength.FIXED_LENGTH_ARRAY, mappingLevel, null, false, false, true, null, null, false, -1, false, icm);
        this.isPadding = true;
    }

    protected ICMSlackBytesElementEntryImpl(ICM.ICMDataType dataType, int LAR, ICM.WhiteSpace whiteSpace, String localName, String nameSpace, String xmlName, String defaultValue, List<String> comments, ICMConstantsSectionHolder cse, int fractionDigits, boolean aligned, ICM.EncodingType encodingType, ICM.VaryingLength variableLengthMappingStrategy, int mappingLevel, boolean signIsLeading, boolean separateChar, ICMSlackBytesElementEntryImpl odoTarget, boolean odoTargetClone, String odoFieldName, int minLength, boolean multiTypedElement, ICM icm) throws ICMException {
        super(dataType, LAR, whiteSpace, odoFieldName == null ? VAR_NAME : odoFieldName, nameSpace, xmlName, defaultValue, comments, cse, fractionDigits, aligned, encodingType, variableLengthMappingStrategy, mappingLevel, null, signIsLeading, separateChar, true, null, odoTarget, odoTargetClone, minLength, multiTypedElement, icm);
        this.isPadding = false;
        this.odoFieldName = odoFieldName;
    }

    protected boolean isPadding() {
        return this.isPadding;
    }

    protected String getODOFieldName() {
        return this.odoFieldName;
    }

    @Override
    protected void buildByteArray() throws IOException {
        this.setBinaryData(EMPTY_ARRAY);
    }

    @Override
    public String toString() {
        String comments = LINE_SEPARATOR + LINE_SEPARATOR + "  THE FOLLOWING ENTRY IS A DUMMY ENTRY THAT DOES NOT REALLY APPEAR IN THE ICM. IT IS ONLY HERE TO ENSURE THE CORRECT" + LINE_SEPARATOR + "  GENERATION OF LANGUAGE STUCTURES. NOTE THAT THE ADDRESS OF THIS ENTRY AND THE SUBSEQUENT ONE ARE THE SAME:" + LINE_SEPARATOR + super.toString();
        if (this.odoFieldName != null) {
            comments = LINE_SEPARATOR + LINE_SEPARATOR + "  THE FOLLOWING ENTRY IS THE TARGET OF A COBOL OCCURS DEPENDING ON CLAUSE. IT IS KNOWN BY THE NAME: " + this.odoFieldName + ". " + comments;
        }
        return comments;
    }

    static {
        COMMENTS.add(COMMENT);
    }
}

