/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMChoiceGroupEntry;
import com.ibm.cics.schema.ICMEndChoiceGroupEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMStartChoiceGroupEntry;
import com.ibm.cics.schema.impl.ICMChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMEndChoiceGroupEntryImpl;
import com.ibm.cics.schema.impl.ICMEntryImpl;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

class ICMStartChoiceGroupEntryImpl
extends ICMEntryImpl
implements ICMStartChoiceGroupEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_LENGTH_OF_TOTAL_NUMBER_OF_OPTIONS = 1;
    private static final int ICM_LENGTH_OF_UNUSED_SPACE = 6;
    private static final int ICM_LENGTH_OF_START_CHOICE_GROUP_RECORD = 40;
    private static final byte[] binaryType = new byte[]{11};
    private ICMEndChoiceGroupEntry endChoice = null;
    private ICMChoiceGroupEntryImpl currentChoiceEntry = null;
    private ICMChoiceGroupEntryImpl firstChoiceEntry = null;
    private int totalOptions;
    private String structureName = null;
    private static final int LENGTH_OF_ICMENTRY_TYPE = 1;
    private static final int OFFSET_OF_ICMENTRY_TYPE = 0;
    private static final int LENGTH_OF_ATTRIBUTES_NUMBER = 1;
    private static final int OFFSET_OF_ATTRIBUTES_NUMBER = 1;
    private static final int LENGTH_OF_ICMENTRY_LENGTH = 2;
    private static final int OFFSET_OF_ICMENTRY_LENGTH = 2;
    private static final int LENGTH_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ICMENTRY_OFFSET = 4;
    private static final int LENGTH_OF_NEXT_ATTRIBUTE_OFFSET = 4;
    private static final int OFFSET_OF_NEXT_ATTRIBUTE_OFFSET = 8;
    private static final int LENGTH_OF_END_GOURP_OFFSET = 4;
    private static final int OFFSET_OF_END_GOURP_OFFSET = 12;
    private static final int LENGTH_OF_END_GOURP_OFFSET_PADDING = 8;
    private static final int OFFSET_OF_END_GOURP_OFFSET_PADDING = 16;
    private static final int LENGTH_OF_CHOICES_NUMBER_IN_GROUP = 1;
    private static final int OFFSET_OF_CHOICES_NUMBER_IN_GROUP = 24;
    private static final int LENGTH_OF_TEMP_LOC_LENGTH = 1;
    private static final int OFFSET_OF_TEMP_LOC_LENGTH = 25;
    private static final int LENGTH_OF_TEMP_LOC_LENGTH_PADDING = 10;
    private static final int OFFSET_OF_TEMP_LOC_LENGTH_PADDING = 26;
    private static final int LENGTH_OF_TEMP_NAME_OFFSET = 4;
    private static final int OFFSET_OF_TEMP_NAME_OFFSET = 36;
    private static final int LENGTH_OF_TYPE11_ICMENTRY = 40;

    protected ICMStartChoiceGroupEntryImpl(String simplifiedXPath, ICMConstantsSectionHolder cse, int mappingLevel, String strucLocationName, String structureName, ICM icm) throws ICMException {
        super(ICM.ICMRecord.START_CHOICE_GROUP_ENTRY_TYPE, cse, mappingLevel, simplifiedXPath, false, false, icm);
        this.setXMLTemplateVariableName(strucLocationName);
        this.setStructureName(structureName);
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        this.extendedEntryPrefixToString(sb, 11, 40, this.endChoice);
        sb.append(indentStr + "    TOTAL NUMBER OF OPTIONS = " + this.totalOptions + LINE_SEPARATOR);
        sb.append(indentStr + "    XML TEMPLATE LOCATION NAME " + this.getXMLTemplateVariableNameEntry().toString(indentStr) + LINE_SEPARATOR);
        return sb.toString();
    }

    protected void addChoiceEntry(ICMChoiceGroupEntryImpl entry) {
        this.currentChoiceEntry = entry;
        if (this.firstChoiceEntry == null) {
            this.firstChoiceEntry = entry;
        }
    }

    @Override
    public ICMChoiceGroupEntry getCurrentChoice() {
        return this.currentChoiceEntry;
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildExtendedByteArrayHeader(baos, binaryType, 40, this.endChoice);
        baos.write(ByteArray.numToByteArray(this.totalOptions, 1));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getLength(), 1));
        baos.write(ByteArray.numToByteArray(0L, 6));
        baos.write(ByteArray.numToByteArray(this.getXMLTemplateVariableNameEntry().getOffset(), 8));
        this.setBinaryData(baos.toByteArray());
    }

    public void setEndChoiceGroupEntry(ICMEndChoiceGroupEntry end) {
        this.endChoice = end;
    }

    public ICMEndChoiceGroupEntry getEndChoiceGroupEntry() {
        return this.endChoice;
    }

    @Override
    public int getTotalOptions() {
        return this.totalOptions;
    }

    @Override
    public void setTotalOptions(int totalNumberOfOptions) {
        this.totalOptions = totalNumberOfOptions;
    }

    @Override
    public String getStructureName() {
        return this.structureName;
    }

    @Override
    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    @Override
    public ICMChoiceGroupEntry getFirstEntry() {
        return this.firstChoiceEntry;
    }

    public ICMStartChoiceGroupEntryImpl(ICMImplFromWSBind icm, byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage) throws ICMException, IOException {
        super(ICM.ICMRecord.START_CHOICE_GROUP_ENTRY_TYPE, null, 0, "", false, false, icm);
        int groupEndOffset;
        this.setType(ICM.ICMRecord.get(ICMContents[offset]));
        if (this.getTypeEnum() != ICM.ICMRecord.START_CHOICE_GROUP_ENTRY_TYPE) {
            throw new ICMException("INTERNAL ERROR: Wrong ICM Entry Type : " + (Object)((Object)this.getTypeEnum()));
        }
        int nextICMEntryOffset = ByteArray.byteArrayToInt(ICMContents, offset + 4);
        if (nextICMEntryOffset > 0) {
            ICMEntryImpl nextICMEntry = icm.getICMEntry(ICMContents, nextICMEntryOffset, constants, CodePage);
            this.setLogicalNextEntry(nextICMEntry);
        }
        if ((groupEndOffset = ByteArray.byteArrayToInt(ICMContents, offset + 12)) > 0) {
            this.endChoice = (ICMEndChoiceGroupEntryImpl)icm.getICMEntry(ICMContents, groupEndOffset, constants, CodePage);
        }
        byte numberOfChoicesInGroup = ICMContents[offset + 24];
        this.setTotalOptions(numberOfChoicesInGroup);
        byte insertNameLength = ICMContents[offset + 25];
        int insertNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 36);
        String xml_name = ByteArray.byteArrayToString(ICMContents, insertNameOffset, insertNameLength, CodePage, false);
        if (xml_name.length() > 0) {
            this.xmlName = constants.createConstant(xml_name, 255L);
            this.xmlName.setOffset(insertNameOffset);
        }
        this.firstChoiceEntry = (ICMChoiceGroupEntryImpl)this.getLogicalNextEntry();
        this.buildByteArray();
    }

    @Override
    public ICMEndChoiceGroupEntry getEndEntry() {
        return this.endChoice;
    }
}

