/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMVariableRepeatEntry;
import com.ibm.cics.schema.impl.ICMConstantsSectionHolder;
import com.ibm.cics.schema.impl.ICMRepeatEntryImpl;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.util.CodePageHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class ICMVariableRepeatEntryImpl
extends ICMRepeatEntryImpl
implements ICMVariableRepeatEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int ICM_MAX_OCCURANCE_LENGTH = 2;
    private static final int ICM_MIN_OCCURANCE_LENGTH = 2;
    protected static final int ICM_LENGTH_OF_VARIABLE_REPEAT_RECORD = 56;
    private int offsetWithinExtendedStructure = 0;
    private static final int LENGTH_OF_CONTENT_DESC = 1;
    private static final int OFFSET_OF_CONTENT_DESC = 1;
    private static final int LENGTH_OF_CONTENT_COUNT_MAXIMUM = 2;
    private static final int OFFSET_OF_CONTENT_COUNT_MAXIMUM = 2;
    private static final int LENGTH_OF_CONTENT_COUNT_MINIMUM = 2;
    private static final int OFFSET_OF_CONTENT_COUNT_MINIMUM = 4;
    private static final int LENGTH_OF_LOCATION_NAME_LENGTH = 1;
    private static final int OFFSET_OF_LOCATION_NAME_LENGTH = 6;
    private static final int LENGTH_OF_STRUCT_NAME_LENGTH = 1;
    private static final int OFFSET_OF_STRUCT_NAME_LENGTH = 7;
    private static final int LENGTH_OF_CONT_NAME = 4;
    private static final int OFFSET_OF_CONT_NAME = 8;
    private static final int LENGTH_OF_CONTENT_LENGTH = 4;
    private static final int OFFSET_OF_CONTENT_LENGTH = 12;
    private static final int LENGTH_OF_FLAGS = 1;
    private static final int OFFSET_OF_FLAGS = 16;
    private static final int LENGTH_OF_CONTAINER_OFFSET_PADDING = 3;
    private static final int OFFSET_OF_CONTAINER_OFFSET_PADDING = 17;
    private static final int LENGTH_OF_CONTAINER_OFFSET = 4;
    private static final int OFFSET_OF_CONTAINER_OFFSET = 20;
    private static final int LENGTH_OF_LOCATION_NAME_OFFSET_PADDING = 4;
    private static final int OFFSET_OF_LOCATION_NAME_OFFSET_PADDING = 24;
    private static final int LENGTH_OF_LOCATION_NAME_OFFSET = 4;
    private static final int OFFSET_OF_LOCATION_NAME_OFFSET = 28;
    private static final int LENGTH_OF_STRUCT_NAME_OFFSET_PADDING = 4;
    private static final int OFFSET_OF_STRUCT_NAME_OFFSET_PADDING = 32;
    private static final int LENGTH_OF_STRUCT_NAME_OFFSET = 4;
    private static final int OFFSET_OF_STRUCT_NAME_OFFSET = 36;
    private static final int LENGTH_OF_CONT_NAME_LENGTH = 1;
    private static final int OFFSET_OF_CONT_NAME_LENGTH = 40;
    private static final int LENGTH_OF_XML_TEMPLATE_LENGTH_PADDING = 3;
    private static final int OFFSET_OF_XML_TEMPLATE_LENGTH_PADDING = 41;
    private static final int LENGTH_OF_XML_TEMPLATE_LENGTH = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_LENGTH = 44;
    private static final int LENGTH_OF_XML_TEMPLATE_OFFSET_PADDING = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_OFFSET_PADDING = 48;
    private static final int LENGTH_OF_XML_TEMPLATE_OFFSET = 4;
    private static final int OFFSET_OF_XML_TEMPLATE_OFFSET = 52;
    private static final int LENGTH_OF_TYPE3_ICMENTYR = 56;
    private ByteArray containerName = null;

    protected ICMVariableRepeatEntryImpl(int max, int min, boolean choice, ICMConstantsSectionHolder csh, int totalChoices, int thisChoiceNumber, boolean mixedContent, int mappingLevel, String simplifiedXPath, boolean optionalModelGroup, String simpleNamedContainer, String structuralNamedContainer, ICM icm, boolean optionalArray, boolean innerArray) throws ICMException {
        super(ICM.ICMRecord.VARIABLE_REPEAT_RECORD_TYPE, csh, mappingLevel, simplifiedXPath, false, icm);
        byte[] bytes;
        this.maxOccurance = max;
        this.minOccurance = min;
        this.choice = choice;
        this.totalChoices = totalChoices;
        this.thisChoiceNumber = thisChoiceNumber;
        this.setMixedContent(mixedContent);
        this.optionalModelGroup = optionalModelGroup;
        this.innerArray = innerArray;
        if (simpleNamedContainer != null) {
            bytes = simpleNamedContainer.getBytes(CodePageHelper.getCurrentEBCDICCodePage());
            this.simpleNamedContainer = csh.createConstant(bytes, 16L);
        }
        if (structuralNamedContainer != null) {
            bytes = structuralNamedContainer.getBytes(CodePageHelper.getCurrentEBCDICCodePage());
            this.structuralNamedContainer = csh.createConstant(bytes, 16L);
        }
        this.optionalArray = optionalArray;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    protected String toString(int indent) {
        StringBuilder indentStrB = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentStrB.append(" ");
        }
        String indentStr = indentStrB.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR + indentStr + "  Variable Repeat (Offset within ICM = " + ByteArray.formatNumForDisplay(this.getOffsetIntoICM() + (long)this.getOffsetWithinExtendedStructure()) + ")" + LINE_SEPARATOR);
        sb.append(indentStr + "    RECORD TYPE = " + this.getTypeEnum().getCode() + LINE_SEPARATOR);
        sb.append(indentStr + "    CONTENT BITS = " + this.getContentByte() + LINE_SEPARATOR);
        sb.append(indentStr + "       STRUCTURAL NAMED CONTAINER CONTENT = " + (this.structuralNamedContainer != null) + LINE_SEPARATOR);
        sb.append(indentStr + "       SIMPLE NAMED CONTAINER CONTENT = " + (this.simpleNamedContainer != null) + LINE_SEPARATOR);
        sb.append(indentStr + "       STRUCTURAL CONTENT = " + this.isStructural() + LINE_SEPARATOR);
        sb.append(indentStr + "       MIXED CONTENT = " + this.isMixedContent() + LINE_SEPARATOR);
        sb.append(indentStr + "    MAX OCCURRENCE = " + this.getMaxOccurance() + LINE_SEPARATOR);
        sb.append(indentStr + "    MIN OCCURRENCE = " + this.getMinOccurance() + LINE_SEPARATOR);
        sb.append(indentStr + "    PART OF A CHOICE GROUP = " + this.isPartOfAChoiceGroup() + LINE_SEPARATOR);
        sb.append(indentStr + "    TOTAL NUMBER OF CHOICES = " + this.getTotalNumberOfOptions() + LINE_SEPARATOR);
        sb.append(indentStr + "    THIS CHOICE NUMBER = " + this.getOptionNumber() + LINE_SEPARATOR);
        sb.append(super.toString(indent));
        return sb.toString();
    }

    @Override
    protected void buildByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(new byte[]{3});
        baos.write(ByteArray.numToByteArray(this.getContentByte(), 1));
        baos.write(ByteArray.numToByteArray(this.getMaxOccurance(), 2));
        baos.write(ByteArray.numToByteArray(this.getMinOccurance(), 2));
        this.formatRepeatsection(baos);
        this.setBinaryData(baos.toByteArray());
    }

    protected int getOffsetWithinExtendedStructure() {
        return this.offsetWithinExtendedStructure;
    }

    protected void setOffsetWithinExtendedStructure(int offsetWithinExtendedStructure) {
        this.offsetWithinExtendedStructure = offsetWithinExtendedStructure;
    }

    protected ICMVariableRepeatEntryImpl(byte[] ICMContents, int offset, int length, ICMConstantsSectionHolder constants, Charset CodePage, ICM icm) throws ICMException, IOException {
        super(ICM.ICMRecord.VARIABLE_REPEAT_RECORD_TYPE, null, 0, "", false, icm);
        byte flags;
        this.setType(ICM.ICMRecord.get(ICMContents[offset]));
        byte contentDesc = ICMContents[offset + 1];
        if ((contentDesc & 1) > 0) {
            this.setStructural(true);
        } else {
            this.setStructural(false);
        }
        if ((contentDesc & 2) > 0) {
            this.setMixedContent(true);
        } else {
            this.setMixedContent(false);
        }
        this.maxOccurance = ByteArray.byteArrayToInt(ICMContents, offset + 2, 2);
        this.minOccurance = ByteArray.byteArrayToInt(ICMContents, offset + 4, 2);
        this.structureSize = ByteArray.byteArrayToInt(ICMContents, offset + 12);
        byte locationNameLength = ICMContents[offset + 6];
        int locationNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 28);
        if (locationNameOffset >= 0) {
            String loaction_name = ByteArray.byteArrayToString(ICMContents, locationNameOffset, locationNameLength, CodePage, false);
            this.xmlName = constants.createConstant(loaction_name, 255L);
            this.xmlName.setOffset(locationNameOffset);
        }
        byte structNameLength = ICMContents[offset + 7];
        int structNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 36);
        if (structNameOffset >= 0) {
            String structure_name = ByteArray.byteArrayToString(ICMContents, structNameOffset, structNameLength, CodePage, false);
            this.name = constants.createConstant(structure_name, 255L);
            this.name.setOffset(structNameOffset);
        }
        int content_length = ByteArray.byteArrayToInt(ICMContents, offset + 12);
        this.setStructureSize(content_length);
        int containerOffset = ByteArray.byteArrayToInt(ICMContents, offset + 20);
        this.setOffsetIntoStructure(containerOffset);
        byte contNameLength = ICMContents[offset + 40];
        int contNameOffset = ByteArray.byteArrayToInt(ICMContents, offset + 8);
        String container_name = ByteArray.byteArrayToString(ICMContents, contNameOffset, contNameLength, CodePageHelper.getCurrentEBCDICCodePage(), false);
        if ((contentDesc & 0x20) > 0) {
            this.simpleNamedContainer = constants.createConstant(container_name.getBytes(CodePageHelper.getCurrentEBCDICCodePage()), 255L);
            this.simpleNamedContainer.setOffset(contNameOffset);
        } else if ((contentDesc & 0x40) > 0) {
            this.structuralNamedContainer = constants.createConstant(container_name.getBytes(CodePageHelper.getCurrentEBCDICCodePage()), 255L);
            this.structuralNamedContainer.setOffset(contNameOffset);
        }
        int XMLTemplateLength = ByteArray.byteArrayToInt(ICMContents, offset + 44);
        int XMLTemplateOffset = ByteArray.byteArrayToInt(ICMContents, offset + 52);
        if (XMLTemplateOffset >= 0) {
            String xml_template = ByteArray.byteArrayToString(ICMContents, XMLTemplateOffset, XMLTemplateLength, CodePage, false);
            this.xmlTemplate = constants.createConstant(xml_template, Long.MAX_VALUE);
            this.xmlTemplate.setOffset(XMLTemplateOffset);
        }
        if (((flags = ICMContents[offset + 16]) & 0x10) == 16) {
            this.optionalArray = true;
        }
        if ((flags & 0x20) == 32) {
            this.innerArray = true;
        }
        this.buildByteArray();
    }

    @Override
    public ByteArray getContainerName() {
        if (this.containerName != null) {
            return this.containerName;
        }
        try {
            this.containerName = new ByteArray("                ".getBytes("Cp037"), true);
            byte[] source = null;
            if (this.structuralNamedContainer != null) {
                source = this.structuralNamedContainer.getBytes();
            } else if (this.simpleNamedContainer != null) {
                source = this.simpleNamedContainer.getBytes();
            }
            if (source == null) {
                return null;
            }
            System.arraycopy(source, 0, this.containerName.getByteArrayBuffer(), this.containerName.getByteArrayOffset(), source.length);
            return this.containerName;
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Unexpected Exception");
            re.initCause(e);
            throw re;
        }
    }

    @Override
    public boolean isSimpleNamedContainer() {
        return this.simpleNamedContainer != null;
    }

    @Override
    public boolean isStructuredNamedContainer() {
        return this.structuralNamedContainer != null;
    }
}

