/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.UniqueNameGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;

class ICMXMLTemplateHolder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private StringBuilder templatePart = null;
    private StringBuilder template = null;
    private int nameSpaceCounter = 0;
    private Map<String, String> nameSpacePrefixMap = null;
    private int logicalLevel = 0;
    private String currentTopLevelNameSpace = null;
    private String currentTopLevelTag = null;
    private String currentTopLevelDfltNS = null;
    private QName currentTopLevelType = null;
    private String currentTopLevelTypePrefix = null;
    private boolean topLevelCloseTagNeeded = true;
    private List<String> attributeLocationNames = new LinkedList<String>();
    private List<String> attributesWithValues = new LinkedList<String>();
    private List<String> nameSpaces = new LinkedList<String>();
    private String currentDefaultNS = null;
    private int mappingLevel = -1;
    private Set<String> variableNames = null;

    protected ICMXMLTemplateHolder(int mappingLevel, String currentDefaultNameSpace) {
        this.templatePart = new StringBuilder();
        this.variableNames = new TreeSet<String>();
        this.nameSpacePrefixMap = new TreeMap<String, String>();
        this.template = new StringBuilder();
        this.mappingLevel = mappingLevel;
        this.nameSpaces.add(currentDefaultNameSpace);
    }

    protected void addStartTag(String nameSpace, String tag, boolean setInheritingNS, QName type) {
        String prefix = null;
        this.currentDefaultNS = this.nameSpaces.get(this.nameSpaces.size() - 1);
        this.nameSpaces.add(nameSpace);
        if (tag.indexOf(58) > -1) {
            nameSpace = null;
        }
        if (nameSpace != null && !setInheritingNS && (prefix = this.nameSpacePrefixMap.get(nameSpace)) == null) {
            ++this.nameSpaceCounter;
            prefix = "ns" + this.nameSpaceCounter;
            this.nameSpacePrefixMap.put(nameSpace, prefix);
        }
        if (this.logicalLevel > 0) {
            this.templatePart.append("<");
            if (nameSpace != null && !setInheritingNS) {
                this.templatePart.append(prefix);
                this.templatePart.append(":");
                this.currentDefaultNS = null;
            }
            this.templatePart.append(tag);
            if (setInheritingNS && (this.currentDefaultNS == null && nameSpace != null || this.currentDefaultNS != null && !this.currentDefaultNS.equals(nameSpace))) {
                this.templatePart.append(" xmlns=\"");
                if (nameSpace != null) {
                    this.templatePart.append(nameSpace);
                }
                this.templatePart.append("\"");
            }
            this.templatePart.append(">");
        } else {
            this.currentTopLevelNameSpace = prefix;
            this.currentTopLevelTag = tag;
            this.currentTopLevelType = type;
            if (setInheritingNS) {
                this.currentTopLevelDfltNS = nameSpace;
            }
            if (type != null) {
                this.addNamespace("http://www.w3.org/2001/XMLSchema-instance");
                this.currentTopLevelTypePrefix = this.addNamespace(type.getNamespaceURI());
            }
        }
        ++this.logicalLevel;
    }

    protected void addEndTag(String nameSpace, String tag, boolean setInheritingNS) throws ICMException {
        --this.logicalLevel;
        if (this.nameSpaces.size() > 0) {
            this.nameSpaces.remove(this.nameSpaces.size() - 1);
        }
        String prefix = null;
        if (nameSpace != null && !setInheritingNS && (prefix = this.nameSpacePrefixMap.get(nameSpace)) == null) {
            throw new ICMException("INTERNAL ERROR: NameSpace '" + nameSpace + "' unexpected in an '" + tag + "' end tag.");
        }
        this.templatePart.append("</");
        if (nameSpace != null && !setInheritingNS) {
            this.templatePart.append(prefix);
            this.templatePart.append(":");
        }
        this.templatePart.append(tag);
        this.templatePart.append(">");
        if (this.logicalLevel == 0) {
            String defaultNSFromParentTemplate;
            if (this.topLevelCloseTagNeeded) {
                this.templatePart.insert(0, ">");
            }
            Iterator<String> attributes = this.attributeLocationNames.iterator();
            int offset = 0;
            while (attributes.hasNext()) {
                String attribute = attributes.next();
                String insert = "&" + attribute + ";";
                this.templatePart.insert(offset, insert);
                offset += insert.length();
            }
            attributes = this.attributesWithValues.iterator();
            while (attributes.hasNext()) {
                this.templatePart.insert(offset, attributes.next());
            }
            String prefixForXSI = this.nameSpacePrefixMap.remove("http://www.w3.org/2001/XMLSchema-instance");
            for (Map.Entry entry : this.nameSpacePrefixMap.entrySet()) {
                this.templatePart.insert(0, " xmlns:" + (String)entry.getValue() + "=\"" + (String)entry.getKey() + "\" ");
            }
            if (prefixForXSI != null) {
                this.templatePart.insert(0, " xmlns:" + prefixForXSI + "=\"" + "http://www.w3.org/2001/XMLSchema-instance" + "\" ");
            }
            if (!((defaultNSFromParentTemplate = this.nameSpaces.get(0)) != null && defaultNSFromParentTemplate.equals(this.currentTopLevelDfltNS) || defaultNSFromParentTemplate == null && this.currentTopLevelDfltNS == null)) {
                if (this.currentTopLevelDfltNS != null) {
                    this.templatePart.insert(0, " xmlns=\"" + this.currentTopLevelDfltNS + "\"");
                } else if (!"SOAP-ENV:Body".equals(this.currentTopLevelTag)) {
                    this.templatePart.insert(0, " xmlns=\"\"");
                }
            }
            if (this.currentTopLevelType != null) {
                this.templatePart.insert(0, " xsi:type=\"" + this.currentTopLevelTypePrefix + ":" + this.currentTopLevelType.getLocalPart() + "\"");
            }
            this.templatePart.insert(0, this.currentTopLevelTag);
            if (this.currentTopLevelNameSpace != null) {
                this.templatePart.insert(0, ":");
                this.templatePart.insert(0, this.currentTopLevelNameSpace);
            }
            this.templatePart.insert(0, "<");
            this.currentTopLevelTag = null;
            this.currentTopLevelNameSpace = null;
            this.currentTopLevelDfltNS = null;
            this.nameSpacePrefixMap.clear();
            this.template.append(this.templatePart.toString());
            this.templatePart.delete(0, this.templatePart.length());
        }
    }

    private String addNamespace(String nameSpace) {
        String prefixTmp = this.nameSpacePrefixMap.get(nameSpace);
        if (prefixTmp == null) {
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(nameSpace)) {
                prefixTmp = "xsi";
            } else if ("http://www.ibm.com/xmlns/prod/CICS/channel-instance".equals(nameSpace)) {
                prefixTmp = "cics";
            } else {
                ++this.nameSpaceCounter;
                prefixTmp = "ns" + this.nameSpaceCounter;
            }
            this.nameSpacePrefixMap.put(nameSpace, prefixTmp);
        }
        return prefixTmp;
    }

    protected String addAttribute(String attributeName, String nameSpace, StringBuilder prefix) {
        prefix.setLength(0);
        String variableName = this.getLocationName(attributeName);
        if (nameSpace != null) {
            String prefixTmp = this.addNamespace(nameSpace);
            prefix.append(prefixTmp);
        }
        if (this.templatePart.indexOf(">") == -1) {
            this.attributeLocationNames.add(variableName);
        } else {
            int currentLocation = this.templatePart.length() - 1;
            while (this.templatePart.charAt(currentLocation) != '>') {
                --currentLocation;
            }
            this.templatePart.insert(currentLocation, "&" + variableName + ";");
        }
        return variableName;
    }

    protected void addAttributeWithValue(String attributeName, String nameSpace, String value) {
        String prefixTmp = null;
        if (nameSpace != null) {
            prefixTmp = this.addNamespace(nameSpace);
        }
        String attrWithValue = attributeName + "=\"" + value + "\"";
        if (prefixTmp != null) {
            attrWithValue = prefixTmp + ":" + attrWithValue;
        }
        attrWithValue = " " + attrWithValue;
        if (this.templatePart.indexOf(">") == -1) {
            this.attributesWithValues.add(attrWithValue);
        } else {
            int currentLocation = this.templatePart.length() - 1;
            while (this.templatePart.charAt(currentLocation) != '>') {
                --currentLocation;
            }
            this.templatePart.insert(currentLocation, attrWithValue);
        }
    }

    protected String addVariable(String typeNameSpace, String type, String variableName) {
        if (typeNameSpace != null && type != null) {
            if (this.templatePart.length() != 0) {
                this.templatePart.deleteCharAt(this.templatePart.length() - 1);
            } else {
                this.topLevelCloseTagNeeded = false;
            }
            this.templatePart.append(" xsi:type=\"" + this.nameSpacePrefixMap.get(typeNameSpace) + ":" + type + "\">");
        }
        variableName = this.getLocationName(variableName);
        this.templatePart.append("&");
        this.templatePart.append(variableName);
        this.templatePart.append(";");
        return variableName;
    }

    private String getLocationName(String candidateName) {
        if (MappingLevelHelper.supportsMappingLevel_2(this.mappingLevel)) {
            return UniqueNameGenerator.ensureUnique(this.variableNames, candidateName, true, this.mappingLevel, true).getName();
        }
        return UniqueNameGenerator.ensureUnique(this.variableNames, candidateName, true, this.mappingLevel, false).getName();
    }

    public String toString() {
        if (this.template == null || this.template.toString().equals("")) {
            return this.templatePart.toString();
        }
        return this.template.toString();
    }

    protected String getCurrentDefaultNameSpace() {
        return this.nameSpaces.get(this.nameSpaces.size() - 1);
    }

    protected boolean containsTypeInfo() {
        return this.currentTopLevelType != null;
    }
}

