/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class XMLTemplateEvent {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    EventType eventType = null;
    QName qname = null;
    String insertName = null;

    public static List<XMLTemplateEvent> parseXMLTemplate(String template, boolean json) {
        ArrayList<XMLTemplateEvent> events = new ArrayList<XMLTemplateEvent>(20);
        Stack<String> defaultNSs = new Stack<String>();
        Pattern pattern1 = Pattern.compile("[&<>]");
        Matcher matcher = pattern1.matcher(template);
        Pattern pattern2 = Pattern.compile("[&>/\\s]");
        boolean betweenTags = true;
        while (matcher.find()) {
            if (matcher.group().equals("&")) {
                int endIndex = template.indexOf(59, matcher.start());
                if (endIndex < 0) {
                    throw new RuntimeException("Invalid XML template (1)");
                }
                String varName = template.substring(matcher.start(), endIndex + 1);
                if (betweenTags) {
                    events.add(new XMLTemplateEvent(EventType.TAG_INSERT_POINT, null, varName));
                    continue;
                }
                events.add(new XMLTemplateEvent(EventType.ATTRIBUTE_INSERT_POINT, null, varName));
                continue;
            }
            if (matcher.group().equals("<")) {
                char delimitChar;
                betweenTags = false;
                if (template.charAt(matcher.start() + 1) == '/') {
                    int endPos = template.indexOf(62, matcher.start());
                    if (endPos == -1) {
                        throw new RuntimeException("Invalid XML template (2)");
                    }
                    String localName = template.substring(matcher.start() + 2, endPos);
                    if (localName.indexOf("SOAP-ENV:Body") != -1) continue;
                    events.add(new XMLTemplateEvent(EventType.END_TAG, null, null));
                    betweenTags = true;
                    if (localName.indexOf("&elName;") != -1) {
                        matcher.find();
                        continue;
                    }
                    defaultNSs.pop();
                    continue;
                }
                String substring = template.substring(matcher.start() + 1);
                Matcher matcher2 = pattern2.matcher(substring);
                matcher2.find();
                String localName = substring.substring(0, matcher2.start());
                String namespace = null;
                if (localName.equals("")) {
                    matcher2.find();
                    localName = substring.substring(0, matcher2.start());
                    if (!localName.equals("&elName;")) {
                        throw new RuntimeException("Invalid XML template (3)");
                    }
                    matcher.find();
                    int endPos = substring.indexOf(62);
                    if (endPos == -1) {
                        throw new RuntimeException("Invalid XML template (4)");
                    }
                    int indexOfNS = substring.indexOf("xmlns:ns1=");
                    if (indexOfNS <= -1 || indexOfNS >= endPos) {
                        throw new RuntimeException("Invalid XML template (5)");
                    }
                    char delimitChar2 = substring.charAt(indexOfNS + 10);
                    endPos = substring.indexOf(delimitChar2, indexOfNS + 11);
                    namespace = substring.substring(indexOfNS + 11, endPos);
                    int indexOfDT = substring.indexOf("xsi:type=");
                    String dataType = null;
                    if (indexOfDT <= -1 || indexOfDT >= endPos) {
                        throw new RuntimeException("Invalid XML template (6)");
                    }
                    delimitChar = substring.charAt(indexOfDT + 9);
                    endPos = substring.indexOf(delimitChar, indexOfDT + 10);
                    dataType = substring.substring(indexOfDT + 10, endPos);
                    events.add(new XMLTemplateEvent(EventType.ADT_TAG, null, dataType));
                    events.add(new XMLTemplateEvent(EventType.NAMESPACE, new QName(namespace, "", "ns1"), null));
                    matcher.find();
                    continue;
                }
                String cicsAttrLN = null;
                String cicsAttrVal = null;
                if (!matcher.group().equals(">")) {
                    int endPos = substring.indexOf(62);
                    if (endPos == -1) {
                        throw new RuntimeException("Invalid XML template (7)");
                    }
                    int indexOfNS = substring.indexOf("xmlns=");
                    if (indexOfNS > -1 && indexOfNS < endPos) {
                        delimitChar = substring.charAt(indexOfNS + 6);
                        endPos = substring.indexOf(delimitChar, indexOfNS + 7);
                        namespace = substring.substring(indexOfNS + 7, endPos);
                    }
                    int indexOfCICSAttr = substring.indexOf("cics:");
                    endPos = substring.indexOf(62);
                    if (indexOfCICSAttr > -1 && indexOfCICSAttr < endPos) {
                        int endOfLocalName = substring.indexOf(61, indexOfCICSAttr);
                        cicsAttrLN = substring.substring(indexOfCICSAttr + 5, endOfLocalName);
                        int startOfValue = substring.indexOf(34, indexOfCICSAttr);
                        int endOfValue = substring.indexOf(34, startOfValue + 1);
                        cicsAttrVal = substring.substring(startOfValue + 1, endOfValue);
                    }
                }
                if (namespace == null && defaultNSs.size() > 0) {
                    namespace = (String)defaultNSs.peek();
                }
                if (localName.equals("SOAP-ENV:Body")) continue;
                if (!json && localName.indexOf(58) > -1) {
                    throw new RuntimeException("Invalid XML template (8)");
                }
                defaultNSs.push(namespace);
                events.add(new XMLTemplateEvent(EventType.NEW_TAG, new QName(localName), null));
                if (namespace != null) {
                    events.add(new XMLTemplateEvent(EventType.DEFAULT_NAMESPACE, new QName(namespace, ""), null));
                }
                if (cicsAttrLN == null) continue;
                events.add(new XMLTemplateEvent(EventType.ATTRIBUTE, new QName("http://www.ibm.com/xmlns/prod/CICS/channel-instance", cicsAttrLN, "cics"), cicsAttrVal));
                continue;
            }
            if (!matcher.group().equals(">")) continue;
            betweenTags = true;
        }
        return events;
    }

    public XMLTemplateEvent(EventType eventType, QName qname, String insertName) {
        this.eventType = eventType;
        this.qname = qname;
        this.insertName = insertName;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getInsertName() {
        return this.insertName;
    }

    public String toString() {
        return "Event type: '" + (Object)((Object)this.eventType) + "' qname: '" + this.qname + "' insert: '" + this.insertName + "'";
    }

    public static enum EventType {
        NEW_TAG,
        END_TAG,
        NAMESPACE,
        DEFAULT_NAMESPACE,
        TAG_INSERT_POINT,
        ATTRIBUTE_INSERT_POINT,
        ADT_TAG,
        ATTRIBUTE;

    }
}

