/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.util;

import com.ibm.cics.schema.util.CodePageHelper;
import java.io.PrintStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.activation.DataHandler;

public class ByteArray
extends DataHandler
implements Comparable<ByteArray> {
    private static final int LINE_LENGTH = 76;
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ByteBuffer buffer = null;
    private boolean constant = false;
    private int hashCode = 0;
    private int length = 0;
    private String text = null;
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF8");
    private static final int MASK = 15;
    private static final URL MEDIA_TYPE;
    private static byte[] byteFF;
    private static byte[] byteFFFF;
    private static byte[] byteFFFFFF;
    private static final char[] TOKENS;
    private static final char PAD_TOKEN = '=';

    public ByteArray(byte[] d, boolean constant) {
        super(MEDIA_TYPE);
        this.buffer = ByteBuffer.wrap(d);
        this.constant = constant;
        this.length = d.length;
    }

    public ByteArray(String s, boolean constant) {
        this(s, constant, CHARSET_UTF8);
    }

    public ByteArray(String s, boolean constant, Charset encoding) {
        this(s.getBytes(encoding), constant);
        this.text = s;
    }

    public ByteArray(byte[] d, int offset, int length, boolean constant) {
        super(MEDIA_TYPE);
        this.buffer = ByteBuffer.wrap(d, offset, length);
        this.constant = constant;
        this.length = length;
    }

    public ByteArray(ByteArray b, int offset, int length, boolean constant) {
        super(MEDIA_TYPE);
        this.buffer = ByteBuffer.wrap(b.getByteArrayBuffer(), b.getByteArrayOffset() + offset, length);
        this.constant = constant;
        this.length = length;
    }

    public final int length() {
        return this.length;
    }

    public final byte[] getByteArrayBuffer() {
        return this.buffer.array();
    }

    public final int getByteArrayOffset() {
        return this.buffer.position();
    }

    public final void stripLeadingBOM() {
        byte[] data = this.buffer.array();
        int offset = this.buffer.position();
        if (this.length > 2 && data[offset] == -17 && data[offset + 1] == -69 && data[offset + 2] == -65) {
            this.buffer.position(offset + 3);
            this.length -= 3;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteArray)) {
            return false;
        }
        ByteArray otherBA = (ByteArray)other;
        if (this.hashCode != 0 && this.hashCode != other.hashCode()) {
            return false;
        }
        return ByteArray.equals(this.buffer.array(), this.buffer.position(), this.length(), otherBA.getByteArrayBuffer(), otherBA.getByteArrayOffset(), otherBA.length());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int hash = 0;
        int start = this.buffer.position();
        int end = start + this.length();
        byte[] array = this.buffer.array();
        for (int i = start; i < end; ++i) {
            hash += array[i];
        }
        hash += this.length();
        if (this.constant) {
            this.hashCode = hash;
        }
        return hash;
    }

    @Override
    public int compareTo(ByteArray bytes) {
        int len1 = this.length();
        int len2 = bytes.length();
        byte[] data1 = this.getByteArrayBuffer();
        byte[] data2 = bytes.getByteArrayBuffer();
        int offset1 = this.getByteArrayOffset();
        int offset2 = bytes.getByteArrayOffset();
        int i = 0;
        while (true) {
            int byte1 = 0;
            int byte2 = 0;
            if (i < len1) {
                byte1 = data1[i + offset1] & 0xFF;
            } else if (i >= len2) {
                return 0;
            }
            if (i < len2) {
                byte2 = data2[i + offset2] & 0xFF;
            }
            if (byte1 > byte2) {
                return 1;
            }
            if (byte2 > byte1) {
                return -1;
            }
            ++i;
        }
    }

    private static boolean equals(byte[] a1, int a1Offset, int a1Length, byte[] a2, int a2Offset, int a2Length) {
        if (a1Length != a2Length) {
            return false;
        }
        for (int i = 0; i < a1Length; ++i) {
            if (a1[i + a1Offset] == a2[i + a2Offset]) continue;
            return false;
        }
        return true;
    }

    public Object getContent() {
        return this.buffer;
    }

    public String toText(Charset encoding) {
        return this.toTextTrimmed(encoding, true);
    }

    public String toTextTrimmed(Charset encoding, boolean trim) {
        String data;
        if (this.text != null) {
            return this.text;
        }
        try {
            data = new String(this.getByteArrayBuffer(), this.getByteArrayOffset(), this.length(), encoding);
            if (trim) {
                data = data.trim();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.constant) {
            this.text = data;
        }
        return data;
    }

    public String formatBytesForDisplay() {
        return ByteArray.formatBytesForDisplay(this.getByteArrayBuffer(), this.getByteArrayOffset(), this.length());
    }

    public static final String formatBytesForDisplay(byte[] data) {
        return ByteArray.formatBytesForDisplay(data, 0, data.length);
    }

    public static final String formatBytesForDisplay(byte[] data, int offset, int length) {
        StringBuilder result = new StringBuilder();
        if (data != null) {
            result.append("0x");
            int endOffset = offset + length;
            for (int i = offset; i < endOffset; ++i) {
                result.append(HEXCHARS[data[i] >> 4 & 0xF]);
                result.append(HEXCHARS[data[i] & 0xF]);
            }
        } else {
            result.append("NULL");
        }
        return result.toString();
    }

    public final void logReadableBinaryData(Charset codePage, PrintStream out) {
        int i;
        StringBuilder sb = new StringBuilder();
        byte[] displayCopy = new byte[this.length()];
        System.arraycopy(this.getByteArrayBuffer(), this.getByteArrayOffset(), displayCopy, 0, this.length());
        for (i = 0; i < displayCopy.length; ++i) {
            if (displayCopy[i] <= -1 || displayCopy[i] >= 75 || displayCopy[i] == 64) continue;
            displayCopy[i] = 75;
        }
        for (i = this.getByteArrayOffset(); i < this.length(); ++i) {
            if (i % 4 == 0 && i > 0) {
                sb.append(' ');
            }
            if (i % 16 == 0 && i > 0) {
                sb.append("  ");
            }
            if (i % 32 == 0 && i > 0) {
                if (codePage == null) {
                    sb.append("   *" + new String(displayCopy, i - 32 - this.getByteArrayOffset(), 32, CodePageHelper.getCurrentCodePage()) + "*" + LINE_SEPARATOR + " ");
                } else {
                    sb.append("   *" + new String(displayCopy, i - 32 - this.getByteArrayOffset(), 32, codePage) + "*" + LINE_SEPARATOR + " ");
                }
            }
            if (i % 256 == 0) {
                sb.append(LINE_SEPARATOR + "Offset: " + ByteArray.formatNumForDisplay(i) + LINE_SEPARATOR + " ");
            }
            byte[] array = this.getByteArrayBuffer();
            sb.append(HEXCHARS[array[i] >> 4 & 0xF]);
            sb.append(HEXCHARS[array[i] & 0xF]);
        }
        if (i > 0) {
            int bytes = i % 32;
            if (bytes == 0) {
                bytes = 32;
            }
            sb.append("   *" + new String(displayCopy, i - bytes - this.getByteArrayOffset(), bytes, CodePageHelper.getCurrentCodePage()) + "*" + LINE_SEPARATOR);
        }
        out.print(sb.toString());
    }

    public static byte[] toEBCDICByteArray(String s, int desiredLength) {
        return ByteArray.toCodePageByteArray(s, desiredLength, CodePageHelper.getCurrentCodePage());
    }

    public static byte[] toCodePageByteArray(String sIn, int desiredLength, Charset codepage) {
        String s = sIn;
        if (s == null) {
            s = "";
        }
        byte[] tmp = s.getBytes(codepage);
        if (desiredLength != -1 && tmp.length > desiredLength) {
            throw new RuntimeException("INTERNAL ERROR: String '" + s + "' is longer than " + desiredLength + " bytes in codepage '" + codepage + "'.");
        }
        if (desiredLength != -1 && tmp.length < desiredLength) {
            byte[] tmp2 = tmp;
            tmp = new byte[desiredLength];
            System.arraycopy(tmp2, 0, tmp, 0, tmp2.length);
        }
        return tmp;
    }

    public static byte[] numToByteArray(long sourceIn, int bytesRequiredIn) {
        long source = sourceIn;
        int bytesRequired = bytesRequiredIn;
        byte[] output = new byte[bytesRequired];
        int bytesRequiredOrig = bytesRequired--;
        if (source == -1L) {
            switch (bytesRequired) {
                case 0: {
                    output = byteFF;
                    break;
                }
                case 1: {
                    output = byteFFFF;
                    break;
                }
                case 2: {
                    output = byteFFFFFF;
                    break;
                }
                default: {
                    for (int i = bytesRequired; i > -1; --i) {
                        output[i] = -1;
                    }
                }
            }
        } else {
            long maxNum;
            switch (bytesRequiredOrig) {
                case 1: {
                    maxNum = 255L;
                    break;
                }
                case 2: {
                    maxNum = 65535L;
                    break;
                }
                case 3: {
                    maxNum = 0xFFFFFFL;
                    break;
                }
                default: {
                    maxNum = -1L;
                }
            }
            if (maxNum != -1L && maxNum < source) {
                throw new RuntimeException("INTERNAL ERROR: A range error has occurred. Value '" + source + "' is too large. The maximum value supported is '" + maxNum + "'.");
            }
            for (int i = bytesRequired; i > -1; --i) {
                output[i] = (byte)(source % 256L);
                source /= 256L;
            }
        }
        return output;
    }

    public static String formatNumForDisplay(long l) {
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        byte[] hexvalue = null;
        try {
            hexvalue = ByteArray.numToByteArray(l, 8);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return "UNKNOWN";
        }
        for (int i = 0; i < hexvalue.length; ++i) {
            sb.append(HEXCHARS[hexvalue[i] >> 4 & 0xF]);
            sb.append(HEXCHARS[hexvalue[i] & 0xF]);
        }
        sb.append(" (" + l + ")");
        return sb.toString();
    }

    public static int byteArrayToInt(byte[] b, int offset) {
        return b[3 + offset] & 0xFF | (b[2 + offset] & 0xFF) << 8 | (b[1 + offset] & 0xFF) << 16 | (b[0 + offset] & 0xFF) << 24;
    }

    public static int byteArrayToShort(byte[] b, int offset) {
        return b[1 + offset] & 0xFF | (b[0 + offset] & 0xFF) << 8;
    }

    public static void intToByteArray(byte[] b, int offset, int i) {
        b[offset] = (byte)(i >> 24 & 0xFF);
        b[offset + 1] = (byte)(i >> 16 & 0xFF);
        b[offset + 2] = (byte)(i >> 8 & 0xFF);
        b[offset + 3] = (byte)(i & 0xFF);
    }

    public static int byteArrayToInt(ByteArray byteArray, int offset) {
        byte[] b = byteArray.getByteArrayBuffer();
        int totalOffset = byteArray.getByteArrayOffset() + offset;
        return ByteArray.byteArrayToInt(b, totalOffset);
    }

    public static void intToByteArray(ByteArray byteArray, int offset, int i) {
        byte[] b = byteArray.getByteArrayBuffer();
        int totalOffset = byteArray.getByteArrayOffset() + offset;
        ByteArray.intToByteArray(b, totalOffset, i);
    }

    public static boolean byteArrayToBool(byte[] b, int offset) {
        return (b[offset] & 1) == 1;
    }

    public static void boolToByteArray(byte[] b, int offset, boolean bool) {
        b[offset] = bool ? (byte)1 : 0;
    }

    public static boolean byteArrayToBool(ByteArray byteArray, int offset) {
        byte[] b = byteArray.getByteArrayBuffer();
        int totalOffset = byteArray.getByteArrayOffset() + offset;
        return ByteArray.byteArrayToBool(b, totalOffset);
    }

    public static void boolToByteArray(ByteArray byteArray, int offset, boolean bool) {
        byte[] b = byteArray.getByteArrayBuffer();
        int totalOffset = byteArray.getByteArrayOffset() + offset;
        ByteArray.boolToByteArray(b, totalOffset, bool);
    }

    public static String byteArrayToBase64Binary(byte[] bytes) {
        StringBuilder b64Binary = new StringBuilder(ByteArray.encode(bytes, 0, bytes.length));
        if (b64Binary.indexOf(LINE_SEPARATOR) == -1) {
            StringBuilder output = new StringBuilder();
            int i = 0;
            do {
                int lineLength = b64Binary.length() - i * 76 > 76 ? 76 : b64Binary.length() - i * 76;
                String line = b64Binary.substring(i * 76, i * 76 + lineLength);
                output.append(line + LINE_SEPARATOR);
            } while (++i * 76 < b64Binary.length());
            return output.toString();
        }
        return b64Binary.toString();
    }

    public static boolean allNulls(byte[] buffer, int offset, int range) {
        int endOffset = offset + range;
        for (int i = offset; i < endOffset; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean allEmpty(byte[] buffer, int offset, int range, boolean testNull, boolean testSpace, boolean testZero, boolean testPackedZero) {
        int endOffset = offset + range;
        for (int i = offset; i < endOffset; ++i) {
            if (testNull && buffer[i] == 0 || testSpace && buffer[i] == 64 || testZero && buffer[i] == -16 || testPackedZero && buffer[i] == 0 || testPackedZero && buffer[i] == 12 || testPackedZero && buffer[i] == 13 || testPackedZero && buffer[i] == 15) continue;
            return false;
        }
        return true;
    }

    public static byte[] timeStampToBinary(Date timestamp, int length, Charset codepage) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        return ByteArray.padBytes(ByteArray.toCodePageByteArray(sdf.format(timestamp), length, codepage));
    }

    private static byte[] padBytes(byte[] bytes) {
        byte[] b = bytes;
        for (int i = b.length - 1; i > 0 && b[i] == 0; --i) {
            b[i] = 64;
        }
        return b;
    }

    public static String byteArrayToString(byte[] b, int offset, int length, Charset cp, boolean trim) {
        try {
            String s = new String(b, offset, length, cp);
            if (trim && (s = s.trim()).indexOf(0) > -1) {
                s = s.substring(0, s.indexOf(0));
            }
            return s;
        }
        catch (Exception e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
    }

    public static int byteArrayToInt(byte[] b, int offset, int bytes) {
        if (bytes > 4 || bytes < 0) {
            throw new RuntimeException("INTERNAL ERROR: A range error has occurred. The byte[] must be less than or equal 4. ");
        }
        int number = 0;
        if (bytes == 1 ? b[offset] == -1 : (bytes == 2 ? b[offset] == -1 && b[offset + 1] == -1 : bytes == 3 && b[offset] == -1 && b[offset + 1] == -1 && b[offset + 2] == -1)) {
            return -1;
        }
        for (int i = offset; i < offset + bytes; ++i) {
            byte numPart = b[i];
            number *= 256;
            number += numPart;
            if (numPart > -1) continue;
            number += 256;
        }
        return number;
    }

    private static String encode(byte[] data, int offset, int length) {
        int remainder = length % 3;
        int resultSize = (remainder == 0 ? length : length + 3 - remainder) / 3 * 4;
        StringBuilder resultBuff = new StringBuilder(resultSize);
        int groupIndex = 0;
        int previousByte = 0;
        for (int i = offset; i < length; ++i) {
            int currentByte = data[i];
            switch (groupIndex) {
                case 0: {
                    resultBuff.append(TOKENS[(currentByte & 0xFC) >> 2]);
                    groupIndex = 1;
                    break;
                }
                case 1: {
                    resultBuff.append(TOKENS[(previousByte & 3) << 4 | (currentByte & 0xF0) >> 4]);
                    groupIndex = 2;
                    break;
                }
                case 2: {
                    resultBuff.append(TOKENS[(previousByte & 0xF) << 2 | (currentByte & 0xC0) >> 6]);
                    resultBuff.append(TOKENS[currentByte & 0x3F]);
                    groupIndex = 0;
                    break;
                }
            }
            previousByte = currentByte;
        }
        switch (groupIndex) {
            case 1: {
                resultBuff.append(TOKENS[(previousByte & 3) << 4]);
                resultBuff.append('=');
                resultBuff.append('=');
                break;
            }
            case 2: {
                resultBuff.append(TOKENS[(previousByte & 0xF) << 2]);
                resultBuff.append('=');
                break;
            }
        }
        String result = resultBuff.toString();
        return result;
    }

    static {
        try {
            MEDIA_TYPE = new URL("http://ByteArray");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byteFF = new byte[]{-1};
        byteFFFF = new byte[]{-1, -1};
        byteFFFFFF = new byte[]{-1, -1, -1};
        TOKENS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    }
}

