/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.util;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class CodePageHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2006, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    public static final String UTF_16BE_CODEPAGE_NAME = "UTF-16BE";
    public static final Charset UTF_16BE_CHARSET = Charset.forName("UTF-16BE");
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF8");
    public static final Charset CP037_CHARSET = Charset.forName("Cp037");
    public static final int UTF_16BE_CCSID = 1200;
    private static Charset defaultCP;
    private static Charset currentCP;
    private static Charset currentEBCDICCP;
    private static Map<String, Charset> CCSIDToCharset;
    private static final byte[] TEST_BYTES;
    private static final String TEST_BYTES_STR = "A0";
    public static final byte[] UTF16BE_BOM;
    public static final byte[] UTF16LE_BOM;

    public static Charset getCurrentCodePage() {
        return currentCP;
    }

    public static Charset getCurrentEBCDICCodePage() {
        return currentEBCDICCP;
    }

    public static Charset getDefaultCodePage() {
        return defaultCP;
    }

    public static void setCurrentCodePage(Charset cp) {
        if (cp.equals(UTF_16BE_CHARSET)) {
            if (!currentCP.equals(UTF_16BE_CHARSET)) {
                currentEBCDICCP = currentCP;
            }
        } else if (!cp.equals(UTF_16BE_CHARSET)) {
            currentEBCDICCP = cp;
        }
        currentCP = cp;
    }

    private static void populateCCSIDMap() {
        CCSIDToCharset.put("37", Charset.forName("Cp037"));
        CCSIDToCharset.put("367", Charset.forName("ASCII"));
        CCSIDToCharset.put("1200", Charset.forName(UTF_16BE_CODEPAGE_NAME));
        CCSIDToCharset.put("1208", Charset.forName("UTF8"));
        CCSIDToCharset.put("1392", Charset.forName("GB18030"));
    }

    public static Charset resolveCCSID(int codepage) {
        if (codepage == 1208) {
            return UTF_8_CHARSET;
        }
        if (codepage == 37) {
            return CP037_CHARSET;
        }
        String CCSID = Integer.toString(codepage);
        if (CCSIDToCharset.isEmpty()) {
            CodePageHelper.populateCCSIDMap();
        }
        if (codepage == 0) {
            return null;
        }
        Charset resolvedCharset = CCSIDToCharset.get(CCSID);
        if (resolvedCharset != null) {
            return resolvedCharset;
        }
        String CpTest = "Cp" + CCSID;
        if (CodePageHelper.codePageExists(CpTest)) {
            resolvedCharset = Charset.forName(CpTest);
        }
        if (resolvedCharset == null) {
            throw new RuntimeException("No Java CharSet available for CCSID: " + codepage);
        }
        CCSIDToCharset.put(CCSID, resolvedCharset);
        return resolvedCharset;
    }

    public static Charset resolveCCSID(String CCSID) {
        if (CCSIDToCharset.isEmpty()) {
            CodePageHelper.populateCCSIDMap();
        }
        if (CCSID == null) {
            return null;
        }
        String simpleCCSID = CodePageHelper.removeLeadingZeros(CCSID);
        Charset resolvedCharset = CCSIDToCharset.get(simpleCCSID);
        if (resolvedCharset == null) {
            String CpTest = "Cp" + simpleCCSID;
            if (!CodePageHelper.codePageExists(CpTest)) {
                if (CodePageHelper.codePageExists(simpleCCSID)) {
                    resolvedCharset = Charset.forName(simpleCCSID);
                }
            } else {
                resolvedCharset = Charset.forName(CpTest);
            }
            CCSIDToCharset.put(simpleCCSID, resolvedCharset);
        }
        return resolvedCharset;
    }

    private static boolean codePageExists(String codepage) {
        try {
            new String(TEST_BYTES, codepage);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String removeLeadingZeros(String CCSID) {
        int firstNonZero;
        if (CCSID == null) {
            return null;
        }
        int lastChar = CCSID.length();
        for (firstNonZero = 0; firstNonZero < lastChar && CCSID.charAt(firstNonZero) == '0'; ++firstNonZero) {
        }
        if (firstNonZero == lastChar) {
            firstNonZero = 0;
        }
        return CCSID.substring(firstNonZero).intern();
    }

    public static boolean isEBCDICCCSID(String CCSID) {
        if (CCSID == null) {
            return false;
        }
        Charset resolvedCCSID = CodePageHelper.resolveCCSID(CCSID);
        String converted = new String(TEST_BYTES, resolvedCCSID);
        return converted.equals(TEST_BYTES_STR);
    }

    public static int getApplicationCCSID(String ccsid) {
        int CCSIDNum = 0;
        if (ccsid != null && !"".equals(ccsid)) {
            CCSIDNum = Integer.parseInt(ccsid);
        }
        return CCSIDNum;
    }

    public static Charset getEBCDICEncodingForICM(int ccsidIn, int altCcsid) {
        Charset encoding;
        int ccsid = ccsidIn;
        if (ccsid == 1200) {
            ccsid = altCcsid;
        }
        if ((encoding = ccsid == 0 ? CodePageHelper.getDefaultCodePage() : CodePageHelper.resolveCCSID(ccsid)) == null) {
            throw new NullPointerException("Encoding unrecognised: " + ccsid);
        }
        return encoding;
    }

    static {
        currentCP = defaultCP = Charset.forName("Cp037");
        currentEBCDICCP = defaultCP;
        CCSIDToCharset = new HashMap<String, Charset>();
        TEST_BYTES = new byte[]{-63, -16};
        UTF16BE_BOM = new byte[]{-2, -1};
        UTF16LE_BOM = new byte[]{-1, -2};
    }
}

