/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.schema.utils;

import com.ibm.cics.schema.utils.MappingLevelHelper;
import java.util.Locale;
import java.util.Set;

public class UniqueNameGenerator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean NOT_CASE_SENSITIVE = false;
    public static final boolean OPTIMISED_NAMES = true;
    public static final boolean HUMAN_READABLE_NAMES = false;
    public static final boolean NO_REUSE_OF_NAME = true;
    public static final boolean ALLOW_REUSE_OF_NAME = false;

    public static UniqueName ensureUnique(Set<String> allNames, String seed, boolean isCaseSensitive, int mappingLevel, boolean optimisation) {
        return UniqueNameGenerator.ensureUnique(allNames, seed, isCaseSensitive, mappingLevel, optimisation, true, null);
    }

    public static UniqueName ensureUnique(Set<String> allNames, String seed, boolean isCaseSensitive, int mappingLevel, boolean optimisation, boolean reserve) {
        if (!optimisation) {
            return UniqueNameGenerator.ensureUniqueHumanReadable(allNames, seed, isCaseSensitive, mappingLevel, reserve, null);
        }
        return UniqueNameGenerator.ensureUniqueOptimised(allNames, isCaseSensitive, mappingLevel, reserve, null);
    }

    public static UniqueName ensureUnique(Set<String> allNames, String seed, boolean isCaseSensitive, int mappingLevel, boolean optimisation, boolean reserve, String parentName) {
        if (!optimisation) {
            return UniqueNameGenerator.ensureUniqueHumanReadable(allNames, seed, isCaseSensitive, mappingLevel, reserve, parentName);
        }
        return UniqueNameGenerator.ensureUniqueOptimised(allNames, isCaseSensitive, mappingLevel, reserve, parentName);
    }

    private static UniqueName ensureUniqueHumanReadable(Set<String> allNames, String seed, boolean isCaseSensitive, int mappingLevel, boolean reserve, String parentName) {
        String localNameOrig = seed;
        if (!isCaseSensitive) {
            localNameOrig = localNameOrig.toUpperCase(Locale.ENGLISH);
        }
        String localName = localNameOrig;
        int i = 1;
        if (MappingLevelHelper.supportsMappingLevel_2_2(mappingLevel)) {
            i = 2;
        }
        boolean changed = false;
        String localNamePrefix = localName;
        if (parentName != null) {
            localNamePrefix = parentName + ":" + localName;
        }
        while (allNames.contains(localNamePrefix)) {
            if (localNameOrig.length() > 1 && (i == 100 || i == 1000)) {
                localNameOrig = localNameOrig.substring(0, localNameOrig.length() - 1);
                seed = seed.substring(0, seed.length() - 1);
            }
            localName = !isCaseSensitive ? localNameOrig + i : seed + i;
            localNamePrefix = localName;
            if (parentName != null) {
                localNamePrefix = parentName + ":" + localName;
            }
            changed = true;
            ++i;
        }
        UniqueName returnStruc = null;
        if (!changed) {
            localName = seed;
            returnStruc = new UniqueName(localName, false);
        } else {
            if (!MappingLevelHelper.requiresMappingLevel_1(mappingLevel)) {
                localName = seed + (i - 1);
            }
            returnStruc = new UniqueName(localName, true);
        }
        if (reserve) {
            if (isCaseSensitive) {
                allNames.add(localNamePrefix);
            } else {
                allNames.add(localNamePrefix.toUpperCase(Locale.ENGLISH));
            }
        }
        return returnStruc;
    }

    private static UniqueName ensureUniqueOptimised(Set<String> allNames, boolean isCaseSensitive, int mappingLevel, boolean reserve, String parentName) {
        int currentCandidate = allNames.size();
        char newCandidate = (char)(currentCandidate % 26 + 65);
        return UniqueNameGenerator.ensureUniqueHumanReadable(allNames, Character.toString(newCandidate), isCaseSensitive, mappingLevel, reserve, parentName);
    }

    public static class UniqueName {
        String name = null;
        boolean nameClash = false;

        public UniqueName(String name, boolean nameClash) {
            this.name = name;
            this.nameClash = nameClash;
        }

        public String getName() {
            return this.name;
        }

        public boolean getNameClash() {
            return this.nameClash;
        }
    }
}

