/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.soap.validation;

import com.ibm.cics.soap.validation.Validator;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.util.Map;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class MyResolver
implements EntityResolver {
    private Map<String, Element> schemas = null;
    private InputStream generatedSchema = null;

    public MyResolver(Map<String, Element> schemas, InputStream generatedSchema) {
        this.schemas = schemas;
        this.generatedSchema = generatedSchema;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (Validator.traceLog != null) {
            Validator.traceLog.println("looking for: " + publicId + " " + systemId);
        }
        if (this.schemas.containsKey(systemId)) {
            InputSource is;
            if (Validator.traceLog != null) {
                Validator.traceLog.println("found it. ");
            }
            if ((is = this.getInputSourceFromElement(this.schemas.get(systemId))) != null) {
                is.setPublicId(publicId);
            }
            if (is != null) {
                return is;
            }
        } else {
            if ("http://CICSMAGIC".equals(systemId)) {
                if (Validator.traceLog != null) {
                    Validator.traceLog.println("found it - this is the CICSMAGIC schema.");
                }
                InputSource is = new InputSource(this.generatedSchema);
                is.setPublicId(publicId);
                return is;
            }
            for (Map.Entry<String, Element> entry : this.schemas.entrySet()) {
                InputSource is;
                String sysid = entry.getKey();
                if (!systemId.endsWith(sysid)) continue;
                if (Validator.traceLog != null) {
                    Validator.traceLog.println("guessed it. ");
                }
                if ((is = this.getInputSourceFromElement(entry.getValue())) != null) {
                    is.setPublicId(publicId);
                }
                if (is == null) continue;
                return is;
            }
        }
        if (systemId.startsWith("http:") && System.getProperty("http.proxyHost") == null) {
            System.err.println("SOAP Validator Warning: No HTTP Proxy has been configured.");
        }
        return null;
    }

    private InputSource getInputSourceFromElement(Element element) {
        try {
            CharArrayWriter caw = new CharArrayWriter();
            Validator.printXMLElement(element, caw);
            caw.flush();
            char[] chars = caw.toCharArray();
            CharArrayReader car = new CharArrayReader(chars);
            return new InputSource(car);
        }
        catch (Exception exception) {
            System.err.println("Error detected in the XML validator.");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }
}

