/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.soap.validation;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.CodePageErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.Task;
import com.ibm.cics.soap.validation.MyErrorHandler;
import com.ibm.cics.soap.validation.MyResolver;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.ws2ls.WSDLFile;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Validator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static String LOCALCCSID = System.getProperty("com.ibm.cics.jvmserver.local.ccsid");
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private String namespace = null;
    private Map<String, Element> schemas = new HashMap<String, Element>();
    private InputStream newSchema = null;
    protected static final String CICSMAGIC = "http://CICSMAGIC";
    public static final String SOAPBODY = "APP_XML";
    private boolean documentStyle = true;
    private boolean valid = false;
    private static final String VALIDATION_CONT = "DFHVALIDATE";
    private static final String VALIDATION_CONT_OUT = "DFHVALIDATE-OUT";
    private static final String SOAP_BODY_CONT = "DFHWS-BODY";
    private static final String XML_NS_CONT = "DFHWS-XMLNS";
    private static final int ALLS_WELL = 0;
    private static final int CHANNEL_NOT_FOUND = 1;
    private static final int VAL_CONTAINER_ERROR = 2;
    private static final int CCSID_ERROR = 3;
    private static final int INPUT_TOO_SHORT = 4;
    private static final int INVALID = 5;
    private static final int SOAP_CONTAINER_ERROR = 6;
    private static final int INVALID_ENCODING = 8;
    private static final int LENGTH_ERROR = 9;
    static PrintStream traceLog = null;
    private static String message = null;
    private static final String DOCNAMESPACE = "http://CICSgeneratedNS4Validation/";
    private static final String NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private static final String TRACE_PROPERTY = "com.ibm.cics.soap.validation.trace";
    private static final String CHANNEL_INSTANCE_PROPERTY = "http://www.ibm.com/xmlns/prod/CICS/channel-instance";
    private WSDLFile wsdl = null;
    private static final int SCHEMA_DOC = 1;
    private static final int SCHEMA_RPC = 2;
    private static final int SCHEMA_ELEMENT = 3;

    public static void main(String[] args) {
        message = null;
        String value = System.getProperty(TRACE_PROPERTY);
        if (value != null) {
            traceLog = System.err;
        }
        try {
            Task t = Task.getTask();
            Channel myChannel = t.getCurrentChannel();
            Container output = myChannel.createContainer(VALIDATION_CONT_OUT);
            byte rcode = Validator.gatherInputAndProcess(myChannel);
            byte[] outputBytes = null;
            if (message != null) {
                byte[] messageBytes = message.getBytes(LOCALCCSID);
                outputBytes = new byte[messageBytes.length + 1];
                System.arraycopy(messageBytes, 0, outputBytes, 1, messageBytes.length);
                outputBytes[0] = rcode;
            } else {
                outputBytes = new byte[]{rcode};
            }
            output.put(outputBytes);
            if (traceLog != null) {
                traceLog.println("Got err code: " + rcode);
                traceLog.println("Message: " + message);
                traceLog.println("Container DFHVALIDATE-OUT:");
                ByteArray cont = new ByteArray(outputBytes, true);
                traceLog.println(cont.toString());
            }
        }
        catch (Exception e) {
            System.err.println("Error message from the SOAP Validator: ");
            e.printStackTrace();
        }
    }

    private static byte gatherInputAndProcess(Channel myChannel) {
        Container dfhvalidation = null;
        if (myChannel != null) {
            try {
                dfhvalidation = myChannel.getContainer(VALIDATION_CONT);
            }
            catch (ContainerErrorException cee) {
                return 2;
            }
        } else {
            return 1;
        }
        byte[] inputParms = null;
        if (dfhvalidation != null) {
            try {
                inputParms = dfhvalidation.get();
            }
            catch (CCSIDErrorException ccee) {
                return 3;
            }
            catch (CodePageErrorException cpee) {
                return 3;
            }
            catch (ChannelErrorException cem) {
                return 1;
            }
            catch (ContainerErrorException cee) {
                return 2;
            }
            catch (LengthErrorException lee) {
                return 9;
            }
        }
        String WSDLFileName = null;
        String binding = null;
        String operation = null;
        boolean request = true;
        String soap_container = null;
        String ns_container = null;
        String xml_name = null;
        String archiveFileName = null;
        if (inputParms != null && inputParms.length == 287) {
            try {
                WSDLFileName = new String(inputParms, 32, 255, LOCALCCSID).trim();
                soap_container = new String(inputParms, 0, 16, LOCALCCSID).trim();
                ns_container = new String(inputParms, 16, 16, LOCALCCSID).trim();
                xml_name = "XML_BODY";
            }
            catch (UnsupportedEncodingException uee) {
                if (traceLog != null) {
                    uee.printStackTrace(traceLog);
                }
                message = "Unsupported encoding: '" + LOCALCCSID + "'.";
                return 8;
            }
        } else if (inputParms != null && inputParms.length >= 1021) {
            try {
                WSDLFileName = new String(inputParms, 0, 255, LOCALCCSID).trim();
                binding = new String(inputParms, 255, 255, LOCALCCSID).trim();
                operation = new String(inputParms, 510, 255, LOCALCCSID).trim();
                if (inputParms[765] == 1) {
                    request = false;
                }
                archiveFileName = new String(inputParms, 766, 255, LOCALCCSID).trim();
                soap_container = SOAP_BODY_CONT;
                ns_container = XML_NS_CONT;
                xml_name = SOAPBODY;
            }
            catch (UnsupportedEncodingException uee) {
                if (traceLog != null) {
                    uee.printStackTrace(traceLog);
                }
                message = "Unsupported encoding: '" + LOCALCCSID + "'.";
                return 8;
            }
        } else {
            return 4;
        }
        if (traceLog != null) {
            traceLog.println("Channel name is: " + myChannel.getName());
            traceLog.println("WSDLFileName is: " + WSDLFileName);
            traceLog.println("Binding is: " + binding);
            traceLog.println("Operation is: " + operation);
            traceLog.println("Request Message: " + request);
            traceLog.println("XML container: " + soap_container);
            traceLog.println("XML namespace container: " + ns_container);
            traceLog.println("Archive file name is: " + archiveFileName);
        }
        String soapBody = null;
        String resolvedCCSID = null;
        String soapBodyXML = null;
        try {
            dfhvalidation = myChannel.getContainer(soap_container);
            soapBody = dfhvalidation.getString();
            if (traceLog != null) {
                traceLog.println("XML encoding: '" + dfhvalidation.getCCSID() + "'");
            }
            soapBodyXML = soapBody;
            if (traceLog != null) {
                traceLog.println("Codepage in use: " + resolvedCCSID);
                traceLog.println("Body Container " + soap_container + ":");
                traceLog.println(soapBodyXML);
            }
        }
        catch (CCSIDErrorException ccee) {
            return 3;
        }
        catch (CodePageErrorException cpee) {
            return 3;
        }
        catch (ChannelErrorException cem) {
            return 1;
        }
        catch (ContainerErrorException cee) {
            return 6;
        }
        catch (LengthErrorException cee) {
            return 9;
        }
        String namespaces = null;
        String namespacesXML = null;
        try {
            dfhvalidation = myChannel.getContainer(ns_container);
            if (dfhvalidation != null) {
                namespacesXML = namespaces = dfhvalidation.getString();
                if (traceLog != null) {
                    traceLog.println("Codepage in use: " + resolvedCCSID);
                    traceLog.println("Namespace container " + soap_container + ":");
                    traceLog.println(soapBodyXML);
                }
            } else {
                namespaces = "";
            }
        }
        catch (CCSIDErrorException ccee) {
            return 3;
        }
        catch (CodePageErrorException cpee) {
            return 3;
        }
        catch (ChannelErrorException cem) {
            return 1;
        }
        catch (ContainerErrorException cee) {
            namespaces = "";
        }
        catch (LengthErrorException cem) {
            return 9;
        }
        try {
            Validator me = new Validator(WSDLFileName, soapBodyXML, binding, operation, request, namespacesXML, archiveFileName);
            me.cleanUp();
            if (me.isValid()) {
                return 0;
            }
            return 5;
        }
        catch (SAXParseException sax) {
            String id = sax.getSystemId();
            if (id == null) {
                id = sax.getPublicId();
            }
            if (id == null) {
                id = xml_name;
            }
            String local_message = "Error encountered in document '" + id + "' in line " + sax.getLineNumber() + " and column " + sax.getColumnNumber() + ". ";
            if (traceLog != null) {
                traceLog.println(local_message);
                sax.printStackTrace(traceLog);
            }
            message = local_message + sax.getMessage();
            return 5;
        }
        catch (Exception e) {
            if (traceLog != null) {
                e.printStackTrace(traceLog);
            }
            message = e.getMessage();
            return 5;
        }
    }

    public Validator(String wsdlSource, String xmlSource, String bindingName, String operationName, boolean request, String namespaces) throws Exception {
        this(wsdlSource, xmlSource, bindingName, operationName, request, namespaces, "");
    }

    public Validator(String wsdlSource, String xmlSource, String bindingName, String operationName, boolean request, String namespaces, String archiveName) throws Exception {
        this.checkWSDLFileExists(wsdlSource, archiveName);
        int schemaStyle = -1;
        QName elementToValidate = null;
        InputSource is = null;
        if (operationName == null) {
            schemaStyle = 3;
            xmlSource = this.removeXMLProlog(xmlSource);
            is = this.generateXMLInputFromSOAP(xmlSource, this.namespace, namespaces, schemaStyle);
            elementToValidate = this.identifyFirstTag(xmlSource, namespaces);
            this.schemas = Factory.createICMBuilderFromWSDL(null, 1, null).getSchemasAsElements(wsdlSource);
        } else {
            this.wsdl = new WSDLFile(wsdlSource, true, null, null, true, false, archiveName, true);
            System.setProperty("user.dir", this.wsdl.getDirName());
            this.parseWSDL(bindingName, operationName);
            schemaStyle = this.documentStyle ? 1 : 2;
            is = this.generateXMLInputFromSOAP(xmlSource, this.namespace, namespaces, schemaStyle);
        }
        this.newSchema = this.generateSchema(operationName, request, schemaStyle, elementToValidate, namespaces);
        DocumentBuilder builder = this.getDocumentBuilder();
        builder.parse(is);
        this.valid = true;
    }

    private String removeXMLProlog(String xmlSource) {
        int endOfProlog = xmlSource.indexOf("?>");
        if (endOfProlog > -1) {
            xmlSource = xmlSource.substring(endOfProlog + 2);
        }
        return xmlSource;
    }

    private QName identifyFirstTag(String xmlSource, String namespaces) throws Exception {
        String localName = null;
        String namespace = null;
        String prefix = null;
        int startOfFirstTag = xmlSource.indexOf(60);
        int endOfFirstTag = xmlSource.indexOf(62);
        String firstTag = xmlSource.substring(startOfFirstTag + 1, endOfFirstTag);
        int endOfPrefix = -1;
        int endOfTagName = firstTag.length();
        for (int i = 0; i < firstTag.length(); ++i) {
            if (firstTag.charAt(i) == ':') {
                endOfPrefix = i;
            }
            if (firstTag.charAt(i) != ' ' && firstTag.charAt(i) != '/') continue;
            endOfTagName = i;
            break;
        }
        if (endOfPrefix == -1) {
            localName = firstTag.substring(0, endOfTagName);
            prefix = "xmlns=";
        } else {
            localName = firstTag.substring(endOfPrefix + 1, endOfTagName);
            prefix = "xmlns:" + firstTag.substring(0, endOfPrefix) + "=";
        }
        namespace = this.findNamespace(firstTag, prefix);
        if (namespace == null) {
            namespace = this.findNamespace(namespaces, prefix);
        }
        if (namespace == null) {
            throw new Exception("CICS can't validate XML if the XML does not have a namespace or if the associated XML schema does not set a targetNamespace. This is not an application error.");
        }
        return new QName(namespace, localName);
    }

    private String findNamespace(String stringToSearch, String prefix) {
        if (stringToSearch == null) {
            return null;
        }
        int startOfPrefixDec = stringToSearch.indexOf(prefix);
        if (startOfPrefixDec > -1) {
            char quote = stringToSearch.charAt(startOfPrefixDec + prefix.length());
            int endOfPrefixDec = stringToSearch.indexOf(quote, startOfPrefixDec + prefix.length() + 1);
            return stringToSearch.substring(startOfPrefixDec + prefix.length() + 1, endOfPrefixDec);
        }
        return null;
    }

    public static void setTrace(PrintStream localTrace) {
        traceLog = localTrace;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void checkWSDLFileExists(String fileName, String archiveName) throws Exception {
        String dirName = null;
        String checkFileName = null;
        String wsdlInArchive = null;
        File checkFile = null;
        if ((archiveName == null || archiveName.equals("")) && (fileName == null || fileName.equals(""))) {
            throw new Exception("Validation requires the WEBSERVICE resource to have a value for WSDLFILE or ARCHIVEFILE set.");
        }
        if (archiveName != null && !archiveName.equals("")) {
            checkFileName = archiveName;
            int i = archiveName.lastIndexOf(File.separator);
            wsdlInArchive = i == -1 ? archiveName : archiveName.substring(i + 1);
            wsdlInArchive = wsdlInArchive.replace(".zip", ".wsdl");
        } else {
            checkFileName = fileName;
        }
        checkFile = new File(checkFileName);
        if (!checkFile.exists()) {
            throw new Exception("File '" + checkFileName + "' does not exist.");
        }
        if (checkFile.isDirectory()) {
            throw new Exception("File '" + checkFileName + "' is actually a directory. It must be a file.");
        }
        if (!checkFile.canRead()) {
            throw new Exception("File '" + checkFileName + "' exists but could not be read.");
        }
        dirName = checkFile.getParentFile().getCanonicalPath();
        System.setProperty("user.dir", dirName);
        if (wsdlInArchive != null && archiveName != null && !archiveName.equals("")) {
            try {
                ZipFile wsdlZip = new ZipFile(archiveName);
                ZipEntry entry = wsdlZip.getEntry(wsdlInArchive);
                if (entry == null) {
                    wsdlZip.close();
                    throw new Exception("File '" + wsdlInArchive + "' could not be found in zip '" + archiveName + "'.");
                }
                wsdlZip.close();
            }
            catch (IOException ioe) {
                throw new Exception("Archive file '" + archiveName + "' could not be read.");
            }
        }
    }

    private void parseWSDL(String bindingName, String operationName) throws Exception {
        String binding = this.wsdl.getBindingName(bindingName);
        if (binding == null) {
            throw new Exception("Binding " + bindingName + " could not be found in WSDL file '" + this.wsdl.getWSDLFileLocation() + "' .");
        }
        this.documentStyle = true;
        this.documentStyle = this.wsdl.getStyle().toUpperCase(Locale.ENGLISH).equals("DOCUMENT");
        boolean foundOperation = false;
        for (String operationN : this.wsdl.getOperationNames(new LinkedList<String>(), null, false)) {
            if (!operationN.equals(operationName)) continue;
            foundOperation = true;
            break;
        }
        if (!foundOperation) {
            throw new Exception("Operation " + operationName + " could not be found in WSDL file '" + this.wsdl.getWSDLFileLocation() + "' .");
        }
        List<Element> allSchemas = this.wsdl.getSchemas();
        this.namespace = this.wsdl.getTargetNameSpace();
        for (Element schema : allSchemas) {
            String targetNameSpace = schema.getAttribute("targetNamespace");
            if (targetNameSpace == null || targetNameSpace.equals("")) {
                throw new Exception("CICS can't validate XML if the associated XML schema does not set a targetNamespace. This is not an application error.");
            }
            if (targetNameSpace.equals(this.namespace) && !this.documentStyle) {
                throw new Exception("CICS can't validate RPC SOAP messages if an in-scope XSD schema shares the same XML namespace as the parent WSDL document. This is not an application error. The problematic namespace is: " + this.namespace);
            }
            for (Node n = schema.getParentNode(); n != null; n = n.getParentNode()) {
                if (traceLog != null) {
                    traceLog.println("Current node is: " + n);
                }
                if (n.getAttributes() == null) continue;
                for (int i = 0; i < n.getAttributes().getLength(); ++i) {
                    Node attr = n.getAttributes().item(i);
                    if (attr.getNamespaceURI() == null || !attr.getNamespaceURI().equals(NAMESPACE_URI) || attr.getLocalName().equals("xmlns") || traceLog == null) continue;
                    traceLog.println("LocalName is :" + attr.getLocalName());
                    traceLog.println("NameSpace is :" + attr.getNamespaceURI());
                    traceLog.println("NodeValue is :" + attr.getNodeValue());
                }
            }
            this.addInScopeNameSpaceRefs(schema);
            if (traceLog != null) {
                traceLog.println("Schema '" + targetNameSpace + "': ");
                CharArrayWriter caw = new CharArrayWriter();
                Validator.printXMLElement(schema, caw);
                traceLog.println(caw.toCharArray());
            }
            this.schemas.put(targetNameSpace, schema);
        }
    }

    private void addInScopeNameSpaceRefs(Element el) {
        HashMap<String, String> inScopeNSs = new HashMap<String, String>();
        for (Node parent = el; parent != null; parent = parent.getParentNode()) {
            if (parent.getAttributes() == null) continue;
            int attributes = parent.getAttributes().getLength();
            for (int i = 0; i < attributes; ++i) {
                Node attr = parent.getAttributes().item(i);
                if (!NAMESPACE_URI.equals(attr.getNamespaceURI()) || inScopeNSs.get(attr.getLocalName()) != null) continue;
                inScopeNSs.put(attr.getLocalName(), attr.getFirstChild().getNodeValue());
            }
        }
        for (Map.Entry entry : inScopeNSs.entrySet()) {
            String prefix = (String)entry.getKey();
            if ("xmlns".equals(prefix)) continue;
            el.setAttributeNS(NAMESPACE_URI, "xmlns:" + prefix, (String)entry.getValue());
        }
    }

    protected static void printXMLElement(Element element, Writer outputWriter) {
        block3: {
            if (element != null) {
                try {
                    TransformerFactory fact = TransformerFactory.newInstance();
                    Transformer trans = fact.newTransformer();
                    trans.setOutputProperty("indent", "yes");
                    trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    trans.setOutputProperty("encoding", "UTF-8");
                    trans.transform(new DOMSource(element), new StreamResult(outputWriter));
                }
                catch (Exception exception) {
                    if (traceLog == null) break block3;
                    traceLog.println(exception.getLocalizedMessage());
                    exception.printStackTrace(traceLog);
                }
            }
        }
    }

    private InputSource generateXMLInputFromSOAP(String xmlToValidate, String WSDLnamespace, String namespaces, int schemaStyle) throws IOException, Exception {
        int endOfFirstTag = xmlToValidate.indexOf(">");
        if (traceLog != null) {
            traceLog.println("end of first tag is: " + endOfFirstTag);
        }
        if (endOfFirstTag < 0) {
            throw new Exception("XML tag not found");
        }
        int startOfLastTag = xmlToValidate.lastIndexOf("<");
        if (traceLog != null) {
            traceLog.println("start of last tag is: " + startOfLastTag);
        }
        if (schemaStyle == 3 && (namespaces == null || namespaces.length() < 2)) {
            return new InputSource(new StringReader(xmlToValidate));
        }
        if (schemaStyle == 1 || schemaStyle == 2) {
            String bodyTag = xmlToValidate.substring(0, endOfFirstTag);
            if (traceLog != null) {
                traceLog.println("first tag is: " + bodyTag);
            }
            namespaces = this.findNameSpaceRefs(namespaces, bodyTag);
            if (traceLog != null) {
                traceLog.println("name spaces are: " + namespaces);
            }
        }
        StringBuilder modifiedSOAP = new StringBuilder();
        modifiedSOAP.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><cicsPrefix1:Body xmlns:cicsPrefix1=\"");
        if (this.documentStyle) {
            modifiedSOAP.append(DOCNAMESPACE);
        } else {
            modifiedSOAP.append(WSDLnamespace);
        }
        modifiedSOAP.append("\" ");
        if (namespaces != null) {
            modifiedSOAP.append(namespaces);
        }
        if (schemaStyle != 1 && schemaStyle != 2) {
            modifiedSOAP.append(">");
            modifiedSOAP.append(xmlToValidate);
        } else if (endOfFirstTag < startOfLastTag) {
            modifiedSOAP.append(xmlToValidate.substring(endOfFirstTag, startOfLastTag));
        } else {
            modifiedSOAP.append(">");
        }
        modifiedSOAP.append("</cicsPrefix1:Body>");
        if (traceLog != null) {
            traceLog.println("Here is a copy of the 'original' XML message: ");
            traceLog.println(xmlToValidate);
            traceLog.println("Here is a copy of the 'modified' XML message: ");
            traceLog.println(modifiedSOAP.toString());
        }
        return new InputSource(new StringReader(modifiedSOAP.toString()));
    }

    private String findNameSpaceRefs(String namespacesIn, String bodyTag) {
        int prefixStartOffset;
        String xmlns = "xmlns:";
        int currOffset = 0;
        currOffset = bodyTag.indexOf("xmlns:", currOffset);
        StringBuilder namespaces = namespacesIn != null ? new StringBuilder(namespacesIn) : new StringBuilder();
        while (currOffset > 0 && (currOffset = bodyTag.indexOf("=", (prefixStartOffset = currOffset + "xmlns:".length()) + 1)) > prefixStartOffset) {
            String prefix = bodyTag.substring(prefixStartOffset, currOffset);
            int nameSpaceStartOffset = currOffset + 2;
            if ((currOffset = bodyTag.indexOf("\"", nameSpaceStartOffset)) <= nameSpaceStartOffset) break;
            String namespace = bodyTag.substring(nameSpaceStartOffset, currOffset);
            namespaces.append(" xmlns:");
            namespaces.append(prefix);
            namespaces.append("=\"");
            namespaces.append(namespace);
            namespaces.append("\" ");
            currOffset = bodyTag.indexOf("xmlns:", currOffset + 1);
        }
        return namespaces.toString();
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        this.schemas.keySet().remove(null);
        String[] allSchemasFromWSDL = this.schemas.keySet().toArray(new String[this.schemas.keySet().size()]);
        for (int i = 0; i < allSchemasFromWSDL.length; ++i) {
            if (!CHANNEL_INSTANCE_PROPERTY.equals(allSchemasFromWSDL[i])) continue;
            String tmp = allSchemasFromWSDL[i];
            allSchemasFromWSDL[i] = allSchemasFromWSDL[0];
            allSchemasFromWSDL[0] = tmp;
        }
        String[] schemas = new String[allSchemasFromWSDL.length + 1];
        for (int count = 0; count < allSchemasFromWSDL.length; ++count) {
            schemas[count] = allSchemasFromWSDL[count];
        }
        schemas[count] = CICSMAGIC;
        if (traceLog != null) {
            traceLog.println("Schema source array count: " + schemas.length);
            for (int i = 0; i < schemas.length; ++i) {
                traceLog.println("Schema " + i + ": " + schemas[i]);
            }
        }
        factory.setAttribute(JAXP_SCHEMA_SOURCE, schemas);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new MyResolver(this.schemas, this.newSchema));
        builder.setErrorHandler(new MyErrorHandler());
        return builder;
    }

    private InputStream generateSchema(String operationName, boolean request, int schemaStyle, QName elementToValidate, String namespaces) throws Exception {
        if (traceLog != null) {
            traceLog.println("Schema 'http://CICSMAGIC': ");
        }
        switch (schemaStyle) {
            case 1: {
                List<Object> messageParts = this.getMessageParts(operationName, request);
                return this.generateDocumentSchema(operationName, DOCNAMESPACE, request, messageParts);
            }
            case 2: {
                return this.generateRPCSchema(operationName, this.wsdl.getTargetNameSpace(), request);
            }
            case 3: {
                ArrayList<Object> list = new ArrayList<Object>();
                if (namespaces != null && namespaces.length() > 1) {
                    list.add(elementToValidate);
                }
                return this.generateDocumentSchema(operationName, DOCNAMESPACE, request, list);
            }
        }
        throw new Exception("Bad schema type: " + schemaStyle);
    }

    private List<Object> getMessageParts(String operationName, boolean requestMessage) throws CICSWSDLException {
        if (this.wsdl == null) {
            return new ArrayList<Object>();
        }
        if (requestMessage) {
            return this.wsdl.getMethodSignatureParts(operationName, ICM.XMLContentType.SOAP_REQUEST, true);
        }
        return this.wsdl.getMethodSignatureParts(operationName, ICM.XMLContentType.SOAP_RESPONSE, true);
    }

    private StringBuilder generateTemplate(String operationName, boolean request, String namespace, List<Object> messageParts) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" ?><schema targetNamespace=\"" + namespace + "\" xmlns=\"http://www.w3.org/2001/XMLSchema\" xmlns:tns=\"" + namespace + "\">\n");
        for (Object part : messageParts) {
            QName type = null;
            type = part instanceof QName ? (QName)part : this.wsdl.getMessagePartElement(part);
            if (type == null) {
                type = this.wsdl.getMessagePartType(part);
            }
            if (type == null) {
                throw new Exception("Part '" + part + "' does not have a type.");
            }
            sb.append("<import namespace=\"" + type.getNamespaceURI() + "\" />\n");
        }
        return sb;
    }

    private InputStream generateDocumentSchema(String operationName, String namespace, boolean request, List<Object> messageParts) throws Exception {
        StringBuilder sb = this.generateTemplate(operationName, request, namespace, messageParts);
        sb.append("<element name=\"Body\">\n<complexType mixed=\"true\">\n<all maxOccurs=\"1\" minOccurs=\"1\">\n");
        for (Object part : messageParts) {
            QName type = null;
            type = part instanceof QName ? (QName)part : this.wsdl.getMessagePartElement(part);
            if (type != null) {
                sb.append("<element ref=\"xsd1:" + type.getLocalPart() + "\" xmlns:xsd1=\"" + type.getNamespaceURI() + "\"/>\n");
                continue;
            }
            throw new Exception("Document style part '" + part + "' does not have an element.");
        }
        sb.append("</all>\n</complexType>\n</element>\n</schema>");
        if (traceLog != null) {
            traceLog.println(sb);
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private InputStream generateRPCSchema(String operationName, String namespace, boolean request) throws Exception {
        List<Object> messageParts = this.getMessageParts(operationName, request);
        StringBuilder sb = this.generateTemplate(operationName, request, namespace, messageParts);
        if (!request) {
            operationName = operationName.concat("Response");
        }
        sb.append("<element name=\"" + operationName + "\" >\n<complexType>\n<all maxOccurs=\"1\" minOccurs=\"1\">\n");
        for (Object part : messageParts) {
            String partName = this.wsdl.getMessagePartName(part);
            QName type = this.wsdl.getMessagePartElement(part);
            if (type != null) {
                sb.append("<element ref=\"xsd1:" + type.getLocalPart() + "\" xmlns:xsd1=\"" + type.getNamespaceURI() + "\"/>\n");
            } else {
                type = this.wsdl.getMessagePartType(part);
                if (type != null) {
                    sb.append("<element name=\"" + partName + "\" type=\"xsd1:" + type.getLocalPart() + "\" nillable=\"false\" xmlns:xsd1=\"" + type.getNamespaceURI() + "\"/>\n");
                }
            }
            if (type != null) continue;
            throw new Exception("RPC style part '" + part + "' does not have a type.");
        }
        sb.append("</all>\n</complexType>\n</element>\n");
        sb.append("<element name=\"Body\">\n<complexType mixed=\"true\">\n<sequence maxOccurs=\"1\" minOccurs=\"1\">\n");
        sb.append("<element ref=\"tns:" + operationName + "\" />\n");
        sb.append("</sequence>\n</complexType>\n</element>\n</schema>");
        if (traceLog != null) {
            traceLog.println(sb);
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void cleanUp() {
        if (this.wsdl != null) {
            this.wsdl.cleanUp();
        }
    }
}

