/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WSDLZipHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2010 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private String zipFileLocation;
    private File extractDir;
    private String baseWSDLLocation;
    private Vector<File> createdFiles;

    public WSDLZipHandler(String zipFileLocation) {
        this.zipFileLocation = zipFileLocation;
        this.createdFiles = new Vector();
        this.extractDir = null;
        this.baseWSDLLocation = "";
    }

    public void extractAll() throws IOException {
        if (this.extractDir == null) {
            this.extractDir = File.createTempFile("CICSValidation", "");
            this.extractDir.delete();
            this.extractDir.mkdir();
            this.extractDir.deleteOnExit();
        }
        this.extractAll(this.extractDir);
    }

    public void extractAll(File toDirectory) throws IOException {
        ZipFile zip = new ZipFile(this.zipFileLocation);
        this.baseWSDLLocation = toDirectory.getAbsolutePath() + File.separator;
        int i = zip.getName().lastIndexOf(File.separator);
        this.baseWSDLLocation = i == -1 ? this.baseWSDLLocation + zip.getName() : this.baseWSDLLocation + zip.getName().substring(i + 1);
        this.baseWSDLLocation = this.baseWSDLLocation.replace(".zip", ".wsdl");
        File outputFile = null;
        byte[] buff = new byte[1024];
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            InputStream zis = zip.getInputStream(entry);
            Throwable throwable = null;
            try {
                boolean ignored;
                String fileName = toDirectory.getAbsolutePath() + File.separator + entry.getName();
                outputFile = new File(fileName);
                outputFile.deleteOnExit();
                if (entry.isDirectory()) {
                    ignored = outputFile.mkdirs();
                    this.createdFiles.add(outputFile);
                    continue;
                }
                ignored = outputFile.getParentFile().mkdirs();
                ignored = outputFile.createNewFile();
                this.createdFiles.add(outputFile);
                FileOutputStream fos = new FileOutputStream(outputFile);
                Throwable throwable2 = null;
                try {
                    int read = 0;
                    while ((read = zis.read(buff)) != -1) {
                        fos.write(buff, 0, read);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (zis == null) continue;
                if (throwable != null) {
                    try {
                        zis.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                zis.close();
            }
        }
        zip.close();
    }

    public String getExtractDir() {
        if (this.extractDir == null) {
            return null;
        }
        return this.extractDir.getAbsolutePath();
    }

    public void deleteAllExtracted() {
        boolean deleted;
        while (!this.createdFiles.isEmpty()) {
            File nextToDelete = this.createdFiles.firstElement();
            deleted = this.deleteTempFile(nextToDelete);
            if (!deleted) {
                System.err.println("File not deleted: " + nextToDelete.getAbsolutePath());
            }
            this.createdFiles.remove(0);
        }
        deleted = this.extractDir.delete();
        if (!deleted) {
            System.out.println("File not deleted: " + this.extractDir.getAbsolutePath());
        }
        this.extractDir = null;
    }

    private boolean deleteTempFile(File tempFile) {
        boolean deleted = false;
        File tempDir = tempFile.getParentFile();
        deleted = tempFile.delete();
        if (!deleted) {
            return deleted;
        }
        while (tempDir != null) {
            if (tempDir.compareTo(this.extractDir) == 0) {
                return true;
            }
            File tempDir2 = tempDir.getParentFile();
            deleted = tempDir.delete();
            if (!deleted) {
                return true;
            }
            tempDir = tempDir2;
        }
        return true;
    }

    public String getBaseWSDLLocation() {
        if (this.baseWSDLLocation == null) {
            return "";
        }
        return this.baseWSDLLocation;
    }

    protected void finalize() throws Throwable {
        this.deleteAllExtracted();
        super.finalize();
    }
}

