/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.c;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.CICSWSDLParseException;
import com.ibm.cics.wsdl.c.AliasType;
import com.ibm.cics.wsdl.c.LanguageStruct;
import com.ibm.cics.wsdl.c.Member;
import com.ibm.cics.wsdl.c.Primitive;
import com.ibm.cics.wsdl.c.UserType;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LangStruct_C
extends LangStruct {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String PACKED_KEYWORD = "_PACKED";
    private static final String STRUCT_KEYWORD = "STRUCT";
    private static final String TYPEDEF_KEYWORD = "TYPEDEF";
    private static final String DFHREQUEST = "DFHREQUEST";
    private static final String DFHRESPONSE = "DFHRESPONSE";
    private static final String DFHDATA = "DFHDATA";
    private String DFHCOMMAREA;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAX_LINE_LENGTH = 72;
    private static final Pattern singleLineCommentPattern = Pattern.compile("//.*[^/*//]");
    private static final Pattern commentBlockPattern = Pattern.compile("/\\*.*?\\*/");
    private static final Pattern structTagPattern = Pattern.compile("^\\s*(struct\\s*[^\\s{]+)\\s*", 2);
    private static final Pattern nameTagPattern = Pattern.compile("\\s*struct \\s*", 2);
    private static final Pattern structInstancePattern = Pattern.compile("\\}\\s*([^}]*)\\s*;\\s*$");
    private static final Pattern variablesPattern = Pattern.compile("([^}]\\S+?)\\s*[,;]");
    private static final Pattern typedefPattern = Pattern.compile("typedef\\s*", 2);
    private static final Pattern nameDimensionPattern = Pattern.compile("(\\S+?)(\\[\\S+)");
    private static final Pattern dimensionPattern = Pattern.compile("\\[\\s*(\\S+?)\\s*\\]");
    private static final Pattern keywordPattern = Pattern.compile("(auto|static|register|const|mutable|volatile)", 2);
    private static final Pattern fixedPointPattern = Pattern.compile("decimal\\s*\\(", 2);
    private static final Pattern compilerDirectivePattern = Pattern.compile("(^\\s*#.*)");
    private static final Pattern assignmentPattern1 = Pattern.compile("(\\s*=\\s*\\S+\\s*);");
    private static final Pattern assignmentPattern2 = Pattern.compile("(\\s*=\\s*\\S+\\s*),");
    private static final Pattern macroPattern = Pattern.compile("(__\\S+__)");
    private static final Pattern middleStructPattern = Pattern.compile("struct\\s*\\S*?\\s*\\{", 2);
    private static int generatedName = 0;
    private boolean foundCommArea = false;
    private static final Pattern illegalKeywordPattern = Pattern.compile("(extern |union |enum |using |friend |virtual |explicit |_export |inline |namespace |operator |template |typeid |typename |_callback |_cdecl)", 2);
    private static final List<String> illegalCharacters = new ArrayList<String>();
    private LanguageStruct mainStruct = new LanguageStruct("MAIN");
    private List<String> nameDim = new ArrayList<String>();
    private static final int LAR = 0;
    private Map<String, UserType> userTypes = new HashMap<String, UserType>();
    private static UserType CHAR;
    private static UserType SIGNED_CHAR;
    private static UserType SHORT;
    private static UserType UNSIGNED_SHORT;
    private static UserType INT;
    private static UserType UNSIGNED_INT;
    private static UserType LONG;
    private static UserType UNSIGNED_LONG;
    private static UserType LONG_LONG;
    private static UserType UNSIGNED_LONG_LONG;
    private static UserType BOOL;
    private static UserType HFP_SHORT;
    private static UserType HFP_LONG;
    private static UserType BFP_FLOAT;
    private static UserType BFP_DOUBLE;

    public LangStruct_C(boolean useAbstimeDates) {
        super(true, useAbstimeDates);
    }

    final UserType getUserType(String userTypeName) throws CICSWSDLParseException {
        UserType result;
        if ("float".equals(userTypeName)) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                if (this.useHexFloat) {
                    return HFP_SHORT;
                }
                return BFP_FLOAT;
            }
            throw new CICSWSDLParseException(MessageHandler.buildMessage("DFHPI9540E", new Object[]{"float"}));
        }
        if ("double".equals(userTypeName)) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                if (this.useHexFloat) {
                    return HFP_LONG;
                }
                return BFP_DOUBLE;
            }
            throw new CICSWSDLParseException(MessageHandler.buildMessage("DFHPI9540E", new Object[]{"double"}));
        }
        String modifiedTypeName = userTypeName;
        boolean packed = false;
        if (userTypeName.startsWith("_Packed")) {
            packed = true;
            modifiedTypeName = modifiedTypeName.replaceFirst("_Packed ", "").trim();
        }
        if ((result = this.userTypes.get(modifiedTypeName)) instanceof LanguageStruct && packed) {
            ((LanguageStruct)result).setPacked(packed);
        }
        if (result == null) {
            throw new CICSWSDLParseException(MessageHandler.buildMessage("DFHPI9536E", new Object[]{modifiedTypeName}));
        }
        return result;
    }

    final boolean addUserType(String tag, UserType myType) {
        if (this.userTypes.containsKey(tag)) {
            return false;
        }
        this.userTypes.put(tag, myType);
        return true;
    }

    @Override
    protected final String preProcessLine(String line) {
        Matcher compilerDirectiveMatcher;
        String theLine = line;
        if (theLine.length() > 72) {
            theLine = theLine.substring(0, 72).trim();
        }
        if ((compilerDirectiveMatcher = compilerDirectivePattern.matcher(theLine = singleLineCommentPattern.matcher(theLine).replaceAll(""))).find()) {
            Logging.writeMessage(4, "DFHPI9537W", new Object[]{compilerDirectiveMatcher.group(1)});
            theLine = compilerDirectivePattern.matcher(theLine).replaceAll("");
        }
        return theLine;
    }

    private void initialiseUserTypes() {
        this.userTypes.clear();
        this.userTypes.put("char", CHAR);
        this.userTypes.put("signed char", SIGNED_CHAR);
        this.userTypes.put("short", SHORT);
        this.userTypes.put("unsigned short", UNSIGNED_SHORT);
        this.userTypes.put("int", INT);
        this.userTypes.put("unsigned int", UNSIGNED_INT);
        this.userTypes.put("long", INT);
        this.userTypes.put("unsigned long", UNSIGNED_INT);
        this.userTypes.put("long long", LONG_LONG);
        this.userTypes.put("unsigned long long", UNSIGNED_LONG_LONG);
        this.userTypes.put("bool", BOOL);
        this.userTypes.put("long int", LONG);
        this.userTypes.put("short int", SHORT);
        this.userTypes.put("unsigned char", CHAR);
        this.userTypes.put("signed int", INT);
        this.userTypes.put("signed long int", LONG);
        this.userTypes.put("signed short int", SHORT);
        this.userTypes.put("signed short", SHORT);
        this.userTypes.put("signed long", LONG);
        this.userTypes.put("unsigned short int", UNSIGNED_SHORT);
        this.userTypes.put("unsigned long int", UNSIGNED_LONG);
    }

    @Override
    protected final void processLangStructure(String input, String structureName, String fileName) throws CICSWSDLException {
        String theInput = input;
        this.initialiseUserTypes();
        this.DFHCOMMAREA = null;
        if (structureName != null && structureName.length() != 0) {
            this.DFHCOMMAREA = structureName;
        } else {
            switch (this.msgType) {
                case SOAP_REQUEST: {
                    this.DFHCOMMAREA = DFHREQUEST;
                    break;
                }
                case SOAP_RESPONSE: {
                    this.DFHCOMMAREA = DFHRESPONSE;
                    break;
                }
                case XML_ELEMENT: 
                case XML_TYPE: {
                    this.DFHCOMMAREA = DFHDATA;
                    break;
                }
                default: {
                    throw new RuntimeException("INTERNAL ERROR: bad message type - " + (Object)((Object)this.msgType));
                }
            }
        }
        theInput = commentBlockPattern.matcher(theInput).replaceAll("");
        this.scanForErrors(theInput);
        theInput = this.scanForWarnings(theInput);
        theInput = theInput.replaceAll("\\?\\?\\(", "[");
        theInput = theInput.replaceAll("\\?\\?\\)", "]");
        if (!this.findMainObjects(theInput, fileName)) {
            return;
        }
        this.resolveMainStruct();
    }

    private void scanForErrors(String inputFile) {
        Matcher macroMatcher;
        String upperInput = inputFile.toUpperCase(Locale.ENGLISH);
        if (upperInput.indexOf(STRUCT_KEYWORD) == -1) {
            Logging.writeMessage(12, "DFHPI9538E", null);
        }
        for (String currentKeyword : illegalCharacters) {
            if (upperInput.indexOf(currentKeyword) == -1) continue;
            Logging.writeMessage(12, "DFHPI9539E", new Object[]{currentKeyword});
        }
        Matcher illegalKeywordMatcher = illegalKeywordPattern.matcher(inputFile);
        while (illegalKeywordMatcher.find()) {
            Logging.writeMessage(12, "DFHPI9540E", new Object[]{illegalKeywordMatcher.group(1)});
        }
        Matcher fixedPointMatcher = fixedPointPattern.matcher(inputFile);
        if (fixedPointMatcher.find()) {
            Logging.writeMessage(12, "DFHPI9541E", null);
        }
        if ((macroMatcher = macroPattern.matcher(inputFile)).find()) {
            Logging.writeMessage(12, "DFHPI9542E", new Object[]{macroMatcher.group(1)});
        }
        boolean numeric = true;
        Matcher dimensionMatcher = dimensionPattern.matcher(inputFile);
        block2: while (dimensionMatcher.find()) {
            String dim = dimensionMatcher.group(1);
            for (int i = 0; i < dim.length(); ++i) {
                numeric = Character.isDigit(dim.charAt(i));
                if (numeric) continue;
                Logging.writeMessage(12, "DFHPI9543E", new Object[]{dim});
                continue block2;
            }
        }
    }

    private String scanForWarnings(String inputString) {
        Matcher assignmentMatcher2;
        Matcher keywordMatcher = keywordPattern.matcher(inputString);
        while (keywordMatcher.find()) {
            Logging.writeMessage(4, "DFHPI9544W", new Object[]{keywordMatcher.group(1)});
        }
        String outputString = keywordMatcher.replaceAll("");
        Matcher assignmentMatcher1 = assignmentPattern1.matcher(outputString);
        if (assignmentMatcher1.find()) {
            Logging.writeMessage(4, "DFHPI9545W", null);
        }
        if ((assignmentMatcher2 = assignmentPattern2.matcher(outputString = assignmentMatcher1.replaceAll(";"))).find()) {
            Logging.writeMessage(4, "DFHPI9546W", null);
        }
        outputString = assignmentMatcher2.replaceAll(",");
        return outputString;
    }

    private boolean findMainObjects(String input, String fileName) throws CICSWSDLParseException {
        this.log.println(LINE_SEPARATOR + LINE_SEPARATOR + "Scanning for Top-level Structures");
        this.log.println("---------------------------------");
        int lastSplit = 0;
        int openCount = 0;
        int closeCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            char current = input.charAt(i);
            if (current == '{') {
                ++openCount;
            } else if (current == '}') {
                ++closeCount;
            }
            if (openCount != closeCount || current != ';') continue;
            String objectString = input.substring(lastSplit, i + 1).trim();
            this.log.println("Top Level Object: " + objectString);
            String tempUpper = objectString.toUpperCase(Locale.ENGLISH);
            if (tempUpper.indexOf(PACKED_KEYWORD) == 0 && tempUpper.indexOf(STRUCT_KEYWORD) >= 0 && tempUpper.indexOf("{") != -1) {
                this.parseStruct(objectString, this.mainStruct, 0, 0, fileName);
            } else if (tempUpper.indexOf(STRUCT_KEYWORD) == 0 && tempUpper.indexOf("{") != -1) {
                this.parseStruct(objectString, this.mainStruct, 0, 0, fileName);
            } else if (tempUpper.indexOf(TYPEDEF_KEYWORD) == 0) {
                if (!this.parseDefinition(objectString, fileName)) {
                    return false;
                }
            } else {
                Logging.writeMessage(4, "DFHPI9547E", new Object[]{objectString});
            }
            lastSplit = i + 1;
        }
        if (!this.foundCommArea) {
            String structType;
            switch (this.msgType) {
                case SOAP_REQUEST: {
                    structType = "Request";
                    break;
                }
                case SOAP_RESPONSE: {
                    structType = "Response";
                    break;
                }
                case XML_ELEMENT: 
                case XML_TYPE: {
                    structType = "input";
                    break;
                }
                default: {
                    throw new RuntimeException("INTERNAL ERROR: bad message type - " + (Object)((Object)this.msgType));
                }
            }
            Logging.writeMessage(12, "DFHPI9548E", new Object[]{structType, this.DFHCOMMAREA});
            return false;
        }
        return true;
    }

    private boolean parseDefinition(String input, String fileName) throws CICSWSDLParseException {
        String output = null;
        if (input.indexOf(123) == -1) {
            this.parseAliasTypedef(input, fileName);
        } else {
            Matcher typedefMatcher = typedefPattern.matcher(input);
            output = typedefMatcher.replaceAll("");
            Matcher typedefTagMatcher = structTagPattern.matcher(output);
            String tag = null;
            if (typedefTagMatcher.find()) {
                tag = typedefTagMatcher.group(1);
            }
            Matcher typedefInstanceMatcher = structInstancePattern.matcher(output);
            String rawNames = null;
            if (typedefInstanceMatcher.find()) {
                rawNames = typedefInstanceMatcher.group(1);
            }
            if (tag == null && rawNames == null) {
                Logging.writeMessage(12, "DFHPI9549E", null);
                return false;
            }
            if (tag != null && rawNames == null) {
                this.parseStruct(output, this.mainStruct, 0, 0, fileName);
                return true;
            }
            List<Member> typedefMembers = this.parseStruct(output, this.mainStruct, 1, 0, fileName);
            for (Member member : typedefMembers) {
                this.addUserType(member.getInstanceName(), member.getType());
            }
        }
        return true;
    }

    private void parseAliasTypedef(String input, String fileName) {
        String output = input.replaceAll("\\s+\\[", "[");
        String name = "";
        String dimension = "";
        String type = "";
        this.nameDim.clear();
        Matcher variablesMatcher = variablesPattern.matcher(output);
        while (variablesMatcher.find()) {
            this.nameDim.add(variablesMatcher.group(1));
        }
        output = variablesMatcher.replaceAll("");
        Matcher typedefMatcher = typedefPattern.matcher(output);
        output = typedefMatcher.replaceAll("");
        type = output.trim();
        for (String current : this.nameDim) {
            Matcher nameMatcher = nameDimensionPattern.matcher(current);
            if (nameMatcher.find()) {
                name = nameMatcher.group(1);
                dimension = nameMatcher.group(2);
            } else {
                name = current;
            }
            name = name.trim();
            List<Integer> dims = this.parseDimensions(dimension, fileName);
            this.addUserType(name, new AliasType(name, type, dims));
        }
    }

    private List<Integer> parseDimensions(String dimensions, String fileName) {
        ArrayList<Integer> dims = new ArrayList<Integer>();
        Matcher dimMatcher = dimensionPattern.matcher(dimensions);
        while (dimMatcher.find()) {
            int dimension = Util.stringToInt(dimMatcher.group(1), 1, fileName);
            if (dimension < 1) {
                Logging.writeMessage(12, "DFHPI9574E", new Object[]{dimensions});
                dimension = 1;
            }
            dims.add(dimension);
        }
        return dims;
    }

    private List<Member> parseStruct(String input, LanguageStruct parent, int source, int memberPosition, String fileName) throws CICSWSDLParseException {
        LanguageStruct myStruct = new LanguageStruct();
        String output = input.replaceAll(",\\s*", ",");
        if (output.indexOf("_Packed ") == 0) {
            myStruct.setPacked(true);
            output = output.replaceFirst("_Packed ", "").trim();
        }
        Matcher structTagMatcher = structTagPattern.matcher(output);
        String typeTag = null;
        typeTag = structTagMatcher.find() ? structTagMatcher.group(1) : LangStruct_C.generateTag();
        myStruct.setTypeName(typeTag);
        Matcher structInstanceMatcher = structInstancePattern.matcher(output);
        String rawStructNames = "";
        if (structInstanceMatcher.find()) {
            rawStructNames = structInstanceMatcher.group(1);
        }
        Matcher nameTagMatcher = nameTagPattern.matcher(typeTag);
        String nameTag = nameTagMatcher.replaceAll("");
        if (source == 0 && nameTag.equalsIgnoreCase(this.DFHCOMMAREA)) {
            this.foundCommArea = true;
        }
        List<Member> instances = null;
        instances = nameTag.equalsIgnoreCase(this.DFHCOMMAREA) ? this.parseInstances(typeTag, nameTag, fileName) : this.parseInstances(typeTag, rawStructNames, fileName);
        if (source == 0) {
            Iterator<Member> memberIT = instances.iterator();
            while (memberIT.hasNext()) {
                parent.addMember(memberIT.next(), memberPosition);
            }
        }
        output = structInstanceMatcher.replaceAll("");
        output = output.replaceAll("^struct\\s*[^\\s{]*\\s*\\{", "");
        output = output.trim();
        int iterations = 0;
        boolean structsRemaining = true;
        int middleStructsFound = 0;
        block1: while (structsRemaining) {
            int i;
            String candidate;
            int structPosPreviousWord;
            if (++iterations > 5000) {
                throw new CICSWSDLParseException(MessageHandler.buildMessage("DFHPI9685E", new Object[0]));
            }
            Matcher middleStructMatcher = middleStructPattern.matcher(output);
            if (!middleStructMatcher.find()) break;
            int structPos = middleStructMatcher.start();
            String PACKED = "_Packed";
            for (structPosPreviousWord = structPos - 1; structPosPreviousWord > -1 && Character.isWhitespace(output.charAt(structPosPreviousWord)); --structPosPreviousWord) {
            }
            if (++structPosPreviousWord - "_Packed".length() > -1 && "_Packed".equals(candidate = output.substring(structPosPreviousWord - "_Packed".length(), structPosPreviousWord))) {
                structPos = structPosPreviousWord - "_Packed".length();
            }
            int openCount = 0;
            int closeCount = 0;
            String counterString = output.substring(0, structPos);
            int internalPosition = 0 + middleStructsFound;
            for (i = 0; i < counterString.length(); ++i) {
                if (counterString.charAt(i) != ';') continue;
                ++internalPosition;
            }
            ++middleStructsFound;
            for (i = structPos; i < output.length(); ++i) {
                char current = output.charAt(i);
                if (current == '{') {
                    ++openCount;
                } else if (current == '}') {
                    ++closeCount;
                }
                if (openCount != closeCount || current != ';') continue;
                String structString = output.substring(structPos, i + 1);
                this.parseStruct(structString, myStruct, 0, internalPosition, fileName);
                output = output.substring(0, structPos) + output.substring(i + 1);
                continue block1;
            }
        }
        String[] members = output.trim().split(";");
        for (int i = 0; i < members.length; ++i) {
            this.parseMember(members[i], myStruct, fileName);
        }
        if (!this.addUserType(myStruct.getTypeName(), myStruct)) {
            throw new CICSWSDLParseException(MessageHandler.buildMessage("DFHPI9550E", new Object[]{myStruct.getTypeName()}));
        }
        return instances;
    }

    private List<Member> parseInstances(String typeTag, String rawInstanceNames, String fileName) {
        ArrayList<Member> instanceMembers = new ArrayList<Member>();
        String[] instances = rawInstanceNames.split(",");
        for (int i = 0; i < instances.length; ++i) {
            if (instances[i].equals("")) continue;
            String name = "";
            String dimension = "";
            instances[i] = instances[i].trim();
            instances[i] = instances[i].replaceAll("\\s+\\[", "[");
            Matcher nameMatcher = nameDimensionPattern.matcher(instances[i]);
            if (nameMatcher.find()) {
                name = nameMatcher.group(1);
                dimension = nameMatcher.group(2);
            } else {
                name = instances[i];
            }
            List<Integer> dims = this.parseDimensions(dimension, fileName);
            instanceMembers.add(new Member(this, name, typeTag, dims));
        }
        return instanceMembers;
    }

    private void parseMember(String inMember, LanguageStruct parent, String fileName) throws CICSWSDLParseException {
        String dimension = "";
        String type = "";
        String name = "";
        String member = inMember;
        this.nameDim.clear();
        if (member.indexOf(";") == -1) {
            member = member + ";";
        }
        member = member.replaceAll("\\s+\\[", "[");
        Matcher variablesMatcher = variablesPattern.matcher(member);
        while (variablesMatcher.find()) {
            this.nameDim.add(variablesMatcher.group(1));
        }
        member = variablesMatcher.replaceAll("");
        type = member.trim();
        String[] typeTokens = type.split(" ");
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < typeTokens.length; ++i) {
            if (typeTokens[i].equals("")) continue;
            temp.append(typeTokens[i] + " ");
        }
        type = temp.toString().trim();
        for (String current : this.nameDim) {
            Matcher nameMatcher = nameDimensionPattern.matcher(current);
            if (nameMatcher.find()) {
                name = nameMatcher.group(1).trim();
                dimension = nameMatcher.group(2);
            } else {
                name = current.trim();
            }
            List<Integer> dims = this.parseDimensions(dimension, fileName);
            if (type.equals("char16_t") && dims.size() == 0) {
                dims.add(1);
            }
            if (type.indexOf("char") != -1 && dims.size() > 0) {
                ICM.ICMDataType dataType = ICM.ICMDataType.CHAR_ARRAY;
                if (type.indexOf("wchar") != -1) {
                    dataType = ICM.ICMDataType.WIDE_CHAR_ARRAY;
                } else if (type.contains("char16_t")) {
                    if (!MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                        throw new CICSWSDLParseException(MessageHandler.buildMessage("DFHPI9724E", new Object[]{"char16_t", ICM.MAPPING_LEVELS[8], ICM.MAPPING_LEVELS[this.mappingLevel]}));
                    }
                    dataType = ICM.ICMDataType.UTF16_CHAR_ARRAY;
                    this.props.setProperty("UTF-16", Boolean.TRUE.toString());
                }
                type = LangStruct_C.generateTag();
                if (dataType.equals((Object)ICM.ICMDataType.CHAR_ARRAY) && dims.get(0).equals(8) && MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel) && this.useAbstimeDates) {
                    dataType = ICM.ICMDataType.ABSTIME;
                }
                int lastDimension = dims.size() - 1;
                this.addUserType(type, new Primitive(type, dataType, dims.remove(lastDimension), this.mappingStrategy));
            }
            parent.addMember(new Member(this, name, type, dims));
        }
    }

    private void resolveMainStruct() throws CICSWSDLException {
        boolean foundMainStruct = false;
        for (Member member : this.mainStruct.getOrderedMembers()) {
            String dfhcommarea = member.getInstanceName();
            if (!dfhcommarea.equalsIgnoreCase(this.DFHCOMMAREA)) continue;
            this.log.println(LINE_SEPARATOR + "Found Main-Structure '" + this.DFHCOMMAREA + "'.");
            foundMainStruct = true;
            member.generateICM(this.DFHCOMMAREA, this, new HashSet<String>(), this.mainStruct.isPacked());
            break;
        }
        if (!foundMainStruct) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9551E", new Object[]{this.DFHCOMMAREA}));
        }
    }

    private static String generateTag() {
        String generated = "dfh_reserved" + generatedName;
        ++generatedName;
        return generated;
    }

    static {
        illegalCharacters.add("'");
        illegalCharacters.add("\"");
        illegalCharacters.add("*");
        illegalCharacters.add(":");
        CHAR = new Primitive("char", ICM.ICMDataType.UNSIGNED_BYTE, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        SIGNED_CHAR = new Primitive("signed char", ICM.ICMDataType.BYTE, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        SHORT = new Primitive("short", ICM.ICMDataType.SHORT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        UNSIGNED_SHORT = new Primitive("unsigned short", ICM.ICMDataType.UNSIGNED_SHORT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        INT = new Primitive("int", ICM.ICMDataType.INT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        UNSIGNED_INT = new Primitive("unsigned int", ICM.ICMDataType.UNSIGNED_INT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        LONG = new Primitive("long", ICM.ICMDataType.INT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        UNSIGNED_LONG = new Primitive("unsigned long", ICM.ICMDataType.UNSIGNED_INT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        LONG_LONG = new Primitive("long long", ICM.ICMDataType.LONG, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        UNSIGNED_LONG_LONG = new Primitive("unsigned long long", ICM.ICMDataType.UNSIGNED_LONG, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        BOOL = new Primitive("bool", ICM.ICMDataType.BOOLEAN, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        HFP_SHORT = new Primitive("hexShort", ICM.ICMDataType.HFP_SHORT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        HFP_LONG = new Primitive("hexLong", ICM.ICMDataType.HFP_LONG, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        BFP_FLOAT = new Primitive("IEEEFloat", ICM.ICMDataType.BFP_FLOAT, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
        BFP_DOUBLE = new Primitive("IEEEDouble", ICM.ICMDataType.BFP_DOUBLE, 0, ICM.VaryingLength.NO_VARYING_STRATEGY);
    }
}

