/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.c;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ws2ls.MakeLang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class MakeC
extends MakeLang {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int LANGSTRUCT_INDENT = 2;
    private static final int LANGSTRUCT_LINE = 2;
    private static final int MAX_LINE_LENGTH = 79;
    public static final int MAX_VARIABLE_LENGTH = 50;
    public static final int MAX_VARIABLE_LENGTH_FOR_CONTAINER_NAMES = 44;
    public static final int MAX_VARIABLE_LENGTH_FOR_CONTAINER_NAMES_OLD = 45;
    private static final String LINE_TERMINATOR = ";";
    private static final String NATURAL_SEPERATOR = "_";
    private static final Pattern illegalCharsPattern = Pattern.compile("(\\W)");
    private static final Pattern firstCharPattern = Pattern.compile("^[^a-zA-Z]");
    private boolean isC;
    private static final int COMMENT_FORMAT_ADJUSTMENT = 2;
    private static final Map<String, Boolean> internalKeywords = new HashMap<String, Boolean>();

    public MakeC(ICM.XMLContentType messageType, QName artifactName, String pdsName, String structName, boolean isCLang, int mappingLevel, int mep, int langStructIncrement, boolean runZOS, int tool, Map<QName, String> typeMemberNameMap, Properties theInputParms, boolean response) {
        super(messageType, artifactName, pdsName, structName, internalKeywords, true, mappingLevel, mep, langStructIncrement, runZOS, tool, typeMemberNameMap, theInputParms, response);
        this.isC = isCLang;
    }

    @Override
    protected final void gotFixedRepeat(ICMFixedRepeatEntry fixRepeat, boolean isStructural) throws CICSWSDLException {
        super.gotFixedRepeat(fixRepeat, isStructural, 99999);
    }

    @Override
    protected void buildOuterStructLine(String name) {
        this.block.addElement("struct " + name);
        this.block.addElement("{ ");
    }

    @Override
    protected void buildStructLine(String name, int level, Stack<ICMFixedRepeatEntry> repeatStack) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i <= this.block.getNestingLevel() * 2; ++i) {
            line.append(" ");
        }
        String copyIndent = line.toString();
        this.block.addElement(copyIndent + "struct");
        this.block.addElement(copyIndent + "{ ");
    }

    @Override
    protected String formatOccurs(int o) {
        String s = "";
        if (o > 1) {
            s = !this.runZOS ? "[" + o + "]" : "??(" + o + "??)";
        }
        return s;
    }

    @Override
    protected String buildDataLine(String name, ICM.ICMDataType type, int lar, int unused, boolean unused2, int unused3, Stack<ICMFixedRepeatEntry> repeatStack, ICM.VaryingLength mappingStrategy, boolean signLeading, boolean separateChar, String odoTargetFieldName, int minLength) throws CICSWSDLException {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i <= this.block.getNestingLevel() * 2 + 2; ++i) {
            line.append(" ");
        }
        line.append(this.buildC(name, type, lar, repeatStack));
        return line.toString();
    }

    private String buildC(String name, ICM.ICMDataType dataType, int lar, Stack<ICMFixedRepeatEntry> repeatStack) throws CICSWSDLException {
        StringBuilder result = new StringBuilder();
        String larBit = null;
        switch (dataType) {
            case CHAR_ARRAY: 
            case HEX_ARRAY: 
            case BASE64_ARRAY: 
            case ABSTIME: 
            case UTF16_CHAR_ARRAY: {
                if (dataType.equals((Object)ICM.ICMDataType.ABSTIME)) {
                    lar = 8;
                }
                if (dataType.equals((Object)ICM.ICMDataType.UTF16_CHAR_ARRAY)) {
                    result.append("char16_t ");
                } else {
                    result.append("char ");
                }
                result.append(name);
                if (!this.runZOS) {
                    larBit = "[" + lar + "]";
                    break;
                }
                larBit = "??(" + lar + "??)";
                break;
            }
            case BYTE: {
                result.append("signed char " + name);
                break;
            }
            case UNSIGNED_BYTE: {
                result.append("char " + name);
                break;
            }
            case SHORT: {
                result.append("short " + name);
                break;
            }
            case UNSIGNED_SHORT: {
                result.append("unsigned short " + name);
                break;
            }
            case INT: {
                result.append("int " + name);
                break;
            }
            case UNSIGNED_INT: {
                result.append("unsigned int " + name);
                break;
            }
            case LONG: {
                result.append("long long " + name);
                break;
            }
            case UNSIGNED_LONG: {
                result.append("unsigned long long " + name);
                break;
            }
            case BOOLEAN: {
                if (this.isC) {
                    if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                        result.append("char " + name);
                        break;
                    }
                    result.append("short " + name);
                    break;
                }
                result.append("bool " + name);
                break;
            }
            case HFP_SHORT: 
            case BFP_FLOAT: {
                result.append("float " + name);
                break;
            }
            case HFP_LONG: 
            case BFP_DOUBLE: {
                result.append("double " + name);
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL_ERROR: Internal problem. ICM Type '" + (Object)((Object)dataType) + "' not recognised.");
            }
        }
        while (!repeatStack.empty()) {
            int dimension = repeatStack.pop().getOccurances();
            if (dimension == 1 && MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel)) continue;
            if (!this.runZOS) {
                result.append("[" + dimension + "]");
                continue;
            }
            result.append("??(" + dimension + "??)");
        }
        if (larBit != null) {
            result.append(larBit);
        }
        result.append(LINE_TERMINATOR);
        return result.toString();
    }

    @Override
    protected final void addEntireStructureComments(List<String> comments) {
        super.addEntireStructureComments(comments);
        this.block.addElement("struct " + this.structName);
        this.block.addElement("{ ");
    }

    @Override
    protected final void markEnd() {
        this.block.addElement("};");
        if (!this.block.hasData()) {
            this.blockManager.removeTopBlock(this.block);
        }
    }

    @Override
    protected void closeInnerBlock() {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i <= this.block.getNestingLevel() * 2; ++i) {
            line.append(" ");
        }
        line.append("} " + this.block.getName());
        Stack<ICMFixedRepeatEntry> dims = this.block.getDimensions();
        while (!dims.isEmpty()) {
            line.append(this.formatOccurs(dims.pop().getOccurances()));
        }
        line.append(LINE_TERMINATOR);
        this.block.addElement(line.toString());
        this.block.addElement(" ");
    }

    @Override
    protected void closeOuterBlock() {
        this.block.addElement("};");
    }

    @Override
    protected final String ensureValidInLang(String basename) {
        Matcher illegalMatcher = illegalCharsPattern.matcher(basename);
        String validName = illegalMatcher.replaceAll("X");
        Matcher firstCharMatcher = firstCharPattern.matcher(validName);
        validName = firstCharMatcher.replaceAll("X");
        return validName;
    }

    @Override
    protected final String ensureValidVariableLength(String basename) {
        return this.shrinkToFit(basename, 50);
    }

    @Override
    protected final String ensureValidContainerIDLength(String basename) {
        return this.shrinkToFit(basename, 50);
    }

    @Override
    protected final int getInitialNestingLevel() {
        return 0;
    }

    @Override
    protected final String generateIndentForComments() {
        StringBuilder format = new StringBuilder();
        for (int i = 0; i <= this.block.getNestingLevel() * 2 + 2; ++i) {
            format.append(" ");
        }
        return format.toString();
    }

    @Override
    protected final int getMaxLineLength() {
        return 79;
    }

    @Override
    protected final List<String> removeCommentsFromStringList(List<String> input) {
        ArrayList<String> output = new ArrayList<String>();
        if (input.isEmpty()) {
            return output;
        }
        boolean commentStarted = false;
        for (String line : input) {
            if (line.trim().startsWith("/*") || commentStarted) {
                commentStarted = true;
            } else {
                output.add(line);
            }
            if (line.indexOf("*/") == -1) continue;
            commentStarted = false;
        }
        output.add(0, " ");
        output.add(0, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/");
        return output;
    }

    @Override
    protected final List<String> addHeaderFormatting(List<String> input) {
        if (input.size() == 0) {
            input.add("/* " + MessageHandler.getMessage("HLL_COMMENT_EMPTY") + " */");
            return input;
        }
        for (int i = 0; i < input.size(); ++i) {
            String line = input.get(i);
            line = line.replaceAll("/\\*", "<*");
            line = line.replaceAll("\\*/", "*>");
            line = "| " + line;
            input.remove(i);
            input.add(i, line);
        }
        input.add(0, "/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        return input;
    }

    @Override
    protected String getTopLevelStrucName(String baseName) {
        return this.getMemberName() + NATURAL_SEPERATOR + baseName;
    }

    @Override
    protected String getContentName(String baseName) {
        baseName = this.shrinkToFit(baseName, 40);
        return baseName + "_value";
    }

    @Override
    protected String getAttributeName(String localName, String elName, boolean nil) {
        localName = this.shrinkToFit(localName, 17);
        if (nil) {
            elName = this.shrinkToFit(elName, 13);
            return "attr_" + localName + NATURAL_SEPERATOR + elName + "_value";
        }
        return "attr_" + localName + "_value";
    }

    @Override
    protected String getAttributeExistenceByteName(String localName, String elName, boolean nil) {
        localName = this.shrinkToFit(localName, 17);
        if (nil) {
            elName = this.shrinkToFit(elName, 13);
            return "attr_" + localName + NATURAL_SEPERATOR + elName + "_exist";
        }
        return "attr_" + localName + "_exist";
    }

    @Override
    protected String getContainerFieldName(String baseName) {
        int truncationPoint = 44;
        if (!MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel)) {
            truncationPoint = 45;
        }
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.mappingLevel)) {
            String containerName;
            int maxLength = truncationPoint;
            baseName = this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true") ? ((containerName = this.inputParms.getProperty("CONTAINER-NAME-SUFFIX")) != null ? this.shrinkToFit(baseName, maxLength += 4 - containerName.length()) + NATURAL_SEPERATOR + containerName : this.shrinkToFit(baseName, maxLength -= 4) + "_dataarea") : this.shrinkToFit(baseName, maxLength) + "_cont";
        }
        return baseName;
    }

    @Override
    protected String getDescriminatorFieldName(String baseName) {
        int truncationPoint = 44;
        baseName = this.shrinkToFit(baseName, truncationPoint);
        return baseName + "_enum";
    }

    @Override
    protected String buildEnumerationValueLine(String name, String value) {
        return null;
    }

    @Override
    protected String getContainerOccurencesFieldName(String baseName, ICMRepeatEntry varRepeat) {
        int truncationPoint = 44;
        if (!MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel)) {
            truncationPoint = 45;
        }
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.mappingLevel)) {
            String originalName = baseName;
            baseName = this.shrinkToFit(baseName, truncationPoint) + "_num";
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                if (this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true") && !varRepeat.isOptionalArray() && Util.isResponseCodeEntity(originalName)) {
                    baseName = this.shrinkToFit(originalName, truncationPoint - 6) + "_existence";
                } else if (varRepeat.getMinOccurance() == 0 && varRepeat.getMaxOccurance() == 1) {
                    baseName = this.shrinkToFit(originalName, truncationPoint - 6) + "_existence";
                }
            }
        }
        return baseName;
    }

    @Override
    protected int getCommentAdjustment() {
        return 2;
    }

    @Override
    protected String getLineTerminator() {
        return LINE_TERMINATOR;
    }

    @Override
    protected String getNaturalSeperator() {
        return NATURAL_SEPERATOR;
    }

    @Override
    protected String buildContainerNumberLine(String contid, int level, ICMRepeatEntry varRepeat) {
        return this.generateIndentForComments() + "int " + this.getContainerOccurencesUniqueFieldName(contid, true, varRepeat) + LINE_TERMINATOR;
    }

    @Override
    protected String buildContainerNameLine(String contid, int level) {
        String fieldName = this.getContainerUniqueFieldName(contid, true);
        if (!this.runZOS) {
            return this.generateIndentForComments() + "char " + fieldName + "[16]" + LINE_TERMINATOR;
        }
        return this.generateIndentForComments() + "char " + fieldName + "??(16??)" + LINE_TERMINATOR;
    }

    @Override
    protected String buildDescriminatorNameLine(String contid, int level) {
        String fieldName = this.getDescriminatorUniqueFieldName(contid, true);
        if (!this.runZOS) {
            return this.generateIndentForComments() + "char " + fieldName + LINE_TERMINATOR;
        }
        return this.generateIndentForComments() + "char " + fieldName + LINE_TERMINATOR;
    }

    @Override
    protected String getVaryingLengthCountName(String baseName) {
        baseName = this.shrinkToFit(baseName, 20);
        return baseName + "_length";
    }

    @Override
    protected boolean supportsPureDBCS() {
        return false;
    }

    @Override
    protected int getLanguageType() {
        return 3;
    }

    static {
        internalKeywords.put("auto", Boolean.TRUE);
        internalKeywords.put("break", Boolean.TRUE);
        internalKeywords.put("case", Boolean.TRUE);
        internalKeywords.put("char", Boolean.TRUE);
        internalKeywords.put("const", Boolean.TRUE);
        internalKeywords.put("continue", Boolean.TRUE);
        internalKeywords.put("default", Boolean.TRUE);
        internalKeywords.put("do", Boolean.TRUE);
        internalKeywords.put("double", Boolean.TRUE);
        internalKeywords.put("else", Boolean.TRUE);
        internalKeywords.put("enum", Boolean.TRUE);
        internalKeywords.put("extern", Boolean.TRUE);
        internalKeywords.put("float", Boolean.TRUE);
        internalKeywords.put("for", Boolean.TRUE);
        internalKeywords.put("goto", Boolean.TRUE);
        internalKeywords.put("if", Boolean.TRUE);
        internalKeywords.put("int", Boolean.TRUE);
        internalKeywords.put("long", Boolean.TRUE);
        internalKeywords.put("register", Boolean.TRUE);
        internalKeywords.put("return", Boolean.TRUE);
        internalKeywords.put("short", Boolean.TRUE);
        internalKeywords.put("signed", Boolean.TRUE);
        internalKeywords.put("sizeof", Boolean.TRUE);
        internalKeywords.put("static", Boolean.TRUE);
        internalKeywords.put("struct", Boolean.TRUE);
        internalKeywords.put("switch", Boolean.TRUE);
        internalKeywords.put("typedef", Boolean.TRUE);
        internalKeywords.put("union", Boolean.TRUE);
        internalKeywords.put("unsigned", Boolean.TRUE);
        internalKeywords.put("void", Boolean.TRUE);
        internalKeywords.put("volatile", Boolean.TRUE);
        internalKeywords.put("while", Boolean.TRUE);
        internalKeywords.put("and", Boolean.TRUE);
        internalKeywords.put("and_eq", Boolean.TRUE);
        internalKeywords.put("bitand", Boolean.TRUE);
        internalKeywords.put("bitor", Boolean.TRUE);
        internalKeywords.put("compl", Boolean.TRUE);
        internalKeywords.put("not", Boolean.TRUE);
        internalKeywords.put("not_eq", Boolean.TRUE);
        internalKeywords.put("or", Boolean.TRUE);
        internalKeywords.put("or_eq", Boolean.TRUE);
        internalKeywords.put("xor", Boolean.TRUE);
        internalKeywords.put("xor_eq", Boolean.TRUE);
        internalKeywords.put("asm", Boolean.TRUE);
        internalKeywords.put("bool", Boolean.TRUE);
        internalKeywords.put("class", Boolean.TRUE);
        internalKeywords.put("const_cast", Boolean.TRUE);
        internalKeywords.put("delete", Boolean.TRUE);
        internalKeywords.put("dynamic_cast", Boolean.TRUE);
        internalKeywords.put("explicit", Boolean.TRUE);
        internalKeywords.put("export", Boolean.TRUE);
        internalKeywords.put("false", Boolean.TRUE);
        internalKeywords.put("friend", Boolean.TRUE);
        internalKeywords.put("inline", Boolean.TRUE);
        internalKeywords.put("mutable", Boolean.TRUE);
        internalKeywords.put("namespace", Boolean.TRUE);
        internalKeywords.put("new", Boolean.TRUE);
        internalKeywords.put("operator", Boolean.TRUE);
        internalKeywords.put("private", Boolean.TRUE);
        internalKeywords.put("protected", Boolean.TRUE);
        internalKeywords.put("public", Boolean.TRUE);
        internalKeywords.put("reinterpret_cas", Boolean.TRUE);
        internalKeywords.put("static_cast", Boolean.TRUE);
        internalKeywords.put("template", Boolean.TRUE);
        internalKeywords.put("this", Boolean.TRUE);
        internalKeywords.put("throw", Boolean.TRUE);
        internalKeywords.put("true", Boolean.TRUE);
        internalKeywords.put("try", Boolean.TRUE);
        internalKeywords.put("typeid", Boolean.TRUE);
        internalKeywords.put("typename", Boolean.TRUE);
        internalKeywords.put("using", Boolean.TRUE);
        internalKeywords.put("virtual", Boolean.TRUE);
        internalKeywords.put("wchar_t", Boolean.TRUE);
    }
}

